/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import javax.swing.Icon;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcModify;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.data.RJDataLPRControler;
import sanproject.client.pool.RJPoolDataSupplier;
import sanproject.client.pool.RJPoolElement;
import sanproject.client.pool.RJPoolIconTable;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiLDEVInfoDetailEUx;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serversx.data.RJiPGIndex;

public class RJPoolLdevElement
extends RJPoolElement {
    private Robj_interface_RJiLDEVInfoDetailEUx ldevDetail = null;
    protected int ldkc = -1;
    protected int cu = -1;
    protected int ldev = -1;
    protected boolean topVolFlg = false;
    private int blocked = 0;
    private Integer clprNo = null;
    private String clprName = null;
    private int emulationType = 0;
    private int raid = 0;
    private int volFlg = 0;
    private Long capacity = null;
    private Long lbacount = null;
    private Robj_interface_RJiPGIndex pg = null;
    private Integer luPath = null;
    private int luseCount = -1;
    protected boolean external = false;
    private Integer hdd = null;
    private Integer exdev = null;
    private boolean cacheMode = false;
    private boolean encryption = false;
    protected boolean normalVolume = false;
    protected boolean vvol = false;
    protected boolean aouvol = false;
    private int slprNo = 0;
    private int poolId = -1;
    private int poolIdInit = -1;
    protected RJcModify modify = new RJcModify();

    public RJPoolLdevElement(int n, int n2, int n3) {
        this(n, n2, n3, null, null);
    }

    public RJPoolLdevElement(int n, int n2, int n3, RJPoolDataSupplier rJPoolDataSupplier, RJcTreePanel rJcTreePanel) {
        super(null, rJPoolDataSupplier, rJcTreePanel);
        this.ldkc = n;
        this.cu = n2;
        this.ldev = n3;
        this.setName(RJPoolLdevElement.toHexString(n, 2) + ":" + RJPoolLdevElement.toHexString(n2, 2) + ":" + RJPoolLdevElement.toHexString(n3, 2));
    }

    public void initDetail(int n, Robj_interface_RJiLDEVInfoDetailEUx robj_interface_RJiLDEVInfoDetailEUx) {
        this.poolIdInit = this.poolId = n;
        this.initDetail(robj_interface_RJiLDEVInfoDetailEUx);
    }

    public void initDetail(Robj_interface_RJiLDEVInfoDetailEUx robj_interface_RJiLDEVInfoDetailEUx) {
        if (robj_interface_RJiLDEVInfoDetailEUx != null) {
            this.ldevDetail = robj_interface_RJiLDEVInfoDetailEUx;
            this.name = RJComUty.getLDEVDisplayName((Robj_interface_RJiLDEVInfoDetail)robj_interface_RJiLDEVInfoDetailEUx);
            this.external = robj_interface_RJiLDEVInfoDetailEUx.isExternalVolume();
            this.emulationType = robj_interface_RJiLDEVInfoDetailEUx.getIEmulationType();
            this.capacity = new Long(robj_interface_RJiLDEVInfoDetailEUx.getLLDEVLBASize() / 2L);
            this.lbacount = new Long(robj_interface_RJiLDEVInfoDetailEUx.getLLDEVLBASize());
            this.volFlg = robj_interface_RJiLDEVInfoDetailEUx.getByVolumeFlag();
            this.raid = robj_interface_RJiLDEVInfoDetailEUx.getIRaidLevel();
            this.pg = new RJiPGIndex();
            this.pg.setIFB4(robj_interface_RJiLDEVInfoDetailEUx.getIFB4());
            this.pg.setIPG(robj_interface_RJiLDEVInfoDetailEUx.getIPG());
            this.hdd = new Integer(robj_interface_RJiLDEVInfoDetailEUx.getByDriveType());
            this.exdev = new Integer(robj_interface_RJiLDEVInfoDetailEUx.getByExtDriveType());
            this.luPath = new Integer(robj_interface_RJiLDEVInfoDetailEUx.getSLUPathNumber());
            this.luseCount = robj_interface_RJiLDEVInfoDetailEUx.getSLUSEElmCount();
            this.clprNo = new Integer(robj_interface_RJiLDEVInfoDetailEUx.getSCLPR());
            this.slprNo = robj_interface_RJiLDEVInfoDetailEUx.getSSLPR();
            this.cacheMode = robj_interface_RJiLDEVInfoDetailEUx.isBCacheMode();
            this.encryption = robj_interface_RJiLDEVInfoDetailEUx.isBEncrypt();
            this.topVolFlg = this.supplier.isTopPoolVOL((Robj_interface_RJiLDEVIndex)robj_interface_RJiLDEVInfoDetailEUx);
        }
    }

    public static String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        return string;
    }

    public static String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n).toUpperCase();
        return string.substring(string.length() - n2);
    }

    public Icon getIcon(boolean bl) {
        Icon icon = RJPoolIconTable.getIcon(14);
        if (this.topVolFlg) {
            icon = RJPoolIconTable.getIcon(16);
        }
        return icon;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJPoolLdevElement && this.cu == ((RJPoolLdevElement)object).getCU() && this.ldev == ((RJPoolLdevElement)object).getLdev()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.cu << 8 | this.ldev;
        return n;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof RJPoolLdevElement && (n = this.cu - ((RJPoolLdevElement)object).getCU()) == 0) {
            n = this.ldev - ((RJPoolLdevElement)object).getLdev();
        }
        return n;
    }

    public RJcModify getModify() {
        return this.modify;
    }

    public Robj_interface_RJiLDEVInfoDetail getLdevDetail() {
        return this.ldevDetail;
    }

    public int getLDKC() {
        return this.ldkc;
    }

    public int getCU() {
        return this.cu;
    }

    public Robj_interface_RJiCUIndex getCUIndex() {
        RJiCUIndex rJiCUIndex = new RJiCUIndex();
        rJiCUIndex.setCUIndex((short)this.ldkc, (short)this.cu);
        return rJiCUIndex;
    }

    public int getLdev() {
        return this.ldev;
    }

    public void setBlocked(int n) {
        this.blocked = n;
    }

    public Integer getClprNo() {
        return this.clprNo;
    }

    public String getClprName() {
        String string = "CLPR0";
        RJDataLPRControler rJDataLPRControler = this.supplier.getLPRCtr();
        if (rJDataLPRControler != null) {
            string = rJDataLPRControler.getCLPRNoToName(this.clprNo);
        }
        return string;
    }

    public String getEmulationType() {
        String string = this.supplier.chgEmulation(this.emulationType);
        return string;
    }

    public String getRAIDLevel() {
        String string = this.supplier.chgRAIDLevel(this.raid);
        return string;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public String toCapacityString() {
        String string = null;
        switch (this.volFlg) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                string = RJComUty.ktoGSlong(this.capacity) + " " + RJcGuide.text("Pool/CapacityGB");
                break;
            }
        }
        return string;
    }

    public Long getLBACount() {
        return this.lbacount;
    }

    public int getVolumeFlg() {
        return this.volFlg;
    }

    public Robj_interface_RJiPGIndex getPG() {
        return this.pg;
    }

    public Integer getLUPath() {
        return this.luPath;
    }

    public boolean isLuse() {
        return this.luseCount != 1;
    }

    public Integer getHDDType() {
        return this.hdd;
    }

    public Integer getExDev() {
        return this.exdev;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isCacheMode() {
        return this.cacheMode;
    }

    public String getCacheMode() {
        String string = null;
        string = this.isExternal() ? (this.cacheMode ? RJcGuide.text("Pool/CacheModeEnable") : RJcGuide.text("Pool/CacheModeDisable")) : "-";
        return string;
    }

    public boolean isEncryption() {
        return this.encryption;
    }

    public String getEncryption() {
        String string = null;
        string = this.ldevDetail.isNormalVolume() ? (this.encryption ? RJcGuide.text("COMMON/Valid") : RJcGuide.text("COMMON/Unvalid")) : "-";
        return string;
    }

    public int getSlprNo() {
        return this.slprNo;
    }

    public int getPoolId() {
        return this.poolId;
    }

    public void setPoolId(int n) {
        this.poolId = n;
        this.modify.setModify(this.poolId != this.poolIdInit);
    }

    public int getRaidLevel() {
        return this.raid;
    }
}

