/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcPanel;
import sanproject.client.pool.RJPoolDataSupplier;
import sanproject.client.pool.RJPoolGuideDef;
import sanproject.serverux.dataimpl.POOLgetAllPoolInfo;

public class RJPoolSystemInfoPanel
extends RJcPanel
implements RJPoolGuideDef {
    private JLabel qsTotalCapaField = null;
    private JLabel qsUsedCapaField = null;
    private JLabel aouTotalCapaField = null;
    private JLabel aouUsedCapaField = null;
    private int compIndex = 0;

    public RJPoolSystemInfoPanel(RJPoolDataSupplier rJPoolDataSupplier) {
        this.setLayout(new GridBagLayout());
        Border border = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        this.setBorder(border);
        this.setOpaque(false);
        JLabel jLabel = this.createLabel("Pool/SystemInfoPoolMngBlockLbl");
        JLabel jLabel2 = this.createLabel("Pool/SystemInfoTotalCapacityLbl");
        JLabel jLabel3 = this.createLabel("Pool/SystemInfoUsedCapacityLbl");
        JLabel jLabel4 = this.createLabel("Pool/NodeQuickShadow");
        JLabel jLabel5 = this.createLabel("Pool/NodeAOU");
        this.qsTotalCapaField = this.createField("Pool/SystemInfoQSTotalCapacityField");
        this.qsUsedCapaField = this.createField("Pool/SystemInfoQSUsedCapacityField");
        this.aouTotalCapaField = this.createField("Pool/SystemInfoAOUTotalCapacityField");
        this.aouUsedCapaField = this.createField("Pool/SystemInfoAOUUsedCapacityField");
        this.addCenterPanel(jLabel, jLabel3, jLabel2);
        this.addCenterPanel(jLabel4, this.qsUsedCapaField, this.qsTotalCapaField);
        this.addCenterPanel(jLabel5, this.aouUsedCapaField, this.aouTotalCapaField);
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(RJcGuide.text(string));
        jLabel.setForeground(RJcGuide.color(string));
        jLabel.setHorizontalAlignment(2);
        jLabel.setFont(RJcConst.boldFont);
        return jLabel;
    }

    private JLabel createField(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setForeground(RJcGuide.color(string));
        jLabel.setFont(RJcConst.boldFont);
        return jLabel;
    }

    private void addCenterPanel(JLabel jLabel, JLabel jLabel2, JLabel jLabel3) {
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel(RJcGuide.text("Pool/SystemInfoDlm1Lbl"));
        jLabel5.setForeground(RJcGuide.color("Pool/SystemInfoDlm1Lbl"));
        jLabel5.setFont(RJcConst.boldFont);
        JLabel jLabel6 = new JLabel(RJcGuide.text("Pool/SystemInfoDlm2Lbl"));
        jLabel6.setForeground(RJcGuide.color("Pool/SystemInfoDlm2Lbl"));
        jLabel6.setFont(RJcConst.boldFont);
        this.add((Component)jLabel4, new GridBagConstraints(0, this.compIndex, 1, 1, 0.1, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jLabel, new GridBagConstraints(1, this.compIndex, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jLabel5, new GridBagConstraints(2, this.compIndex, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)jLabel2, new GridBagConstraints(3, this.compIndex, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)jLabel6, new GridBagConstraints(4, this.compIndex, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)jLabel3, new GridBagConstraints(5, this.compIndex, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 0, 0), 0, 0));
        ++this.compIndex;
    }

    public void showPanel(POOLgetAllPoolInfo pOOLgetAllPoolInfo) {
        this.qsTotalCapaField.setText(null);
        this.qsUsedCapaField.setText(null);
        this.aouTotalCapaField.setText(null);
        this.aouUsedCapaField.setText(null);
        if (pOOLgetAllPoolInfo != null) {
            this.qsTotalCapaField.setText(this.toCapacityString(pOOLgetAllPoolInfo.lQSPoolTotalCapa));
            this.qsUsedCapaField.setText(this.toCapacityString(pOOLgetAllPoolInfo.lQSPoolTotalUsed));
            this.aouTotalCapaField.setText(this.toCapacityString(pOOLgetAllPoolInfo.lAOUPoolTotalCapa));
            this.aouUsedCapaField.setText(this.toCapacityString(pOOLgetAllPoolInfo.lAOUPoolTotalUsed));
        }
    }

    public String toCapacityString(long l) {
        String string = RJComUty.ktoGSlong(l * 1024L) + " " + RJcGuide.text("Pool/CapacityGB");
        return string;
    }
}

