/*
 * Decompiled with CFR 0.152.
 */
package sanproject.serverux.sso.certificate;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import sanproject.serverux.sso.certificate.HpCmsCertificateException;
import sanproject.serverux.sso.certificate.HpCmsKeyStore;
import sanproject.serverux.sso.certificate.HpCmsKeyStoreException;
import sanproject.serverux.sso.certificate.HpCmsKeyStoreNotFoundException;

public class HpCmsCertificateHandler {
    private static final String CERT_TYPE = "X509";

    private HpCmsCertificateHandler() {
    }

    private static Certificate generateCertificate(String string) throws HpCmsCertificateException {
        Certificate certificate = null;
        FileInputStream fileInputStream = null;
        File file = new File(string);
        try {
            fileInputStream = new FileInputStream(file);
            CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE);
            certificate = certificateFactory.generateCertificate(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new HpCmsCertificateException("File I/O Error.", fileNotFoundException);
        }
        catch (CertificateException certificateException) {
            throw new HpCmsCertificateException("cannot create certificate.", certificateException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return certificate;
    }

    public static Certificate getCertificate(String string) throws HpCmsCertificateException, HpCmsKeyStoreNotFoundException {
        Certificate certificate = null;
        try {
            if (!HpCmsKeyStore.exists()) {
                throw new HpCmsKeyStoreNotFoundException("not found the KeyStoreFile.");
            }
            KeyStore keyStore = HpCmsKeyStore.load();
            if (!keyStore.containsAlias(string)) {
                throw new HpCmsCertificateException("no such Certificate.");
            }
            certificate = keyStore.getCertificate(string);
        }
        catch (HpCmsKeyStoreException hpCmsKeyStoreException) {
            throw new HpCmsCertificateException("cannot access the KeyStoreFile.", hpCmsKeyStoreException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new HpCmsCertificateException("cannot set the certificate.", keyStoreException);
        }
        return certificate;
    }

    public static String analysisCertificate(String string) throws HpCmsCertificateException {
        Certificate certificate = HpCmsCertificateHandler.generateCertificate(string);
        return certificate.toString();
    }

    public static void importCertificate(String string, String string2) throws HpCmsCertificateException {
        Certificate certificate = HpCmsCertificateHandler.generateCertificate(string2);
        try {
            KeyStore keyStore = HpCmsKeyStore.load();
            keyStore.setCertificateEntry(string, certificate);
            HpCmsKeyStore.store(keyStore);
        }
        catch (HpCmsKeyStoreException hpCmsKeyStoreException) {
            throw new HpCmsCertificateException("cannot access the KeyStoreFile.", hpCmsKeyStoreException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new HpCmsCertificateException("cannot set the certificate.", keyStoreException);
        }
    }

    public static String[] listCertificate() throws HpCmsCertificateException, HpCmsKeyStoreNotFoundException {
        String[] stringArray = null;
        if (!HpCmsKeyStore.exists()) {
            throw new HpCmsKeyStoreNotFoundException("not found the KeyStoreFile.");
        }
        try {
            KeyStore keyStore = HpCmsKeyStore.load();
            ArrayList<String> arrayList = Collections.list(keyStore.aliases());
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        catch (HpCmsKeyStoreException hpCmsKeyStoreException) {
            throw new HpCmsCertificateException("cannot load the KeyStore.", hpCmsKeyStoreException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new HpCmsCertificateException("cannot get aliases.", keyStoreException);
        }
        return stringArray;
    }

    public static String detailCertificate(String string) throws HpCmsCertificateException, HpCmsKeyStoreNotFoundException {
        Certificate certificate = null;
        if (!HpCmsKeyStore.exists()) {
            throw new HpCmsKeyStoreNotFoundException("not found the KeyStoreFile.");
        }
        try {
            KeyStore keyStore = HpCmsKeyStore.load();
            if (!keyStore.containsAlias(string)) {
                throw new HpCmsCertificateException("no such Certificate.");
            }
            certificate = keyStore.getCertificate(string);
        }
        catch (HpCmsKeyStoreException hpCmsKeyStoreException) {
            throw new HpCmsCertificateException("cannot load the KeyStore.", hpCmsKeyStoreException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new HpCmsCertificateException("cannot load the Certificate.", keyStoreException);
        }
        return certificate.toString();
    }

    public static void deleteCertificate(String string) throws HpCmsCertificateException, HpCmsKeyStoreNotFoundException {
        if (!HpCmsKeyStore.exists()) {
            throw new HpCmsKeyStoreNotFoundException("not found the KeyStoreFile.");
        }
        try {
            KeyStore keyStore = HpCmsKeyStore.load();
            if (!keyStore.containsAlias(string)) {
                throw new HpCmsCertificateException("no such Certificate.");
            }
            keyStore.deleteEntry(string);
            HpCmsKeyStore.store(keyStore);
        }
        catch (HpCmsKeyStoreException hpCmsKeyStoreException) {
            throw new HpCmsCertificateException("cannot access the KeyStoreFile.", hpCmsKeyStoreException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new HpCmsCertificateException("cannot set the certificate.", keyStoreException);
        }
    }
}

