/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat;

import java.text.ParseException;
import java.util.HashMap;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdExecParameter;
import sanproject.getmondat.com.RJMdMessage;
import sanproject.getmondat.com.RJMdMsgID;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.serverux.data.MonSetMonitoringSwitch;

public class RJMdSetCommand
implements RJMdMsgID {
    private RJMdDataControl controller;
    private RJMdExecParameter parameter;
    private static final String OP_SWITCH = "switch";
    private static final String PP_PerformanceMonitor = "Performance Monitor";
    private final long LOCK_ID_INVALID = -1L;
    public long lockID = 0L;

    public RJMdSetCommand(RJMdDataControl rJMdDataControl) {
        this.controller = rJMdDataControl;
        this.parameter = rJMdDataControl.getExecParameter();
    }

    public void analyze(RJMdCmdParser rJMdCmdParser) throws ParseException {
        HashMap hashMap = this.parameter.getOperandSet();
        char c = rJMdCmdParser.nextToken();
        while (true) {
            if (c != 'I') break;
            String string = rJMdCmdParser.getToken();
            if (string.equals(OP_SWITCH)) {
                if (!this.controller.isAdministrator()) {
                    throw RJMdMessage.parseException("MSG028", rJMdCmdParser.getLine());
                }
            } else {
                throw RJMdMessage.parseException("MSG024", string);
            }
            c = rJMdCmdParser.nextTokenS();
            int n = this.getIntegerValue(rJMdCmdParser, string);
            hashMap.put(OP_SWITCH, new Integer(n));
            c = rJMdCmdParser.nextToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getIntegerValue(RJMdCmdParser rJMdCmdParser, String string) throws ParseException {
        int n = 0;
        char c = rJMdCmdParser.getKind();
        if (c != '=') throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        c = rJMdCmdParser.nextTokenS();
        if (c != 'I') throw RJMdMessage.parseException("MSG001", rJMdCmdParser.getLine());
        String string2 = rJMdCmdParser.getToken().toLowerCase();
        if (string2.equals("off")) return n;
        try {
            n = Integer.parseInt(string2);
            if (n > 0 && n <= 15) return n;
            throw RJMdMessage.parseException("MSG013", string + "=" + string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw RJMdMessage.parseException("MSG019", string + "=" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doit() throws ParseException {
        HashMap hashMap = this.parameter.getOperandSet();
        Integer n = (Integer)(hashMap = this.checkWritePermission(hashMap)).get(OP_SWITCH);
        if (n != null) {
            try {
                String string = this.parameter.getUserId();
                String string2 = this.parameter.getPassWord();
                this.lockID = this.controller.lock(string, string2);
                this.controller.clearApplyData();
                MonSetMonitoringSwitch monSetMonitoringSwitch = null;
                monSetMonitoringSwitch = n != 0 ? new MonSetMonitoringSwitch(true, n * 60) : new MonSetMonitoringSwitch(false);
                this.controller.setMonitorSwtch(monSetMonitoringSwitch);
                this.controller.doApply(this.lockID);
                RJMdDataControl.trace("set " + hashMap.toString() + " succeeded.");
            }
            catch (RJMdRmiException rJMdRmiException) {
                this.controller.putMessage(rJMdRmiException.getMessage());
                this.parameter.setExitCode(1);
            }
            finally {
                try {
                    this.controller.unlock(this.lockID);
                }
                catch (RJMdRmiException rJMdRmiException) {
                    this.controller.putMessage(rJMdRmiException.getMessage());
                    throw new ParseException(null, 0);
                }
            }
        }
    }

    private HashMap checkWritePermission(HashMap hashMap) throws ParseException {
        try {
            Integer n = (Integer)hashMap.get(OP_SWITCH);
            if (n != null) {
                boolean bl = this.controller.hasPermission(0);
                boolean bl2 = this.controller.hasPermission(1);
                boolean bl3 = this.controller.hasPermission(2);
                if (!(bl || bl2 || bl3)) {
                    this.controller.putMessage(RJMdMessage.message("MSG026"));
                    this.parameter.setExitCode(4);
                    hashMap.put(OP_SWITCH, null);
                }
            }
        }
        catch (RJMdRmiException rJMdRmiException) {
            this.controller.putMessage(rJMdRmiException.getMessage());
            throw new ParseException(null, 0);
        }
        return hashMap;
    }
}

