/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataPPCGroup;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgPPCGroupAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.data.PPCGroupAbility;

public class RJMdGroupPPCG
extends RJMdGroupData {
    private static final String groupID = "PPCG";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "PPCG_dat";
    private static final String groupInfo = "PPC group data";
    private RJMdUnitParallelStream stream = null;
    public static final int LIMIT_PARAMS_PPCG = 512;
    private static final String EN_PPCG_IOPS = "PPCG_IOPS";
    private static final String EN_PPCG_KBPS = "PPCG_KBPS";
    private static final String EN_PPCG_Response = "PPCG_Response";
    private static final String[] entryNames = new String[]{"PPCG_IOPS", "PPCG_KBPS", "PPCG_Response"};

    public RJMdGroupPPCG(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupPPCG();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupPPCG() throws RJMdRmiException, IOException {
        RJMdUnitEntry rJMdUnitEntry;
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, RJMdUnitEntry> hashMap = new HashMap<String, RJMdUnitEntry>();
        for (int i = 0; i < entryNames.length; ++i) {
            rJMdUnitEntry = this.stream.createEntry(entryNames[i], this.getTimeRange());
            hashMap.put(entryNames[i], rJMdUnitEntry);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        rJMdUnitEntry = new ArgPPCGroupAbility(1, rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPPCGroup();
        ArrayList arrayList2 = this.controller.getNotGroupedWWN();
        this.initProgress(arrayList, arrayList2.size() != 0);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPPCGroup rJMdDataPPCGroup = (RJMdDataPPCGroup)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPPCGroup)) continue;
            if (rJMdUnitEntry.size() >= 512) {
                this.collect(hashMap, (ArgPPCGroupAbility)rJMdUnitEntry);
                this.addProgress(rJMdUnitEntry.size());
                rJMdUnitEntry = new ArgPPCGroupAbility(1, rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
            }
            rJMdUnitEntry.addGroupName(rJMdDataPPCGroup.getNickname());
        }
        if (arrayList2.size() != 0) {
            rJMdUnitEntry.addGroupName("");
            this.addProgress(1);
        }
        this.collect(hashMap, (ArgPPCGroupAbility)rJMdUnitEntry);
        this.addProgress(rJMdUnitEntry.size());
        rJMdUnitEntry = new ArgPPCGroupAbility(1, rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList, boolean bl) {
        int n = arrayList.size();
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPPCGroup rJMdDataPPCGroup = (RJMdDataPPCGroup)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPPCGroup)) continue;
            ++n2;
        }
        if (bl) {
            ++n;
            ++n2;
        }
        super.initProgress(n2, n);
    }

    public void collect(HashMap hashMap, ArgPPCGroupAbility argPPCGroupAbility) throws RJMdRmiException, IOException {
        if (argPPCGroupAbility.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)argPPCGroupAbility);
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                PPCGroupAbility pPCGroupAbility = (PPCGroupAbility)monitorInfoCollection.get(i);
                String string = pPCGroupAbility.getGroupName();
                if (string.equals("")) {
                    string = "<Not Grouped>";
                }
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PPCG_IOPS), new RJMdColumn(string, pPCGroupAbility.getAvrIOPerSec()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PPCG_KBPS), new RJMdColumn(string, pPCGroupAbility.getAvrTransRate()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_PPCG_Response), new RJMdColumn(string, pPCGroupAbility.getResponseTime()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePPCGRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPPCG =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }
}

