/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataLDEV;
import sanproject.getmondat.data.RJMdDataPG;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupPhyData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.serverux.arg.monitor.HIHsmLDEVUseRateArgInfo;
import sanproject.serverux.arg.monitor.HIHsmPhysicalLDEVUseRateArgInfo;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HIHsmLDEVUseRate;
import sanproject.serverux.data.HIHsmPhysicalLDEVUseRate;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupPhyLDEV
extends RJMdGroupPhyData {
    private static final String groupID = "PhyLDEV";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "PhyLDEV_dat";
    private static final String groupInfoS = " data of physical range";
    private static final String groupInfoL = " data of physical long range";
    private String DLM = ".";
    public static final int LIMIT_PARAMS_PhyLDEV = 128;
    private static final String PHY_Short_LDEV = "PHY_LDEV_";
    private static final String PHY_Short_LDEV_SI = "PHY_LDEV_SI_";
    private static final String PHY_Long_LDEV = "PHY_Long_LDEV_";
    private static final int KIND_PHYLDEV = 1;
    private static final int KIND_PHYLDEV_SI = 2;

    public RJMdGroupPhyLDEV(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup(int n) throws RJMdRmiException, IOException {
        try {
            this.createGroupPhyLDEV(n, 1);
            if (n == 0) {
                this.createGroupPhyLDEV(n, 2);
            }
        }
        finally {
            this.stream.closeEntry();
        }
    }

    private void createGroupPhyLDEV(int n, int n2) throws RJMdRmiException, IOException {
        if (n2 == 1) {
            this.putInfomation("INF006", "LDEV" + this.getGroupInfo(n));
        } else if (n2 == 2) {
            this.putInfomation("INF006", "LDEV ShadowImage" + this.getGroupInfo(n));
        }
        ArrayList arrayList = this.controller.getPG(4);
        this.controller.createLdevCache(arrayList);
        int n3 = this.initProgressLDEV(arrayList);
        int n4 = 0;
        CollectParam collectParam = new CollectParam(n, n3);
        n3 -= collectParam.getCount();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            ArrayList arrayList2 = this.controller.getPGToLDEV(rJMdDataPG.getFB4(), rJMdDataPG.getPG());
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator2.next();
                if (n4 >= 128) {
                    this.collect(collectParam, n, n2);
                    this.addProgress(n4);
                    n4 = 0;
                    collectParam = new CollectParam(n, n3);
                    n3 -= collectParam.getCount();
                }
                collectParam.add(n4, rJMdDataPG, rJMdDataLDEV);
                ++n4;
            }
        }
        this.collect(collectParam, n, n2);
        this.addProgress(n4);
        this.closeProgress();
        if (n2 == 1) {
            this.putInfomation("INF007", "LDEV" + this.getGroupInfo(n));
        } else if (n2 == 2) {
            this.putInfomation("INF007", "LDEV ShadowImage" + this.getGroupInfo(n));
        }
    }

    public HIHsmLDEVUseRateArgInfo createArgument(int n, int n2) {
        HIHsmPhysicalLDEVUseRateArgInfo hIHsmPhysicalLDEVUseRateArgInfo = null;
        int n3 = n2;
        if (n2 >= 128) {
            n3 = 128;
        }
        if (n == 0) {
            hIHsmPhysicalLDEVUseRateArgInfo = new HIHsmPhysicalLDEVUseRateArgInfo(1, this.parameter.getShortRange().getFromTime(), this.parameter.getShortRange().getToTime(), n3);
        } else if (n == 1) {
            hIHsmPhysicalLDEVUseRateArgInfo = new HIHsmLDEVUseRateArgInfo(1, this.parameter.getLongRange().getFromTime(), this.parameter.getLongRange().getToTime(), n3);
        }
        return hIHsmPhysicalLDEVUseRateArgInfo;
    }

    public void collect(CollectParam collectParam, int n, int n2) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                Object object;
                Object object2;
                String string;
                String string2;
                RJMdDataPG rJMdDataPG;
                HIHsmPhysicalLDEVUseRate hIHsmPhysicalLDEVUseRate;
                if (n == 0) {
                    hIHsmPhysicalLDEVUseRate = (HIHsmPhysicalLDEVUseRate)monitorInfoCollection.get(i);
                    rJMdDataPG = collectParam.getPG(hIHsmPhysicalLDEVUseRate.getLdkc(), hIHsmPhysicalLDEVUseRate.getCu(), hIHsmPhysicalLDEVUseRate.getLdev());
                    string2 = rJMdDataPG.toString();
                    string = this.toLdevString(hIHsmPhysicalLDEVUseRate.getLdkc(), hIHsmPhysicalLDEVUseRate.getCu(), hIHsmPhysicalLDEVUseRate.getLdev());
                    switch (n2) {
                        case 1: {
                            object2 = PHY_Short_LDEV + string2;
                            object = this.stream.getCurrentEntry();
                            if (object == null || !((RJMdUnitEntry)object).getName().equals(object2)) {
                                if (object != null) {
                                    this.stream.closeEntry();
                                }
                                this.stream.createEntry((String)object2, this.getTimeRange(n));
                            }
                            this.stream.write(new RJMdColumn(string, hIHsmPhysicalLDEVUseRate.getUseRate()));
                            break;
                        }
                        case 2: {
                            String string3 = PHY_Short_LDEV_SI + string2;
                            RJMdUnitEntry rJMdUnitEntry = this.stream.getCurrentEntry();
                            if (rJMdUnitEntry == null || !rJMdUnitEntry.getName().equals(string3)) {
                                if (rJMdUnitEntry != null) {
                                    this.stream.closeEntry();
                                }
                                this.stream.createEntry(string3, this.getTimeRange(n));
                            }
                            this.stream.write(new RJMdColumn(string, hIHsmPhysicalLDEVUseRate.getMrcfAverage()));
                            break;
                        }
                    }
                    continue;
                }
                if (n != 1 || n2 != 1) continue;
                hIHsmPhysicalLDEVUseRate = (HIHsmLDEVUseRate)monitorInfoCollection.get(i);
                rJMdDataPG = collectParam.getPG(hIHsmPhysicalLDEVUseRate.getLdkc(), hIHsmPhysicalLDEVUseRate.getCu(), hIHsmPhysicalLDEVUseRate.getLdev());
                string2 = rJMdDataPG.toString();
                string = PHY_Long_LDEV + string2;
                object2 = this.stream.getCurrentEntry();
                if (object2 == null || !((RJMdUnitEntry)object2).getName().equals(string)) {
                    if (object2 != null) {
                        this.stream.closeEntry();
                    }
                    this.stream.createEntry(string, this.getTimeRange(n));
                }
                object = this.toLdevString(hIHsmPhysicalLDEVUseRate.getLdkc(), hIHsmPhysicalLDEVUseRate.getCu(), hIHsmPhysicalLDEVUseRate.getLdev());
                this.stream.write(new RJMdColumn((String)object, hIHsmPhysicalLDEVUseRate.getUseRate()));
            }
        }
    }

    private int initProgressLDEV(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPG rJMdDataPG = (RJMdDataPG)iterator.next();
            ArrayList arrayList2 = this.controller.getPGToLDEV(rJMdDataPG.getFB4(), rJMdDataPG.getPG());
            n2 += arrayList2.size();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPG)) continue;
            n += arrayList2.size();
        }
        super.initProgress(n, n2);
        return n;
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo(int n) {
        String string = "";
        string = n == 0 ? groupInfoS : groupInfoL;
        return string;
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        this.analyzeTimeRange(rJMdCmdParser);
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePGrpRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPG =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArrayList pglist = new ArrayList();
        private ArrayList ldevlist = new ArrayList();
        private HIHsmLDEVUseRateArgInfo argInfo = null;

        CollectParam(int n, int n2) {
            this.argInfo = RJMdGroupPhyLDEV.this.createArgument(n, n2);
        }

        public int getCount() {
            return this.argInfo.getCount();
        }

        public void add(int n, RJMdDataPG rJMdDataPG, RJMdDataLDEV rJMdDataLDEV) {
            this.pglist.add(rJMdDataPG);
            this.ldevlist.add(rJMdDataLDEV);
            this.argInfo.setAllParam(n, rJMdDataLDEV.getLDKC(), rJMdDataLDEV.getCU(), rJMdDataLDEV.getLDEV());
        }

        public int size() {
            return this.argInfo.getCount();
        }

        public RJMdDataPG getPG(int n) {
            return (RJMdDataPG)this.pglist.get(n);
        }

        public RJMdDataPG getPG(int n, int n2, int n3) {
            RJMdDataPG rJMdDataPG = null;
            Iterator iterator = this.ldevlist.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                RJMdDataLDEV rJMdDataLDEV = (RJMdDataLDEV)iterator.next();
                if (rJMdDataLDEV.getLDKC() == n && rJMdDataLDEV.getCU() == n2 && rJMdDataLDEV.getLDEV() == n3) {
                    rJMdDataPG = this.getPG(n4);
                    break;
                }
                ++n4;
            }
            return rJMdDataPG;
        }

        public HIHsmLDEVUseRateArgInfo getArgument() {
            return this.argInfo;
        }
    }
}

