/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataPort;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgPortAbility;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.data.PPCPortAbility;

public class RJMdGroupPort
extends RJMdGroupData {
    private static final String groupID = "Port";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "Port_dat";
    private static final String groupInfo = "port data";
    public final int LIMIT_PARAMS_PORT;
    public static final int LIMIT_PARAMS_PORT_RAID = 258;
    public static final int LIMIT_PARAMS_PORT_HM = 130;
    private RJMdUnitParallelStream stream = null;
    private static final String EN_Port_IOPS = "Port_IOPS";
    private static final String EN_Port_KBPS = "Port_KBPS";
    private static final String EN_Port_Response = "Port_Response";
    private static final String[] entryNames = new String[]{"Port_IOPS", "Port_KBPS", "Port_Response"};
    private static final int KIND_TARGET = 1;
    private static final int KIND_INITIATOR = 2;
    private static final int ATTR_TARGET = 1;
    private static final int ATTR_INITIATOR = 0;
    private int nPortAttrId = 0;
    private static final String EN_Port_Initiator_IOPS = "Port_Initiator_IOPS";
    private static final String EN_Port_Initiator_KBPS = "Port_Initiator_KBPS";
    private static final String EN_Port_Initiator_Response = "Port_Initiator_Response";
    private static final String[] entryNamesInitiator = new String[]{"Port_Initiator_IOPS", "Port_Initiator_KBPS", "Port_Initiator_Response"};
    private static final String Console_Initiator = "Initiator ";

    public RJMdGroupPort(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.LIMIT_PARAMS_PORT = rJMdDataControl.isHM() ? 130 : 258;
        this.nPortAttrId = 0;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupPort(1, entryNames);
            this.createGroupPort(2, entryNamesInitiator);
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupPort(int n, String[] stringArray) throws RJMdRmiException, IOException {
        Object object;
        switch (n) {
            case 1: {
                this.putInfomation("INF006", this.getGroupInfo());
                break;
            }
            case 2: {
                this.putInfomation("INF006", Console_Initiator + this.getGroupInfo());
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            object = this.stream.createEntry(stringArray[i], this.getTimeRange());
            hashMap.put(stringArray[i], object);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getPort(n);
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPort)) continue;
            if (((CollectParam)object).size() >= this.LIMIT_PARAMS_PORT) {
                this.collect(hashMap, (CollectParam)object, n);
                this.addProgress(((CollectParam)object).size());
                object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
            }
            ((CollectParam)object).add(rJMdDataPort);
        }
        switch (n) {
            case 1: {
                this.nPortAttrId = 1;
                break;
            }
            case 2: {
                this.nPortAttrId = 0;
            }
        }
        ((CollectParam)object).set(this.nPortAttrId);
        this.collect(hashMap, (CollectParam)object, n);
        this.addProgress(((CollectParam)object).size());
        this.closeProgress();
        switch (n) {
            case 1: {
                this.putInfomation("INF007", this.getGroupInfo());
                break;
            }
            case 2: {
                this.putInfomation("INF007", Console_Initiator + this.getGroupInfo());
            }
        }
    }

    private void initProgress(ArrayList arrayList) {
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataPort)) continue;
            ++n;
        }
        super.initProgress(n, arrayList.size());
    }

    public void collect(HashMap hashMap, CollectParam collectParam, int n) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            block4: for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                PPCPortAbility pPCPortAbility = (PPCPortAbility)monitorInfoCollection.get(i);
                String string = collectParam.getPortName(pPCPortAbility.getPortID());
                switch (n) {
                    case 1: {
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_Port_IOPS), new RJMdColumn(string, pPCPortAbility.getAvrIOPerSec()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_Port_KBPS), new RJMdColumn(string, pPCPortAbility.getAvrTransRate()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_Port_Response), new RJMdColumn(string, pPCPortAbility.getResponseTime()));
                        continue block4;
                    }
                    case 2: {
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_Port_Initiator_IOPS), new RJMdColumn(string, pPCPortAbility.getAvrIOPerSec()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_Port_Initiator_KBPS), new RJMdColumn(string, pPCPortAbility.getAvrTransRate()));
                        this.stream.write((RJMdUnitEntry)hashMap.get(EN_Port_Initiator_Response), new RJMdColumn(string, pPCPortAbility.getResponseTime()));
                        continue block4;
                    }
                }
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzePortRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tPort =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArgPortAbility portArgument = null;
        private ArrayList portlist = new ArrayList();

        CollectParam(Date date, Date date2) {
            this.portArgument = new ArgPortAbility(1, date, date2);
        }

        public void add(RJMdDataPort rJMdDataPort) {
            this.portlist.add(rJMdDataPort);
            this.portArgument.addPortID(rJMdDataPort.getPortID());
        }

        public void set(int n) {
            this.portArgument.setPortAttr(n);
        }

        public int size() {
            return this.portArgument.size();
        }

        public String getPortName(int n) {
            String string = "unknown";
            Iterator iterator = this.portlist.iterator();
            while (iterator.hasNext()) {
                RJMdDataPort rJMdDataPort = (RJMdDataPort)iterator.next();
                if (n != rJMdDataPort.getPortID()) continue;
                string = rJMdDataPort.getPortName();
                break;
            }
            return string;
        }

        public ArgPortAbility getArgument() {
            return this.portArgument;
        }
    }
}

