/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgHRCCLPR;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.MonitorInfoCollection;
import sanproject.serverux.dataimpl.PRMCLPRName;
import sanproject.serverux.dataimpl.RMCPgetUsageCLPRInfEx;

public class RJMdGroupRCCLPR
extends RJMdGroupData {
    private static final String groupID = "RCCLPR";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "RCCLPR_dat";
    private static final String groupInfo = "RCCLPR data";
    private RJMdUnitParallelStream stream = null;
    public static final int LIMIT_PARAMS_RCCLPR = 32;
    private static final String EN_RCCLPR_SideFile = "RCCLPR_SideFile";
    private static final String[] entryNames = new String[]{"RCCLPR_SideFile"};

    public RJMdGroupRCCLPR(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.allowPSA = false;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupRCCLPR();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupRCCLPR() throws RJMdRmiException, IOException {
        Object object;
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < entryNames.length; ++i) {
            object = this.stream.createEntry(entryNames[i], this.getTimeRange());
            hashMap.put(entryNames[i], object);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getCLPRList();
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            PRMCLPRName pRMCLPRName = (PRMCLPRName)iterator.next();
            if (((CollectParam)object).size() >= 32) {
                this.collect(hashMap, (CollectParam)object);
                this.addProgress(((CollectParam)object).size());
                object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
            }
            ((CollectParam)object).add(pRMCLPRName);
        }
        this.collect(hashMap, (CollectParam)object);
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        super.initProgress(n += arrayList.size(), n);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                RMCPgetUsageCLPRInfEx rMCPgetUsageCLPRInfEx = (RMCPgetUsageCLPRInfEx)monitorInfoCollection.get(i);
                String string = collectParam.toColumnName(rMCPgetUsageCLPRInfEx.getClpr());
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_RCCLPR_SideFile), new RJMdColumn(string, rMCPgetUsageCLPRInfEx.getSideFile()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    class CollectParam {
        private ArrayList clprList = new ArrayList();
        private HashMap columnNames = new HashMap();
        private Date fromTime;
        private Date toTime;

        CollectParam(Date date, Date date2) {
            this.fromTime = date;
            this.toTime = date2;
        }

        public void add(PRMCLPRName pRMCLPRName) {
            this.columnNames.put(this.toKeyString(pRMCLPRName.nID), pRMCLPRName);
            this.clprList.add(pRMCLPRName);
        }

        public int size() {
            return this.clprList.size();
        }

        private String toColumnName(int n) {
            PRMCLPRName pRMCLPRName = (PRMCLPRName)this.columnNames.get(this.toKeyString(n));
            short s = pRMCLPRName.nID;
            String string = pRMCLPRName.strName;
            MessageFormat messageFormat = new MessageFormat("{0,number,00}({1})");
            Object[] objectArray = new Object[]{new Integer(s), string};
            String string2 = messageFormat.format(objectArray);
            return string2;
        }

        private String toKeyString(int n) {
            String string = String.valueOf(n);
            return string;
        }

        public ArgHRCCLPR getArgument() {
            int[] nArray = new int[this.clprList.size()];
            Iterator iterator = this.clprList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                PRMCLPRName pRMCLPRName = (PRMCLPRName)iterator.next();
                nArray[n] = pRMCLPRName.nID;
                ++n;
            }
            ArgHRCCLPR argHRCCLPR = new ArgHRCCLPR(this.fromTime, this.toTime, nArray);
            return argHRCCLPR;
        }
    }
}

