/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdCmdParser;
import sanproject.getmondat.com.RJMdRange;
import sanproject.getmondat.com.RJMdRmiException;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.data.RJMdDataControl;
import sanproject.getmondat.data.RJMdDataJNL;
import sanproject.getmondat.group.RJMdColumn;
import sanproject.getmondat.group.RJMdGroupData;
import sanproject.getmondat.group.RJMdUnitEntry;
import sanproject.getmondat.group.RJMdUnitParallelStream;
import sanproject.serverux.arg.monitor.ArgHURGrp;
import sanproject.serverux.arg.monitor.MonArg;
import sanproject.serverux.data.HURgetUsageGrpInf;
import sanproject.serverux.data.MonitorInfoCollection;

public class RJMdGroupURJNL
extends RJMdGroupData {
    private static final String groupID = "URJNL";
    private static final String[] groupAlias = new String[0];
    private static final String groupName = "URJNL_dat";
    private static final String groupInfo = "URJNL data";
    private RJMdUnitParallelStream stream = null;
    public static final int LIMIT_PARAMS_URJNL = 512;
    private static final String EN_URJNL_Read_Record = "URJNL_Read_Record";
    private static final String EN_URJNL_Read_Hit = "URJNL_Read_Hit";
    private static final String EN_URJNL_Write_Record = "URJNL_Write_Record";
    private static final String EN_URJNL_Write_Hit = "URJNL_Write_Hit";
    private static final String EN_URJNL_Read_Transfer = "URJNL_Read_Transfer";
    private static final String EN_URJNL_Write_Transfer = "URJNL_Write_Transfer";
    private static final String EN_URJNL_Initial_Copy_Hit = "URJNL_Initial_Copy_Hit";
    private static final String EN_URJNL_Initial_Copy_Transfer = "URJNL_Initial_Copy_Transfer";
    private static final String EN_URJNL_MJNL_Asynchronous_RIO = "URJNL_M-JNL_Asynchronous_RIO";
    private static final String EN_URJNL_MJNL_Asynchronous_Journal = "URJNL_M-JNL_Asynchronous_Journal";
    private static final String EN_URJNL_MJNL_Asynchronous_Copy_Transfer = "URJNL_M-JNL_Asynchronous_Copy_Transfer";
    private static final String EN_URJNL_MJNL_Asynchronous_Copy_Response = "URJNL_M-JNL_Asynchronous_Copy_Response";
    private static final String EN_URJNL_RJNL_Asynchronous_RIO = "URJNL_R-JNL_Asynchronous_RIO";
    private static final String EN_URJNL_RJNL_Asynchronous_Journal = "URJNL_R-JNL_Asynchronous_Journal";
    private static final String EN_URJNL_RJNL_Asynchronous_Copy_Transfer = "URJNL_R-JNL_Asynchronous_Copy_Transfer";
    private static final String EN_URJNL_RJNL_Asynchronous_Copy_Response = "URJNL_R-JNL_Asynchronous_Copy_Response";
    private static final String EN_URJNL_MJNL_Data_Used_Rate = "URJNL_M-JNL_Data_Used_Rate";
    private static final String EN_URJNL_MJNL_Meta_Data_Used_Rate = "URJNL_M-JNL_Meta_Data_Used_Rate";
    private static final String EN_URJNL_RJNL_Data_Used_Rate = "URJNL_R-JNL_Data_Used_Rate";
    private static final String EN_URJNL_RJNL_Meta_Data_Used_Rate = "URJNL_R-JNL_Meta_Data_Used_Rate";
    private static final String[] entryNames = new String[]{"URJNL_Write_Record", "URJNL_Write_Transfer", "URJNL_Initial_Copy_Hit", "URJNL_Initial_Copy_Transfer", "URJNL_M-JNL_Asynchronous_RIO", "URJNL_M-JNL_Asynchronous_Journal", "URJNL_M-JNL_Asynchronous_Copy_Transfer", "URJNL_M-JNL_Asynchronous_Copy_Response", "URJNL_R-JNL_Asynchronous_RIO", "URJNL_R-JNL_Asynchronous_Journal", "URJNL_R-JNL_Asynchronous_Copy_Transfer", "URJNL_R-JNL_Asynchronous_Copy_Response", "URJNL_M-JNL_Data_Used_Rate", "URJNL_M-JNL_Meta_Data_Used_Rate", "URJNL_R-JNL_Data_Used_Rate", "URJNL_R-JNL_Meta_Data_Used_Rate"};

    public RJMdGroupURJNL(RJMdDataControl rJMdDataControl) {
        super(rJMdDataControl);
        this.allowPSA = false;
    }

    public void init() throws IOException {
        String string = this.parameter.getDirectory();
        File file = new File(string);
        this.stream = new RJMdUnitParallelStream(groupName, file);
        this.stream.setCompress(this.parameter.isCompless());
    }

    protected boolean isGroupExists() {
        boolean bl = this.stream.exists();
        return bl;
    }

    public void deleteGroup() {
        this.stream.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGroup() throws RJMdRmiException, IOException {
        try {
            this.createGroupURJNL();
        }
        finally {
            this.stream.close();
        }
    }

    private void createGroupURJNL() throws RJMdRmiException, IOException {
        Object object;
        this.putInfomation("INF006", this.getGroupInfo());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < entryNames.length; ++i) {
            object = this.stream.createEntry(entryNames[i], this.getTimeRange());
            hashMap.put(entryNames[i], object);
        }
        RJMdTimeRange rJMdTimeRange = this.parameter.getShortRange();
        object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
        ArrayList arrayList = this.controller.getJNLGrps();
        this.initProgress(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataJNL rJMdDataJNL = (RJMdDataJNL)iterator.next();
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataJNL)) continue;
            int n = rJMdDataJNL.getJNLGrpNum();
            if (((CollectParam)object).size() >= 512) {
                this.collect(hashMap, (CollectParam)object);
                this.addProgress(((CollectParam)object).size());
                object = new CollectParam(rJMdTimeRange.getFromTime(), rJMdTimeRange.getToTime());
            }
            ((CollectParam)object).add(rJMdDataJNL);
        }
        this.collect(hashMap, (CollectParam)object);
        this.closeProgress();
        this.putInfomation("INF007", this.getGroupInfo());
    }

    private void initProgress(ArrayList arrayList) throws RJMdRmiException {
        int n = 0;
        int n2 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            RJMdDataJNL rJMdDataJNL = (RJMdDataJNL)iterator.next();
            ++n2;
            if (!this.parameter.containsRange(this.getGroupID(), rJMdDataJNL)) continue;
            ++n;
        }
        super.initProgress(n, n2);
    }

    public void collect(HashMap hashMap, CollectParam collectParam) throws RJMdRmiException, IOException {
        if (collectParam.size() > 0) {
            MonitorInfoCollection monitorInfoCollection = (MonitorInfoCollection)this.controller.getMonitorInfo((MonArg)collectParam.getArgument());
            for (int i = 0; i < monitorInfoCollection.size(); ++i) {
                HURgetUsageGrpInf hURgetUsageGrpInf = (HURgetUsageGrpInf)monitorInfoCollection.get(i);
                String string = collectParam.toColumnName(hURgetUsageGrpInf.getJNLGrp());
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_Write_Record), new RJMdColumn(string, hURgetUsageGrpInf.getwriteRecord()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_Write_Transfer), new RJMdColumn(string, hURgetUsageGrpInf.getwriteTransfer()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_Initial_Copy_Hit), new RJMdColumn(string, hURgetUsageGrpInf.getinitHit()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_Initial_Copy_Transfer), new RJMdColumn(string, hURgetUsageGrpInf.getinitTransfer()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_MJNL_Asynchronous_RIO), new RJMdColumn(string, hURgetUsageGrpInf.getmjnlAsyncRio()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_MJNL_Asynchronous_Journal), new RJMdColumn(string, hURgetUsageGrpInf.getmjniAsyncJnl()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_MJNL_Asynchronous_Copy_Transfer), new RJMdColumn(string, hURgetUsageGrpInf.getmjnlAsyncTransfer()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_MJNL_Asynchronous_Copy_Response), new RJMdColumn(string, hURgetUsageGrpInf.getmjnlAsyncResponse()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_RJNL_Asynchronous_RIO), new RJMdColumn(string, hURgetUsageGrpInf.getrjnlAsyncRio()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_RJNL_Asynchronous_Journal), new RJMdColumn(string, hURgetUsageGrpInf.getrjnlAsyncJnl()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_RJNL_Asynchronous_Copy_Transfer), new RJMdColumn(string, hURgetUsageGrpInf.getrjnlAsyncTransfer()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_RJNL_Asynchronous_Copy_Response), new RJMdColumn(string, hURgetUsageGrpInf.getrjnlAsyncResponce()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_MJNL_Data_Used_Rate), new RJMdColumn(string, hURgetUsageGrpInf.getmjnlDataUsed()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_MJNL_Meta_Data_Used_Rate), new RJMdColumn(string, hURgetUsageGrpInf.getmjnlMetaDataUsed()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_RJNL_Data_Used_Rate), new RJMdColumn(string, hURgetUsageGrpInf.getrjnlDataUsed()));
                this.stream.write((RJMdUnitEntry)hashMap.get(EN_URJNL_RJNL_Meta_Data_Used_Rate), new RJMdColumn(string, hURgetUsageGrpInf.getrjnlMetaDataUsed()));
            }
        }
    }

    public String[] getGroupAlias() {
        return groupAlias;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupName() {
        return groupName;
    }

    public String getGroupInfo() {
        return groupInfo;
    }

    public RJMdTimeRange getTimeRange() {
        return this.parameter.getShortRange();
    }

    public void analyzeOperand(RJMdCmdParser rJMdCmdParser) throws ParseException {
        RJMdRange rJMdRange = null;
        char c = rJMdCmdParser.getKind();
        while ((rJMdRange = this.analyzeJNLRange(rJMdCmdParser)) != null) {
            RJMdDataControl.trace("\tJNL =  " + rJMdRange);
            this.parameter.addGroupRange(this.getGroupID(), rJMdRange);
            if (rJMdCmdParser.getKind() != ' ') break;
            rJMdCmdParser.nextToken();
        }
    }

    class CollectParam {
        private ArrayList jnlList = new ArrayList();
        private Date fromTime;
        private Date toTime;

        CollectParam(Date date, Date date2) {
            this.fromTime = date;
            this.toTime = date2;
        }

        public void add(RJMdDataJNL rJMdDataJNL) {
            this.jnlList.add(rJMdDataJNL);
        }

        public int size() {
            return this.jnlList.size();
        }

        private String toColumnName(int n) {
            String string = RJMdGroupURJNL.this.toHexString(n, 2);
            return string;
        }

        public ArgHURGrp getArgument() {
            int n = this.jnlList.size();
            int[] nArray = new int[n];
            Iterator iterator = this.jnlList.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                RJMdDataJNL rJMdDataJNL = (RJMdDataJNL)iterator.next();
                nArray[n2] = rJMdDataJNL.getJNLGrpNum();
                ++n2;
            }
            ArgHURGrp argHURGrp = new ArgHURGrp(this.fromTime, this.toTime, nArray);
            return argHURGrp;
        }
    }
}

