/*
 * Decompiled with CFR 0.152.
 */
package sanproject.getmondat.group;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import sanproject.getmondat.com.RJMdExecParameter;
import sanproject.getmondat.com.RJMdTimeRange;
import sanproject.getmondat.group.RJMdColumn;

public class RJMdUnitEntry {
    public static final int MAX_COLUMN = 128;
    private static final String NEWLINE = System.getProperty("line.separator");
    private String entryName;
    private File entryPath;
    private String fileName;
    private ArrayList columns = new ArrayList();
    private boolean appendMode = false;
    private RJMdTimeRange timeRange = null;
    private boolean titleOut = false;
    private int serialNumber;
    private String productName;

    public RJMdUnitEntry(String string, File file, RJMdTimeRange rJMdTimeRange) {
        this.entryName = string;
        this.fileName = string + ".csv";
        this.entryPath = new File(file.getAbsolutePath(), string);
        this.timeRange = rJMdTimeRange;
        this.serialNumber = RJMdExecParameter.getSerialNumber();
        this.productName = RJMdExecParameter.getProductName();
    }

    public String getName() {
        return this.entryName;
    }

    public boolean getAppendMode() {
        boolean bl = this.appendMode;
        this.appendMode = true;
        return bl;
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public boolean write(RJMdColumn rJMdColumn) throws IOException {
        boolean bl = false;
        int n = this.columns.size();
        if (n < 128) {
            this.columns.add(rJMdColumn);
            bl = true;
        }
        return bl;
    }

    public void flush(OutputStream outputStream) throws IOException {
        this.flushColumns(outputStream);
        this.columns.clear();
    }

    private void flushColumns(OutputStream outputStream) throws IOException {
        int n = this.columns.size();
        if (n > 0) {
            if (!this.titleOut) {
                this.write(outputStream, this.getTitleString());
                this.titleOut = true;
            }
            this.write(outputStream, this.getHeaderString());
            int n2 = ((RJMdColumn)this.columns.get(0)).getRowCount();
            for (int i = 0; i < n2; ++i) {
                String string = "\"" + String.valueOf(i + 1) + "\",";
                string = string + "\"" + this.timeRange.toTickString(i + 1) + "\"";
                Iterator iterator = this.columns.iterator();
                while (iterator.hasNext()) {
                    RJMdColumn rJMdColumn = (RJMdColumn)iterator.next();
                    String[] stringArray = rJMdColumn.getValues();
                    string = string + "," + stringArray[i];
                }
                this.write(outputStream, string);
            }
        }
    }

    private void write(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = (string + NEWLINE).getBytes();
        outputStream.write(byArray, 0, byArray.length);
    }

    private String getTitleString() {
        StringBuffer stringBuffer = new StringBuffer(this.fileName + NEWLINE);
        stringBuffer.append("Serial number : " + this.serialNumber + "(" + this.productName + ")" + NEWLINE);
        stringBuffer.append("From : " + this.timeRange.toFromString() + NEWLINE);
        stringBuffer.append("To   : " + this.timeRange.toToString() + NEWLINE);
        long l = this.timeRange.getUnitTime();
        if (l >= 0L) {
            stringBuffer.append("sampling rate : " + l / 60L / 1000L + NEWLINE);
        }
        return stringBuffer.toString();
    }

    private String getHeaderString() {
        StringBuffer stringBuffer = new StringBuffer("\"No.\",");
        stringBuffer.append("\"time\"");
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            RJMdColumn rJMdColumn = (RJMdColumn)iterator.next();
            stringBuffer.append(",\"" + rJMdColumn.getName() + "\"");
        }
        return stringBuffer.toString();
    }

    public void print(PrintStream printStream) {
        printStream.println("RJMdUnitEntry.print start " + this.entryName);
        int n = this.columns.size();
        if (n > 0) {
            printStream.println(this.getHeaderString());
            int n2 = ((RJMdColumn)this.columns.get(0)).getRowCount();
            for (int i = 0; i < n2; ++i) {
                String string = String.valueOf(i);
                Iterator iterator = this.columns.iterator();
                while (iterator.hasNext()) {
                    RJMdColumn rJMdColumn = (RJMdColumn)iterator.next();
                    String[] stringArray = rJMdColumn.getValues();
                    string = string + "," + stringArray[i];
                }
                printStream.println(string);
            }
        }
        printStream.println("RJMdUnitEntry.print end");
    }
}

