/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.xml;

import com.klg.jclass.util.xml.JCTablePopulator;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import com.sun.xml.parser.Resolver;
import com.sun.xml.parser.ValidatingParser;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JCTableXMLParser
implements Serializable {
    public static final String JCTableDataDTD = "<!-- DTD for JClass LiveTable data source -->\n<!ELEMENT JCTableData (ColumnLabel*, Row+) >\n\n<!ELEMENT Row (RowLabel?, Cell*) >\n\n<!ELEMENT Cell (#PCDATA)>\n<!ELEMENT RowLabel (#PCDATA)>\n<!ELEMENT ColumnLabel (#PCDATA)>\n\n";
    public static final String XML_DS = "JCTableData";
    public static final String XML_DS_COLUMNLABEL = "ColumnLabel";
    public static final String XML_DS_ROWLABEL = "RowLabel";
    public static final String XML_DS_ROW = "Row";
    public static final String XML_DS_ROW_CELL = "Cell";
    protected boolean isDebug = false;

    private Object cvtToTableValue(String string) {
        try {
            Double d = new Double(string);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public void readAndParse(Reader reader, JCTablePopulator jCTablePopulator) throws IOException {
        InputSource inputSource = new InputSource(reader);
        XmlDocument xmlDocument = null;
        try {
            XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
            ValidatingParser validatingParser = new ValidatingParser();
            inputSource.setSystemId("file:/template.xml");
            validatingParser.setErrorHandler((ErrorHandler)new JCXMLErrorPrinter());
            validatingParser.setEntityResolver((EntityResolver)((Object)new DTDResolver()));
            validatingParser.setDocumentHandler((DocumentHandler)xmlDocumentBuilder);
            validatingParser.parse(inputSource);
            xmlDocument = xmlDocumentBuilder.getDocument();
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
            throw new IOException("XML Parsing Error");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
            throw new IOException("XML Error");
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw iOException;
        }
        if (xmlDocument == null) {
            return;
        }
        this.readTableData(xmlDocument, jCTablePopulator);
    }

    private void readTableData(XmlDocument xmlDocument, JCTablePopulator jCTablePopulator) throws IOException {
        int n;
        Object object;
        Object object2;
        TreeWalker treeWalker = new TreeWalker((Node)xmlDocument);
        Element element = treeWalker.getNextElement(XML_DS);
        element.normalize();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        Node node = treeWalker.getNextElement(XML_DS_COLUMNLABEL);
        while (node != null) {
            ++n4;
            node = treeWalker.getNextElement(XML_DS_COLUMNLABEL);
        }
        if (n4 > 0) {
            bl2 = true;
        }
        n3 = Math.max(n3, n4);
        treeWalker.reset();
        Element element2 = treeWalker.getNextElement(XML_DS_ROW);
        while (element2 != null) {
            ++n2;
            object2 = new TreeWalker((Node)element2);
            int n5 = 0;
            object = object2.getNextElement(XML_DS_ROW_CELL);
            while (object != null) {
                ++n5;
                object = object2.getNextElement(XML_DS_ROW_CELL);
            }
            n3 = Math.max(n3, n5);
            object2.reset();
            if (!bl && object2.getNextElement(XML_DS_ROWLABEL) != null) {
                bl = true;
            }
            element2 = treeWalker.getNextElement(XML_DS_ROW);
        }
        object2 = null;
        Vector vector = new Vector();
        object = new Vector();
        Vector<TreeWalker> vector2 = new Vector<TreeWalker>();
        Vector<TreeWalker> vector3 = null;
        treeWalker.reset();
        if (bl2) {
            n = 0;
            while ((node = treeWalker.getNextElement(XML_DS_COLUMNLABEL)) != null) {
                object2 = null;
                if (node != null) {
                    object2 = (node = node.getFirstChild()) != null && node instanceof Text ? this.cvtToTableValue(node.getNodeValue()) : "";
                }
                vector2.addElement((TreeWalker)object2);
                if (this.isDebug) {
                    System.out.println("Column Label " + n + " is " + object2);
                }
                ++n;
            }
        }
        treeWalker.reset();
        n = 0;
        while (n < n2) {
            Node node2;
            Element element3 = treeWalker.getNextElement(XML_DS_ROW);
            if (element3 == null) break;
            TreeWalker treeWalker2 = new TreeWalker((Node)element3);
            if (bl) {
                object2 = null;
                node2 = treeWalker2.getNextElement(XML_DS_ROWLABEL);
                if (node2 != null) {
                    if ((node2 = node2.getFirstChild()) != null && node2 instanceof Text) {
                        object2 = this.cvtToTableValue(node2.getNodeValue());
                    }
                } else {
                    object2 = null;
                }
                ((Vector)object).addElement(object2);
                if (this.isDebug) {
                    System.out.println("Row Label " + n + " is " + object2);
                }
            }
            vector3 = new Vector<TreeWalker>();
            treeWalker2.reset();
            node2 = null;
            int n6 = 0;
            while ((node2 = treeWalker2.getNextElement(XML_DS_ROW_CELL)) != null) {
                object2 = null;
                if (node2 != null && (node2 = node2.getFirstChild()) != null && node2 instanceof Text) {
                    object2 = this.cvtToTableValue(node2.getNodeValue());
                }
                vector3.addElement((TreeWalker)object2);
                if (this.isDebug) {
                    System.out.println("Value at row " + n + " col " + n6 + " is " + object2);
                }
                ++n6;
            }
            vector.addElement(vector3);
            ++n;
        }
        jCTablePopulator.setTableData(vector, (Vector)object, vector2, n2, n3);
    }

    static class DTDResolver
    extends Resolver {
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2.indexOf("JCTableData.dtd") != -1) {
                return new InputSource(new StringReader(JCTableXMLParser.JCTableDataDTD));
            }
            return super.resolveEntity(string, string2);
        }
    }
}

