/*
 * Decompiled with CFR 0.152.
 */
package sanproject.trlog.utility.logging;

import java.io.FileInputStream;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import sanproject.trlog.utility.com.TRLogFormatter;

public class MultiUnitTrOperationLogger {
    private String logFilePath = "";
    private String propFilePath = "";
    public final String LOGGER_NAME = "TRLogger";
    private final String LIMIT_KEY = "limit";
    private final String COUNT_KEY = "count";
    private int limit = 0;
    private int count = 0;
    private Logger logger = null;

    private MultiUnitTrOperationLogger(String logFilePath, String propFilePath) {
        this.logFilePath = logFilePath;
        this.propFilePath = propFilePath;
        this.initialize();
    }

    public static MultiUnitTrOperationLogger getLogger(String logFilePath, String propFilePath) {
        MultiUnitTrOperationLogger trLogger = new MultiUnitTrOperationLogger(logFilePath, propFilePath);
        return trLogger;
    }

    private void initialize() {
        block2: {
            FileHandler handler = null;
            this.logger = Logger.getLogger("TRLogger");
            this.readProperties();
            try {
                handler = new FileHandler(this.logFilePath, this.limit, this.count, true);
                handler.setFormatter(new TRLogFormatter());
                this.logger.addHandler(handler);
                this.logger.setUseParentHandlers(false);
            }
            catch (Exception e) {
                if (handler == null) break block2;
                handler.close();
                this.logger.removeHandler(handler);
            }
        }
    }

    public void putLog(String log) {
        this.logger.info(log);
    }

    private void readProperties() {
        Properties cnf = new Properties();
        try {
            cnf.load(new FileInputStream(this.propFilePath));
            this.limit = this.chkProps(cnf, "limit");
            if (this.limit == 0) {
                this.limit = 0x100000;
            }
            this.count = this.chkProps(cnf, "count");
            if (this.count == 0) {
                this.count = 10;
            }
        }
        catch (Exception e) {
            this.limit = 0x100000;
            this.count = 10;
        }
    }

    private int chkProps(Properties cnf, String paramName) {
        int param = 0;
        try {
            param = Integer.parseInt(cnf.getProperty(paramName));
        }
        catch (Exception e) {
            // empty catch block
        }
        return param;
    }

    public void close() {
        Handler[] handlers = this.logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            this.logger.removeHandler(handlers[i]);
            handlers[i].close();
        }
    }
}

