/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sanproject.client.data.RJDataMsg;
import sanproject.server.data.DGDgetGuardFile;
import sanproject.server.data.DISKgetSubsystemInfo;

public class RJDGDFODownloadPanel
extends RJDGDInsetsPanel
implements ListSelectionListener {
    private static final String CLASSNAME = "RJDGDFODownloadPanel";
    private RJDGDFODataControler m_clsDataControler;
    private RJDGDFOGuardFileList m_lstPatternFiles;
    private JButton m_btnExecDownload;

    public static void main(String[] stringArray) {
        Thread thread = Thread.currentThread();
        try {
            System.out.println("UnitTest start.");
            JFrame jFrame = new JFrame("UnitTest Window");
            jFrame.setDefaultCloseOperation(3);
            System.out.println("\tNo 'DataControler' Constructor");
            Thread.sleep(1000L);
            System.out.println("\t@ create Panel.");
            RJDGDFODownloadPanel rJDGDFODownloadPanel = new RJDGDFODownloadPanel();
            jFrame.getContentPane().add(rJDGDFODownloadPanel);
            jFrame.pack();
            jFrame.show();
            System.out.println("\tSuccessful.");
            System.out.println("\n");
            System.out.println("\tEnable Test");
            System.out.println("\t@ setEnabled : true");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.setEnabled(true);
            System.out.println("\t@ setEnabled : false");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.setEnabled(false);
            System.out.println("\tSuccessful.");
            System.out.println("\n");
            System.out.println("\tRefresh Test");
            System.out.println("\t@ call refreshData...");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.refreshData();
            System.out.println("\tSuccessful.");
            System.out.println("\n");
            System.out.println("\tDownload Test");
            System.out.println("\t@ downloadDirectory : null");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.downloadGuardFile(null);
            System.out.println("\t@ downloadDirectory : " + System.getProperty("user.home"));
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.downloadGuardFile(new File(System.getProperty("user.home")));
            System.out.println("\t@ downloadDirectory : unknown directory");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.downloadGuardFile(new File("/hogehogehoge"));
            System.out.println("\tSuccessful.");
            System.out.println("\n");
            System.out.println("\tNew 'DataControler' Constructor");
            Thread.sleep(1000L);
            System.out.println("\t@ create Panel.");
            rJDGDFODownloadPanel = new RJDGDFODownloadPanel(new RJDGDJWSDataControler());
            jFrame.getContentPane().removeAll();
            jFrame.getContentPane().add(rJDGDFODownloadPanel);
            jFrame.pack();
            jFrame.show();
            System.out.println("\tSuccessful.");
            System.out.println("\n");
            System.out.println("\tEnable Test");
            System.out.println("\t@ setEnabled : true");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.setEnabled(true);
            System.out.println("\t@ setEnabled : false");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.setEnabled(false);
            System.out.println("\tSuccessful.");
            System.out.println("\n");
            System.out.println("\tRefresh Test");
            System.out.println("\t@ call refreshData...");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.refreshData();
            System.out.println("\tSuccessful.");
            System.out.println("\n");
            System.out.println("\tDownload Test");
            System.out.println("\t@ downloadDirectory : null");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.downloadGuardFile(null);
            System.out.println("\t@ downloadDirectory : " + System.getProperty("user.home"));
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.downloadGuardFile(new File(System.getProperty("user.home")));
            System.out.println("\t@ downloadDirectory : unknown directory");
            Thread.sleep(1000L);
            rJDGDFODownloadPanel.downloadGuardFile(new File("/hogehogehoge"));
            System.out.println("\tSuccessful.");
            System.out.println("\n");
            System.out.println("UnitTest Successful.");
        }
        catch (Exception exception) {
            System.out.println("Found Exception : " + exception.getClass().getName());
            exception.printStackTrace(System.err);
        }
    }

    public RJDGDFODownloadPanel() {
        this((RJDGDFODataControler)null);
    }

    public RJDGDFODownloadPanel(RJDGDFODataControler rJDGDFODataControler) {
        this.initInstance();
        this.buildLayout();
        this.setDataControler(rJDGDFODataControler);
    }

    public void setEnabled(boolean bl) {
        final boolean bl2 = bl;
        Runnable runnable = new Runnable(){

            public void run() {
                RJDGDFODownloadPanel.this.m_lstPatternFiles.setEnabled(bl2);
            }
        };
        SwingUtilities.invokeLater(runnable);
        if (bl2) {
            Runnable runnable2 = new Runnable(){

                public void run() {
                    ListSelectionModel listSelectionModel = RJDGDFODownloadPanel.this.m_lstPatternFiles.getSelectionModel();
                    ListSelectionEvent listSelectionEvent = new ListSelectionEvent(listSelectionModel, 0, 0, false);
                    RJDGDFODownloadPanel.this.valueChanged(listSelectionEvent);
                }
            };
            SwingUtilities.invokeLater(runnable2);
        } else {
            Runnable runnable3 = new Runnable(){

                public void run() {
                    RJDGDFODownloadPanel.this.m_btnExecDownload.setEnabled(bl2);
                }
            };
            SwingUtilities.invokeLater(runnable3);
        }
    }

    public void refreshData() throws RJDGDRefreshDataException {
        RJDGDFODataControler rJDGDFODataControler = this.getDataControler();
        if (rJDGDFODataControler != null) {
            this.m_lstPatternFiles.refreshData(rJDGDFODataControler);
        }
    }

    protected void finalize() throws Throwable {
        this.m_btnExecDownload = null;
        this.m_lstPatternFiles = null;
        this.m_clsDataControler = null;
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void downloadGuardFile(File file) {
        String string;
        Object[] objectArray;
        RJDGDFODataControler rJDGDFODataControler = this.getDataControler();
        if (rJDGDFODataControler == null) return;
        if (file == null) return;
        if (file.exists()) {
            objectArray = rJDGDFODataControler.getMessageObject(9211, 5808);
            string = RJDGDGuidanceManager.getString("STRING_DPT_EXTENDEDFILE");
            int n = JOptionPane.showConfirmDialog(this, objectArray.getMessage(), string, 0, 3);
            if (n != 0) {
                return;
            }
        }
        RJDGDFOFrontPanel.initProgress();
        RJDGDFOFrontPanel.addProgressMaximum(100);
        RJDGDFOFrontPanel.setPanelEnabled(false);
        RJDGDFOFrontPanel.addProgressValue(2);
        objectArray = this.m_lstPatternFiles.getSelectedValues();
        RJDGDFOFrontPanel.addProgressValue(2);
        if (objectArray == null) return;
        if (objectArray.length <= 0) return;
        string = objectArray[0].toString();
        RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "Download Guard File [" + string + " -> " + file.getName() + "]");
        try {
            try {
                DGDgetGuardFile dGDgetGuardFile = rJDGDFODataControler.downloadGuardFile(string);
                RJDGDFOFrontPanel.addProgressValue(2);
                dGDgetGuardFile.name = file.getName();
                RJDGDFOFrontPanel.addProgressValue(2);
                GuardFileWriter guardFileWriter = new GuardFileWriter(dGDgetGuardFile);
                guardFileWriter.setOutputDirectory(file.getParentFile());
                guardFileWriter.write();
                RJDGDFOFrontPanel.addProgressValue(20);
                rJDGDFODataControler.setProperty("donwload_directory", file.getParent());
                RJDataMsg rJDataMsg = rJDGDFODataControler.getMessageObject(110, 9002);
                RJDGDFOFrontPanel.showMessageDialog(rJDataMsg);
            }
            catch (Exception exception) {
                RJDGDFOFrontPanel.processException(exception);
                Object var9_11 = null;
                RJDGDFOFrontPanel.destroyProgress();
                RJDGDFOFrontPanel.setPanelEnabled(true);
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            RJDGDFOFrontPanel.destroyProgress();
            RJDGDFOFrontPanel.setPanelEnabled(true);
            throw throwable;
        }
        RJDGDFOFrontPanel.destroyProgress();
        RJDGDFOFrontPanel.setPanelEnabled(true);
    }

    synchronized void setDataControler(RJDGDFODataControler rJDGDFODataControler) {
        this.m_clsDataControler = rJDGDFODataControler;
    }

    RJDGDFODataControler getDataControler() {
        return this.m_clsDataControler;
    }

    private void initInstance() {
        this.m_lstPatternFiles = new RJDGDFOGuardFileList();
        this.m_lstPatternFiles.setSelectionMode(0);
        this.m_lstPatternFiles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && n == 2) {
                    RJDGDFODownloadPanel.this.m_btnExecDownload.doClick();
                }
            }
        });
        final ListSelectionModel listSelectionModel = this.m_lstPatternFiles.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        ButtonOperator buttonOperator = new ButtonOperator();
        String string = "STRING_BTN_DOWNLOAD";
        String string2 = RJDGDGuidanceManager.getString(string);
        Color color = RJDGDGuidanceManager.getColor(string);
        this.m_btnExecDownload = new RJDGDBaseButton(string2);
        this.m_btnExecDownload.setActionCommand(string);
        this.m_btnExecDownload.setForeground(color);
        this.m_btnExecDownload.addActionListener(buttonOperator);
        Runnable runnable = new Runnable(){

            public void run() {
                ListSelectionEvent listSelectionEvent = new ListSelectionEvent(listSelectionModel, 0, 0, false);
                RJDGDFODownloadPanel.this.valueChanged(listSelectionEvent);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void buildLayout() {
        String string = "STRING_TNN_KEYPATTERN";
        String string2 = RJDGDGuidanceManager.getString(string);
        JComponent jComponent = new RJDGDFieldTitleLabel(string2);
        RJDGDBaseScrollPane rJDGDBaseScrollPane = new RJDGDBaseScrollPane(this.m_lstPatternFiles);
        string = "COLOR_BACK_LABEL";
        RJDGDInputAreaPanel rJDGDInputAreaPanel = new RJDGDInputAreaPanel();
        rJDGDInputAreaPanel.setBackground(RJDGDGuidanceManager.getColor(string));
        rJDGDInputAreaPanel.setOpaque(true);
        rJDGDInputAreaPanel.setLayout(new RJDGDBorderLayout());
        rJDGDInputAreaPanel.add((Component)rJDGDBaseScrollPane, "Center");
        RJDGDBasePanel rJDGDBasePanel = new RJDGDBasePanel();
        rJDGDBasePanel.setLayout(new RJDGDBorderLayout());
        rJDGDBasePanel.add((Component)jComponent, "North");
        rJDGDBasePanel.add((Component)rJDGDInputAreaPanel, "Center");
        jComponent = new RJDGDInsetsPanel();
        jComponent.setLayout(new RJDGDBorderLayout());
        jComponent.add((Component)this.m_btnExecDownload, "South");
        string = "COLOR_BACK_PANEL";
        this.setLayout(new RJDGDBorderLayout());
        this.setPreferredSize(new Dimension(400, 200));
        this.setBackground(RJDGDGuidanceManager.getColor(string));
        this.setOpaque(true);
        this.add((Component)rJDGDBasePanel, "Center");
        this.add((Component)jComponent, "East");
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.m_lstPatternFiles.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            this.m_btnExecDownload.setEnabled(true);
        } else {
            this.m_btnExecDownload.setEnabled(false);
        }
    }

    private class ButtonOperator
    implements ActionListener {
        private static final String CLASSNAME = "RJDGDFODownloadPanel.ButtonOperator";

        private ButtonOperator() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "on click button [" + string + "]");
            if (string != null && !string.equals("") && string.equals("STRING_BTN_DOWNLOAD")) {
                String string2 = "STRING_DTL_DOWNLOADDIR";
                RJDGDFODataControler rJDGDFODataControler = RJDGDFODownloadPanel.this.getDataControler();
                String string3 = rJDGDFODataControler.getProperty("donwload_directory");
                if (string3 == null || string3.trim().equals("")) {
                    string3 = System.getProperty("user.home") + "/ ";
                }
                File file = new File(string3);
                Object[] objectArray = RJDGDFODownloadPanel.this.m_lstPatternFiles.getSelectedValues();
                if (objectArray == null || objectArray.length < 1) {
                    return;
                }
                String string4 = objectArray[0].toString();
                File file2 = new File(string4);
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setSelectedFile(file2);
                jFileChooser.setDialogTitle(RJDGDGuidanceManager.getString(string2));
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setFileFilter(new RJDGDFOGuardFileFilter());
                jFileChooser.setAcceptAllFileFilterUsed(false);
                int n = jFileChooser.showSaveDialog((Component)actionEvent.getSource());
                if (n == 0) {
                    File file3;
                    File file4 = jFileChooser.getSelectedFile();
                    String string5 = file4.getName();
                    if (!(string5 = string5.trim()).endsWith(".gad")) {
                        string5 = string5 + ".gad";
                        file3 = new File(file4.getParentFile(), string5);
                    } else {
                        file3 = file4;
                    }
                    RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "Approved. [" + file3 + "]");
                    File file5 = file3;
                    Thread thread = new Thread(this, file5){
                        private final /* synthetic */ File val$downloadDirectory;
                        private final /* synthetic */ ButtonOperator this$1;
                        {
                            this.this$1 = buttonOperator;
                            this.val$downloadDirectory = file;
                        }

                        public void run() {
                            ButtonOperator.access$400(this.this$1).downloadGuardFile(this.val$downloadDirectory);
                        }
                    };
                    thread.start();
                }
            }
        }

        static /* synthetic */ RJDGDFODownloadPanel access$400(ButtonOperator buttonOperator) {
            return buttonOperator.RJDGDFODownloadPanel.this;
        }
    }

    class GuardFileWriter {
        private static final String CLASSNAME = "RJDGDFODownloadPanel.GuardFileWriter";
        private DGDgetGuardFile m_clsGuardFileInfo;
        private File m_fleOutputDirectory;

        public GuardFileWriter(DGDgetGuardFile dGDgetGuardFile) {
            this.m_clsGuardFileInfo = dGDgetGuardFile;
        }

        public void setOutputDirectory(File file) throws RJDGDException {
            this.downloadDirectoryCheck(file);
            this.m_fleOutputDirectory = file;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void write() throws RJDGDException {
            String string = this.m_clsGuardFileInfo.name;
            this.downloadDirectoryCheck(this.m_fleOutputDirectory);
            File file = new File(this.m_fleOutputDirectory, string);
            DataOutputStream dataOutputStream = null;
            try {
                try {
                    try {
                        dataOutputStream = new DataOutputStream(new FileOutputStream(file));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace(System.err);
                        throw new RJDGDException(9211, 6526);
                    }
                    int n = 0;
                    DISKgetSubsystemInfo dISKgetSubsystemInfo = RJDGDFODownloadPanel.this.m_clsDataControler.getSubsystemInfo();
                    n = dISKgetSubsystemInfo.nDKCSerialNumber;
                    byte[] byArray = new byte[16];
                    byArray[0] = (byte)((n & 0xFF) >>> 0 & 0xFF);
                    byArray[1] = (byte)((n & 0xFF00) >>> 8 & 0xFF);
                    byArray[2] = (byte)((n & 0xFF0000) >>> 16 & 0xFF);
                    byArray[3] = (byte)((n & 0xFF000000) >>> 24 & 0xFF);
                    try {
                        dataOutputStream.write(byArray);
                        int n2 = 0;
                        block13: while (n2 < 32) {
                            int n3 = 0;
                            while (true) {
                                if (n3 >= 256) {
                                    ++n2;
                                    continue block13;
                                }
                                dataOutputStream.write(this.m_clsGuardFileInfo.guard[n2][n3]);
                                ++n3;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace(System.err);
                        throw new RJDGDException(9211, 6527);
                    }
                    Object var10_15 = null;
                    if (dataOutputStream == null) return;
                }
                catch (RJDGDException rJDGDException) {
                    File file2 = file;
                    Runnable runnable = new Runnable(this, file2){
                        private final /* synthetic */ File val$deleteFile;
                        private final /* synthetic */ GuardFileWriter this$1;
                        {
                            this.this$1 = guardFileWriter;
                            this.val$deleteFile = file;
                        }

                        public void run() {
                            try {
                                System.out.println(this.val$deleteFile.getName() + " : delete [" + this.val$deleteFile.delete() + "]");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                    throw rJDGDException;
                }
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (dataOutputStream == null) throw throwable;
                try {
                    dataOutputStream.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            dataOutputStream.close();
            return;
        }

        protected void finalize() throws Throwable {
            this.m_fleOutputDirectory = null;
            this.m_clsGuardFileInfo = null;
            super.finalize();
        }

        protected void downloadDirectoryCheck(File file) throws RJDGDException {
            if (file == null || !file.isDirectory()) {
                RJDGDLogManager.putLog(5, this.getClass().getName() + ":" + CLASSNAME, "[" + file.getName() + "]");
                throw new RJDGDException(9211, 6525);
            }
        }
    }
}

