/*
 * Decompiled with CFR 0.152.
 */
package sanproject.server.data;

public class DGDFOSurveillancer {
    private static final String CLASSNAME = "DGDFOSurveillancer";
    public static final int NORMAL_STATUS = 0;
    public static final int ERROR_STATUS = Integer.MIN_VALUE;
    public static final int WEBCONSOLE_REQUEST = 0x1000000;
    public static final int FILEOPERATOR_REQUEST = 0x2000000;
    public static final int NEUTRAL_STATUS = 1;
    public static final int PROCESS_START = 16;
    public static final int PROCESSING = 32;
    public static final int FILE_UPLOADING = 256;
    public static final int FILE_UPLOADED = 512;
    public static final int PROCESS_STOP = 32768;
    public static final int PROCESS_TIMEOUT = -2147418112;
    private int m_iWebConsoleStatus;
    private OperationSurveillanceThread m_trdWebConsoleSurveillancer;
    private int m_iFileOperatorStatus;
    private OperationSurveillanceThread m_trdFileOperatorSurveillancer;

    public DGDFOSurveillancer() {
        this.initInstance();
    }

    public int getSurveillanceTime(int n) {
        int n2 = 0;
        if (n == 0x1000000) {
            n2 = this.m_trdWebConsoleSurveillancer.getSurveillanceTime();
        } else if (n == 0x2000000) {
            n2 = this.m_trdFileOperatorSurveillancer.getSurveillanceTime();
        }
        return n2;
    }

    public int getRemainingTime(int n) {
        int n2 = 0;
        if (n == 0x1000000) {
            this.m_trdWebConsoleSurveillancer.getRemainingTime();
        } else if (n == 0x2000000) {
            this.m_trdFileOperatorSurveillancer.getRemainingTime();
        }
        return n2;
    }

    public void setStatus(int n, int n2) {
        if (n == 0x1000000) {
            int n3 = this.m_iWebConsoleStatus;
            if ((n2 & 0x80010000) != 0) {
                this.m_trdWebConsoleSurveillancer.requestSurveillanceStop();
            } else if ((n2 & 0x8000) != 0) {
                this.m_trdWebConsoleSurveillancer.requestSurveillanceStop();
                this.setStatus(0x2000000, 1);
            } else if ((n2 & 0x20) != 0) {
                this.m_trdWebConsoleSurveillancer.resetRemainingTime();
            } else if ((n2 & 0x10) != 0) {
                this.m_trdWebConsoleSurveillancer = new OperationSurveillanceThread(n);
                this.m_trdWebConsoleSurveillancer.start();
            }
            this.m_iWebConsoleStatus = n2;
        } else if (n == 0x2000000) {
            int n4 = this.m_iFileOperatorStatus;
            if ((n2 & 0x80010000) != 0) {
                this.m_trdFileOperatorSurveillancer.requestSurveillanceStop();
            } else if ((n2 & 0x8000) != 0) {
                this.m_trdFileOperatorSurveillancer.requestSurveillanceStop();
            } else if ((n2 & 0x20) != 0) {
                this.m_trdFileOperatorSurveillancer.resetRemainingTime();
                if ((n2 & 0x200) != 0) {
                    System.out.println(" @ File uploaded status.");
                } else if ((n2 & 0x100) != 0) {
                    System.out.println(" @ File upload start.");
                }
            } else if ((n2 & 0x10) != 0) {
                this.m_trdFileOperatorSurveillancer = new OperationSurveillanceThread(n);
                this.m_trdFileOperatorSurveillancer.start();
            }
            int n5 = this.getStatus(0x1000000);
            if ((n5 & 0x30) > 0) {
                this.m_iFileOperatorStatus = n2;
            }
        }
    }

    public int getStatus(int n) {
        int n2 = 0;
        if (n == 0x1000000) {
            n2 = this.m_iWebConsoleStatus;
        } else if (n == 0x2000000) {
            n2 = this.m_iFileOperatorStatus;
        }
        return n2;
    }

    protected void finalize() throws Throwable {
        this.m_trdFileOperatorSurveillancer = null;
        this.m_trdWebConsoleSurveillancer = null;
        super.finalize();
    }

    private void initInstance() {
        this.m_iWebConsoleStatus = 1;
        this.m_trdWebConsoleSurveillancer = null;
        this.m_iFileOperatorStatus = 1;
        this.m_trdFileOperatorSurveillancer = null;
    }

    protected class OperationSurveillanceThread
    extends Thread {
        private static final String CLASSNAME = "DGDFOSurveillancer.OperationSurveillanceThread";
        public static final int DEFAULT_TIMER = 30;
        private int m_iSurveillanceTimer = 30;
        private int m_iRemainingTime = 30;
        private boolean m_bStopRequest = false;
        private int m_iOperatorID;

        public OperationSurveillanceThread(int n) {
            this.m_iOperatorID = n;
        }

        public void setSurveillanceTime(int n) {
            if (n > 0) {
                this.m_iSurveillanceTimer = n;
            }
        }

        public int getSurveillanceTime() {
            return this.m_iSurveillanceTimer;
        }

        public void resetRemainingTime() {
            if (this.m_iOperatorID == 0x1000000) {
                System.out.println("get WebConsole polling");
            } else if (this.m_iOperatorID == 0x2000000) {
                System.out.println("get FileOperator polling");
            }
            this.m_iRemainingTime = this.m_iSurveillanceTimer;
        }

        public int getRemainingTime() {
            return this.m_iRemainingTime;
        }

        public void run() {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace(System.err);
                    this.m_bStopRequest = true;
                }
                --this.m_iRemainingTime;
            } while (!this.m_bStopRequest && this.m_iRemainingTime >= 0);
            if (this.m_iRemainingTime <= 0) {
                DGDFOSurveillancer.this.setStatus(this.m_iOperatorID, -2147418112);
                if (this.m_iOperatorID == 0x1000000) {
                    System.out.println("Polling timeout [WebConsole]");
                } else if (this.m_iOperatorID == 0x2000000) {
                    System.out.println("Polling timeout [FileOperator]");
                }
            }
        }

        public void start() {
            OperationSurveillanceThread operationSurveillanceThread = this;
            synchronized (operationSurveillanceThread) {
                if (this.m_iOperatorID == 0x1000000) {
                    System.out.println("Polling start [WebConsole]");
                } else if (this.m_iOperatorID == 0x2000000) {
                    System.out.println("Polling start [FileOperator]");
                }
                super.start();
            }
        }

        public void requestSurveillanceStop() {
            OperationSurveillanceThread operationSurveillanceThread = this;
            synchronized (operationSurveillanceThread) {
                if (this.m_iOperatorID == 0x1000000) {
                    System.out.println("Polling end request [WebConsole]");
                } else if (this.m_iOperatorID == 0x2000000) {
                    System.out.println("Polling end request [FileOperator]");
                }
                this.m_bStopRequest = true;
            }
        }
    }
}

