/*
 * Decompiled with CFR 0.152.
 */
package sanproject.server.data;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import sanproject.server.data.DGDAClassWithNativeMethods;
import sanproject.server.data.DGDFOSurveillancer;
import sanproject.server.data.DGDGuardFileChecker;
import sanproject.server.data.DGDgetGuardFile;
import sanproject.server.data.DGDgetLdevGuard;
import sanproject.server.data.DGDgetVtocArea;
import sanproject.server.data.DGDsetExtendedGuardFile;
import sanproject.server.data.DISKgetSubsystemInfo;
import sanproject.server.data.JNIException;
import sanproject.server.data.RmiObjImpl;
import sanproject.server.data.SANRmiException;
import sanproject.server.data.common_Obj;

public class DGDObj
extends common_Obj
implements Serializable {
    static final String FUN_LDEV_GUARD = new String("DGD getLdevGuard");
    static final String FUN_GUARD_LIST = new String("DGD getGuardFileList");
    static final String FUN_GUARD_FILE = new String("DGD getGuardFile");
    static final String FUN_VTOC_AREA = new String("DGD getVtocArea");
    static final String FUN_SET_UPLOAD = new String("DGD setUploadFile");
    static final String FUN_GET_UPLOAD = new String("DGD getUploadFile");
    static final String FUN_GET_UPLOADS = new String("DGD getUploadFiles");
    static final String FUN_SET_FOS = new String("DGD setFOStatus");
    static final String FUN_GET_FOS = new String("DGD getFOStatus");
    public static final int ERP_JNI = 9207;
    public static final int MSG_INVALID_PARAM = 7119;
    public static final int MSG_INVALID_CLASS = 5804;
    public static final int MSG_ERR_REFER_SERIAL = 6029;
    public static final int MSG_INVALID_FILENAME = 5805;
    public static final int MSG_LONG_FILENAME = 5806;
    public static final int MSG_INVALID_DKCSERIAL_FORMAT = 5804;
    public static final int MSG_UNMATCH_DKCSERIAL = 5800;
    public static final int MSG_FILE_FULL = 7445;
    public static final int MSG_ALREADY_NAME = 5807;
    public static final int MIN_DKC_SERIAL = 1;
    public static final int MAX_DKC_SERIAL = 65535;
    public static final int MAX_GRD_FILES = 32;
    String RegName = new String();
    private DGDAClassWithNativeMethods c = new DGDAClassWithNativeMethods();
    private DGDFOSurveillancer m_clsSurveillancer = new DGDFOSurveillancer();
    private ArrayList _uploadFiles = new ArrayList();
    private String[] _fileNames = new String[0];

    public DGDObj(RmiObjImpl rmiObjImpl) {
        super(rmiObjImpl);
    }

    DGDgetLdevGuard getLdevGuard() throws SANRmiException {
        DGDgetLdevGuard dGDgetLdevGuard;
        block5: {
            String string = FUN_LDEV_GUARD;
            this.preProc(string);
            dGDgetLdevGuard = null;
            try {
                try {
                    this.run(string);
                    dGDgetLdevGuard = this.c.getLdevGuard(this.getRegName());
                    this.runEnd(string);
                }
                catch (JNIException jNIException) {
                    this.errSAN(string, jNIException);
                    Object var6_4 = null;
                    this.postProc(string);
                    break block5;
                }
                catch (Exception exception) {
                    this.exp(exception);
                    Object var6_5 = null;
                    this.postProc(string);
                }
                Object var6_3 = null;
                this.postProc(string);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.postProc(string);
                throw throwable;
            }
        }
        return dGDgetLdevGuard;
    }

    String[] getGuardFileList() throws SANRmiException {
        String[] stringArray;
        block5: {
            String string = FUN_GUARD_LIST;
            this.preProc(string);
            stringArray = new String[]{};
            try {
                try {
                    this.run(string);
                    stringArray = this.c.getGuardFileList(this.getRegName());
                    this.runEnd(string);
                    this._fileNames = stringArray;
                }
                catch (JNIException jNIException) {
                    this.errSAN(string, jNIException);
                    Object var6_4 = null;
                    this.postProc(string);
                    break block5;
                }
                catch (Exception exception) {
                    this.exp(exception);
                    Object var6_5 = null;
                    this.postProc(string);
                }
                Object var6_3 = null;
                this.postProc(string);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.postProc(string);
                throw throwable;
            }
        }
        return stringArray;
    }

    DGDgetGuardFile getGuardFile(String string) throws SANRmiException {
        DGDgetGuardFile dGDgetGuardFile;
        block5: {
            String string2 = FUN_GUARD_FILE;
            this.preProc(string2);
            dGDgetGuardFile = null;
            try {
                try {
                    this.run(string2);
                    dGDgetGuardFile = this.c.getGuardFile(this.getRegName(), string);
                    this.runEnd(string2);
                }
                catch (JNIException jNIException) {
                    this.errSAN(string2, jNIException);
                    Object var7_5 = null;
                    this.postProc(string2);
                    break block5;
                }
                catch (Exception exception) {
                    this.exp(exception);
                    Object var7_6 = null;
                    this.postProc(string2);
                }
                Object var7_4 = null;
                this.postProc(string2);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.postProc(string2);
                throw throwable;
            }
        }
        return dGDgetGuardFile;
    }

    DGDgetVtocArea[] getVtocArea() throws SANRmiException {
        DGDgetVtocArea[] dGDgetVtocAreaArray;
        block5: {
            String string = FUN_VTOC_AREA;
            this.preProc(string);
            dGDgetVtocAreaArray = new DGDgetVtocArea[]{};
            try {
                try {
                    this.run(string);
                    dGDgetVtocAreaArray = this.c.getVtocArea(this.getRegName());
                    this.runEnd(string);
                }
                catch (JNIException jNIException) {
                    this.errSAN(string, jNIException);
                    Object var6_4 = null;
                    this.postProc(string);
                    break block5;
                }
                catch (Exception exception) {
                    this.exp(exception);
                    Object var6_5 = null;
                    this.postProc(string);
                }
                Object var6_3 = null;
                this.postProc(string);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.postProc(string);
                throw throwable;
            }
        }
        return dGDgetVtocAreaArray;
    }

    DGDsetExtendedGuardFile setUploadFile(Object object, DISKgetSubsystemInfo dISKgetSubsystemInfo) throws SANRmiException {
        DGDsetExtendedGuardFile dGDsetExtendedGuardFile;
        block8: {
            String string = FUN_SET_UPLOAD;
            this.preProc(string);
            dGDsetExtendedGuardFile = null;
            try {
                try {
                    this.run(string);
                    int n = this.getFOStatus(0x2000000);
                    this.setFOStatus(0x2000000, n |= 0x100);
                    dGDsetExtendedGuardFile = this.addUploadFile(object, dISKgetSubsystemInfo);
                    this.setFOStatus(0x2000000, n &= 0xFFFFFEFF);
                    if (dGDsetExtendedGuardFile != null && dGDsetExtendedGuardFile.error == 0) {
                        this.setFOStatus(0x2000000, n |= 0x200);
                    }
                    System.out.println("-------------------------------------------");
                    if (dGDsetExtendedGuardFile == null || dGDsetExtendedGuardFile.error != 0) {
                        System.out.println(" @ setUploadFile( ) Failed.");
                    } else {
                        System.out.println(" @ setUploadFile( ) Successed.");
                    }
                    System.out.println("    now Operator Status = 0x" + Integer.toHexString(n));
                    System.out.println("-------------------------------------------");
                    this.runEnd(string);
                }
                catch (JNIException jNIException) {
                    this.errSAN(string, jNIException);
                    Object var8_8 = null;
                    this.postProc(string);
                    break block8;
                }
                catch (Exception exception) {
                    this.exp(exception);
                    Object var8_9 = null;
                    this.postProc(string);
                }
                Object var8_7 = null;
                this.postProc(string);
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.postProc(string);
                throw throwable;
            }
        }
        return dGDsetExtendedGuardFile;
    }

    DGDgetGuardFile getUploadFile() throws SANRmiException {
        DGDgetGuardFile dGDgetGuardFile;
        block5: {
            String string = FUN_GET_UPLOAD;
            this.preProc(string);
            dGDgetGuardFile = null;
            try {
                try {
                    this.run(string);
                    dGDgetGuardFile = this.c.getUploadFile(this.getRegName());
                    this.runEnd(string);
                }
                catch (JNIException jNIException) {
                    this.errSAN(string, jNIException);
                    Object var6_4 = null;
                    this.postProc(string);
                    break block5;
                }
                catch (Exception exception) {
                    this.exp(exception);
                    Object var6_5 = null;
                    this.postProc(string);
                }
                Object var6_3 = null;
                this.postProc(string);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.postProc(string);
                throw throwable;
            }
        }
        return dGDgetGuardFile;
    }

    DGDgetGuardFile[] getUploadFiles() throws SANRmiException {
        String string = FUN_GET_UPLOADS;
        this.preProc(string);
        DGDgetGuardFile[] dGDgetGuardFileArray = new DGDgetGuardFile[this._uploadFiles.size()];
        try {
            try {
                this.run(string);
                int n = 0;
                while (n < this._uploadFiles.size()) {
                    dGDgetGuardFileArray[n] = (DGDgetGuardFile)this._uploadFiles.get(n);
                    ++n;
                }
                this.runEnd(string);
            }
            catch (Exception exception) {
                this.exp(exception);
                Object var5_6 = null;
                this.postProc(string);
            }
            Object var5_5 = null;
            this.postProc(string);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.postProc(string);
            throw throwable;
        }
        return dGDgetGuardFileArray;
    }

    void setFOStatus(int n, int n2) throws SANRmiException {
        String string = FUN_SET_FOS;
        this.preProc(string);
        try {
            try {
                this.run(string);
                this.m_clsSurveillancer.setStatus(n, n2);
                if (n == 0x1000000 && n2 == 16) {
                    this._uploadFiles.clear();
                }
                this.runEnd(string);
            }
            catch (Exception exception) {
                this.exp(exception);
                Object var6_5 = null;
                this.postProc(string);
            }
            Object var6_4 = null;
            this.postProc(string);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProc(string);
            throw throwable;
        }
    }

    int getFOStatus(int n) throws SANRmiException {
        String string = FUN_GET_FOS;
        this.preProc(string);
        int n2 = 0;
        try {
            try {
                this.run(string);
                n2 = this.m_clsSurveillancer.getStatus(n);
                this.runEnd(string);
            }
            catch (Exception exception) {
                this.exp(exception);
                Object var6_5 = null;
                this.postProc(string);
            }
            Object var6_4 = null;
            this.postProc(string);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.postProc(string);
            throw throwable;
        }
        return n2;
    }

    private DGDsetExtendedGuardFile addUploadFile(Object object, DISKgetSubsystemInfo dISKgetSubsystemInfo) throws JNIException {
        DGDsetExtendedGuardFile dGDsetExtendedGuardFile = null;
        System.out.println(">>>>>>>>>> Upload File Check");
        System.out.println("uploadObj  = " + object);
        System.out.println("subsysInfo = " + dISKgetSubsystemInfo);
        if (object == null) {
            throw new JNIException(9207, 7119);
        }
        if (!(object instanceof DGDsetExtendedGuardFile)) {
            throw new JNIException(9207, 5804);
        }
        if (dISKgetSubsystemInfo == null) {
            throw new JNIException(9207, 6029);
        }
        dGDsetExtendedGuardFile = (DGDsetExtendedGuardFile)object;
        dGDsetExtendedGuardFile.error = 0;
        DGDGuardFileChecker dGDGuardFileChecker = new DGDGuardFileChecker(dGDsetExtendedGuardFile.name);
        System.out.println("Upload File Name     = " + dGDsetExtendedGuardFile.name);
        System.out.println("Serial No.           = " + dGDsetExtendedGuardFile.serial_no + "(DKC:" + dISKgetSubsystemInfo.nDKCSerialNumber + ")");
        System.out.println("isSafeCharacters     = " + dGDGuardFileChecker.isSafeCharacters());
        System.out.println("isSafeFileNameLength = " + dGDGuardFileChecker.isSafeFileNameLength());
        System.out.println("Total File Count     = " + (this._uploadFiles.size() + this._fileNames.length));
        if (!dGDGuardFileChecker.isSafeCharacters()) {
            dGDsetExtendedGuardFile.error = 5805;
        } else if (!dGDGuardFileChecker.isSafeFileNameLength()) {
            dGDsetExtendedGuardFile.error = 5806;
        } else if (dGDsetExtendedGuardFile.serial_no < 1 || dGDsetExtendedGuardFile.serial_no > 65535) {
            dGDsetExtendedGuardFile.error = 5804;
        } else if (dGDsetExtendedGuardFile.serial_no != dISKgetSubsystemInfo.nDKCSerialNumber) {
            dGDsetExtendedGuardFile.error = 5800;
        } else if (this._uploadFiles.size() + this._fileNames.length >= 32) {
            dGDsetExtendedGuardFile.error = 7445;
        } else {
            DGDgetGuardFile dGDgetGuardFile = new DGDgetGuardFile();
            dGDgetGuardFile.name = DGDGuardFileChecker.getFileNameWithoutGuardFileExtension(dGDsetExtendedGuardFile.name);
            dGDgetGuardFile.name = dGDgetGuardFile.name.trim();
            System.out.println("Triming Name         = [" + dGDgetGuardFile.name + "]");
            dGDgetGuardFile.error = dGDsetExtendedGuardFile.error;
            dGDgetGuardFile.guard = dGDsetExtendedGuardFile.guard;
            int n = 0;
            while (n < this._fileNames.length) {
                if (dGDgetGuardFile.name.equalsIgnoreCase(this._fileNames[n])) {
                    dGDgetGuardFile.error = 5807;
                    break;
                }
                ++n;
            }
            Iterator iterator = ((AbstractList)this._uploadFiles).iterator();
            while (dGDgetGuardFile.error == 0 && iterator.hasNext()) {
                DGDgetGuardFile dGDgetGuardFile2 = (DGDgetGuardFile)iterator.next();
                if (!dGDgetGuardFile.name.equalsIgnoreCase(dGDgetGuardFile2.name)) continue;
                dGDgetGuardFile.error = 5807;
            }
            if (dGDgetGuardFile.error == 0) {
                this._uploadFiles.add(dGDgetGuardFile);
            }
            dGDsetExtendedGuardFile.error = dGDgetGuardFile.error;
        }
        System.out.println("Error Code           = " + dGDsetExtendedGuardFile.error);
        System.out.println("<<<<<<<<<< Upload File Check");
        return dGDsetExtendedGuardFile;
    }
}

