/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.jserver.soma;

import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_PPKPPInfoDataClassUx;
import sanproject.common.Robj_interface_PPKgetKeyLicenseUx;
import sanproject.serverux.data.SANRmiException;

class LicenseManager {
    private static final String HM800_PPID = "8544";
    private static Thread licenseThread = null;
    private long mInterval = 1800000L;
    private boolean mIsValid = false;

    LicenseManager() {
        try {
            this.mInterval = ProviderProperties.getLicenseCheckIntervalSeconds() * 1000;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void checkLicense() {
        if (ProviderProperties.isEmbedded()) {
            licenseThread = new LicenseThread();
            licenseThread.start();
        } else {
            this.mIsValid = true;
        }
    }

    private void checkLicense(RMIObjectMapping rmiObj) throws WBEMException {
        if (null == rmiObj) {
            throw new WBEMException("RMI connection is not valid while running embedded");
        }
        Logger logger = Logger.getLogger("com.ws.wbem.jserver");
        if (rmiObj.isHitachiSystem()) {
            boolean isValidLicense;
            logger.info("Detected Hitachi system.");
            do {
                isValidLicense = this.licenseCheck(rmiObj.getRMIObject());
                if (!Boolean.getBoolean("com.hitachi.badlicensetest") && isValidLicense) continue;
                logger.log(Level.SEVERE, "Invalid license, will wait {0} seconds and check again", this.mInterval / 1000L);
                try {
                    Thread.sleep(this.mInterval, 0);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            } while (!isValidLicense && !HitachiCacheMangerService.isShuttingDown());
            logger.info("Detected a valid license");
        } else {
            logger.info("Detected OTHER system.");
        }
    }

    private Robj_interface_PPKPPInfoDataClassUx getInstallStatusKeyValue(RMIObjectCache rmiObj) throws WBEMException {
        Robj_interface_PPKPPInfoDataClassUx ret = null;
        try {
            Robj_interface_PPKgetKeyLicenseUx licenseUx = rmiObj.getKeyLicenseUx();
            Robj_interface_PPKPPInfoDataClassUx[] data = licenseUx.getPpinfoclass();
            for (int x = 0; x < data.length && ret == null; ++x) {
                Robj_interface_PPKPPInfoDataClassUx d = data[x];
                RMIObjectMapping mapObj = RMIObjectMapping.getEmbeddedRMIObjectMapping();
                RMIObjectMapping.VendorAndType type = mapObj.getVendorAndType();
                if (RMIObjectMapping.VendorAndType.HITACHI_HM800 != type || !HM800_PPID.equalsIgnoreCase(d.getStrPPID())) continue;
                ret = d;
            }
        }
        catch (SANRmiException e) {
            throw new WBEMException(1, e.getErrMsgEn(), null, (Throwable)e);
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
        return ret;
    }

    boolean isValid() {
        return this.mIsValid;
    }

    private boolean licenseCheck(RMIObjectCache rmiObj) throws WBEMException {
        boolean ret = false;
        try {
            Robj_interface_PPKPPInfoDataClassUx keyType;
            try {
                keyType = this.getInstallStatusKeyValue(rmiObj);
            }
            catch (Throwable t) {
                Logger logger = Logger.getLogger("com.ws.wbem.jserver");
                logger.log(Level.INFO, "Exception from getInstallStatusKeyValue: " + t, t);
                keyType = null;
            }
            if (keyType != null) {
                switch (keyType.getNKeyKind()) {
                    case 0: {
                        ret = true;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: {
                        if (keyType.getNRemainingTerm() > 0) {
                            ret = true;
                            break;
                        }
                        ret = false;
                        break;
                    }
                    case 99: {
                        ret = false;
                    }
                }
            }
        }
        catch (Throwable t) {
            Logger logger = Logger.getLogger("com.ws.wbem.jserver");
            logger.log(Level.INFO, "Unexpected exception checking license: " + t, t);
            ret = false;
        }
        return ret;
    }

    public void stop() {
        if (null != licenseThread) {
            licenseThread.interrupt();
        }
    }

    class LicenseThread
    extends Thread {
        LicenseThread() {
            super("Hitachi_License_Thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (ProviderProperties.isEmbedded()) {
                    RMIObjectMapping RMIObj = RMIObjectMapping.getEmbeddedRMIObjectMapping();
                    LicenseManager.this.checkLicense(RMIObj);
                }
                LicenseManager.this.mIsValid = true;
            }
            catch (Exception e) {
                LicenseManager.this.mIsValid = false;
            }
            finally {
                if (null != licenseThread) {
                    licenseThread = null;
                }
            }
        }
    }
}

