/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AOUVolInfoVersionChecker;
import com.hitachi.smi.cache.CHABranchChecker;
import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.HURBranchChecker;
import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.cache.ISCSITargetPortChecker;
import com.hitachi.smi.cache.LDEVBranchChecker;
import com.hitachi.smi.cache.LUPathBranchChecker;
import com.hitachi.smi.cache.LicenseBranchChecker;
import com.hitachi.smi.cache.LocalCopyBranchChecker;
import com.hitachi.smi.cache.NicknameVersionChecker;
import com.hitachi.smi.cache.PDEVInfoChecker;
import com.hitachi.smi.cache.PGBranchChecker;
import com.hitachi.smi.cache.PoolBranchChecker;
import com.hitachi.smi.cache.PortBranchChecker;
import com.hitachi.smi.cache.RCMPBranchChecker;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.cache.ResourceGroupInfoVersionChecker;
import com.hitachi.smi.cache.RetentionBranchChecker;
import com.hitachi.smi.cache.VersionCheckerIF;
import com.hitachi.smi.cache.VirtualIDBranchChecker;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.ProviderStatusUtils;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_ConfVerDetailList;
import sanproject.common.Robj_interface_ConfVerSummary;
import sanproject.common.Robj_interface_VerBranch;
import sanproject.common.Robj_interface_VerLeaf;
import sanproject.serverux.data.SANRmiException;

public class CacheUpdater
extends Thread {
    private static final Map<String, CacheUpdater> updaters = new HashMap<String, CacheUpdater>();
    private static final HashMap<String, List<UpdateCallbackHolder>> updateCallbackHolder = new HashMap();
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private static boolean mRunning = false;
    private static boolean updating = false;
    private final EnumMap<ConfVerID, Integer> masterVers;
    private final EnumMap<ConfVerID, Robj_interface_VerBranch> verDetails;
    private final EnumMap<ConfVerID, List<VersionCheckerIF>> versionCheckCallbacks;
    private final EnumMap<CallBackType, ArrayList<CacheUpdateNotifier>> mUpdateCallbackList;
    private final String deviceSerialNum;
    private boolean firstCall;

    public static <T extends Serializable> void doCallback(CacheUpdater updater, CacheUpdateType pUpdateType, CallBackType pCallBackType, T changed) {
        ArrayList<CacheUpdateNotifier> updateList = updater.mUpdateCallbackList.get((Object)pCallBackType);
        for (int i = 0; updateList != null && i < updateList.size() && CacheUpdater.isRunning(); ++i) {
            try {
                CacheUpdateNotifier cun = updateList.get(i);
                if (cun == null || changed == null) continue;
                switch (pUpdateType) {
                    case ADD: {
                        cun.cacheItemAdded(changed);
                        break;
                    }
                    case DELETE: {
                        cun.cacheItemDeleted(changed);
                        break;
                    }
                    case MODIFY: {
                        cun.cacheItemModified(changed);
                        break;
                    }
                    default: {
                        mLogger.log(Level.WARNING, "Unrecognized CacheUpdateType, {0}, on {1}", new Object[]{pUpdateType.toString(), updater.deviceSerialNum});
                    }
                }
                continue;
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Exception while performing cache update callback on " + updater.deviceSerialNum, t);
            }
        }
    }

    public static <T extends Serializable> void doCallback(String serialNum, CacheUpdateType pUpdateType, CallBackType pCallBackType, T[] elements) {
        CacheUpdater updater = updaters.get(serialNum);
        if (null == updater) {
            throw new NullPointerException("No cache updater with serial number " + serialNum);
        }
        if (elements != null && elements.length > 0) {
            for (T element : elements) {
                NotifyThread worker = new NotifyThread(updater, pUpdateType, pCallBackType, (Serializable)element, null);
                ProcessTask.addTask(worker);
            }
        }
    }

    private static Collection<CacheUpdater> getDeviceUpdaters(String pDevSerial) {
        Collection<CacheUpdater> notifiers;
        if (null == pDevSerial) {
            notifiers = updaters.values();
        } else {
            CacheUpdater updater = updaters.get(pDevSerial);
            if (null != updater) {
                notifiers = new ArrayList<CacheUpdater>();
                notifiers.add(updater);
            } else {
                mLogger.log(Level.SEVERE, "No cache updaters registered for {0}", pDevSerial);
                notifiers = new ArrayList<CacheUpdater>(0);
            }
        }
        return notifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<CacheUpdateNotifier> getUpdateCallbackList(CacheUpdater updater, CallBackType pCBT) {
        ArrayList<CacheUpdateNotifier> list = null;
        if (!updater.mUpdateCallbackList.containsKey((Object)pCBT)) {
            EnumMap<CallBackType, ArrayList<CacheUpdateNotifier>> enumMap = updater.mUpdateCallbackList;
            synchronized (enumMap) {
                if (!updater.mUpdateCallbackList.containsKey((Object)pCBT)) {
                    list = new ArrayList();
                    updater.mUpdateCallbackList.put(pCBT, list);
                }
            }
        } else {
            list = updater.mUpdateCallbackList.get((Object)pCBT);
        }
        return list;
    }

    public static synchronized boolean isRunning() {
        if (mRunning && HitachiCacheMangerService.isShuttingDown()) {
            mRunning = false;
        }
        return mRunning;
    }

    public static synchronized boolean isUpating() {
        return updating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerUpdateCallback(CallBackType pCBT, CacheUpdateNotifier p2BeCalled, String pDevSerial) {
        List<Object> list;
        Collection<CacheUpdater> notifiers = CacheUpdater.getDeviceUpdaters(pDevSerial);
        if (notifiers.isEmpty()) {
            HashMap<String, List<UpdateCallbackHolder>> hashMap = updateCallbackHolder;
            synchronized (hashMap) {
                notifiers = CacheUpdater.getDeviceUpdaters(pDevSerial);
                if (notifiers.isEmpty()) {
                    mLogger.log(Level.INFO, "Delayed update registration for device {0}, type {1}, notifier {2}", new Object[]{pDevSerial, pCBT, p2BeCalled});
                    UpdateCallbackHolder temp = new UpdateCallbackHolder(pCBT, p2BeCalled);
                    list = updateCallbackHolder.get(pDevSerial);
                    if (null == list) {
                        list = new ArrayList();
                        updateCallbackHolder.put(pDevSerial, list);
                    }
                    list.add((CacheUpdateNotifier)((Object)temp));
                }
            }
        }
        for (CacheUpdater updater : notifiers) {
            if (null == updater) {
                mLogger.log(Level.SEVERE, "notifiers contained a null updater: {0}", notifiers);
                continue;
            }
            list = CacheUpdater.getUpdateCallbackList(updater, pCBT);
            if (((ArrayList)list).contains(p2BeCalled)) continue;
            ((ArrayList)list).add(p2BeCalled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerVersionChecker(ConfVerID type, VersionCheckerIF callee) {
        Collection<CacheUpdater> notifiers = CacheUpdater.getDeviceUpdaters(callee.getSerialNumber());
        for (CacheUpdater updater : notifiers) {
            if (null == updater) {
                mLogger.log(Level.SEVERE, "notifiers contains null updater {0} ", notifiers);
                continue;
            }
            if (!updater.versionCheckCallbacks.containsKey((Object)type)) {
                EnumMap<ConfVerID, List<VersionCheckerIF>> enumMap = updater.versionCheckCallbacks;
                synchronized (enumMap) {
                    if (!updater.versionCheckCallbacks.containsKey((Object)type)) {
                        updater.versionCheckCallbacks.put(type, new ArrayList());
                    }
                }
            }
            List<VersionCheckerIF> list = updater.versionCheckCallbacks.get((Object)type);
            list.add(callee);
        }
    }

    public static synchronized void setRunning(boolean pRunning) {
        mRunning = pRunning;
    }

    private static synchronized void setUpdating(boolean flag) {
        updating = flag;
    }

    public static void stopUpdaterThread() {
        CacheUpdater.setRunning(false);
    }

    public static void unregisterUpdateCallback(CallBackType pCBT, CacheUpdateNotifier p2BeCalled, String pDevSerial) {
        Collection<CacheUpdater> notifiers = CacheUpdater.getDeviceUpdaters(pDevSerial);
        for (CacheUpdater updater : notifiers) {
            if (null == updater) {
                mLogger.log(Level.SEVERE, "notifiers contained a null updater: {0}", notifiers);
                continue;
            }
            ArrayList<CacheUpdateNotifier> list = updater.mUpdateCallbackList.get((Object)pCBT);
            if (null != list) {
                if (list.remove(p2BeCalled)) continue;
                mLogger.log(Level.INFO, "unregisterUpdateCallback was called for device {0} to unregister for a {1}, but the callee, {2}, is not registered.", new Object[]{updater.deviceSerialNum, pCBT, p2BeCalled});
                continue;
            }
            mLogger.log(Level.INFO, "unregisterUpdateCallback was called to unregister for a {0}, but nothing is registered.", new Object[]{pCBT});
        }
    }

    protected CacheUpdater(String serialNumber) throws WBEMException {
        super("Hitachi_Cache_Update_thread for " + serialNumber);
        this.setDaemon(true);
        this.deviceSerialNum = serialNumber;
        this.masterVers = new EnumMap(ConfVerID.class);
        this.verDetails = new EnumMap(ConfVerID.class);
        this.versionCheckCallbacks = new EnumMap(ConfVerID.class);
        this.mUpdateCallbackList = new EnumMap(CallBackType.class);
        this.setFirstCall(false);
        updaters.put(serialNumber, this);
        this.initialize();
    }

    private void checkVersionDetail(ConfVerID verKey, Robj_interface_ConfVerDetailList confVerDetail) {
        Robj_interface_VerBranch currentDetail = confVerDetail.getConfVerDetail(verKey.getValue());
        mLogger.log(Level.FINE, "Checking current ConfVer for {0}:\n Summary={1}, nVer={2}", new Object[]{verKey, null == currentDetail ? "null" : Integer.valueOf(currentDetail.getNSummaryVer()), null == currentDetail ? "null" : Integer.valueOf(currentDetail.getNVer())});
        Robj_interface_VerBranch previousDetail = this.verDetails.get((Object)verKey);
        mLogger.log(Level.FINE, "Checking previous ConfVer for {0}:\n Summary={1}, nVer={2}", new Object[]{verKey, null == previousDetail ? "nu;;" : Integer.valueOf(previousDetail.getNSummaryVer()), null == previousDetail ? "null" : Integer.valueOf(previousDetail.getNVer())});
        if (verKey == ConfVerID.CACHE || verKey == ConfVerID.RESOURCEGRP || verKey == ConfVerID.VIRTUALID || verKey == ConfVerID.FCSP || currentDetail.getNVer() != previousDetail.getNVer() || currentDetail.getNSummaryVer() != previousDetail.getNSummaryVer()) {
            this.verDetails.put(verKey, currentDetail);
            Robj_interface_VerLeaf[] currentChildren = currentDetail != null ? currentDetail.getObjChildren() : null;
            Robj_interface_VerLeaf[] prevChildren = previousDetail != null ? previousDetail.getObjChildren() : null;
            mLogger.log(Level.INFO, "{0} version change detected on {1}", new Object[]{verKey.toString(), this.deviceSerialNum});
            List<VersionCheckerIF> callees = this.versionCheckCallbacks.get((Object)verKey);
            if (callees != null && !callees.isEmpty()) {
                for (VersionCheckerIF callee : callees) {
                    if (callee != null) {
                        mLogger.log(Level.INFO, "Begin {0} on {1}", new Object[]{callee.getClass().getSimpleName(), this.deviceSerialNum});
                        callee.checkVersionDetails(currentChildren, prevChildren);
                        mLogger.log(Level.INFO, "End {0} on {1}", new Object[]{callee.getClass().getSimpleName(), this.deviceSerialNum});
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "null version checker for key {0}, device {1}", new Object[]{verKey.toString(), this.deviceSerialNum});
                }
            } else {
                mLogger.log(Level.SEVERE, "No version checkers registered for key {0}, device {1}", new Object[]{verKey.toString(), this.deviceSerialNum});
            }
        }
        mLogger.log(Level.INFO, "Done with {0} version changes on {1}", new Object[]{verKey.toString(), this.deviceSerialNum});
    }

    private void CreateCacheUpdaters() {
        new LDEVBranchChecker(this.deviceSerialNum);
        new LUPathBranchChecker(this.deviceSerialNum);
        new PGBranchChecker(this.deviceSerialNum);
        new PortBranchChecker(this.deviceSerialNum);
        new CHABranchChecker(this.deviceSerialNum);
        new NicknameVersionChecker(this.deviceSerialNum);
        new LocalCopyBranchChecker(this.deviceSerialNum);
        new PoolBranchChecker(this.deviceSerialNum);
        new RCMPBranchChecker(this.deviceSerialNum);
        new LicenseBranchChecker(this.deviceSerialNum);
        new RetentionBranchChecker(this.deviceSerialNum);
        new PDEVInfoChecker(this.deviceSerialNum);
        new VirtualIDBranchChecker(this.deviceSerialNum);
        new ResourceGroupInfoVersionChecker(this.deviceSerialNum);
        new HURBranchChecker(this.deviceSerialNum);
        new AOUVolInfoVersionChecker(this.deviceSerialNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelayedRegisterUpdateCallback() {
        HashMap<String, List<UpdateCallbackHolder>> hashMap = updateCallbackHolder;
        synchronized (hashMap) {
            if (!updateCallbackHolder.isEmpty()) {
                UpdateCallbackHolder t;
                LinkedList<UpdateCallbackHolder> list = new LinkedList<UpdateCallbackHolder>();
                List<UpdateCallbackHolder> tList = updateCallbackHolder.get(null);
                if (null != tList) {
                    list.addAll(tList);
                }
                if (null != (tList = updateCallbackHolder.remove(this.deviceSerialNum))) {
                    list.addAll(tList);
                }
                mLogger.log(Level.INFO, "Delayed update registration for {0} callbacks for device {1}", new Object[]{list.size(), this.deviceSerialNum});
                while (null != (t = (UpdateCallbackHolder)list.poll())) {
                    CacheUpdater.registerUpdateCallback(t.getpCBT(), t.getP2BeCalled(), this.deviceSerialNum);
                }
            }
        }
    }

    private void doUpdating() {
        do {
            this.getVersionInfo();
            try {
                Thread.sleep(ProviderProperties.getVersionCheckIntervalSeconds() * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (CacheUpdater.isRunning());
    }

    private Robj_interface_ConfVerDetailList getVersionDetail(RMIObjectCache rmiobj, Robj_interface_ConfVerSummary ver, ConfVerID[] verKeys) throws RemoteException, SANRmiException {
        int[] vals = new int[verKeys.length - 4];
        int index = 0;
        for (ConfVerID verKey : verKeys) {
            if (verKey == ConfVerID.CACHE || verKey == ConfVerID.RESOURCEGRP || verKey == ConfVerID.FCSP || verKey == ConfVerID.VIRTUALID) continue;
            vals[index++] = verKey.getValue();
        }
        return rmiobj.getConfVerDetail(vals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getVersionInfo() {
        if (CacheUpdater.isRunning()) {
            try {
                if (this.isFirstCall()) {
                    this.initialize();
                } else {
                    CacheUpdater.setUpdating(true);
                    RMIObjectMapping mappingObj = RMIObjectMapping.getRMIObjectMapping(this.deviceSerialNum);
                    RMIObjectCache rmiobj = mappingObj.getRMIObject();
                    ConfVerID[] verKeys = ConfVerID.values();
                    Robj_interface_ConfVerSummary ver = rmiobj.getConfVerSummary();
                    Robj_interface_ConfVerDetailList confVerDetail = this.getVersionDetail(rmiobj, ver, verKeys);
                    mLogger.log(Level.INFO, "Checking for version updates on {0}", this.deviceSerialNum);
                    long begin = System.currentTimeMillis();
                    ISCSITargetPortChecker.getISCSITargetPortChecker(this.deviceSerialNum).checkVersionDetails(null, null);
                    boolean rsgChecked = false;
                    for (ConfVerID verKey : verKeys) {
                        int currentVer;
                        Integer previousVer = this.masterVers.get((Object)verKey);
                        if (previousVer.compareTo(currentVer = ver.getNVer(verKey.getValue())) == 0) continue;
                        if (verKey == ConfVerID.RESOURCEGRP) {
                            rsgChecked = true;
                        } else if (!rsgChecked) {
                            this.checkVersionDetail(ConfVerID.RESOURCEGRP, confVerDetail);
                            rsgChecked = true;
                        }
                        this.masterVers.put(verKey, new Integer(currentVer));
                        try {
                            this.checkVersionDetail(verKey, confVerDetail);
                        }
                        catch (Throwable t) {
                            mLogger.log(Level.SEVERE, "Unexpected exception checking " + verKey.toString() + ": " + t + " on " + this.deviceSerialNum, t);
                            ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Warning, ProviderStatusUtils.ProviderStatusDetailCode.UNEXPECTED);
                        }
                    }
                    long end = System.currentTimeMillis();
                    mLogger.info("Done checking for version updates on " + this.deviceSerialNum + ", time elapsed: " + (end - begin) / 1000L + " seconds, " + (end - begin) % 1000L + " millis");
                    ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Ready, ProviderStatusUtils.ProviderStatusDetailCode.NONE);
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Unexpected exception getting version data on " + this.deviceSerialNum, t);
                ProviderStatusUtils.setProviderStatus(ProviderStatusUtils.ProviderStatus.Warning, ProviderStatusUtils.ProviderStatusDetailCode.TIMEOUT);
            }
            finally {
                CacheUpdater.setUpdating(false);
            }
        }
    }

    private void initialize() throws WBEMException {
        try {
            mLogger.log(Level.INFO, "Getting version info for first time for {0}", this.deviceSerialNum);
            RMIObjectMapping mappingObj = RMIObjectMapping.getRMIObjectMapping(this.deviceSerialNum);
            RMIObjectCache rmiobj = mappingObj.getRMIObject();
            rmiobj.refreshUx(0);
            Robj_interface_ConfVerSummary ver = rmiobj.getConfVerSummary();
            ConfVerID[] verKeys = ConfVerID.values();
            Robj_interface_ConfVerDetailList confVerDetail = this.getVersionDetail(rmiobj, ver, verKeys);
            for (ConfVerID verKey : verKeys) {
                int version = ver.getNVer(verKey.getValue());
                mLogger.log(Level.FINE, "Initial nVer for {0}: {1}", new Object[]{verKey, version});
                this.masterVers.put(verKey, new Integer(version));
                Robj_interface_VerBranch curVerDetail = confVerDetail.getConfVerDetail(verKey.getValue());
                this.verDetails.put(verKey, curVerDetail);
                mLogger.log(Level.FINE, "Initial ConfVer for {0}: Summary={1}, nVer={2}", new Object[]{verKey, null == curVerDetail ? "null" : Integer.valueOf(curVerDetail.getNSummaryVer()), null == curVerDetail ? "null" : Integer.valueOf(curVerDetail.getNVer())});
            }
            this.setFirstCall(false);
            this.CreateCacheUpdaters();
            this.doDelayedRegisterUpdateCallback();
        }
        catch (Throwable t) {
            if (t instanceof SANRmiException) {
                SANRmiException sre = (SANRmiException)t;
                throw new WBEMException(1, "Unexpected exception getting version data: " + sre.getErrMsgEn(), null, t);
            }
            throw new WBEMException(1, "Unexpected exception getting version data: " + t, null, t);
        }
    }

    private final synchronized boolean isFirstCall() {
        return this.firstCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CacheUpdater.setRunning(true);
        if (null != System.getProperty("DUMPCACHE")) {
            CacheLib.printCacheData();
        }
        try {
            this.doUpdating();
            this.versionCheckCallbacks.clear();
            this.verDetails.clear();
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Unexpected exception in cache updating thread on " + this.deviceSerialNum, t);
        }
        finally {
            mLogger.log(Level.INFO, "Cache updating thread is exiting for {0}", this.deviceSerialNum);
            updaters.remove(this.deviceSerialNum);
        }
    }

    private final synchronized void setFirstCall(boolean firstCall) {
        this.firstCall = firstCall;
    }

    private static class UpdateCallbackHolder {
        final CallBackType pCBT;
        final CacheUpdateNotifier p2BeCalled;

        protected UpdateCallbackHolder(CallBackType pCBT, CacheUpdateNotifier p2BeCalled) {
            this.pCBT = pCBT;
            this.p2BeCalled = p2BeCalled;
        }

        protected CacheUpdateNotifier getP2BeCalled() {
            return this.p2BeCalled;
        }

        protected CallBackType getpCBT() {
            return this.pCBT;
        }
    }

    private static class NotifyThread<T extends Serializable>
    implements Task {
        private final CacheUpdateType mUpdateType;
        private final CallBackType mCallBackType;
        private final T mChanged;
        private final CacheUpdater mUpdater;

        private NotifyThread(CacheUpdater updater, CacheUpdateType pUpdateType, CallBackType pCallBackType, T pChanged) {
            this.mUpdateType = pUpdateType;
            this.mCallBackType = pCallBackType;
            this.mChanged = pChanged;
            this.mUpdater = updater;
        }

        @Override
        public void doTask() {
            CacheUpdater.doCallback(this.mUpdater, this.mUpdateType, this.mCallBackType, this.mChanged);
        }

        /* synthetic */ NotifyThread(CacheUpdater x0, CacheUpdateType x1, CallBackType x2, Serializable x3, 1 x4) {
            this(x0, x1, x2, x3);
        }
    }

    public static enum ConfVerID {
        RESOURCEGRP(100794369),
        BASIC(0x6010001),
        THIN_PROVISION(100728834),
        POOL(100728835),
        RETENTION(100728836),
        LOCAL_COPY(100728837),
        MIGRATION(0x6010006),
        REMOTE_COPY(100728839),
        REMOTE_COPY_J(100728840),
        PAV(100728841),
        NICKNAME(100728843),
        CACHE(100728842),
        VIRTUALID(100794625),
        FCSP(0x7000001),
        HIGHAVAILABILITY(134283777);

        private int mVal;

        private ConfVerID(int val) {
            this.mVal = val;
        }

        public int getValue() {
            return this.mVal;
        }
    }

    public static enum CallBackType {
        RESOURCEGRP(207),
        LDEV(0),
        PG(1),
        PORT(2),
        LUPATH(3),
        LUSE(4),
        CHA(5),
        LICENSE(6),
        POOL(7),
        THINPOOL(8),
        CACHE(10),
        NICKNAME(11),
        DKAINFO(12),
        MPPCB(13),
        REMOTE_COPY(14),
        REMOTE_COPY_J(15),
        PORTHOSTGROUP(100),
        VDEV(101),
        ECAG(103),
        SNAPSHOT(104),
        LDEVNICKNAME(105),
        POOLNICKNAME(106),
        CACHEINFODATA(200),
        DCRINFO(201),
        PDEVINFO(202),
        PDEVINFOENTRY(203),
        PGNUMBER(204),
        PRMCLASS(205),
        LDEVCAPA(206),
        FCSP(208),
        VIRTUALID(209);

        private int mVal;

        private CallBackType(int val) {
            this.mVal = val;
        }

        public int getValue() {
            return this.mVal;
        }
    }
}

