/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdateType;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.PDEVInfo;
import com.hitachi.smi.common.PDEVInfoEntry;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.logging.Level;
import sanproject.common.Robj_interface_BASICVerAllPG;
import sanproject.common.Robj_interface_VerLeaf;

public class PDEVInfoChecker
extends AbstractVersionChecker {
    protected PDEVInfoChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.BASIC, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        this.comparePDEVInfoEntryBranch((Robj_interface_BASICVerAllPG)currentChildren[1], (Robj_interface_BASICVerAllPG)prevChildren[1]);
    }

    private void comparePDEVInfoEntryBranch(Robj_interface_BASICVerAllPG current, Robj_interface_BASICVerAllPG prior) {
        if (current.getNVer() != prior.getNVer() || current.getNSummaryVer() != prior.getNSummaryVer()) {
            mLogger.info("Detected change in PDEVInfoEntry");
            this.updatePDEVInfo();
        }
    }

    private void updatePDEVInfo() {
        try {
            PDEVInfo updated = PDEVInfo.modifyCachedPDEVInfoClass(this.getSerialNumber());
            if (null != updated) {
                CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PDEVINFO, (Serializable[])new PDEVInfo[]{updated});
            }
            LinkedList<PDEVInfoEntry> added = new LinkedList<PDEVInfoEntry>();
            LinkedList<PDEVInfoEntry> modified = new LinkedList<PDEVInfoEntry>();
            LinkedList<PDEVInfoEntry> removed = new LinkedList<PDEVInfoEntry>();
            PDEVInfoEntry.updateCachedEntries(added, modified, removed, this.getSerialNumber());
            mLogger.log(Level.INFO, "PDEVInfoEntry Modified: {0}, Added: {1}, Removed: {2}", new Object[]{modified.size(), added.size(), removed.size()});
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.DELETE, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PDEVINFOENTRY, (Serializable[])removed.toArray(new PDEVInfoEntry[removed.size()]));
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.ADD, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PDEVINFOENTRY, (Serializable[])removed.toArray(new PDEVInfoEntry[added.size()]));
            CacheUpdater.doCallback((String)this.getSerialNumber(), (CacheUpdateType)CacheUpdateType.MODIFY, (CacheUpdater.CallBackType)CacheUpdater.CallBackType.PDEVINFOENTRY, (Serializable[])removed.toArray(new PDEVInfoEntry[modified.size()]));
        }
        catch (Throwable we) {
            mLogger.log(Level.SEVERE, "Excpetion occurred trying to update PDEVInfo: " + we, we);
        }
    }
}

