/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.cache;

import com.hitachi.smi.cache.AbstractVersionChecker;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.LDEVBranchChecker;
import java.util.LinkedList;
import java.util.logging.Level;
import sanproject.common.Robj_interface_ODGDVerAllLDEV;
import sanproject.common.Robj_interface_ODGDVerLDEVPerCU;
import sanproject.common.Robj_interface_VerLeaf;

public class RetentionBranchChecker
extends AbstractVersionChecker {
    protected RetentionBranchChecker(String serialNum) {
        super(serialNum);
        CacheUpdater.registerVersionChecker(CacheUpdater.ConfVerID.RETENTION, this);
    }

    @Override
    public void checkVersionDetails(Robj_interface_VerLeaf[] currentChildren, Robj_interface_VerLeaf[] prevChildren) {
        this.compareAllRetentionBranch((Robj_interface_ODGDVerAllLDEV)currentChildren[0], (Robj_interface_ODGDVerAllLDEV)prevChildren[0]);
    }

    private void compareAllRetentionBranch(Robj_interface_ODGDVerAllLDEV currentChildren, Robj_interface_ODGDVerAllLDEV prevChildren) {
        if (currentChildren.getNSummaryVer() != prevChildren.getNSummaryVer() || currentChildren.getNVer() != prevChildren.getNVer()) {
            mLogger.info("Change detected in RETENTION version");
            Robj_interface_ODGDVerLDEVPerCU[] currentPerCU = (Robj_interface_ODGDVerLDEVPerCU[])currentChildren.getObjChildren();
            Robj_interface_ODGDVerLDEVPerCU[] priorPerCU = (Robj_interface_ODGDVerLDEVPerCU[])prevChildren.getObjChildren();
            for (short x = 0; x < currentPerCU.length; x = (short)(x + 1)) {
                this.compareLDEVPerCU(x, currentPerCU[x], priorPerCU[x]);
            }
        }
    }

    private void compareLDEVPerCU(short cuIndex, Robj_interface_ODGDVerLDEVPerCU currentLDEVPerCU, Robj_interface_ODGDVerLDEVPerCU priorLDEVPerCU) {
        try {
            LinkedList<Short[]> modifiedDNs = new LinkedList<Short[]>();
            if (currentLDEVPerCU == null || priorLDEVPerCU == null) {
                mLogger.warning("Retention check found null chiled.\nCurrent: " + currentLDEVPerCU + "Prior: " + priorLDEVPerCU);
            } else if (currentLDEVPerCU.getNVer() != priorLDEVPerCU.getNVer()) {
                mLogger.info("Detected change in CU - " + cuIndex);
                LDEVBranchChecker.addModifiedDN2List(cuIndex, (short)-1, modifiedDNs);
                LDEVBranchChecker.processAffectedDNs(null, modifiedDNs, null, this.getSerialNumber());
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Error getting modified LDEVs from device: " + t.toString(), t);
        }
    }
}

