/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiChaInfo;
import sanproject.serverux.data.SANRmiException;

public class CHAInfo
extends AbstractBaseCommonObject {
    private static final long serialVersionUID = 1L;
    private static Class<CHAInfo[]> clz = CHAInfo[].class;
    private static String[][] pkgTypeData = new String[][]{{"106", "FICON 8port - 8G"}, {"107", "FC 8port - 8G"}, {"108", "FC 4port - 8G"}, {"118", "FC 4port - 16G"}};
    private static Hashtable<Byte, String> pkgType2String = new Hashtable();
    private static Hashtable<String, Byte> String2pkgType = new Hashtable();
    private short mChassisID;
    private short mChaNum;
    private int mCtrID;
    private String mDisplayName;
    private byte mCHAPackageType;
    private short mClusterNum;

    public static CHAInfo[] addCHAInfoToCache(short pChaNum, short pClusterNum, String serialNum) throws WBEMException {
        CHAInfo[] ret = new CHAInfo[]{};
        try {
            ClosableAddableIteratorCB<CHAInfo> callback = new ClosableAddableIteratorCB<CHAInfo>();
            CHAInfo.getUnCachedCHAInfo(RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject(), callback, pChaNum, pClusterNum, -1);
            CloseableAddableIterator<CHAInfo> paths = callback.getWrappedCloseableAddableIter();
            callback = null;
            HashMap<String, List<CHAInfo>> pathMap = new HashMap<String, List<CHAInfo>>();
            ArrayList<CHAInfo> pathList = new ArrayList<CHAInfo>();
            while (paths.hasNext()) {
                CHAInfo path = (CHAInfo)paths.next();
                CHAInfo.addCHAInfoToMap(pathMap, path);
                pathList.add(path);
            }
            CacheLib.addDataToCache(pathMap, pathList, clz, serialNum);
            ret = pathList.toArray(new CHAInfo[pathList.size()]);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add LUPath to cache" + t, null, t);
        }
        return ret;
    }

    private static void addCHAInfoToMap(HashMap<String, List<CHAInfo>> pathMap, CHAInfo chaInfo) {
        String key = CacheLib.getCHAInfoChaNumClusterNum(chaInfo.mChaNum, (short)-1);
        CacheLib.addToMap(pathMap, key, chaInfo);
        key = CacheLib.getCHAInfoChaNumClusterNum((short)-1, chaInfo.mChassisID);
        CacheLib.addToMap(pathMap, key, chaInfo);
        key = CacheLib.getCHAInfoChaNumClusterNum(chaInfo.mChaNum, chaInfo.mChassisID);
        CacheLib.addToMap(pathMap, key, chaInfo);
        key = CacheLib.getCHAInfoCtrID(chaInfo.mCtrID);
        CacheLib.addToMap(pathMap, key, chaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapObj) throws WBEMException, RemoteException, SANRmiException {
        RMIObjectCache rmiObj = mapObj.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<CHAInfo> clazz = CHAInfo.class;
            synchronized (CHAInfo.class) {
                if (!cache.isCached(clz)) {
                    CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
                    CHAInfo.getUnCachedCHAInfo(rmiObj, callback, (short)-1, (short)-1, -1);
                    LinkedList<CHAInfo> paths = callback.getReturnValue();
                    callback = null;
                    HashMap<String, List<CHAInfo>> pathMap = new HashMap<String, List<CHAInfo>>();
                    for (CHAInfo path : paths) {
                        CHAInfo.addCHAInfoToMap(pathMap, path);
                    }
                    CacheLib.addDataToCache(pathMap, paths, clz, mapObj.getSerialNumber());
                } else {
                    cacheLogger.warning("CHAInfo is already in the cache");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            cacheLogger.warning("CHAInfo is already in the cache");
        }
    }

    public static int calculateCtrID(short clusterNum, short chaNum) {
        return clusterNum * 32 + chaNum;
    }

    public static final CHAInfo find(int ctrID, RMIObjectCache rmiObj) throws WBEMException {
        if (null == rmiObj) {
            throw new WBEMException(6, "Cache object must be passed to 'find' functions");
        }
        CHAInfo ret = null;
        try {
            FindMethodCallbackHandler<CHAInfo> callback = new FindMethodCallbackHandler<CHAInfo>();
            CHAInfo.getCHAInfo(rmiObj, callback, (short)-1, (short)-1, ctrID);
            ret = callback.getReturnValue();
        }
        catch (Exception e) {
            WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
            throw we;
        }
        return ret;
    }

    public static void getCHAInfo(RMIObjectCache rmiObj, IteratorCallback<CHAInfo> callback, short pChaNum, short pClusterNum, int pCtrID) throws WBEMException {
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] paths = null;
            if (pChaNum != -1 || pClusterNum != -1) {
                String key = CacheLib.getCHAInfoChaNumClusterNum(pChaNum, pClusterNum);
                paths = (CHAInfo[])cache.getCachedObject(key, clz);
            } else if (pCtrID != -1) {
                String key = CacheLib.getCHAInfoCtrID(pCtrID);
                paths = (CHAInfo[])cache.getCachedObject(key, clz);
            } else {
                paths = (CHAInfo[])cache.getCachedObject(clz);
            }
            if (paths != null) {
                callback.returnItems(paths);
            }
            callback.done();
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "CHAInfo not cached on {0}, performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            try {
                CHAInfo.getUnCachedCHAInfo(rmiObj, callback, pChaNum, pClusterNum, pCtrID);
            }
            catch (Throwable e) {
                throw new WBEMException(1, "Exception getting CHA Info on " + rmiObj.getSMISMappingContainer(), null, e);
            }
        }
    }

    public static void getCHAInfoByChaNum(RMIObjectCache rmiObj, IteratorCallback<CHAInfo> callback, short chaNum) throws WBEMException {
        CHAInfo.getCHAInfo(rmiObj, callback, chaNum, (short)-1, -1);
    }

    private static void getCHAInfoByCtrID(IteratorCallback<CHAInfo> callback, int ctrID) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping map : mappings) {
            if (null != map) {
                CHAInfo.getCHAInfo(map.getRMIObject(), callback, (short)-1, (short)-1, ctrID);
                continue;
            }
            providerLogger.severe("One of the mappings is null.");
        }
    }

    public static void getCHAInfoByCtrID(RMIObjectCache rmiObj, IteratorCallback<CHAInfo> callback, int ctrID) throws WBEMException {
        if (null == rmiObj) {
            CHAInfo.getCHAInfoByCtrID(callback, ctrID);
            return;
        }
        CHAInfo.getCHAInfo(rmiObj, callback, (short)-1, (short)-1, ctrID);
    }

    private static void getUnCachedCHAInfo(RMIObjectCache rmiObj, IteratorCallback<CHAInfo> callback, short pChaNum, short pClusterNum, int pCtrID) throws RemoteException, SANRmiException, WBEMException {
        CHAInfo.initPKGTypeHash();
        Robj_interface_RJiChaInfo[] infoDetails = rmiObj.getCHALocation();
        if (infoDetails.length > 0) {
            TaskProcessor task = new TaskProcessor("CHAInfo", infoDetails.length);
            for (Robj_interface_RJiChaInfo infoDetail : infoDetails) {
                cacheLogger.log(Level.FINE, "SChassis: {0}, SID: {1}, StrLocation: {2}", new Object[]{infoDetail.getSChassis(), infoDetail.getSID(), infoDetail.getStrLocation()});
                WorkerThread worker = new WorkerThread(rmiObj.getSMISMappingContainer().getSerialNumber(), callback, infoDetail, task, pChaNum, pClusterNum, pCtrID);
                task.addTask(worker);
            }
        } else {
            callback.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initPKGTypeHash() {
        if (!pkgType2String.isEmpty()) return;
        Class<CHAInfo> clazz = CHAInfo.class;
        synchronized (CHAInfo.class) {
            if (!pkgType2String.isEmpty()) return;
            for (String[] element : pkgTypeData) {
                byte pkgByteVal = Byte.parseByte(element[0]);
                String pkgTypeStr = element[1];
                pkgType2String.put(pkgByteVal, pkgTypeStr);
                String2pkgType.put(pkgTypeStr, pkgByteVal);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void modifyCachedCHAInfo(List<CHAInfo> added, List<CHAInfo> removed, String serialNum) throws WBEMException {
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            CHAInfo[] cachedLUs = (CHAInfo[])cache.getCachedObject(null, clz);
            CommonClassAsList<CHAInfo> callback = new CommonClassAsList<CHAInfo>();
            CHAInfo.getUnCachedCHAInfo(rmiObj, callback, (short)-1, (short)-1, -1);
            LinkedList<CHAInfo> newLUs = callback.getReturnValue();
            callback = null;
            if (newLUs != null) {
                ArrayList cachedList = cachedLUs != null ? Arrays.asList(cachedLUs) : new ArrayList(0);
                added.addAll(newLUs);
                added.removeAll(cachedList);
                removed.clear();
                removed.addAll(cachedList);
                removed.removeAll(newLUs);
                HashMap<String, List<CHAInfo>> luMap = new HashMap<String, List<CHAInfo>>();
                for (CHAInfo lu : added) {
                    CHAInfo.addCHAInfoToMap(luMap, lu);
                }
                CacheLib.addDataToCache(luMap, added, clz, serialNum);
                luMap.clear();
                CHAInfo.removeItemsFromMap(luMap, removed, serialNum);
            } else {
                cacheLogger.info("No changes detected in CHAInfo");
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to modify LUUSEInfo in cache" + t, null, t);
        }
    }

    public static boolean processInfoDetail(String serialNum, IteratorCallback<CHAInfo> mCallBack, Robj_interface_RJiChaInfo mInfo) {
        CHAInfo lup = new CHAInfo(serialNum, mInfo);
        return mCallBack.returnItem(lup);
    }

    public static CHAInfo[] removeCHAInfoFromCache(short pChaNum, short pClusterNum, String serialNum) throws WBEMException {
        Serializable[] paths;
        try {
            String key = CacheLib.getCHAInfoChaNumClusterNum(pChaNum, pClusterNum);
            HitachiCacheInterface cache = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject().smisGetHitachiCacheIF();
            paths = (CHAInfo[])cache.getCachedObject(key, clz);
            if (paths != null) {
                HashMap<String, List<CHAInfo>> pathMap = new HashMap<String, List<CHAInfo>>();
                for (CHAInfo cHAInfo : paths) {
                    CHAInfo.addCHAInfoToMap(pathMap, cHAInfo);
                }
                CacheLib.removeDataFromCache(pathMap, (Serializable[])paths, clz, (String)serialNum);
            }
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to remove CHAInfo from cache " + serialNum, null, t);
        }
        return paths;
    }

    private static void removeItemsFromMap(HashMap<String, List<CHAInfo>> pathMap, List<CHAInfo> theList, String serialNum) throws WBEMException {
        for (CHAInfo path : theList) {
            CHAInfo.addCHAInfoToMap(pathMap, path);
        }
        CacheLib.removeDataFromCache(pathMap, (Serializable[])theList.toArray(new CHAInfo[theList.size()]), clz, (String)serialNum);
    }

    CHAInfo(CHAInfo orig) {
        super(orig.getSerialNumber());
        this.copy(orig);
    }

    CHAInfo(String serialNum, Robj_interface_RJiChaInfo mInfo) {
        super(serialNum);
        this.mChassisID = mInfo.getSChassis();
        this.mChaNum = mInfo.getSID();
        this.mCtrID = CHAInfo.calculateCtrID(this.mChassisID, this.mChaNum);
        this.mDisplayName = mInfo.getStrLocation();
        this.mCHAPackageType = mInfo.getByCHAPackageType();
        this.mClusterNum = mInfo.getSCL();
    }

    private void copy(CHAInfo orig) {
        this.mChassisID = orig.getChassisID();
        this.mChaNum = orig.getChaNum();
        this.mCtrID = orig.getCtrID();
        this.mDisplayName = orig.getDisplayName();
        this.mCHAPackageType = orig.getCHAPackageType();
        this.mClusterNum = orig.mClusterNum;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CHAInfo other = (CHAInfo)obj;
        if (this.mCHAPackageType != other.mCHAPackageType) {
            return false;
        }
        if (this.mChaNum != other.mChaNum) {
            return false;
        }
        if (this.mChassisID != other.mChassisID) {
            return false;
        }
        if (this.mClusterNum != other.mClusterNum) {
            return false;
        }
        if (this.mCtrID != other.mCtrID) {
            return false;
        }
        return !(this.mDisplayName == null ? other.mDisplayName != null : !this.mDisplayName.equals(other.mDisplayName));
    }

    public short getChaNum() {
        return this.mChaNum;
    }

    public byte getCHAPackageType() {
        return this.mCHAPackageType;
    }

    public short getChassisID() {
        return this.mChassisID;
    }

    public short getClusterNum() {
        return this.mClusterNum;
    }

    public int getCtrID() {
        return this.mCtrID;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public String getPKGType() {
        CHAInfo.initPKGTypeHash();
        String ret = pkgType2String.get(this.mCHAPackageType);
        if (ret == null) {
            providerLogger.log(Level.SEVERE, "UNKNOWN PKG Type: " + this.mCHAPackageType);
            ret = "UNKNOWN";
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.mCHAPackageType;
        result = 31 * result + this.mChaNum;
        result = 31 * result + this.mChassisID;
        result = 31 * result + this.mClusterNum;
        result = 31 * result + this.mCtrID;
        result = 31 * result + (this.mDisplayName == null ? 0 : this.mDisplayName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CHAInfo [SerialNum=");
        builder.append(this.getSerialNumber());
        builder.append(", mChassisID=");
        builder.append(this.mChassisID);
        builder.append(", mChaNum=");
        builder.append(this.mChaNum);
        builder.append(", mCtrID=");
        builder.append(this.mCtrID);
        builder.append(", mDisplayName=");
        builder.append(this.mDisplayName);
        builder.append(", mCHAPackageType=");
        builder.append(this.mCHAPackageType);
        builder.append(", mClusterNum=");
        builder.append(this.mClusterNum);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<CHAInfo> mCallBack;
        private final Robj_interface_RJiChaInfo mInfo;
        private final TaskProcessor mTheTask;
        private final short mChaNum;
        private final short mClusternum;
        private final int mCtrlID;
        private final String serialNum;

        public WorkerThread(String serialNum, IteratorCallback<CHAInfo> callback, Robj_interface_RJiChaInfo infoDetail, TaskProcessor theTask, short pChaNum, short pClusterNum, int pCtrID) {
            this.serialNum = serialNum;
            this.mInfo = infoDetail;
            this.mCallBack = callback;
            this.mTheTask = theTask;
            this.mChaNum = pChaNum;
            this.mClusternum = pClusterNum;
            this.mCtrlID = pCtrID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                if (!this.mTheTask.shouldStop()) {
                    short clusterNum = this.mInfo.getSChassis();
                    short chaNum = this.mInfo.getSID();
                    if (this.mChaNum == -1 && this.mClusternum == -1 ? this.mCtrlID != -1 && this.mCtrlID != CHAInfo.calculateCtrID(chaNum, clusterNum) : this.mChaNum != -1 && this.mChaNum != chaNum && (this.mClusternum != -1 || this.mClusternum != clusterNum)) {
                        return;
                    }
                    boolean ret = CHAInfo.processInfoDetail(this.serialNum, this.mCallBack, this.mInfo);
                    if (!ret) {
                        this.mTheTask.setStop(true);
                    }
                }
            }
            catch (Throwable e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)e : new WBEMException(1, "Exception while processing items", null, e);
                this.mCallBack.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallBack.done();
                }
            }
        }
    }
}

