/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.RMIObjectMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiMpbladeInfo;

public class ChassisInfo
extends AbstractBaseCommonObject {
    private static final long serialVersionUID = 1L;
    static final Map<String, ChassisInfo> infos = new HashMap<String, ChassisInfo>();
    private static String DKC0 = "DKC-0";
    private String[] dkcIDs = new String[0];
    private boolean hasDKC0 = false;

    public static ChassisInfo getChassisInfo(String serialNum) throws WBEMException {
        ChassisInfo info = infos.get(serialNum);
        if (null == info) {
            cacheLogger.log(Level.WARNING, "{0} has no data available, attempting to gather it now", serialNum);
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
            if (null != device) {
                ChassisInfo.populateDKCChassis(device);
                info = infos.get(serialNum);
                if (null == info) {
                    throw new WBEMException("Unable to get chassis data for " + serialNum);
                }
            } else {
                throw new WBEMException("No managed device with serial # " + serialNum);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void populateDKCChassis(RMIObjectMapping device) {
        block13: {
            String serialNum;
            try {
                serialNum = device.getSerialNumber();
            }
            catch (WBEMException we) {
                cacheLogger.log(Level.SEVERE, "Unable to locate managed device: ", device);
                return;
            }
            ChassisInfo info = null;
            try {
                info = infos.get(serialNum);
                if (null == info) {
                    Map<String, ChassisInfo> map = infos;
                    synchronized (map) {
                        info = infos.get(serialNum);
                        if (null == info) {
                            info = new ChassisInfo(serialNum);
                            info.getDKCChassisInfo(device);
                            infos.put(serialNum, info);
                        }
                        break block13;
                    }
                }
                info.getDKCChassisInfo(device);
            }
            catch (Throwable t) {
                if (null != info) {
                    Map<String, ChassisInfo> map = infos;
                    synchronized (map) {
                        infos.remove(serialNum);
                    }
                }
                cacheLogger.log(Level.SEVERE, "Error populating/updating Chassis info", t);
            }
        }
    }

    private ChassisInfo(String serialNumber) {
        super(serialNumber);
    }

    public String getChassisLocation(int cDev, int rDev) {
        String ret = null;
        if (rDev >= 0 && rDev <= 63 && cDev >= 0 && cDev <= 47) {
            ret = String.format("DKU-%02d", cDev);
        } else {
            cacheLogger.log(Level.SEVERE, "RDev: {0} or CDev: {1} is invalid.", new Object[]{rDev, cDev});
        }
        return null != ret ? ret : "UNKNOWN";
    }

    private synchronized void getDKCChassisInfo(RMIObjectMapping device) throws WBEMException {
        try {
            Robj_interface_RJiMpbladeInfo[] bladeInfos;
            RMIObjectCache rmiObj = device.getRMIObject();
            for (Robj_interface_RJiMpbladeInfo bladeInfo : bladeInfos = rmiObj.getMPBladeLocation()) {
                if (this.hasDKC0 || bladeInfo.getSChassis() != 0) continue;
                this.hasDKC0 = true;
                break;
            }
            ArrayList<String> dkcIDList = new ArrayList<String>();
            if (this.hasDKC0) {
                dkcIDList.add(DKC0);
            }
            this.dkcIDs = dkcIDList.toArray(new String[dkcIDList.size()]);
        }
        catch (Exception e) {
            WBEMException we = e instanceof WBEMException ? (WBEMException)((Object)e) : new WBEMException(1, "Exception populating DKC: " + e, null, (Throwable)e);
            throw we;
        }
    }

    public String[] getDKCIDs() {
        return this.dkcIDs;
    }

    public boolean hasDKC0() {
        return this.hasDKC0;
    }

    public boolean hasDKC1() {
        return false;
    }

    public boolean isValidDKCLocation(String location) {
        boolean ret = false;
        if (null != location) {
            for (String loc : this.dkcIDs) {
                if (!location.equals(loc)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }
}

