/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLUPathIndex;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.serverux.data.SANRmiException;

public class LUPathObject
extends AbstractBaseCommonObject {
    private static Map<String, Set<Short>> assignedLuns = new HashMap<String, Set<Short>>();
    private static final long serialVersionUID = 1L;
    private static Class<LUPathObject[]> clz = LUPathObject[].class;
    private short DKC;
    private short CU;
    private short LDEV;
    private short SLun;
    private short SPort;
    private short SHostGrp;

    public static LUPathObject[] addLUPathToCache(List<Short> addedPorts, LinkedList<Short[]> affectedDNs, String serialNum) throws WBEMException {
        ArrayList<LUPathObject> ret = new ArrayList<LUPathObject>();
        try {
            LUPathObject path;
            CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
            RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
            RMIObjectCache rmiObj = mapping.getRMIObject();
            LUPathObject.getUnCachedLUPaths(rmiObj, callback, (short)-1, (short)-1, -1L);
            LinkedList<LUPathObject> pathList = callback.getReturnValue();
            callback = null;
            HashMap<String, List<LUPathObject>> pathMap = new HashMap<String, List<LUPathObject>>();
            Collections.sort(addedPorts);
            while ((path = (LUPathObject)pathList.poll()) != null) {
                if (Collections.binarySearch(addedPorts, path.getSPort()) < 0) continue;
                LUPathObject.addPathToMap(pathMap, path);
                ret.add(path);
                affectedDNs.offer(new Short[]{path.CU, path.LDEV});
            }
            CacheLib.addDataToCache(pathMap, ret, clz, serialNum);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to add LUPath to cache" + t, null, t);
        }
        return ret.toArray(new LUPathObject[ret.size()]);
    }

    private static void addPathToMap(HashMap<String, List<LUPathObject>> pathMap, LUPathObject path) {
        String key = CacheLib.getLUPathPort(path.getSPort());
        CacheLib.addToMap(pathMap, key, path);
        key = CacheLib.getLUPathPortHostgroup(path.getSPort(), path.getSHostGrp());
        CacheLib.addToMap(pathMap, key, path);
        long devNum = BaseDeviceNumber.makeUniqueDN(path.getDKC(), path.getCU(), path.getLDEV());
        key = CacheLib.getLUPathDevNum(devNum);
        CacheLib.addToMap(pathMap, key, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws RemoteException, SANRmiException, WBEMException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<LUPathObject> clazz = LUPathObject.class;
            synchronized (LUPathObject.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<LUPathObject> callback = new ClosableAddableIteratorCB<LUPathObject>();
                    LUPathObject.getUnCachedLUPaths(rmiObj, callback, (short)-1, (short)-1, -1L);
                    CloseableAddableIterator<LUPathObject> cbIter = callback.getWrappedCloseableAddableIter();
                    HashMap<String, List<LUPathObject>> pathMap = new HashMap<String, List<LUPathObject>>();
                    ArrayList<LUPathObject> paths = new ArrayList<LUPathObject>();
                    while (cbIter.hasNext()) {
                        LUPathObject path = (LUPathObject)cbIter.next();
                        paths.add(path);
                        LUPathObject.addPathToMap(pathMap, path);
                    }
                    CacheLib.addDataToCache(pathMap, paths, clz, mapping.getSerialNumber());
                } else {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                    logger.log(Level.WARNING, "LUPathObject is already cached for {0}", mapping.getSerialNumber());
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.WARNING, "LUPathObject is already cached in {0}", mapping.getSerialNumber());
        }
    }

    private static Robj_interface_RJiLUPathIndex[] callLUPathInChunks(RMIObjectCache rmiObj) throws RemoteException, SANRmiException, WBEMException {
        Robj_interface_RJiLUPathIndex[] tempArray;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
        logger.log(Level.INFO, "entering callLUPathInChunks for {0}", serialNum);
        Robj_interface_RJiLDEVIndex[] ldevIdxArray = rmiObj.getLDEVIndex();
        logger.log(Level.FINE, "getLDEVIndex returned {0} from {1}", new Object[]{ldevIdxArray.length, serialNum});
        int MAX_ARRAY_SIZE = 256;
        ArrayList<Robj_interface_RJiLUPathIndex> result = new ArrayList<Robj_interface_RJiLUPathIndex>(ldevIdxArray.length);
        int numCalls = ldevIdxArray.length / 256;
        int remainder = ldevIdxArray.length % 256;
        logger.log(Level.INFO, "We will call getLUPathIndex {0} times on {1}", new Object[]{numCalls + (remainder > 0 ? 1 : 0), serialNum});
        int x = 0;
        int totalElements = 0;
        Robj_interface_RJiLDEVIndex[] callParam = new Robj_interface_RJiLDEVIndex[numCalls > 0 ? 256 : remainder];
        for (x = 0; x < numCalls; ++x) {
            System.arraycopy(ldevIdxArray, 256 * x, callParam, 0, 256);
            logger.log(Level.FINE, "Calling getLUPathIndex with {0} items on {1}", new Object[]{callParam.length, serialNum});
            tempArray = rmiObj.getLUPathIndex(callParam);
            totalElements += callParam.length;
            logger.log(Level.FINE, "getLUPathIndex returned {0} elements from {1}", new Object[]{tempArray.length, serialNum});
            result.addAll(Arrays.asList(tempArray));
        }
        if (numCalls > 0 && remainder > 0) {
            callParam = new Robj_interface_RJiLDEVIndex[remainder];
        }
        if (remainder > 0) {
            System.arraycopy(ldevIdxArray, 256 * x, callParam, 0, remainder);
            logger.log(Level.FINE, "Calling getLUPathIndex with {0} items", callParam.length);
            tempArray = rmiObj.getLUPathIndex(callParam);
            logger.log(Level.FINE, "getLUPathIndex returned {0} elements from {1}", new Object[]{tempArray.length, serialNum});
            totalElements += callParam.length;
            result.addAll(Arrays.asList(tempArray));
        }
        logger.log(Level.INFO, "Total number of LDEVIndexes processed {0}, retrieved {1} LUPaths on {2}", new Object[]{totalElements, result.size(), serialNum});
        return result.toArray(new Robj_interface_RJiLUPathIndex[result.size()]);
    }

    private static final String createPortHostgroupString(String serialNum, short port, short hostGrp) {
        StringBuilder str = new StringBuilder(serialNum);
        str.append(".");
        str.append(port);
        str.append(".");
        str.append(hostGrp);
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short getFreeLunNumber(String serialNum, short pPort, short pHostgroup) throws WBEMException {
        short ret = -1;
        String portHostgroupString = LUPathObject.createPortHostgroupString(serialNum, pPort, pHostgroup);
        Set<Short> assignedLunsForPortHostgroup = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        Object object = assignedLuns;
        synchronized (object) {
            assignedLunsForPortHostgroup = assignedLuns.get(portHostgroupString);
            if (null == assignedLunsForPortHostgroup) {
                logger.log(Level.FINE, "Creating new set for port {0} and hostgroup {1} for {2}", new Object[]{pPort, pHostgroup, serialNum});
                assignedLunsForPortHostgroup = new HashSet<Short>();
                assignedLuns.put(portHostgroupString, assignedLunsForPortHostgroup);
            }
        }
        object = assignedLunsForPortHostgroup;
        synchronized (object) {
            HashSet<Short> luns = LUPathObject.getLunNums(serialNum, pPort, pHostgroup);
            for (short i = 0; i < 2047; i = (short)(i + 1)) {
                if (assignedLunsForPortHostgroup.contains(i) || luns.contains(i)) continue;
                ret = i;
                assignedLunsForPortHostgroup.add(i);
                logger.log(Level.INFO, "Using LUNNum {0} for port {1}, hostgroup {2} on {3}", new Object[]{i, pPort, pHostgroup, serialNum});
                break;
            }
        }
        return ret;
    }

    public static HashSet<Short> getLunNums(String serialNum, short pPort, short pHostgroup) throws WBEMException {
        HashSet<Short> ret = new HashSet<Short>();
        ClosableAddableIteratorCB<LUPathObject> callback = new ClosableAddableIteratorCB<LUPathObject>();
        String noCache = ProviderProperties.getProviderProperties().getProperty("NoCacheLUPath");
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
        if (null != noCache) {
            try {
                LUPathObject.getUnCachedLUPaths(rmiObj, callback, pPort, pHostgroup, -1L);
            }
            catch (Exception th) {
                throw new WBEMException(1, th.getMessage());
            }
        } else {
            LUPathObject.getLUPaths(rmiObj, callback, pPort, pHostgroup);
        }
        CloseableAddableIterator<LUPathObject> luPaths = callback.getWrappedCloseableAddableIter();
        while (luPaths.hasNext()) {
            LUPathObject luPath = (LUPathObject)luPaths.next();
            ret.add(new Short(luPath.getSLun()));
        }
        return ret;
    }

    private static void getLUPaths(IteratorCallback<LUPathObject> callback, short sPort, short sHostgroup, long pDevNum) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                LUPathObject.getLUPaths(mapObj.getRMIObject(), callback, sPort, sHostgroup, pDevNum);
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static void getLUPaths(RMIObjectCache rmiObj, IteratorCallback<LUPathObject> callback, long devNum) throws WBEMException {
        LUPathObject.getLUPaths(rmiObj, callback, (short)-1, devNum);
    }

    public static void getLUPaths(RMIObjectCache rmiObj, IteratorCallback<LUPathObject> callback, short sPort) throws WBEMException {
        LUPathObject.getLUPaths(rmiObj, callback, sPort, -1L);
    }

    public static void getLUPaths(RMIObjectCache rmiObj, IteratorCallback<LUPathObject> callback, short sPort, long pDevNum) throws WBEMException {
        LUPathObject.getLUPaths(rmiObj, callback, sPort, (short)-1, pDevNum);
    }

    public static void getLUPaths(RMIObjectCache rmiObj, IteratorCallback<LUPathObject> callback, short sPort, short hostGrp) throws WBEMException {
        LUPathObject.getLUPaths(rmiObj, callback, sPort, hostGrp, -1L);
    }

    public static void getLUPaths(RMIObjectCache rmiObj, IteratorCallback<LUPathObject> callback, short sPort, short sHostgroup, long pDevNum) throws WBEMException {
        if (null == rmiObj) {
            LUPathObject.getLUPaths(callback, sPort, sHostgroup, pDevNum);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] paths = null;
            String key = null;
            if (sPort != -1) {
                key = -1 != sHostgroup ? CacheLib.getLUPathPortHostgroup(sPort, sHostgroup) : CacheLib.getLUPathPort(sPort);
                paths = (LUPathObject[])cache.getCachedObject(key, clz);
            } else if (pDevNum != -1L) {
                key = CacheLib.getLUPathDevNum(pDevNum);
                paths = (LUPathObject[])cache.getCachedObject(key, clz);
            } else {
                paths = (LUPathObject[])cache.getCachedObject(clz);
            }
            if (paths != null) {
                callback.returnItems(paths);
            } else {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.info("Did not find any LUPaths in cache that matched:" + key + ", this is OK");
                callback.done();
            }
        } else {
            cacheLogger.log(Level.WARNING, "LUPathObject not cached, performance issue");
            try {
                LUPathObject.getUnCachedLUPaths(rmiObj, callback, sPort, sHostgroup, pDevNum);
            }
            catch (Throwable e) {
                throw new WBEMException(1, "Exception getting LUPaths: " + e, null, e);
            }
        }
    }

    public static void getLUPaths(RMIObjectCache rmiObj, IteratorCallback<LUPathObject> callback, short dkc, short cu, short ldev) throws WBEMException {
        long devNum = BaseDeviceNumber.makeUniqueDN(dkc, cu, ldev);
        LUPathObject.getLUPaths(rmiObj, callback, (short)-1, devNum);
    }

    private static void getUnCachedLUPaths(RMIObjectCache rmiObj, IteratorCallback<LUPathObject> callback, short sPort, short sHostGroup, long pDevNum) throws RemoteException, SANRmiException, WBEMException {
        Robj_interface_RJiLUPathIndex[] luPaths;
        if (sPort != -1) {
            Robj_interface_RJiPortIndex portIndex = (Robj_interface_RJiPortIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJIPORTINDEX);
            portIndex.setSPort(sPort);
            luPaths = rmiObj.getLUPathIndex(portIndex);
            if (-1 != sHostGroup) {
                ArrayList<Robj_interface_RJiLUPathIndex> luPathList = new ArrayList<Robj_interface_RJiLUPathIndex>();
                for (Robj_interface_RJiLUPathIndex luPath : luPaths) {
                    if (sHostGroup != luPath.getSHostGroup()) continue;
                    luPathList.add(luPath);
                }
                luPaths = luPathList.toArray(new Robj_interface_RJiLUPathIndex[luPathList.size()]);
            }
        } else if (pDevNum != -1L) {
            Robj_interface_RJiLDEVIndex ldevIndex = (Robj_interface_RJiLDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
            short[] vals = BaseDeviceNumber.getDevIdStringValues(String.valueOf(pDevNum));
            ldevIndex.setSLDKC(vals[0]);
            ldevIndex.setSCU(vals[1]);
            ldevIndex.setSLDEV(vals[2]);
            Robj_interface_RJiLDEVIndex[] param = new Robj_interface_RJiLDEVIndex[]{ldevIndex};
            luPaths = rmiObj.getLUPathIndex(param);
        } else {
            luPaths = LUPathObject.callLUPathInChunks(rmiObj);
        }
        if (luPaths.length > 0) {
            String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
            TaskProcessor task = new TaskProcessor("LUPaths - " + serialNum, luPaths.length);
            for (Robj_interface_RJiLUPathIndex luPath : luPaths) {
                WorkerThread worker = new WorkerThread(callback, luPath, task, serialNum);
                task.addTask(worker);
            }
        } else {
            callback.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLunUsed(String serialNum, short pPort, short pHostgroup, short pLunNumber) throws WBEMException {
        HashSet<Short> luns = LUPathObject.getLunNums(serialNum, pPort, pHostgroup);
        boolean ret = luns.contains(new Short(pLunNumber));
        if (!ret) {
            Set<Short> assignedLunsForPortHostgroup;
            String portHostgroupString = LUPathObject.createPortHostgroupString(serialNum, pPort, pHostgroup);
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            Object object = assignedLuns;
            synchronized (object) {
                assignedLunsForPortHostgroup = assignedLuns.get(portHostgroupString);
                if (null == assignedLunsForPortHostgroup) {
                    logger.log(Level.FINE, "Creating set for port {0} and hostgroup {1}", new Object[]{pPort, pHostgroup});
                    assignedLunsForPortHostgroup = new HashSet<Short>();
                    assignedLuns.put(portHostgroupString, assignedLunsForPortHostgroup);
                }
            }
            object = assignedLunsForPortHostgroup;
            synchronized (object) {
                if (!assignedLunsForPortHostgroup.contains(pLunNumber)) {
                    assignedLunsForPortHostgroup.add(pLunNumber);
                    logger.log(Level.INFO, "LUNNum {0} is available in port {1}", new Object[]{pLunNumber, pPort});
                } else {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static void modifyCachedLUPath(List<Short> modifiedPorts, List<LUPathObject> added, List<LUPathObject> removed, LinkedList<Short[]> affectedDNs, String serialNum) throws WBEMException {
        AbstractMap<Short, List<LUPathObject>> sortedPaths;
        RMIObjectMapping mapping;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
        logger.log(Level.INFO, "Start processing LUPathObjects on {0}", serialNum);
        try {
            mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
            LUPathObject.getUnCachedLUPaths(mapping.getRMIObject(), callback, (short)-1, (short)-1, -1L);
            LinkedList<LUPathObject> realPaths = callback.getReturnValue();
            callback = null;
            sortedPaths = LUPathObject.sortRelaPathsByPortID(realPaths);
            if (!realPaths.isEmpty()) {
                logger.log(Level.SEVERE, "While modifying LUPaths in cache for {0} we failed to sort out all uncached path information: {1}", new Object[]{serialNum, Arrays.toString(realPaths.toArray())});
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to get uncached LUPaths from " + serialNum, null, t);
        }
        mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
        RMIObjectCache rmiObj = mapping.getRMIObject();
        logger.log(Level.INFO, "Processing {0} modified LUPathObjects on {1}", new Object[]{modifiedPorts.size(), serialNum});
        for (Short modifiedPort : modifiedPorts) {
            callback = new CommonClassAsList();
            try {
                LUPathObject.getLUPaths(rmiObj, callback, modifiedPort);
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable t) {
                throw new WBEMException(1, "Exception occurred trying to get cached LUPaths(" + modifiedPort + ") on  " + serialNum, null, t);
            }
            LinkedList<LUPathObject> cachedPaths = callback.getReturnValue();
            callback = null;
            List<LUPathObject> actualPaths = sortedPaths.remove(modifiedPort);
            if (cachedPaths != null && actualPaths != null) {
                added.addAll(actualPaths);
                added.removeAll(cachedPaths);
                cachedPaths.removeAll(actualPaths);
                removed.addAll(cachedPaths);
                continue;
            }
            if (cachedPaths == null && actualPaths != null) {
                added.addAll(actualPaths);
                continue;
            }
            if (!(cachedPaths != null & actualPaths == null)) continue;
            removed.addAll(cachedPaths);
        }
        HashMap<String, List<LUPathObject>> addedMap = new HashMap<String, List<LUPathObject>>();
        for (LUPathObject path : added) {
            LUPathObject.addPathToMap(addedMap, path);
            affectedDNs.offer(new Short[]{path.CU, path.LDEV});
        }
        CacheLib.addDataToCache(addedMap, added, clz, serialNum);
        LUPathObject.removeItemsFromMap(removed, affectedDNs, serialNum);
        logger.log(Level.INFO, "Done processing LUPathObjects on {0}", serialNum);
    }

    public static boolean processInfoDetail(String serialNumber, IteratorCallback<LUPathObject> mCallBack, Robj_interface_RJiLUPathIndex mInfo) {
        LUPathObject lup = new LUPathObject(serialNumber, mInfo);
        return mCallBack.returnItem(lup);
    }

    private static void removeItemsFromMap(List<LUPathObject> theList, LinkedList<Short[]> affectedDNs, String serialNum) throws WBEMException {
        HashMap<String, List<LUPathObject>> pathMap = new HashMap<String, List<LUPathObject>>();
        for (LUPathObject path : theList) {
            LUPathObject.addPathToMap(pathMap, path);
            affectedDNs.offer(new Short[]{path.CU, path.LDEV});
        }
        CacheLib.removeDataFromCache(pathMap, (Serializable[])theList.toArray(new LUPathObject[theList.size()]), clz, (String)serialNum);
    }

    public static LUPathObject[] removeLUPathFromCache(List<Short> removedPorts, LinkedList<Short[]> affectedDNs, String serialNum) throws WBEMException {
        ArrayList<LUPathObject> paths = new ArrayList<LUPathObject>(removedPorts.size());
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
        RMIObjectCache rmiObj = mapping.getRMIObject();
        try {
            for (Short portID : removedPorts) {
                CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                LUPathObject.getLUPaths(rmiObj, callback, portID);
                LinkedList<LUPathObject> temp = callback.getReturnValue();
                callback = null;
                paths.addAll(temp);
            }
            if (!paths.isEmpty()) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                logger.info("Processing " + paths.size() + " LUPathObjects being removed from cache");
                LUPathObject.removeItemsFromMap(paths, affectedDNs, serialNum);
                logger.info("Done processing LUPathObjects");
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to remove LUPath from cache" + t, null, t);
        }
        return paths.toArray(new LUPathObject[paths.size()]);
    }

    private static AbstractMap<Short, List<LUPathObject>> sortRelaPathsByPortID(Queue<LUPathObject> unsorted) {
        LUPathObject path;
        HashMap<Short, List<LUPathObject>> ret = new HashMap<Short, List<LUPathObject>>();
        while ((path = unsorted.poll()) != null) {
            List<LUPathObject> qByPort = ret.get(path.getSPort());
            if (qByPort == null) {
                qByPort = new ArrayList<LUPathObject>();
                ret.put(path.getSPort(), qByPort);
            }
            qByPort.add(path);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unassignLunNumber(String pSerialNum, short pPort, short pHostgroup, short[] pLunNums) {
        Map<String, Set<Short>> map = assignedLuns;
        synchronized (map) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            String portHostgroupString = LUPathObject.createPortHostgroupString(pSerialNum, pPort, pHostgroup);
            logger.log(Level.INFO, "Examining assignedLuns for port {0}", portHostgroupString);
            Set<Short> assignedLunsForPort = assignedLuns.get(portHostgroupString);
            if (null != assignedLunsForPort) {
                logger.log(Level.INFO, "assignedLunsForPort: {0}", assignedLunsForPort);
                Set<Short> set = assignedLunsForPort;
                synchronized (set) {
                    short[] arr$ = pLunNums;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Short lunNum = arr$[i$];
                        if (assignedLunsForPort.remove(lunNum)) {
                            logger.log(Level.INFO, "Removed LUNNum {0} from {1}", new Object[]{lunNum, portHostgroupString});
                            continue;
                        }
                        logger.log(Level.INFO, "LUNNum {0} was not listed in for {1}", new Object[]{lunNum, portHostgroupString});
                    }
                }
            } else {
                logger.log(Level.WARNING, "{0} was not in assignedLuns", portHostgroupString);
            }
        }
    }

    LUPathObject(LUPathObject orig) {
        super(orig.getSerialNumber());
        this.copy(orig);
    }

    LUPathObject(String serialNum, Robj_interface_RJiLUPathIndex pathInfo) {
        super(serialNum);
        this.DKC = pathInfo.getSLDKC();
        this.CU = pathInfo.getSCU();
        this.LDEV = pathInfo.getSLDEV();
        this.SLun = pathInfo.getSLUN();
        this.SPort = pathInfo.getSPort();
        this.SHostGrp = pathInfo.getSHostGroup();
    }

    private void copy(LUPathObject orig) {
        this.DKC = orig.getDKC();
        this.CU = orig.getCU();
        this.LDEV = orig.getLDEV();
        this.SLun = orig.getSLun();
        this.SPort = orig.getSPort();
        this.SHostGrp = orig.getSHostGrp();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LUPathObject other = (LUPathObject)obj;
        if (this.CU != other.CU) {
            return false;
        }
        if (this.DKC != other.DKC) {
            return false;
        }
        if (this.LDEV != other.LDEV) {
            return false;
        }
        if (this.SHostGrp != other.SHostGrp) {
            return false;
        }
        if (this.SLun != other.SLun) {
            return false;
        }
        return this.SPort == other.SPort;
    }

    public short getCU() {
        return this.CU;
    }

    public String getDeviceID() {
        return String.valueOf(BaseDeviceNumber.makeUniqueDN(this.DKC, this.CU, this.LDEV));
    }

    public DeviceNumber getDeviceNumber() throws WBEMException {
        return DeviceNumber.find(this.getDeviceID(), RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber()).getRMIObject());
    }

    public short getDKC() {
        return this.DKC;
    }

    public short getLDEV() {
        return this.LDEV;
    }

    public String getLunString() {
        return Integer.toHexString(new Short(this.SLun).intValue()).toUpperCase();
    }

    public short getSHostGrp() {
        return this.SHostGrp;
    }

    public short getSLun() {
        return this.SLun;
    }

    public short getSPort() {
        return this.SPort;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.CU;
        result = 31 * result + this.DKC;
        result = 31 * result + this.LDEV;
        result = 31 * result + this.SHostGrp;
        result = 31 * result + this.SLun;
        result = 31 * result + this.SPort;
        return result;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder(LUPathObject.class.getSimpleName());
        ret.append(" - ");
        ret.append("serialNumber: ");
        ret.append(this.getSerialNumber());
        ret.append(", ");
        ret.append("DKC: ");
        ret.append(this.getDKC());
        ret.append(", ");
        ret.append("CU: ");
        ret.append(this.getCU());
        ret.append(", ");
        ret.append("LDEV: ");
        ret.append(this.getLDEV());
        ret.append(", ");
        ret.append("sPort: ");
        ret.append(this.getSPort());
        ret.append(", ");
        ret.append("sLUN: ");
        ret.append(this.getSLun());
        ret.append(", ");
        ret.append("SHostGroup: ");
        ret.append(this.getSHostGrp());
        return ret.toString();
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<LUPathObject> mCallBack;
        private final Robj_interface_RJiLUPathIndex mInfo;
        private final TaskProcessor mTheTask;
        private final String mSerialNumber;

        public WorkerThread(IteratorCallback<LUPathObject> callback, Robj_interface_RJiLUPathIndex pInfo, TaskProcessor theTask, String serialNum) {
            this.mSerialNumber = serialNum;
            this.mInfo = pInfo;
            this.mCallBack = callback;
            this.mTheTask = theTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = LUPathObject.processInfoDetail(this.mSerialNumber, this.mCallBack, this.mInfo))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, "Exception while processing items", null, (Throwable)e);
                this.mCallBack.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallBack.done();
                }
            }
        }
    }
}

