/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.AbstractNickName;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiResourceName;

public class PoolNickname
extends AbstractNickName
implements Comparable<PoolNickname> {
    private static final Class<PoolNickname[]> clz = PoolNickname[].class;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private static final long serialVersionUID = -8551378405965267479L;

    private static void addPoolNicknameToMap(HashMap<String, List<PoolNickname>> map, PoolNickname nickname) {
        String key = CacheLib.getPoolNicknameByPoolID(nickname.getPoolID());
        CacheLib.addToMap(map, key, nickname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<PoolNickname> clazz = PoolNickname.class;
            synchronized (PoolNickname.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<PoolNickname> callback = new ClosableAddableIteratorCB<PoolNickname>();
                    PoolNickname.getUnCachedPoolNicknames(rmiObj, callback, (short)-1);
                    CloseableAddableIterator<PoolNickname> cbIter = callback.getWrappedCloseableAddableIter();
                    ArrayList<PoolNickname> nicknames = new ArrayList<PoolNickname>();
                    HashMap<String, List<PoolNickname>> map = new HashMap<String, List<PoolNickname>>();
                    while (cbIter.hasNext()) {
                        PoolNickname nickname = (PoolNickname)cbIter.next();
                        nicknames.add(nickname);
                        PoolNickname.addPoolNicknameToMap(map, nickname);
                    }
                    CacheLib.addDataToCache(map, nicknames, clz, mapping.getSerialNumber());
                } else {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                    logger.warning("PoolNickname is already in the cache");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.warning("PoolNickname is already in the cache");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final PoolNickname find(RMIObjectCache rmiObj, short poolID) throws WBEMException {
        PoolNickname ret = null;
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            String key = CacheLib.getPoolNicknameByPoolID(poolID);
            PoolNickname[] poolNicks = (PoolNickname[])cache.getCachedObject(key, clz);
            if (poolNicks == null) return ret;
            if (poolNicks.length != 1) throw new WBEMException(1, "Cache " + rmiObj.getSMISMappingContainer().getSerialNumber() + "has " + poolNicks.length + " PoolNicknames " + " for Pool: " + poolID + " but there should only be one.");
            return poolNicks[0];
        }
        try {
            FindMethodCallbackHandler<PoolNickname> callback = new FindMethodCallbackHandler<PoolNickname>();
            PoolNickname.getUnCachedPoolNicknames(rmiObj, callback, poolID);
            return callback.getReturnValue();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
    }

    private static final void getNicknames(IteratorCallback<PoolNickname> callback, short poolID) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                PoolNickname.getNicknames(mapObj.getRMIObject(), callback, poolID);
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    public static final void getNicknames(RMIObjectCache rmiObj, IteratorCallback<PoolNickname> callback, short poolID) throws WBEMException {
        if (null == rmiObj) {
            PoolNickname.getNicknames(callback, poolID);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] nicknames = null;
            String key = null;
            if (-1 == poolID) {
                nicknames = (PoolNickname[])cache.getCachedObject(clz);
            } else {
                key = CacheLib.getPoolNicknameByPoolID(poolID);
                nicknames = (PoolNickname[])cache.getCachedObject(key, clz);
            }
            if (nicknames != null) {
                callback.returnItems(nicknames);
            } else {
                mLogger.log(Level.WARNING, "No PoolNicknames in {0}", rmiObj.getSMISMappingContainer().getSerialNumber());
                callback.done();
            }
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "PoolNickname is not cached on {0}");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
            record.setThrown(new Exception(record.getMessage()));
            cacheLogger.log(record);
            PoolNickname.getUnCachedPoolNicknames(rmiObj, callback, poolID);
        }
    }

    private static void getUnCachedPoolNicknames(RMIObjectCache rmiObj, IteratorCallback<PoolNickname> iter, short poolID) {
        block7: {
            try {
                CommonClassAsList<ThinPool> callback = new CommonClassAsList<ThinPool>();
                ThinPool.getThinPools(rmiObj, callback, poolID);
                LinkedList<ThinPool> tps = callback.getReturnValue();
                callback = null;
                int numPools = tps.size();
                if (numPools > 0) {
                    ThinPool tp;
                    int[] poolIDs = new int[numPools];
                    int count = 0;
                    while ((tp = tps.poll()) != null) {
                        poolIDs[count++] = tp.getPoolID();
                    }
                    Robj_interface_RJiResourceName[] resourceNames = rmiObj.getResourceName(2, poolIDs);
                    if (null != resourceNames && resourceNames.length > 0) {
                        String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
                        TaskProcessor task = new TaskProcessor("PoolNickname - " + serialNum, resourceNames.length);
                        for (Robj_interface_RJiResourceName resourceName : resourceNames) {
                            if (task.shouldStop()) {
                                iter.done();
                                break block7;
                            }
                            WorkerThread worker = new WorkerThread(serialNum, iter, resourceName, task);
                            task.addTask(worker);
                        }
                        break block7;
                    }
                    iter.done();
                    break block7;
                }
                iter.done();
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, e.toString(), null, (Throwable)e);
                iter.exceptionOccurred(we);
                iter.done();
            }
        }
    }

    public static void modifyCachedNickename(List<PoolNickname> added, List<PoolNickname> removed, List<PoolNickname> modified, String serialNum) throws WBEMException {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        try {
            PoolNickname cached;
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            CommonClassAsList<PoolNickname> callback = new CommonClassAsList<PoolNickname>();
            PoolNickname.getNicknames(rmiObj, callback, (short)-1);
            LinkedList<PoolNickname> cachedList = callback.getReturnValue();
            callback = null;
            logger.log(Level.INFO, "Found {0} cached PoolNicknames on {1}", new Object[]{cachedList.size(), serialNum});
            callback = new CommonClassAsList();
            PoolNickname.getUnCachedPoolNicknames(rmiObj, callback, (short)-1);
            LinkedList<PoolNickname> newList = callback.getReturnValue();
            callback = null;
            logger.log(Level.INFO, "Found {0} PoolNicknames on {1}", new Object[]{newList.size(), serialNum});
            Collections.sort(newList);
            Collections.sort(cachedList);
            while ((cached = cachedList.poll()) != null) {
                int index = Collections.binarySearch(newList, cached);
                if (index >= 0) {
                    PoolNickname newNick = (PoolNickname)newList.remove(index);
                    if (cached.equals(newNick)) continue;
                    modified.add(new PoolNickname(cached));
                    cached.setNickname(newNick.getNickname());
                    continue;
                }
                removed.add(cached);
            }
            added.addAll(newList);
            logger.log(Level.INFO, "Found that {0} PoolNicknames have been modified, {1}  removed and {2} added on {3}", new Object[]{modified.size(), removed.size(), added.size(), serialNum});
            HashMap<String, List<PoolNickname>> nicknameMap = new HashMap<String, List<PoolNickname>>();
            if (!removed.isEmpty()) {
                PoolNickname.removeItemsFromMap(nicknameMap, removed, serialNum);
                nicknameMap.clear();
            }
            if (!added.isEmpty()) {
                for (PoolNickname nickname : added) {
                    PoolNickname.addPoolNicknameToMap(nicknameMap, nickname);
                }
                CacheLib.addDataToCache(nicknameMap, added, clz, serialNum);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception occurred trying to modify PoolNickname in cache" + t, null, t);
        }
        logger.info("Done modifiying cached PoolNickname");
    }

    public static boolean processResourceName(IteratorCallback<PoolNickname> mCallback, Robj_interface_RJiResourceName resourceName, String serialNum) {
        boolean ret = true;
        PoolNickname nickname = new PoolNickname((short)resourceName.getNumber(), resourceName.getName(), serialNum);
        ret = mCallback.returnItem(nickname);
        return ret;
    }

    private static void removeItemsFromMap(HashMap<String, List<PoolNickname>> nickNameMap, List<PoolNickname> theList, String serialNum) throws WBEMException {
        for (PoolNickname nickName : theList) {
            PoolNickname.addPoolNicknameToMap(nickNameMap, nickName);
        }
        CacheLib.removeDataFromCache(nickNameMap, (Serializable[])theList.toArray(new PoolNickname[theList.size()]), clz, (String)serialNum);
    }

    public PoolNickname(PoolNickname cached) {
        super(cached.getDeviceNumber(), cached.getSerialNumber(), cached.getNickname());
    }

    private PoolNickname(short poolID, String name, String serialNum) {
        super(Short.toString(poolID), serialNum, name);
    }

    @Override
    public int compareTo(PoolNickname other) {
        short otherPoolID = other.getPoolID();
        short thisPoolID = this.getPoolID();
        return thisPoolID < otherPoolID ? -1 : (thisPoolID == otherPoolID ? 0 : 1);
    }

    public short getPoolID() {
        return Short.valueOf(this.getDeviceNumber());
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<PoolNickname> mCallback;
        private final TaskProcessor mTheTask;
        private final Robj_interface_RJiResourceName mTheVal;
        private final String mSerialNum;

        public WorkerThread(String serialNum, IteratorCallback<PoolNickname> callback, Robj_interface_RJiResourceName val, TaskProcessor pTheTask) {
            this.mSerialNum = serialNum;
            this.mCallback = callback;
            this.mTheVal = val;
            this.mTheTask = pTheTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = PoolNickname.processResourceName(this.mCallback, this.mTheVal, this.mSerialNum))) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Throwable e) {
                WBEMException we = e.getClass().isInstance(WBEMException.class) ? (WBEMException)e : new WBEMException(1, "Exception while processing items", null, e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }
    }
}

