/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.RMIObjectMapping;
import com.ws.wbem.CloseableAddableIterator;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDateTime;
import javax.cim.CIMDateTimeAbsolute;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_PortStatisticInfo;
import sanproject.common.Robj_interface_PortStatisticInfo2_IN;
import sanproject.common.Robj_interface_PortStatisticInfo2_OUT;
import sanproject.common.Robj_interface_PortStatisticInfoEx;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.serverux.data.SANRmiException;

public class PortStats {
    private static boolean checkEXProperty = true;
    UnsignedInteger64 mIOs;
    UnsignedInteger64 mTransRate;
    CIMDateTime mTargetTime;
    String serialNumber;
    short portID;
    private UnsignedInteger64 mTotalIOTime;

    public static PortStats findPortStats(RMIObjectMapping device, FCPort fcPort) throws WBEMException {
        PortStats ret = null;
        CloseableAddableIterator statIter = new CloseableAddableIterator();
        PortStats.processStatData(device, (CloseableAddableIterator<PortStats>)statIter, fcPort.getPort());
        while (statIter.hasNext() && null == ret) {
            ret = (PortStats)statIter.next();
            statIter.done();
        }
        return ret;
    }

    public static PortStats getAllPortStats(String serialNum) throws RemoteException, SANRmiException, WBEMException {
        if (null == serialNum) {
            throw new WBEMException("Must pass valid device serial number");
        }
        PortStats ret = new PortStats(serialNum, -1);
        ret.getStatsInfo();
        return ret;
    }

    public static void getIndividualPortStats(final RMIObjectMapping device, final CloseableAddableIterator<PortStats> retIter) throws RemoteException, SANRmiException, WBEMException {
        if (null == device) {
            retIter.setException(new WBEMException("Must pass valid device ovject"));
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    PortStats.processStatData(device, (CloseableAddableIterator<PortStats>)retIter, (short)-1);
                }
            };
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("PortStats Processor");
            t.start();
        }
    }

    public static CIMDateTime getMaxPortStatisticTime(String serialNum) throws RemoteException, SANRmiException, WBEMException {
        if (null == serialNum) {
            throw new WBEMException("Must pass valid device serial number");
        }
        PortStats stats = new PortStats(serialNum, -1);
        stats.getStatsInfo();
        return stats.getTargetTime();
    }

    public static UnsignedInteger64 getTotalAllIOs(String serialNum) throws RemoteException, SANRmiException, WBEMException {
        if (null == serialNum) {
            throw new WBEMException("Must pass valid device serial number");
        }
        PortStats stats = new PortStats(serialNum, -1);
        stats.getStatsInfo();
        return stats.getIOs();
    }

    public static UnsignedInteger64 getTotalTransRate(String serialNum) throws RemoteException, SANRmiException, WBEMException {
        if (null == serialNum) {
            throw new WBEMException("Must pass valid device serial number");
        }
        PortStats stats = new PortStats(serialNum, -1);
        stats.getStatsInfo();
        return stats.getTransRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processStatData(RMIObjectMapping device, CloseableAddableIterator<PortStats> retIter, short portID) {
        block16: {
            try {
                Robj_interface_RJiPortIndex[] piArray;
                RMIObjectCache rmiObj = device.getRMIObject();
                if (-1 == portID) {
                    piArray = rmiObj.getPortIndex();
                } else {
                    piArray = new Robj_interface_RJiPortIndex[1];
                    Robj_interface_RJiPortIndex tempRJiPortIndex = (Robj_interface_RJiPortIndex)device.getRMIObject().smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJIPORTINDEX);
                    tempRJiPortIndex.setSPort(portID);
                    piArray[0] = tempRJiPortIndex;
                }
                if (piArray.length > 0) {
                    Robj_interface_PortStatisticInfo[] statsArray;
                    Robj_interface_PortStatisticInfo2_IN statReq = (Robj_interface_PortStatisticInfo2_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.PORTSTATISTICINFO2_IN);
                    if (null != statReq) {
                        statReq.setPortIndex(piArray);
                        statReq.setAttr((short)1);
                        Robj_interface_PortStatisticInfo2_OUT portStatsOut = (Robj_interface_PortStatisticInfo2_OUT)rmiObj.getCmnData(statReq);
                        statsArray = portStatsOut.getPortStatisticInfo();
                    } else {
                        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                        logger.log(Level.WARNING, "Robj_interface_PortStatisticInfo2_IN returned null");
                        statsArray = new Robj_interface_PortStatisticInfo[]{};
                    }
                    for (Robj_interface_PortStatisticInfo stats : statsArray) {
                        if (retIter.isDone()) {
                            break block16;
                        }
                        PortStats statObj = new PortStats(device.getSerialNumber(), stats);
                        retIter.add((Object)statObj);
                    }
                    break block16;
                }
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.log(Level.SEVERE, "No ports on {0}, not stats info available", rmiObj);
            }
            catch (WBEMException we) {
                retIter.setException(we);
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                WBEMException we = t instanceof WBEMException ? (WBEMException)t : new WBEMException(1, t.toString() + " getting FCPort statistics", null, t);
                retIter.setException(we);
            }
            finally {
                if (null != retIter && !retIter.isDone()) {
                    retIter.done();
                }
            }
        }
    }

    public PortStats(FCPort port) throws WBEMException, RemoteException, SANRmiException {
        this(port.getSerialNumber(), port.getPort());
        this.getStatsInfo();
    }

    private PortStats(String serialNum, Robj_interface_PortStatisticInfo stats) {
        this(serialNum, stats.getSPort());
        this.mTransRate = new UnsignedInteger64(BigInteger.valueOf(stats.getTotalTransRate()));
        this.mIOs = new UnsignedInteger64(BigInteger.valueOf(stats.getTotalIO()));
        Calendar cal = Calendar.getInstance();
        cal.setTime(stats.getTargetTime());
        this.mTargetTime = new CIMDateTimeAbsolute(cal);
        this.mTotalIOTime = ProviderConstants.UINT64_ZED;
        if (checkEXProperty) {
            try {
                Robj_interface_PortStatisticInfoEx t = (Robj_interface_PortStatisticInfoEx)stats;
                this.mTotalIOTime = new UnsignedInteger64(BigInteger.valueOf(t.getTotalIOTime()));
            }
            catch (Throwable t) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                logger.log(Level.SEVERE, "Error getting data from PortStatisticInfoEx cast, total IO Time is unavailable", t);
                checkEXProperty = false;
            }
        }
    }

    private PortStats(String serialNumber, short portID) {
        this.serialNumber = serialNumber;
        this.portID = portID;
        this.mTransRate = null;
        this.mIOs = null;
        this.mTargetTime = null;
    }

    public UnsignedInteger64 getIOs() {
        return this.mIOs;
    }

    public short getPortID() {
        return this.portID;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    private void getStatsInfo() throws WBEMException, RemoteException, SANRmiException {
        CloseableAddableIterator statIter = new CloseableAddableIterator();
        PortStats.getIndividualPortStats(RMIObjectMapping.getRMIObjectMapping(this.getSerialNumber()), (CloseableAddableIterator<PortStats>)statIter);
        BigInteger ios = BigInteger.ZERO;
        BigInteger transRate = BigInteger.ZERO;
        CIMDateTime maxTime = null;
        while (statIter.hasNext()) {
            PortStats stats = (PortStats)statIter.next();
            if (-1 != this.getPortID() && this.getPortID() != stats.getPortID()) continue;
            ios = ios.add(null != stats.getIOs() ? stats.getIOs().bigIntegerValue() : BigInteger.ZERO);
            transRate = transRate.add(null != stats.getTransRate() ? stats.getTransRate().bigIntegerValue() : BigInteger.ZERO);
            CIMDateTime statsTime = stats.getTargetTime();
            if (null == maxTime) {
                maxTime = statsTime;
                continue;
            }
            if (maxTime.compareTo((Object)statsTime) <= 0) continue;
            maxTime = statsTime;
        }
        this.mIOs = new UnsignedInteger64(ios);
        this.mTransRate = new UnsignedInteger64(transRate);
        this.mTargetTime = maxTime;
    }

    public CIMDateTime getTargetTime() {
        return this.mTargetTime;
    }

    public UnsignedInteger64 getTotalIOTime() {
        return this.mTotalIOTime;
    }

    public UnsignedInteger64 getTransRate() {
        return this.mTransRate;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PortStats [portID=");
        builder.append(this.portID);
        builder.append(", mIOs=");
        builder.append(this.mIOs);
        builder.append(", mTransRate=");
        builder.append(this.mTransRate);
        builder.append(", mTotalIOTime=");
        builder.append(this.mTotalIOTime);
        builder.append(", mTargetTime=");
        builder.append(this.mTargetTime);
        builder.append(", serialNumber=");
        builder.append(this.serialNumber);
        builder.append("]");
        return builder.toString();
    }
}

