/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger64;
import javax.wbem.provider.ProviderHandle;

public class PrimordialPoolIndicationThread
extends Thread {
    protected static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    private boolean mStop;
    private final List<CIMInstance> mPrevInsts;
    private final StoragePoolInstrumentation mInstrumentation;
    private final ProviderHandle mHandle;
    private final String mClassName;

    public PrimordialPoolIndicationThread(StoragePoolInstrumentation inst, ProviderHandle pHandle, String pClassName) {
        super(pClassName + " modify check thread");
        this.setDaemon(true);
        this.mClassName = pClassName;
        this.mHandle = pHandle;
        this.mInstrumentation = inst;
        this.mStop = false;
        this.mPrevInsts = new ArrayList<CIMInstance>();
    }

    private void getAllPrimordialPools() {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StoragePoolPrimordial", null, null);
        for (RMIObjectMapping device : devices) {
            try {
                CIMInstance prev = this.mInstrumentation.generateInstance(op, null, device.getRMIObject());
                this.mPrevInsts.add(prev);
            }
            catch (Throwable e) {
                mLogger.log(Level.SEVERE, "Caught exception trying to get primordial pool from " + device, e);
            }
        }
    }

    public void performCheck() {
        ArrayList<CIMInstance> changed = new ArrayList<CIMInstance>();
        Iterator<CIMInstance> prevInsts = this.mPrevInsts.iterator();
        while (prevInsts.hasNext() && !this.shouldStopThread()) {
            CIMInstance prev = prevInsts.next();
            try {
                CIMObjectPath op = new CIMObjectPath(prev.getObjectPath().getScheme(), prev.getObjectPath().getHost(), prev.getObjectPath().getPort(), ProviderLibs.getImplementationNamespace(), this.mClassName, null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(prev.getObjectPath(), "InstanceID");
                UnsignedInteger64 oldSize = (UnsignedInteger64)prev.getPropertyValue("TotalManagedSpace");
                CIMInstance cur = this.mInstrumentation.generateInstance(op, null, device.getRMIObject());
                UnsignedInteger64 curSize = (UnsignedInteger64)cur.getPropertyValue("TotalManagedSpace");
                if (curSize.longValue() == oldSize.longValue()) continue;
                prevInsts.remove();
                changed.add(cur);
                IndicationHelper helper = new IndicationHelper(this.mHandle);
                CIMInstance ind = helper.createInstModificationInstance(cur, prev);
                this.mHandle.deliverEvent(ind, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Unexpected exception checking for HITACHI_ImportedStoragePoolPrimordial", t);
            }
        }
        this.mPrevInsts.addAll(changed);
    }

    @Override
    public void run() {
        this.getAllPrimordialPools();
        do {
            try {
                Thread.sleep(ProviderProperties.getVersionCheckIntervalSeconds() * 1000);
                if (this.shouldStopThread()) continue;
                this.performCheck();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.shouldStopThread());
    }

    public boolean shouldStopThread() {
        if (!this.mStop && HitachiCacheMangerService.isShuttingDown()) {
            this.mStop = true;
        }
        return this.mStop;
    }

    public void stopThread() {
        this.mStop = true;
    }
}

