/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DKStatusInfo;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.GoalStorageSettingValues;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PGInfo;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderProperties;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.common.VirtualLDEV;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.CreateModifyVolumeLabel;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import java.io.Serializable;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.CloseableIterator;
import javax.wbem.WBEMException;
import javax.wbem.client.EnumerateResponse;
import javax.wbem.provider.ProviderHandle;
import sanproject.common.Robj_interface_ChangeDataInt;
import sanproject.common.Robj_interface_ChangeDataObject;
import sanproject.common.Robj_interface_ChangeDataOneLine;
import sanproject.common.Robj_interface_ChangeDataString;
import sanproject.common.Robj_interface_DISKgetDKCStatusInfo;
import sanproject.common.Robj_interface_DISKgetDKUStatusInfo;
import sanproject.common.Robj_interface_ODGDgetGuardRetention;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiPortAttributeInfoDetail;
import sanproject.common.Robj_interface_RJiSSIDInfo;
import sanproject.common.Robj_interface_RJiSSIDInfoDetail;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public final class ProviderLibs {
    private static LinkedList<Robj_interface_RJiSSIDInfo> ssidInfoList = new LinkedList();
    private static Hashtable<Integer, String> emulationID = null;
    private static volatile Hashtable<String, Integer> emulationType = null;
    private static Hashtable<Integer, ArrayList<String>> e_TypeGroupData = null;
    private static final String IMP_NAMESPACE = "root/hitachi/smis";
    private static final String INTEROP_NAMESPACE = "interop";
    private static volatile Hashtable<Integer, String> raidLevel = null;
    private static final String RAIDLEVEL0 = "RAID0";
    private static final String RAIDLEVEL1 = "RAID1";
    private static final String RAIDLEVEL10 = "RAID10";
    private static final String RAIDLEVEL3 = "RAID3";
    private static final String RAIDLEVEL5 = "RAID5";
    private static final String RAIDLEVEL6 = "RAID6";
    private static volatile Hashtable<Integer, String> fibreAddress = null;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    public static final String NORMAL_VOLUMEDIVISORSIZE_VAL = "1048576";

    public static final void addKeysToProperties(CIMProperty<?>[] keys, List<CIMProperty<?>> props) {
        for (CIMProperty<?> prop : keys) {
            props.add(prop);
        }
    }

    public static <T> HashSet<T> arrayToSet(T[] objArray) {
        HashSet<T> ret = new HashSet<T>();
        for (T obj : objArray) {
            ret.add(obj);
        }
        return ret;
    }

    public static UnsignedInteger64 calcCTPRMS4Snapshot(ThinPool tp, boolean isPoolRMS) throws WBEMException {
        BigInteger tRet;
        RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(tp.getSerialNumber());
        RMIObjectCache rmiObj = mapping.getRMIObject();
        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
        SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, tp.getPoolID(), true);
        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
        long numVols = pairDataList.size();
        pairDataList = null;
        long tms = tp.getPoolCapaAsBytes();
        long tus = tp.getPoolUsed() * 1024L * 1024L;
        if (numVols > 0L) {
            tus = tus / numVols * numVols;
        }
        if (isPoolRMS) {
            long rms = tms - tus;
            tRet = BigInteger.valueOf(rms);
        } else {
            long tVal = numVols > 0L ? tus / numVols : 0L;
            tRet = BigInteger.valueOf(tVal);
        }
        UnsignedInteger64 ret = new UnsignedInteger64(tRet);
        return ret;
    }

    public static PortandHostGroupInfo checkForPortNHostGrp(short ctrID, LUPathObject luPath) throws WBEMException {
        PortandHostGroupInfo pghi = null;
        for (int numTries = 0; null == pghi && numTries < 6; ++numTries) {
            if (numTries > 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            pghi = PortandHostGroupInfo.find(luPath.getSerialNumber(), null, -1 == ctrID ? null : Short.toString(ctrID), Short.toString(luPath.getSPort()), Short.toString(luPath.getSHostGrp()), null, false, null);
        }
        if (null == pghi) {
            throw new WBEMException("Could not find PortAndHostGroup usig: " + luPath);
        }
        return pghi;
    }

    public static List<String> CheckModifiedProperties(CIMInstance currentInst, CIMInstance modifiedInst, String[] propertyList, String[] allowed2BeModified, List<String> invalidChangedProps) throws WBEMException {
        List<Object> allowed;
        ArrayList<String> changed = new ArrayList<String>();
        List<Object> list = allowed = null == allowed2BeModified ? Collections.emptyList() : Arrays.asList(allowed2BeModified);
        if (null != currentInst && null != modifiedInst) {
            for (CIMProperty cProp : currentInst.getProperties()) {
                boolean isValEqual;
                Object mPropVal = modifiedInst.getPropertyValue(cProp.getName());
                if (mPropVal == null) continue;
                if (cProp.getDataType().isArray()) {
                    Object[] cPropArr = (Object[])cProp.getValue();
                    Object[] mPropArr = (Object[])mPropVal;
                    if (null != cPropArr && cPropArr.length > 1 && mPropArr.length > 1) {
                        Arrays.sort(cPropArr);
                        Arrays.sort(mPropArr);
                    }
                    isValEqual = Arrays.equals(cPropArr, mPropArr);
                    continue;
                }
                Object cPropVal = cProp.getValue();
                isValEqual = null == cPropVal ? true : mPropVal.equals(cPropVal);
                if (isValEqual) continue;
                if (!cProp.isKey()) {
                    changed.add(cProp.getName());
                    continue;
                }
                throw new WBEMException(4, "\"" + cProp + "\" is a key and can not be modified.");
            }
            if (0 != allowed.size()) {
                for (String changedProp : changed) {
                    boolean matched = false;
                    for (int x = 0; x < allowed.size() && !matched; ++x) {
                        String allowedProp = (String)allowed.get(x);
                        if (!allowedProp.equalsIgnoreCase(changedProp)) continue;
                        matched = true;
                    }
                    if (matched) continue;
                    if (null != invalidChangedProps) {
                        invalidChangedProps.add(changedProp);
                        continue;
                    }
                    throw new WBEMException(4, "\"" + changedProp + "\" can not be modified");
                }
                if (null != invalidChangedProps && 0 != invalidChangedProps.size()) {
                    throw new WBEMException(4, invalidChangedProps + " can not be modified");
                }
            }
        } else {
            throw new WBEMException(1, "Instances can not be null, current: " + currentInst + ", modified: " + modifiedInst);
        }
        return changed;
    }

    public static boolean checkSettingGoal(CIMObjectPath goal, ChassisArrayGroup target, ProviderHandle pHandle) {
        return ProviderLibs.checkSettingGoal(goal, target.getRaidLevel(), pHandle);
    }

    public static boolean checkSettingGoal(CIMObjectPath goal, DeviceNumber dn, ProviderHandle pHandle) {
        return ProviderLibs.checkSettingGoal(goal, dn.getRaidLevel(), pHandle);
    }

    public static boolean checkSettingGoal(CIMObjectPath goal, String targetRaidLevel, ProviderHandle pHandle) {
        boolean ret = false;
        if (goal == null) {
            ret = true;
        } else {
            try {
                GoalStorageSettingValues theGoal = new GoalStorageSettingValues(goal, pHandle);
                UnsignedInteger16 u16Val = new UnsignedInteger16(ProviderLibs.getDataRedudancy(targetRaidLevel));
                if (theGoal.checkDataRedundancy(u16Val)) {
                    if (theGoal.checkDeltaReservation(ProviderConstants.UINT8_100)) {
                        u16Val = new UnsignedInteger16(ProviderLibs.getExtentStripeLen(targetRaidLevel));
                        if (theGoal.checkExtentStripeLength(u16Val)) {
                            u16Val = new UnsignedInteger16(ProviderLibs.getPackageRedudancy(targetRaidLevel));
                            if (theGoal.checkPackageRedundancy(u16Val)) {
                                u16Val = ProviderLibs.getParityLayout(targetRaidLevel);
                                if (theGoal.checkParityLayout(u16Val)) {
                                    ret = true;
                                } else {
                                    mLogger.log(Level.INFO, "ParityLayout invalid, target: {0}", new Object[]{u16Val});
                                }
                            } else {
                                mLogger.log(Level.INFO, "PackageRedundancy invalid, target: {0}", new Object[]{u16Val});
                            }
                        } else {
                            mLogger.log(Level.INFO, "ExtentStripLength invalid, target: {0}", new Object[]{u16Val});
                        }
                    } else {
                        mLogger.log(Level.INFO, "DeltaReservation invalid, target: {0}", new Object[]{ProviderConstants.UINT8_100});
                    }
                } else {
                    mLogger.log(Level.INFO, "DataRedundancy invalid, target: {0}", new Object[]{u16Val});
                }
            }
            catch (WBEMException e) {
                mLogger.log(Level.SEVERE, "Goal is not valid: " + goal + " error: " + (Object)((Object)e), e);
            }
        }
        return ret;
    }

    public static boolean checkSettingGoal(CIMObjectPath goal, ThinPool target, ProviderHandle pHandle) {
        return ProviderLibs.checkSettingGoal(goal, target.getRAIDLevel(), pHandle);
    }

    public static String collapseSpaces(String pString) {
        return pString.replaceAll("\\s+", " ").trim();
    }

    public static UnsignedInteger16 consistsOf(RMIObjectCache rmiObj, int fb4, int pg) {
        UnsignedInteger16 ret = null;
        boolean internal = false;
        boolean external = false;
        PGInfo element = null;
        try {
            element = PGInfo.find(rmiObj, fb4, pg);
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Error finding PGinfo for consistsOf", e);
        }
        if (element != null && element.getFB4() == fb4 && element.getPG() == pg) {
            if (element.isExternalVolume() || ProviderLibs.isFICONDM(fb4)) {
                external = true;
            } else {
                internal = true;
            }
        }
        ret = internal && external ? ProviderConstants.UINT16_THREE : (internal ? ProviderConstants.UINT16_ONE : (external ? ProviderConstants.UINT16_TWO : ProviderConstants.UINT16_ZED));
        return ret;
    }

    public static UnsignedInteger16 consistsOf(String serialNumber, int fb4, int pg) throws WBEMException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNumber).getRMIObject();
        return ProviderLibs.consistsOf(rmiObj, fb4, pg);
    }

    public static final String createInstanceID(String prefix, String sysName, Integer fb4, BigInteger agOrDevNum, String postFix) throws WBEMException {
        StringBuilder ret = new StringBuilder();
        if (prefix != null) {
            ret.append(prefix);
            ret.append(".");
        }
        if (sysName == null) {
            throw new WBEMException(1, "InstanceID requires a system name (model.serial).");
        }
        ret.append(sysName);
        ret.append(".");
        if (fb4 != null) {
            ret.append(fb4);
            ret.append(".");
        }
        if (agOrDevNum == null) {
            throw new WBEMException(1, "InstanceID requires Sequence, Array Group or Device number.");
        }
        ret.append(agOrDevNum);
        if (postFix != null) {
            ret.append(".");
            ret.append(postFix);
        }
        return ret.toString();
    }

    public static final String createInstanceID(String prefix, String sysName, Integer fb4, Integer seqNumOrArrayGrp, String postFix) throws WBEMException {
        return ProviderLibs.createInstanceID(prefix, sysName, fb4, seqNumOrArrayGrp == null ? null : BigInteger.valueOf(seqNumOrArrayGrp.intValue()), postFix);
    }

    private static int createSSID(Robj_interface_RJiSSIDInfo[] ssIDInfos) {
        int MIN_SSID = 4;
        int MAX_SSID = 65534;
        ArrayList<Integer> usedSSIDList = new ArrayList<Integer>();
        for (Robj_interface_RJiSSIDInfo ssIDinfo : ssIDInfos) {
            usedSSIDList.add(ssIDinfo.getISSID());
        }
        Collections.sort(usedSSIDList);
        int ssid = 4;
        for (Integer usedSSID : usedSSIDList) {
            if (ssid != usedSSID) {
                return ssid;
            }
            ++ssid;
        }
        if (ssid <= 65534) {
            return ssid;
        }
        return -1;
    }

    public static short[] dencodeCULDEVNumber(int value) {
        short cu = -1;
        short ldev = -1;
        short[] ret = new short[]{cu, ldev};
        cu = (short)(value >= 256 ? value / 256 : 0);
        ldev = (short)(value - cu);
        return ret;
    }

    public static Robj_interface_RJiLDEVIndex[] deviceNumbersToLDEVIndexArray(RMIObjectCache rmiObj, List<? extends BaseDeviceNumber> dns) throws WBEMException, SANRmiException, RemoteException {
        Robj_interface_RJiLDEVIndex[] ldevs = null;
        if (null != dns) {
            ldevs = new Robj_interface_RJiLDEVIndex[dns.size()];
            int i = 0;
            for (BaseDeviceNumber baseDeviceNumber : dns) {
                Robj_interface_RJiLDEVIndex ldev = (Robj_interface_RJiLDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
                ldev.setLDEVIndex(baseDeviceNumber.getLdkc(), baseDeviceNumber.getCu(), baseDeviceNumber.getLdev());
                ldevs[i++] = ldev;
            }
        }
        if (null == ldevs) {
            ldevs = new Robj_interface_RJiLDEVIndex[]{};
        }
        return ldevs;
    }

    private static List<Robj_interface_ChangeDataObject> doGetDataChangeTable(String tableName) throws RemoteException, GetRmiException, WBEMException {
        ArrayList<Robj_interface_ChangeDataObject> ret = new ArrayList<Robj_interface_ChangeDataObject>();
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping device : devices) {
            RMIObjectCache rmiObj = device.getRMIObject();
            ArrayList<String> table = new ArrayList<String>();
            table.add(tableName);
            ArrayList<?> retArray = rmiObj.getDataChangeTable(table);
            Robj_interface_ChangeDataObject[] datas = (Robj_interface_ChangeDataObject[])retArray.get(0);
            ret.addAll(Arrays.asList(datas));
        }
        return ret;
    }

    public static int encodeCULDEVNumber(short cu, short ldev) {
        return cu * 256 + ldev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enumerateCIMOMInstances(CIMObjectPath opNS, CloseableAddableIterator<CIMInstance> retIter, ProviderHandle cimomHandle) throws WBEMException {
        try {
            EnumerateResponse response = cimomHandle.enumerateInstances(opNS, null, null, null, null, false, ProviderConstants.UINT32_100);
            boolean gotFirst = false;
            while (!gotFirst || !response.isEnd()) {
                if (gotFirst) {
                    response = cimomHandle.getInstancesWithPath(opNS, response.getContext(), ProviderConstants.UINT32_100);
                } else {
                    gotFirst = true;
                }
                CloseableIterator iter = response.getResponses();
                while (iter.hasNext()) {
                    retIter.add(iter.next());
                }
            }
        }
        finally {
            if (!retIter.isClosed() && !retIter.isDone()) {
                retIter.done();
            }
        }
    }

    public static String generateVPD83Type3(BaseDeviceNumber rDN, VirtualLDEV vDN) throws WBEMException {
        String betweenVandY;
        String betweenUandV;
        int u;
        BaseDeviceNumber dn = null == vDN ? rDN : vDN.getVirtLDEVInfo();
        String serialVal = dn.getSerialNumber();
        String model = null == vDN ? "HM800" : vDN.getVModelName();
        Integer sn5 = serialVal.length() <= 5 ? Integer.valueOf(Integer.parseInt(serialVal)) : Integer.valueOf(Integer.parseInt(serialVal.substring(serialVal.length() - 5)));
        String yyyyy = "Raid800".equalsIgnoreCase(model) || "HM700".equalsIgnoreCase(model) || model.startsWith("HM800") ? String.format("3%05X", sn5) : String.format("%06X", sn5);
        String vvvv = yyyyy.substring(2);
        String zzzz = String.format("%02X%02X", dn.getCu(), dn.getLdev());
        StringBuilder builder = new StringBuilder("60060E80");
        if (1 <= sn5 && sn5 <= 65535) {
            u = 1;
        } else if (65535 <= sn5 && sn5 <= 99999) {
            u = 2;
        } else {
            throw new WBEMException("Serial ID is invalid: " + sn5);
        }
        switch (model) {
            case "HM800 (S Model)": 
            case "HM800 (M Model)": 
            case "HM800 (H Model)": 
            case "HM800": {
                betweenUandV = "2";
                betweenVandY = "00504";
                yyyyy = yyyyy.substring(1);
                break;
            }
            case "Raid800": {
                betweenUandV = "7";
                betweenVandY = String.format("00%02X3", dn.getLdkc());
                yyyyy = yyyyy.substring(1);
                --u;
                break;
            }
            case "HM700": {
                betweenUandV = "3";
                betweenVandY = "00502";
                yyyyy = yyyyy.substring(1);
                break;
            }
            case "Raid700": {
                betweenUandV = "6";
                betweenVandY = String.format("00%02X", dn.getLdkc());
                --u;
                break;
            }
            case "Raid600": {
                betweenUandV = "5";
                betweenVandY = String.format("00%02X", dn.getLdkc());
                --u;
                break;
            }
            case "Raid500": {
                betweenUandV = "4";
                betweenVandY = String.format("00%02X", dn.getLdkc());
                --u;
                break;
            }
            default: {
                mLogger.log(Level.WARNING, "Model, {0}, not recognized - defaulting to {1}", new Object[]{model, "Raid800"});
                betweenUandV = "7";
                betweenVandY = String.format("00%02X3", dn.getLdkc());
                yyyyy = yyyyy.substring(1);
            }
        }
        builder.append(u);
        builder.append(betweenUandV);
        builder.append(vvvv);
        builder.append(betweenVandY);
        builder.append(yyyyy);
        builder.append("0000");
        builder.append(zzzz);
        if (builder.length() != 32) {
            throw new WBEMException("Failed to create valid VPD83Type3 value: " + builder.toString() + ", serial: " + serialVal + ", DN: " + dn);
        }
        return builder.toString();
    }

    public static String getAllButEndString(String pString, char pSeparator) {
        int index;
        if (null != pString && (index = pString.lastIndexOf(pSeparator)) > 0 && index < pString.length() - 1) {
            return pString.substring(0, index);
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ChassisArrayGroup getCAGFromOp(CIMObjectPath op) throws WBEMException {
        ChassisArrayGroup cag = null;
        CIMProperty idProp = op.getKey("InstanceID");
        if (idProp != null) {
            String instanceID = (String)idProp.getValue();
            if (instanceID != null) {
                RMIObjectMapping mapping;
                if (instanceID.contains("ImportedPrimordial")) return null;
                Integer[] ints = ProviderLibs.getInstanceIDInts(instanceID);
                int chassis = ints[0];
                int ag = ints[1];
                String serial = ProviderLibs.getSerialFromString(instanceID, ".", 1);
                if (null != serial && null != (mapping = RMIObjectMapping.getRMIObjectMapping(serial))) {
                    cag = ChassisArrayGroup.find(mapping.getRMIObject(), null, chassis, ag, false);
                    if (cag != null) return cag;
                    mLogger.log(Level.WARNING, "Could not match CAG: {0}", new Object[]{instanceID});
                    return cag;
                } else {
                    mLogger.log(Level.SEVERE, "Serial number is or a device not currently being managed: {0}", new Object[]{op});
                }
                return cag;
            } else {
                mLogger.log(Level.WARNING, "InstanceID is null: {0}", new Object[]{op});
            }
            return cag;
        } else {
            mLogger.log(Level.SEVERE, "Passed in OP doesn't have an InstanceID property: {0}", new Object[]{op});
        }
        return cag;
    }

    public static final Integer[] getChassisAndArrayGroupFromDeviceID(String instID) throws WBEMException {
        Integer[] ret = new Integer[]{-1, -1, -1};
        try {
            int agIdx;
            int fsIdx = instID.lastIndexOf(".");
            int n = agIdx = -1 == fsIdx ? -1 : instID.lastIndexOf(".", fsIdx - 1);
            if (fsIdx == -1 || agIdx == -1) {
                throw new WBEMException(1, "Device ID is not valid: " + instID);
            }
            String fb4Str = instID.substring(0, agIdx);
            Integer chassis = new Integer(fb4Str);
            String agStr = instID.substring(agIdx + 1, fsIdx);
            Integer arrayGroup = new Integer(agStr);
            String fsStr = instID.substring(fsIdx + 1);
            Integer fsIndex = new Integer(fsStr);
            ret[0] = chassis;
            ret[1] = arrayGroup;
            ret[2] = fsIndex;
        }
        catch (NumberFormatException nfe) {
            throw new WBEMException(1, "Failed to convert string (" + instID + ")to Integer", null, (Throwable)nfe);
        }
        return ret;
    }

    public static Integer[] getChassisArrayIDInts(String instID) throws WBEMException {
        Integer[] ret = new Integer[]{-1, -1};
        int fb4Idx = instID.indexOf(".");
        if (fb4Idx != -1) {
            String fb4 = instID.substring(0, fb4Idx);
            int agIdx = instID.indexOf(".", fb4Idx + 1);
            String ag = agIdx != -1 ? instID.substring(fb4Idx + 1, agIdx) : instID.substring(fb4Idx + 1);
            try {
                ret[0] = Integer.valueOf(fb4);
                ret[1] = Integer.valueOf(ag);
            }
            catch (NumberFormatException nfe) {
                throw new WBEMException(1, nfe.toString(), null, (Throwable)nfe);
            }
        }
        return ret;
    }

    public static final int getCompositeStripeLen(String rl) {
        return ProviderLibs.getExtentStripeLen(rl);
    }

    public static String getCUImage(DeviceNumber dn) {
        String cuImage = null;
        switch (dn.getVolumeFlag()) {
            case 1: 
            case 2: {
                cuImage = String.valueOf(dn.getCu());
                break;
            }
            case 3: {
                cuImage = null;
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "Unknown volume flag: {0}", new Object[]{dn.getVolumeFlag()});
            }
        }
        return cuImage;
    }

    private static final Hashtable<String, Integer> getDataChangeTableInt(String tableName) throws WBEMException {
        Hashtable<String, Integer> hash = new Hashtable<String, Integer>(20);
        try {
            List<Robj_interface_ChangeDataObject> datas = ProviderLibs.doGetDataChangeTable(tableName);
            for (Robj_interface_ChangeDataObject t : datas) {
                Robj_interface_ChangeDataInt data = (Robj_interface_ChangeDataInt)t;
                hash.put(data.getStrMibData(), new Integer(data.getNChangeData1()));
            }
        }
        catch (RemoteException re) {
            throw new WBEMException(1, "Caught Remote Exception: " + re, null, (Throwable)re);
        }
        catch (GetRmiException gre) {
            throw new WBEMException(1, "Caught Get RMI Exception: " + gre.getErrMsgEn(), null, (Throwable)gre);
        }
        catch (WBEMException we) {
            throw we;
        }
        return hash;
    }

    private static final Hashtable<Integer, String> getDataChangeTableStr(String tableName) throws WBEMException {
        Hashtable<Integer, String> hash = null;
        try {
            List<Robj_interface_ChangeDataObject> datas = ProviderLibs.doGetDataChangeTable(tableName);
            hash = new Hashtable<Integer, String>(datas.size());
            for (Robj_interface_ChangeDataObject t : datas) {
                Robj_interface_ChangeDataString data = (Robj_interface_ChangeDataString)t;
                hash.put(data.getNMibData(), data.getStrChangeData1());
            }
        }
        catch (RemoteException re) {
            throw new WBEMException(1, "Caught Remote Exception: " + re, null, (Throwable)re);
        }
        catch (GetRmiException gre) {
            throw new WBEMException(1, "Caught Get RMI Exception: " + gre.getErrMsgEn(), null, (Throwable)gre);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Caught throwable: " + t, null, t);
        }
        return hash;
    }

    public static final int getDataRedudancy(String rl) {
        int ret = 0;
        switch (ProviderLibs.getRaidLevelFromString(rl)) {
            case RAID0: 
            case UNKNOWN: {
                ret = 1;
                break;
            }
            case RAID1: {
                ret = 2;
                break;
            }
            case RAID5: 
            case RAID6: {
                ret = 1;
                break;
            }
            default: {
                ret = 1;
            }
        }
        return ret;
    }

    public static DeviceNumber getDeviceNumberFromOP(CIMObjectPath op) throws WBEMException {
        DeviceNumber ret;
        String deviceIDKeyVal = (String)op.getKeyValue("DeviceID");
        if (null != deviceIDKeyVal && "HITACHI_StorageVolume".equalsIgnoreCase(op.getObjectName())) {
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(ProviderLibs.getSerialFromString((String)op.getKeyValue("SystemName")));
            ret = DeviceNumber.find(deviceIDKeyVal, true, device.getRMIObject());
        } else {
            ret = null;
        }
        return ret;
    }

    public static String getDNString(Robj_interface_RJiLDEVIndex ldevIndex) {
        String ret = null;
        if (null != ldevIndex) {
            ret = String.valueOf(BaseDeviceNumber.makeUniqueDN(ldevIndex.getSLDKC(), ldevIndex.getSCU(), ldevIndex.getSLDEV()));
        }
        return ret;
    }

    public static String getEmulatedDevice(DeviceNumber dn) {
        String ret = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Hashtable<String, Integer> getEmulationType() throws RemoteException, GetRmiException, WBEMException {
        Hashtable<String, Integer> t = emulationType;
        if (null != t) return t;
        Class<ProviderLibs> clazz = ProviderLibs.class;
        synchronized (ProviderLibs.class) {
            t = emulationType;
            if (null != t) return t;
            emulationType = ProviderLibs.getDataChangeTableInt("Emulationtype");
            return emulationType;
        }
    }

    public static String getEndString(String pString) {
        return ProviderLibs.getEndString(pString, ProviderConstants.ID_SEPERATOR_AS_CHAR);
    }

    public static String getEndString(String pString, char pSeparator) {
        int index;
        if (null != pString && (index = pString.lastIndexOf(pSeparator)) > 0 && index < pString.length() - 1) {
            return pString.substring(index + 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getETypeInfo(RMIObjectCache rmiObj) throws RemoteException, SANRmiException, GetRmiException, WBEMException {
        Class<ProviderLibs> clazz = ProviderLibs.class;
        synchronized (ProviderLibs.class) {
            if (null == e_TypeGroupData) {
                ArrayList<String> table = new ArrayList<String>();
                table.add("e_typegroup");
                ArrayList<?> retArray = rmiObj.getDataChangeTable(table);
                Robj_interface_ChangeDataOneLine[] datas = (Robj_interface_ChangeDataOneLine[])retArray.get(0);
                e_TypeGroupData = new Hashtable();
                for (Robj_interface_ChangeDataOneLine data : datas) {
                    StringTokenizer toker = new StringTokenizer(data.getStrData(), ",");
                    int count = toker.countTokens();
                    ArrayList<String> list = new ArrayList<String>(count);
                    Integer index = Integer.parseInt(toker.nextToken());
                    while (toker.hasMoreTokens()) {
                        String val = toker.nextToken();
                        if (val == null) continue;
                        list.add(val);
                        e_TypeGroupData.put(index, list);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static final int getExtentStripeLen(String rl) {
        int ret = 0;
        int n = -1;
        switch (ProviderLibs.getRaidLevelFromString(rl)) {
            case RAID0: {
                n = ProviderLibs.getNumDisksInRaid(rl);
                ret = n <= 2 ? 2 : n;
                break;
            }
            case RAID1: {
                ret = 1;
                break;
            }
            case RAID5: 
            case RAID6: {
                n = ProviderLibs.getNumDisksInRaid(rl);
                ret = n <= 3 ? 3 : n;
                break;
            }
            default: {
                ret = 1;
            }
        }
        return ret;
    }

    public static UnsignedInteger16 getExtentType(DeviceNumber dn) {
        UnsignedInteger16 extentType = null;
        switch (dn.getVolumeFlag()) {
            case 1: {
                extentType = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 2: {
                extentType = ProviderConstants.UINT16_THREE;
                break;
            }
            case 3: {
                extentType = ProviderConstants.UINT16_TWO;
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "Unknown volume flag: {0}", new Object[]{dn.getVolumeFlag()});
            }
        }
        return extentType;
    }

    public static final Integer[] getFBPGFromDeviceID(String deviceID) throws WBEMException {
        int ag;
        Integer[] FB4AG = ProviderLibs.getInstanceIDInts(deviceID);
        int fb4 = FB4AG[0];
        int pg = ag = FB4AG[1].intValue();
        return new Integer[]{new Integer(fb4), new Integer(pg)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Hashtable<Integer, String> getFibreAddressInfo() throws RemoteException, GetRmiException, WBEMException {
        Hashtable<Integer, String> t = fibreAddress;
        if (null != t) return t;
        Class<ProviderLibs> clazz = ProviderLibs.class;
        synchronized (ProviderLibs.class) {
            t = fibreAddress;
            if (null != t) return t;
            fibreAddress = ProviderLibs.getDataChangeTableStr("fibreaddress");
            return fibreAddress;
        }
    }

    public static Robj_interface_ODGDgetGuardRetention getGuardRetention(RMIObjectCache rmiobj, DeviceNumber deviceNumber) throws Exception {
        if (null != deviceNumber) {
            short ldkc = deviceNumber.getLdkc();
            short cu = deviceNumber.getCu();
            if (0 == ldkc && 255 > cu) {
                int[] cuUndexArray = new int[8];
                int arrayIndex = cu / 32;
                int bitIndex = cu - arrayIndex * 32;
                cuUndexArray[arrayIndex] = 1 << 31 - bitIndex;
                Robj_interface_ODGDgetGuardRetention[] guardRetentions = rmiobj.getGuardRetention((byte)ldkc, cuUndexArray);
                if (guardRetentions.length > 0) {
                    return guardRetentions[0];
                }
            }
        }
        throw new WBEMException(4);
    }

    public static UnsignedInteger16 getHealthState4CAG(String serialNum, int fb4, int pg) {
        UnsignedInteger16 ret = ProviderConstants.UINT16_FIVE;
        ClosableAddableIteratorCB<DeviceNumber> ldevs = new ClosableAddableIteratorCB<DeviceNumber>();
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
            DeviceNumber.getDNs(rmiObj, ldevs, false, true, null, fb4, pg, -1);
            CloseableAddableIterator<DeviceNumber> ldevIter = ldevs.getWrappedCloseableAddableIter();
            while (ldevIter.hasNext() && ProviderConstants.UINT16_FIVE.intValue() == ret.intValue()) {
                DeviceNumber dn = (DeviceNumber)ldevIter.next();
                ret = dn.getHealthState();
            }
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Exception getting volume data", e);
            ret = ProviderConstants.UINT16_ZED;
        }
        return ret;
    }

    public static final String getHexString(byte[] val) {
        String result = "";
        for (byte element : val) {
            result = result + Integer.toString((element & 0xFF) + 256, 16).substring(1).toUpperCase();
        }
        return result;
    }

    public static String[] getIdentifyingDescriptions(DeviceNumber dn) throws WBEMException {
        String[] ret = null;
        switch (dn.getVolumeFlag()) {
            case 1: {
                ret = new String[]{"RawIdentifier"};
                break;
            }
            case 2: {
                ret = new String[]{"CUNumber+DeviceNumber", "RawIdentifier"};
                break;
            }
            case 3: {
                ret = new String[]{"VPD83Type3;NAA", "RawIdentifier"};
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "Unknown volume flag: {0}", new Object[]{dn.getVolumeFlag()});
            }
        }
        return ret;
    }

    public static final String getImplementationNamespace() {
        return IMP_NAMESPACE;
    }

    public static Integer[] getInstanceIDInts(String instID) throws WBEMException {
        Integer[] ret = new Integer[]{-1, -1};
        try {
            int fb4Idx;
            int agIdx = instID.lastIndexOf(".");
            int n = fb4Idx = -1 == agIdx ? -1 : instID.lastIndexOf(".", agIdx - 1);
            if (agIdx == -1 && fb4Idx == -1) {
                throw new WBEMException(1, "Instance ID is not valid: " + instID);
            }
            String fb4 = instID.substring(fb4Idx + 1, agIdx);
            String ag = instID.substring(agIdx + 1);
            ret[0] = Integer.valueOf(fb4);
            ret[1] = Integer.valueOf(ag);
        }
        catch (NumberFormatException nfe) {
            throw new WBEMException(1, "Failed to convert string (" + instID + ")to Integers", null, (Throwable)nfe);
        }
        return ret;
    }

    public static final String getInteropNamespace() {
        return INTEROP_NAMESPACE;
    }

    public static RMIObjectMapping getManagedDeviceFromObjectPath(CIMObjectPath op, String propertyName) throws WBEMException {
        return ProviderLibs.getManagedDeviceFromObjectPath(op, propertyName, ".", 1);
    }

    public static RMIObjectMapping getManagedDeviceFromObjectPath(CIMObjectPath op, String propertyName, String separator, int index) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevicesFromObjectPath(op, propertyName, separator, index);
        if (null != devices && 1 == devices.size()) {
            RMIObjectMapping temp = devices.get(0);
            if (null != temp) {
                return temp;
            }
        } else if (null != devices && devices.size() > 1) {
            throw new WBEMException(6, "Found " + devices.size() + " managed device using '" + propertyName + "' in " + op);
        }
        throw new WBEMException(6, "Could not find any devices using " + propertyName + " in " + op);
    }

    public static List<RMIObjectMapping> getManagedDevices(CIMObjectPath op, String keyName, Map<String, Object> expectedValues) throws WBEMException {
        return ProviderLibs.getManagedDevices(op, keyName, ".", 1, expectedValues, "SystemName", ".", 1);
    }

    public static List<RMIObjectMapping> getManagedDevices(CIMObjectPath op, String keyName, Map<String, Object> expectedValues, String valuesKey) throws WBEMException {
        return ProviderLibs.getManagedDevices(op, keyName, ".", 1, expectedValues, valuesKey, ".", 1);
    }

    public static List<RMIObjectMapping> getManagedDevices(CIMObjectPath op, String keyName, Map<String, Object> expectedValues, String[] values) throws WBEMException {
        String lookUp = null;
        if (null != expectedValues) {
            for (int x = 0; x < values.length && null == lookUp; ++x) {
                if (!expectedValues.containsKey(values[x])) continue;
                lookUp = values[x];
            }
        }
        List<RMIObjectMapping> ret = null != lookUp ? ProviderLibs.getManagedDevices(op, keyName, expectedValues, lookUp) : ProviderLibs.getManagedDevices(op, keyName, expectedValues);
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<RMIObjectMapping> getManagedDevices(CIMObjectPath op, String keyName, String seperator, int index, Map<String, Object> expectedValues, String valuesKey, String valuesSeperator, int valuesIndex) throws WBEMException {
        List<RMIObjectMapping> devices;
        if (null == expectedValues) {
            devices = ProviderLibs.getManagedDevicesFromObjectPath(op, keyName, ".", 1);
        } else {
            String expValue = (String)expectedValues.get(valuesKey);
            if (null == expValue) throw new WBEMException("Provider called with association parmeters, but " + valuesKey + " was not provided: " + expectedValues);
            String serialNum = ProviderLibs.getSerialFromString(expValue, valuesSeperator, valuesIndex);
            RMIObjectMapping mapObj = RMIObjectMapping.getRMIObjectMapping(serialNum);
            if (null == mapObj) throw new WBEMException("Could not find a device with name " + expValue);
            devices = new ArrayList<RMIObjectMapping>(1);
            devices.add(mapObj);
        }
        if (!devices.isEmpty()) return devices;
        throw new WBEMException("No devices to manage.");
    }

    public static List<RMIObjectMapping> getManagedDevicesFromObjectPath(CIMObjectPath op, String propertyName) throws WBEMException {
        return ProviderLibs.getManagedDevicesFromObjectPath(op, propertyName, ".", 1);
    }

    public static List<RMIObjectMapping> getManagedDevicesFromObjectPath(CIMObjectPath op, String propertyName, String separator, int index) throws WBEMException {
        ArrayList<RMIObjectMapping> ret;
        if (null == op || null == propertyName || null == separator) {
            String msg = String.format("Parameter can not be null, op: %s, propertyName: %s, seperator: %s", op, separator, propertyName);
            throw new WBEMException(msg);
        }
        String serial = null;
        CIMProperty cpValue = op.getKey(propertyName);
        if (null != cpValue) {
            String strVal = (String)cpValue.getValue();
            if (null != strVal) {
                serial = ProviderLibs.getSerialFromString(strVal, separator, index);
                if (null == serial) {
                    throw new WBEMException("Property, " + propertyName + " does not have " + index + " seperators ('" + separator + "'): " + strVal);
                }
            } else {
                throw new WBEMException("Property, " + propertyName + " is null in the passed in objectpath: " + op);
            }
        }
        if (null == serial) {
            Collection<RMIObjectMapping> devs = RMIObjectMapping.getAllRMIObjectMappings();
            ret = new ArrayList<RMIObjectMapping>(devs);
        } else {
            RMIObjectMapping map = RMIObjectMapping.getRMIObjectMapping(serial);
            ret = new ArrayList(1);
            ret.add(map);
        }
        return ret;
    }

    public static UnsignedInteger16 getNameFormat(byte volFlag) {
        UnsignedInteger16 ret = null;
        switch (volFlag) {
            case 1: {
                ret = ProviderConstants.UINT16_ONE;
                break;
            }
            case 2: 
            case 3: {
                ret = ProviderConstants.UINT16_ELEVEN;
            }
        }
        return ret;
    }

    public static UnsignedInteger16 getNameNameSpace(RMIObjectMapping mapping, byte volFlag) {
        UnsignedInteger16 ret = null;
        switch (volFlag) {
            case 1: {
                ret = ProviderConstants.UINT16_ONE;
                break;
            }
            case 2: 
            case 3: {
                ret = mapping.isHitachiSystem() ? ProviderConstants.UINT16_FOUR : ProviderConstants.UINT16_ONE;
            }
        }
        return ret;
    }

    public static final int getNumDisksInRaid(String str) {
        int ret = 0;
        if (str.startsWith("RAID")) {
            int parenIdx = str.indexOf("(");
            int dIdx = str.indexOf("D+");
            int closeParenIdx = str.indexOf(")");
            if (parenIdx != -1 && dIdx != -1 && closeParenIdx != -1 && parenIdx < dIdx && dIdx < closeParenIdx) {
                String dStr = str.substring(parenIdx + 1, dIdx);
                String pStr = str.substring(dIdx + 2, closeParenIdx - 1);
                try {
                    int d = Integer.parseInt(dStr);
                    int p = Integer.parseInt(pStr);
                    ret = d + p;
                }
                catch (NumberFormatException nfe) {
                    mLogger.log(Level.SEVERE, "parseInt failed for: {0}" + str, nfe);
                }
            } else {
                mLogger.log(Level.SEVERE, "string ({0}) does not start with RAID", new Object[]{str});
            }
        }
        return ret;
    }

    public static String[] getOtherIdentifyingInfo(DeviceNumber dn, VirtualLDEV vDN, String volName) throws WBEMException {
        String[] ret = null;
        BaseDeviceNumber bdn = null == vDN ? dn : vDN.getVirtLDEVInfo();
        switch (dn.getVolumeFlag()) {
            case 1: {
                ret = new String[]{String.valueOf(bdn.getCu()) + "+" + bdn.getDNAsString()};
                break;
            }
            case 2: {
                ret = new String[]{String.valueOf(bdn.getCu()) + "+" + bdn.getDNAsString(), volName};
                break;
            }
            case 3: {
                ret = new String[]{ProviderLibs.generateVPD83Type3(dn, vDN), volName};
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "Unknown volume flag: {0}", new Object[]{dn.getVolumeFlag()});
            }
        }
        return ret;
    }

    public static String getOtherNameFormat(DeviceNumber dn) {
        String ret = null;
        switch (dn.getVolumeFlag()) {
            case 1: {
                ret = "CUNumber+DeviceNumber";
                break;
            }
            case 2: {
                ret = null;
                break;
            }
            case 3: {
                ret = "NAA";
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "Unknown volume flag: {0}", new Object[]{dn.getVolumeFlag()});
            }
        }
        return ret;
    }

    public static int getPackageRedudancy(String rl) {
        int ret = 0;
        switch (ProviderLibs.getRaidLevelFromString(rl)) {
            case RAID0: 
            case UNKNOWN: {
                ret = 0;
                break;
            }
            case RAID1: 
            case RAID5: {
                ret = 1;
                break;
            }
            case RAID6: {
                ret = 2;
                break;
            }
            default: {
                ret = 0;
            }
        }
        return ret;
    }

    public static UnsignedInteger16 getParityLayout(String rl) {
        UnsignedInteger16 ret = null;
        switch (ProviderLibs.getRaidLevelFromString(rl)) {
            case RAID0: 
            case RAID1: {
                ret = null;
                break;
            }
            case RAID5: 
            case RAID6: {
                ret = ProviderConstants.UINT16_TWO;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    public static short[] getPortAndHostFromProtocolController(CIMObjectPath pProtocolController) {
        String cpvDeviceID;
        short[] ret = null;
        if (null != pProtocolController && null != (cpvDeviceID = (String)pProtocolController.getKeyValue("DeviceID"))) {
            String portID = ProviderLibs.getAllButEndString(cpvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            String hostGroup = ProviderLibs.getEndString(cpvDeviceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            try {
                Short sPortID = new Short(portID);
                Short sHostGroup = new Short(hostGroup);
                ret = new short[]{sPortID, sHostGroup};
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    public static Hashtable<Short, Byte> getPortKindHash(RMIObjectCache rmiObj) throws WBEMException {
        Hashtable<Short, Byte> ret = new Hashtable<Short, Byte>();
        try {
            Robj_interface_RJiPortAttributeInfoDetail[] infos;
            for (Robj_interface_RJiPortAttributeInfoDetail info : infos = rmiObj.getPortAttributeInfoDetail()) {
                byte portKind = info.getByPortKind();
                short sPort = info.getSPort();
                ret.put(new Short(sPort), new Byte(portKind));
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    public static Integer getRAIDLevel(RMIObjectCache rmiobj, int fb4, int pg) throws WBEMException {
        Integer ret = null;
        PGInfo details = PGInfo.find(rmiobj, fb4, pg);
        if (details == null) {
            throw new WBEMException("Unable to locate details for PGinfo " + fb4 + ":" + pg);
        }
        ret = new Integer(details.getRaidLevel());
        return ret;
    }

    public static final String getRaidLevelAsString(RMIObjectCache rmiobj, Integer rlIntVal) throws RemoteException, GetRmiException, WBEMException {
        String ret = null;
        Hashtable<Integer, String> supRaids = ProviderLibs.getSupportedRaidLevels();
        ret = supRaids.get(rlIntVal);
        if (ret == null || !ret.startsWith("RAID")) {
            ret = "UNKNOWN";
        }
        return ret;
    }

    public static String getRaidLevelByNumDisks(int numDisks) {
        String ret;
        switch (numDisks) {
            case 4: {
                ret = "RAID5(3D+1P)";
                break;
            }
            case 5: {
                ret = "RAID5(4D+1P)";
                break;
            }
            case 7: {
                ret = "RAID5(6D+1P)";
                break;
            }
            case 8: {
                ret = "RAID6(6D+2P)";
                break;
            }
            case 14: {
                ret = "RAID6(12D+2P)";
                break;
            }
            case 16: {
                ret = "RAID6(14D+2P)";
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "Number of disks specified, {0}, does not match a supported RAID level ", numDisks);
                ret = null;
            }
        }
        return ret;
    }

    public static final ProviderConstants.RAID_Level getRaidLevelFromString(String raidLvlStr) {
        ProviderConstants.RAID_Level ret = ProviderConstants.RAID_Level.UNKNOWN;
        if (raidLvlStr.startsWith(RAIDLEVEL0)) {
            ret = raidLvlStr.compareToIgnoreCase(ProviderConstants.RAID_Level.RAID0_1.toString()) == 0 ? ProviderConstants.RAID_Level.RAID0_1 : ProviderConstants.RAID_Level.RAID0;
        } else if (raidLvlStr.startsWith(RAIDLEVEL1)) {
            ret = raidLvlStr.compareToIgnoreCase(ProviderConstants.RAID_Level.RAID1_0.toString()) == 0 ? ProviderConstants.RAID_Level.RAID1_0 : (raidLvlStr.compareToIgnoreCase(RAIDLEVEL10) == 0 ? ProviderConstants.RAID_Level.RAID10 : ProviderConstants.RAID_Level.RAID1);
        } else if (raidLvlStr.startsWith(RAIDLEVEL3)) {
            ret = ProviderConstants.RAID_Level.RAID3;
        } else if (raidLvlStr.startsWith(RAIDLEVEL5)) {
            ret = ProviderConstants.RAID_Level.RAID5;
        } else if (raidLvlStr.startsWith(RAIDLEVEL6)) {
            ret = ProviderConstants.RAID_Level.RAID6;
        }
        return ret;
    }

    public static int getRaidLevelValue(String raidLvl, int numDisks) {
        int ret = -1;
        if (null != raidLvl) {
            int numDisksReq = ProviderLibs.getNumDisksInRaid(raidLvl);
            if (numDisks != numDisksReq) {
                mLogger.log(Level.SEVERE, "{0} disks specified but {1} requires {2} disks", new Object[]{numDisks, raidLvl, numDisksReq});
                ret = -1;
            } else {
                switch (raidLvl) {
                    case "RAID1(2D+2D)": {
                        ret = 8194;
                        break;
                    }
                    case "RAID5(3D+1P)": {
                        ret = 8197;
                        break;
                    }
                    case "RAID5(4D+1P)": {
                        ret = 8202;
                        break;
                    }
                    case "RAID5(6D+1P)": {
                        ret = 8196;
                        break;
                    }
                    case "RAID5(7D+1P)": {
                        ret = 8198;
                        break;
                    }
                    case "RAID6(6D+2P)": {
                        ret = 8199;
                        break;
                    }
                    case "RAID6(12D+2P)": {
                        ret = 8208;
                        break;
                    }
                    case "RAID6(14D+2P)": {
                        ret = 8200;
                        break;
                    }
                    default: {
                        mLogger.log(Level.SEVERE, "Specified RAID level, {0}, is invalid.", raidLvl);
                        ret = -1;
                    }
                }
            }
        } else {
            switch (numDisks) {
                case 4: {
                    ret = 8197;
                    break;
                }
                case 5: {
                    ret = 8202;
                    break;
                }
                case 7: {
                    ret = 8196;
                    break;
                }
                case 8: {
                    ret = 8199;
                    break;
                }
                case 14: {
                    ret = 8208;
                    break;
                }
                case 16: {
                    ret = 8200;
                    break;
                }
                default: {
                    mLogger.log(Level.SEVERE, "Number of disks specified, {0}, does not match a supported RAID level ", numDisks);
                    ret = -1;
                }
            }
        }
        return ret;
    }

    public static Robj_interface_RJiLDEVIndex getRJiLDEVIndex(RMIObjectCache rmiObj, DeviceNumber dn) {
        Robj_interface_RJiLDEVIndex ret = null;
        if (null != dn) {
            try {
                ret = (Robj_interface_RJiLDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
                if (null != ret) {
                    ret.setLDEVIndex(dn.getLdkc(), dn.getCu(), dn.getLdev());
                }
            }
            catch (SANRmiException se) {
                mLogger.log(Level.SEVERE, "SANRmiException trying to create Robj_interface_RJiLDEVIndex object: " + se.getErrMsgEn(), se);
            }
            catch (RemoteException re) {
                mLogger.log(Level.SEVERE, "RemoteException trying to create Robj_interface_RJiLDEVIndex object: " + re.getMessage(), re);
            }
        }
        return ret;
    }

    public static String getSerialFromString(String value) {
        return ProviderLibs.getSerialFromString(value, ".", 1);
    }

    public static String getSerialFromString(String value, String separator, int index) {
        String ret = null;
        if (null != value && null != separator) {
            StringTokenizer tok = new StringTokenizer(value, separator, false);
            for (int count = 0; count <= index && tok.hasMoreTokens(); ++count) {
                String t = tok.nextToken();
                if (count != index) continue;
                ret = t;
            }
        } else {
            mLogger.log(Level.SEVERE, "All parameters need a value, value: %s, seperator: %s", new String[]{value, separator});
        }
        return ret;
    }

    public static ThinPool getSnapShotPool(CIMObjectPath pInPool) throws WBEMException {
        ThinPool ret = null;
        if (pInPool.getObjectName().compareToIgnoreCase("HITACHI_SnapshotPool") == 0) {
            CIMProperty cpInstID = pInPool.getKey("InstanceID");
            if (cpInstID != null) {
                String instID = (String)cpInstID.getValue();
                String serialNum = ProviderLibs.getSerialFromString(instID);
                RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
                RMIObjectCache rmiObj = mapping.getRMIObject();
                try {
                    String poolID = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    ret = ThinPool.find(rmiObj, Short.parseShort(poolID), ThinPool.ThinPoolType.QS);
                }
                catch (NumberFormatException nfe) {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                    logger.log(Level.SEVERE, "Invalid instance ID: " + instID, nfe);
                    ret = null;
                }
                catch (WBEMException e) {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                    logger.log(Level.SEVERE, "Could not find SnapShotPool (" + pInPool + ") on " + rmiObj.getSMISMappingContainer().getSerialNumber(), e);
                    ret = null;
                }
            }
        } else {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.log(Level.SEVERE, "ObjectPath: " + pInPool + " is not for a SnapShotPool");
            ret = null;
        }
        return ret;
    }

    public static Robj_interface_RJiSSIDInfo[] getSSIDInfo(RMIObjectCache rmiObj) throws RemoteException, SANRmiException, WBEMException {
        return ProviderLibs.getSSIDInfo(rmiObj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Robj_interface_RJiSSIDInfo[] getSSIDInfo(RMIObjectCache rmiObj, Robj_interface_RJiSSIDInfoDetail[] retInfoDetail) throws RemoteException, SANRmiException, WBEMException {
        Robj_interface_RJiSSIDInfoDetail ssIDs = rmiObj.getSSIDInfoDetail();
        Robj_interface_RJiSSIDInfo[] ssIDInfo = ssIDs.getObjSSID();
        if (null != retInfoDetail && retInfoDetail.length > 0) {
            retInfoDetail[0] = ssIDs;
        }
        LinkedList<Robj_interface_RJiSSIDInfo> linkedList = ssidInfoList;
        synchronized (linkedList) {
            ssidInfoList.clear();
            ssidInfoList.addAll(Arrays.asList(ssIDInfo));
        }
        return ssIDInfo;
    }

    public static UnsignedInteger16[] getStorageOpStatus(RMIObjectCache rmiObj) throws Exception {
        HashSet<UnsignedInteger16> set = new HashSet<UnsignedInteger16>();
        DKStatusInfo dkInfo = DKStatusInfo.getDKStatusInfo(rmiObj);
        if (null != dkInfo) {
            Robj_interface_DISKgetDKUStatusInfo infoDKU;
            Robj_interface_DISKgetDKCStatusInfo infoDKC = dkInfo.getDKCStatusInfo();
            if (null != infoDKC) {
                set.add(new UnsignedInteger16(ProviderLibs.parseDKStatus(infoDKC.getNDKCHWBattery())));
                set.add(new UnsignedInteger16(ProviderLibs.parseDKStatus(infoDKC.getNDKCHWCache())));
                set.add(new UnsignedInteger16(ProviderLibs.parseDKStatus(infoDKC.getNDKCHWFan())));
                set.add(new UnsignedInteger16(ProviderLibs.parseDKStatus(infoDKC.getNDKCHWPS())));
            }
            if (null != (infoDKU = dkInfo.getDKUStatusInfo())) {
                set.add(new UnsignedInteger16(ProviderLibs.parseDKStatus(infoDKU.getNDKCHWFan())));
                set.add(new UnsignedInteger16(ProviderLibs.parseDKStatus(infoDKU.getNDKUHWPS())));
            } else {
                mLogger.log(Level.SEVERE, "DKUStatusInfo is null!");
            }
        }
        return set.toArray(new UnsignedInteger16[set.size()]);
    }

    public static final Integer[] getStoragePoolChassisAndArrayGroup(String instID) throws WBEMException {
        Integer[] ret = new Integer[]{-1, -1};
        try {
            int fb4Idx;
            int agIdx = instID.lastIndexOf(".");
            int n = fb4Idx = -1 == agIdx ? -1 : instID.lastIndexOf(".", agIdx - 1);
            if (agIdx == -1 && fb4Idx == -1) {
                throw new WBEMException(1, "Instance ID is not valid: " + instID);
            }
            String agStr = instID.substring(agIdx + 1);
            String fb4Str = instID.substring(fb4Idx + 1, agIdx);
            Integer chassis = new Integer(fb4Str);
            Integer arrayGroup = new Integer(agStr);
            ret[0] = chassis;
            ret[1] = arrayGroup;
        }
        catch (NumberFormatException nfe) {
            throw new WBEMException(1, "Failed to convert string (" + instID + ")to Integer", null, (Throwable)nfe);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSubSystemID(short cu, short ldev, boolean create, String serialNum) throws WBEMException {
        int ret = -1;
        try {
            Robj_interface_RJiSSIDInfo[] ssIDInfo;
            if (!create && !ssidInfoList.isEmpty()) {
                LinkedList<Robj_interface_RJiSSIDInfo> linkedList = ssidInfoList;
                synchronized (linkedList) {
                    ssIDInfo = ssidInfoList.toArray(new Robj_interface_RJiSSIDInfo[ssidInfoList.size()]);
                }
            } else {
                RMIObjectMapping map = RMIObjectMapping.getRMIObjectMapping(serialNum);
                RMIObjectCache cache = map.getRMIObject();
                ssIDInfo = ProviderLibs.getSSIDInfo(cache);
            }
            for (Robj_interface_RJiSSIDInfo anSSID : ssIDInfo) {
                if (anSSID.getSCU() != cu || anSSID.getSStartLDEV() > ldev || anSSID.getSEndLDEV() < ldev) continue;
                ret = anSSID.getISSID();
            }
            if (create && ret < 0) {
                ret = ProviderLibs.createSSID(ssIDInfo);
            }
        }
        catch (SANRmiException e) {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            String msg = "SVP San Exception" + e.toString();
            logger.log(Level.SEVERE, msg, e);
            throw new WBEMException(1, msg, null, (Throwable)e);
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Unexcepted error accessing back end" + e.toString(), null, e);
        }
        return ret;
    }

    public static String getSubSystemIDString(DeviceNumber dn) throws WBEMException {
        String ssid = null;
        switch (dn.getVolumeFlag()) {
            case 1: 
            case 2: {
                int ssidVal = ProviderLibs.getSubSystemID(dn.getCu(), dn.getLdev(), false, dn.getSerialNumber());
                ssid = String.valueOf(ssidVal);
                break;
            }
            case 3: {
                ssid = null;
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "Unknown volume flag: {0}", new Object[]{dn.getVolumeFlag()});
            }
        }
        return ssid;
    }

    public static final synchronized Hashtable<Integer, String> getSupportedEmulation(boolean forceRefresh) throws RemoteException, GetRmiException, WBEMException {
        if (forceRefresh) {
            emulationID = null;
        }
        if (null == emulationID) {
            emulationID = ProviderLibs.getDataChangeTableStr("EmulationID");
        }
        return emulationID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Hashtable<Integer, String> getSupportedRaidLevels() throws RemoteException, GetRmiException, WBEMException {
        Hashtable<Integer, String> t = raidLevel;
        if (t != null) return t;
        Class<ProviderLibs> clazz = ProviderLibs.class;
        synchronized (ProviderLibs.class) {
            t = raidLevel;
            if (t != null) return t;
            raidLevel = ProviderLibs.getDataChangeTableStr("RAIDLEVEL");
            return raidLevel;
        }
    }

    public static ThinPool getThinPool(CIMObjectPath pInPool) throws WBEMException {
        ThinPool ret = null;
        if (pInPool.getObjectName().compareToIgnoreCase("HITACHI_ThinProvisioningPool") == 0) {
            CIMProperty cpInstID = pInPool.getKey("InstanceID");
            if (cpInstID != null) {
                String instID = (String)cpInstID.getValue();
                String serialNum = ProviderLibs.getSerialFromString(instID);
                RMIObjectMapping mapping = RMIObjectMapping.getRMIObjectMapping(serialNum);
                RMIObjectCache rmiObj = mapping.getRMIObject();
                try {
                    String poolID = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    ret = ThinPool.find(rmiObj, Short.parseShort(poolID), ThinPool.ThinPoolType.AOU);
                }
                catch (NumberFormatException nfe) {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                    logger.log(Level.SEVERE, "Invalid instance ID: " + instID, nfe);
                    ret = null;
                }
                catch (WBEMException e) {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                    logger.log(Level.SEVERE, "Could not find ThinPool (" + pInPool + ") on " + rmiObj.getSMISMappingContainer().getSerialNumber(), e);
                    ret = null;
                }
            }
        } else {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.log(Level.SEVERE, "ObjectPath: " + pInPool + " is not for a ThinProvisioningPool");
            ret = null;
        }
        return ret;
    }

    public static String getTokenString(String pString, String pSeparator, int start, int end) {
        String ret = "";
        if (null != pString) {
            StringTokenizer st = new StringTokenizer(pString, pSeparator);
            if (end >= start && st.countTokens() > end) {
                for (int i = 0; i < start; ++i) {
                    st.nextToken();
                }
                StringBuilder buf = new StringBuilder();
                for (int i = start; i < end + 1; ++i) {
                    buf.append(st.nextToken());
                    buf.append(pSeparator);
                }
                ret = buf.substring(0, buf.length() - 1);
            }
        }
        return ret;
    }

    public static boolean isElementNameValid(String elementName, int maxNameLength) {
        Pattern pattern;
        Matcher matcher;
        boolean ret = false;
        if (null == elementName || elementName.isEmpty()) {
            ret = true;
        } else if (' ' != elementName.charAt(0) && elementName.length() <= maxNameLength && (matcher = (pattern = Pattern.compile("[\\w\\s!#@$%&'()+-\\.=@\\[\\]^`\\{\\}~]*")).matcher(elementName)).matches()) {
            ret = true;
        }
        return ret;
    }

    public static boolean isEmulationTypeGroup(RMIObjectCache rmiObj, byte ldevInfoIDEmulationVal, int ldevEmulationType) {
        boolean ret = false;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        try {
            String ldevEmulation;
            Integer index;
            ArrayList<String> supportedTypes;
            if (e_TypeGroupData == null) {
                ProviderLibs.getETypeInfo(rmiObj);
            }
            if ((supportedTypes = e_TypeGroupData.get(index = Integer.valueOf(Byte.toString(ldevInfoIDEmulationVal)))).contains(ldevEmulation = ProviderLibs.lookupEmulationType(ldevEmulationType))) {
                ret = true;
            }
        }
        catch (RemoteException e) {
            logger.log(Level.SEVERE, "Exception getting data from back end:" + e, e);
        }
        catch (SANRmiException e) {
            logger.log(Level.SEVERE, "Exception getting data from back end:" + (Object)((Object)e), e.getErrMsgEn());
        }
        catch (GetRmiException e) {
            logger.log(Level.SEVERE, "Exception getting data from back end:" + (Object)((Object)e), e.getErrMsgEn());
        }
        catch (WBEMException e) {
            logger.log(Level.SEVERE, "Exception getting data from back end:" + (Object)((Object)e), e);
        }
        return ret;
    }

    public static boolean isFICONDM(int fb4) {
        return 16641 <= fb4 && fb4 <= 17152;
    }

    public static boolean isLDevAllocated(DeviceNumber dn) throws WBEMException {
        boolean ret = false;
        if (null != dn) {
            DeviceNumber headDN;
            if (3 != dn.getVolumeFlag()) {
                ret = !dn.isReserved();
            } else if (dn.hasPaths()) {
                ret = true;
            } else if (dn.getSLUSEElmCount() == 0 && null != (headDN = DeviceNumber.findHeadLUSE(dn.getDNAsString(), RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getRMIObject())) && headDN.hasPaths()) {
                ret = true;
            }
        }
        return ret;
    }

    static final byte isSameValues(int pFB4ToCheck, int pPGToCheck, int pVdevToCheck, int pCurFB4, int pCurPG, int pCurVdev) {
        int ret = 0;
        if (pFB4ToCheck != -1 && pCurFB4 != pFB4ToCheck) {
            ret = pCurFB4 > pFB4ToCheck ? 1 : -1;
        }
        if (ret == 0 && pPGToCheck != -1 && pCurPG != pPGToCheck) {
            ret = pCurPG > pPGToCheck ? 1 : -1;
        }
        if (ret == 0 && pVdevToCheck != -1 && pCurVdev != pVdevToCheck) {
            ret = -1;
        }
        return (byte)ret;
    }

    public static <E extends Serializable> ArrayList<E> iteratorToArrayList(CustomCloseableIterator<E> iter) {
        ArrayList<Serializable> retList = new ArrayList<Serializable>();
        if (null != iter) {
            while (iter.hasNext()) {
                Serializable o = (Serializable)iter.next();
                retList.add(o);
            }
        }
        return retList;
    }

    public static String lookupEmulationType(int emulationTypeVal) throws RemoteException, GetRmiException, WBEMException {
        Hashtable<Integer, String> emulationHash = ProviderLibs.getSupportedEmulation(false);
        String ret = emulationHash.get(emulationTypeVal);
        if (ret == null) {
            mLogger.log(Level.WARNING, "Could not find emulation type, {0}, in data change table", new Object[]{emulationTypeVal});
            ret = "UNKNOWN";
        }
        return ret;
    }

    public static String[] lookupFibreAddressInfo(int port) throws RemoteException, GetRmiException, WBEMException {
        String[] ret = new String[2];
        Hashtable<Integer, String> fibreAddress = ProviderLibs.getFibreAddressInfo();
        String fibreAddressInfo = fibreAddress.get(port);
        if (null == fibreAddressInfo) {
            mLogger.log(Level.WARNING, "Could not find fibreaddess for port, {0}, in data change table", new Object[]{port});
        } else {
            int index = fibreAddressInfo.indexOf(40);
            int endIndex = fibreAddressInfo.indexOf(41);
            if (index > 2 && index < endIndex) {
                ret[0] = fibreAddressInfo.substring(0, index - 1);
                ret[1] = fibreAddressInfo.substring(index + 1, endIndex);
            } else {
                mLogger.log(Level.WARNING, "cannot parse fibreAddress string returned fromdata change table: {0}", new Object[]{fibreAddressInfo});
            }
        }
        return ret;
    }

    public static void modifyElementName(CIMInstance currentInst, CIMInstance modifiedInst, AbstractBaseCommonObject obj, String user, String host, String affectedJobElement, String owningJobElement) throws WBEMException {
        String cElementName;
        ProviderLibs.CheckModifiedProperties(currentInst, modifiedInst, null, new String[]{"ElementName"}, null);
        String mElementName = (String)modifiedInst.getPropertyValue("ElementName");
        if (null == mElementName) {
            mElementName = "";
        }
        if (null == (cElementName = (String)currentInst.getPropertyValue("ElementName"))) {
            cElementName = "";
        }
        if (!mElementName.equalsIgnoreCase(cElementName)) {
            if (ProviderLibs.isElementNameValid(mElementName, 32)) {
                CIMObjectPath owningService;
                BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageConfigurationServiceInstrumentation");
                RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(obj.getSerialNumber()).getRMIObject();
                try {
                    owningService = bi.generateObjectPath(currentInst.getObjectPath(), rmiObj);
                }
                catch (Exception e) {
                    throw new WBEMException(1, "Error getting configuration service", null, (Throwable)e);
                }
                CreateModifyVolumeLabel cml = new CreateModifyVolumeLabel(user, host, owningService, mElementName, currentInst.getObjectPath(), obj, affectedJobElement, owningJobElement);
                CIM_ConcreteJob job = cml.submitJob(false);
                job.setDescription("Modify ElementName for " + currentInst.getObjectPath());
                ProviderLibs.waitForJob(job);
            } else {
                throw new WBEMException("Element name \"" + mElementName + "\" is not valid");
            }
        }
    }

    private static int parseDKStatus(int pStatus) {
        int ret;
        switch (pStatus) {
            case 1: {
                ret = 2;
                break;
            }
            case 2: {
                ret = 6;
                break;
            }
            case 3: {
                ret = 5;
                break;
            }
            case 4: {
                ret = 4;
                break;
            }
            case 5: {
                ret = 11;
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "Unknown DKStatus: {0}", new Object[]{pStatus});
                ret = 0;
            }
        }
        return ret;
    }

    public static String[] parseStorageCapabilitiesInstanceID(String instID) throws WBEMException {
        String[] ret = new String[]{null, null};
        if (null != instID) {
            StringTokenizer tokenizer = new StringTokenizer(instID, ".");
            int tokCount = tokenizer.countTokens();
            if (5 == tokCount) {
                tokenizer.nextToken();
                --tokCount;
            }
            if (4 == tokCount) {
                ret[0] = tokenizer.nextToken() + "." + tokenizer.nextToken();
                ret[1] = tokenizer.nextToken() + "." + tokenizer.nextToken();
            } else if (3 == tokCount) {
                ret[0] = tokenizer.nextToken() + "." + tokenizer.nextToken();
                ret[1] = tokenizer.nextToken();
            }
        }
        return ret;
    }

    public static boolean shouldAdvertiseOnHM700(CIMInstance ci) throws WBEMException {
        boolean ret = true;
        String instID = (String)ci.getPropertyValue("InstanceID");
        ret = ProviderLibs.shouldAdvertiseOnHM700(instID);
        return ret;
    }

    public static boolean shouldAdvertiseOnHM700(CIMObjectPath op) throws WBEMException {
        boolean ret = true;
        CIMProperty cvInstID = op.getKey("InstanceID");
        String instID = null == cvInstID ? null : (String)cvInstID.getValue();
        ret = ProviderLibs.shouldAdvertiseOnHM700(instID);
        return ret;
    }

    public static boolean shouldAdvertiseOnHM700(String profileName) throws WBEMException {
        boolean ret = true;
        if (ProviderProperties.isEmbedded()) {
            RMIObjectMapping.getEmbeddedRMIObjectMapping();
        } else {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            while (devices.isEmpty()) {
                mLogger.warning("There are no managed devices, waiting...");
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException e) {
                    mLogger.log(Level.FINE, "waiting for devices was interuppted - this is OK", e);
                }
            }
            devices.iterator().next();
        }
        return true;
    }

    public static void sortHashMapList(AbstractMap<Integer, List<Integer>> map) {
        Set<Integer> keys = map.keySet();
        for (Integer key : keys) {
            List<Integer> list2Sort = map.get(key);
            if (list2Sort == null) continue;
            Collections.sort(list2Sort);
        }
    }

    public static final long toKBytes(long numOfBytes) {
        if (numOfBytes % 2L == 0L) {
            return 1024L * (numOfBytes / 2L) / 1000L;
        }
        return 1024L * ((numOfBytes + 1L) / 2L) / 1000L;
    }

    public static void validateVARArgs(Class<?>[] expectedClz, Object[] varArgs, String callerName) throws IllegalArgumentException {
        int numParams = expectedClz.length;
        if (null == varArgs || varArgs.length < expectedClz.length) {
            throw new IllegalArgumentException(callerName + " expected to get " + numParams + " argument but got " + (null != varArgs ? Integer.valueOf(varArgs.length) : "null"));
        }
        for (int x = 0; x < numParams; ++x) {
            Class<?> clz = expectedClz[x];
            if (null == clz || null != varArgs[x] && expectedClz[x].isInstance(varArgs[x])) continue;
            throw new IllegalArgumentException(callerName + " parameter " + (x + 1) + " expected a " + clz.getSimpleName() + " but got " + (null != varArgs[x] ? varArgs[x].getClass().getSimpleName() : "null"));
        }
    }

    public static final boolean valueExist(UnsignedInteger16[] uint16Array, int value) {
        if (null != uint16Array) {
            for (UnsignedInteger16 uint16 : uint16Array) {
                if (null == uint16 || uint16.compareTo(new UnsignedInteger16(value)) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static final void waitForJob(CIM_ConcreteJob job) throws WBEMException {
        boolean done = false;
        while (!done) {
            UnsignedInteger16[] values;
            CIM_ConcreteJob.JobState state = job.getJobState();
            UnsignedInteger16 stateVal = state.getValue();
            if (stateVal.intValue() != 7 && stateVal.intValue() != 10) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    mLogger.log(Level.FINEST, "waitForJob sleep interrupted - this is OK", ie);
                }
                continue;
            }
            done = true;
            boolean isJobComplete = false;
            boolean isNoError = false;
            for (UnsignedInteger16 value : values = job.getOperationalStatus()) {
                if (value.intValue() == 17) {
                    isJobComplete = true;
                    continue;
                }
                if (value.intValue() != 2) continue;
                isNoError = true;
            }
            if (isJobComplete && isNoError) {
                mLogger.log(Level.INFO, "Job {0} completed Successfully", job.getInstanceID());
                continue;
            }
            throw new WBEMException("Operation failed, error: " + job.getErrorDescription());
        }
    }

    private ProviderLibs() {
    }
}

