/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.ws.wbem.CloseableAddableIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import javax.wbem.provider.ProviderHandle;

public class ProviderProperties {
    private static final String OPERATIONMODE_DEFAULT = "embedded";
    private static volatile ProviderProperties singleton;
    private static final int DeafultTime2WaitB4JobDelete = 60;
    private static final Logger mLogger;
    private static Properties mProps;
    private static ProviderHandle wbemClient;
    private static final String PROPS_HTTPENABLED = "HttpEnabled";
    private static final String PROPS_CACHECREATION = "CacheCreation";
    private static final String PROPS_LICENSECHECKINTERVAL = "LicenseCheckInterval";
    private static final String PROPS_VERSIONCHECKINTERVAL = "VersionCheckInterval";
    private static final String PROPS_MONITORINTERVAL = "MonitorInterval";
    private static final String PROPS_ERRORCHECKINTERVAL = "ErrorCheckInterval";
    private static final String PROPS_NUMMINUTES2WAITB4JOBDELETE = "MinutesBeforeJobDeleted";
    private static final String PROPS_OPERATIONMODE = "OperationMode";
    private static final String PROPS_LOCKRETRIES = "LockRetries";
    private static final String PROPS_LOCKWAITTIME = "LockWaitTime";
    private static final String CMN_METHODNAME = "SetEnabledCipherSuites";
    private static final String USERDEF_CIPHERS = "CipherSuites";
    private static final String PROPS_RMIPORT = "RMIPortNumber";
    private static final String CCN_SETTINGSCLZ = "HITACHI_CIMXMLSettingData";
    private static final String PROPS_CONCURRENT_AUTH = "ConcurrentAuthReq";

    public static boolean getCacheCreation() throws WBEMException {
        String val = ProviderProperties.getProviderProperties().getProperty(PROPS_CACHECREATION, "false");
        return Boolean.parseBoolean(val);
    }

    public static int getConcurrentAuthRequests() {
        int concurrentAuthAllowed;
        String val;
        try {
            val = ProviderProperties.getProviderProperties().getProperty(PROPS_CONCURRENT_AUTH, "4");
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Error getting ConcurrentAuthReq", e);
            val = "4";
        }
        try {
            concurrentAuthAllowed = Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            mLogger.log(Level.SEVERE, "Error getting ConcurrentAuthReq", nfe);
            concurrentAuthAllowed = 4;
        }
        return concurrentAuthAllowed;
    }

    public static int getErrorCheckIntervalSeconds() {
        int ErrorCheckInterval;
        try {
            String val = ProviderProperties.getProviderProperties().getProperty(PROPS_ERRORCHECKINTERVAL, "30");
            ErrorCheckInterval = Integer.parseInt(val);
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Error getting ErrorCheckInterval", e);
            ErrorCheckInterval = 30;
        }
        return ErrorCheckInterval;
    }

    public static int getJobWaitB4Delete() {
        int numMinutes2WaitB4JobDelete;
        try {
            String val = ProviderProperties.getProviderProperties().getProperty(PROPS_NUMMINUTES2WAITB4JOBDELETE, String.valueOf(60));
            numMinutes2WaitB4JobDelete = Integer.parseInt(val);
            if (numMinutes2WaitB4JobDelete < 5 || numMinutes2WaitB4JobDelete > 300) {
                mLogger.warning("Can not wait less then 5 minutes or  more then 300 minutes for job completion, defaulting to 60 minutes");
                numMinutes2WaitB4JobDelete = 60;
            }
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Error getting MinutesBeforeJobDeleted", e);
            numMinutes2WaitB4JobDelete = 60;
        }
        return numMinutes2WaitB4JobDelete;
    }

    public static int getLicenseCheckIntervalSeconds() throws WBEMException {
        int LicenseCheckInterval;
        String val = ProviderProperties.getProviderProperties().getProperty(PROPS_LICENSECHECKINTERVAL, "1800");
        try {
            LicenseCheckInterval = Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            mLogger.log(Level.SEVERE, "Error getting LicenseCheckInterval", nfe);
            LicenseCheckInterval = 1800;
        }
        return LicenseCheckInterval;
    }

    public static int getLockRetries() {
        int lockRetries;
        try {
            String val = ProviderProperties.getProviderProperties().getProperty(PROPS_LOCKRETRIES, "3");
            lockRetries = Integer.parseInt(val);
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Error getting LockRetries", e);
            lockRetries = 30;
        }
        return lockRetries;
    }

    public static int getLockWaitTime() {
        int lockWaitTime;
        try {
            String val = ProviderProperties.getProviderProperties().getProperty(PROPS_LOCKWAITTIME, "60");
            lockWaitTime = Integer.parseInt(val);
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Error getting LockWaitTime", e);
            lockWaitTime = 60;
        }
        return lockWaitTime;
    }

    public static int getMonitorIntervalSeconds() {
        int MonitorInterval;
        try {
            String val = ProviderProperties.getProviderProperties().getProperty(PROPS_MONITORINTERVAL, "300");
            MonitorInterval = Integer.parseInt(val);
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Error getting MonitorInterval", e);
            MonitorInterval = 300;
        }
        return MonitorInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ProviderProperties getProviderProperties() throws WBEMException {
        ProviderProperties t = singleton;
        if (null != t) return t;
        Class<ProviderProperties> clazz = ProviderProperties.class;
        synchronized (ProviderProperties.class) {
            t = singleton;
            if (null != t) return t;
            singleton = new ProviderProperties();
            return singleton;
        }
    }

    public static int getRMIPortNumber() {
        int ret;
        try {
            String val = ProviderProperties.getProviderProperties().getProperty(PROPS_RMIPORT, "1099");
            ret = Integer.parseInt(val);
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Error getting RMIPortNumber", e);
            ret = 1099;
        }
        return ret;
    }

    public static int getVersionCheckIntervalSeconds() {
        int VersionCheckInterval;
        try {
            String val = ProviderProperties.getProviderProperties().getProperty(PROPS_VERSIONCHECKINTERVAL, "30");
            VersionCheckInterval = Integer.parseInt(val);
        }
        catch (Throwable e) {
            mLogger.log(Level.SEVERE, "Error getting MonitorInterval", e);
            VersionCheckInterval = 30;
        }
        return VersionCheckInterval;
    }

    public static boolean isEmbedded() {
        String val = "true";
        try {
            val = ProviderProperties.getProviderProperties().getProperty(PROPS_OPERATIONMODE, OPERATIONMODE_DEFAULT);
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Error getting OperationMode", e);
        }
        return OPERATIONMODE_DEFAULT.equalsIgnoreCase(val);
    }

    public static boolean isHttpEnabled() throws WBEMException {
        String val = ProviderProperties.getProviderProperties().getProperty(PROPS_HTTPENABLED, "false");
        return Boolean.parseBoolean(val);
    }

    public static boolean start(ProviderHandle hCimom) {
        boolean ret = false;
        try {
            wbemClient = hCimom;
            ProviderProperties pp = ProviderProperties.getProviderProperties();
            pp.processSecurityData();
            ret = true;
        }
        catch (WBEMException we) {
            mLogger.log(Level.SEVERE, "Unable to get provider.properties data", we);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stop() {
        Class<ProviderProperties> clazz = ProviderProperties.class;
        synchronized (ProviderProperties.class) {
            singleton = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return true;
        }
    }

    private ProviderProperties() throws WBEMException {
        mProps = new Properties();
        StringBuilder propFile = new StringBuilder(ProviderConstants.getConfigDirectory());
        propFile.append("provider.properties");
        File f = new File(propFile.toString());
        if (f.exists()) {
            try (FileInputStream in = new FileInputStream(f);){
                mLogger.log(Level.INFO, "{0} loading data", propFile);
                mProps.load(in);
            }
            catch (FileNotFoundException fnf) {
                mLogger.log(Level.WARNING, "provider.properties could not be found", fnf);
            }
            catch (IOException ioe) {
                throw new WBEMException(1, "Error getting data from provider.properties", null, (Throwable)ioe);
            }
        } else {
            mLogger.log(Level.INFO, "{0} could not be found", propFile);
        }
    }

    private String[] getCiphers() {
        String[] ret = null;
        String val = this.getProperty(USERDEF_CIPHERS, null);
        if (null != val) {
            ret = val.split(",");
        }
        return ret;
    }

    public String getProperty(String propName) throws WBEMException {
        return this.getProperty(propName, null);
    }

    public String getProperty(String propName, String defaultValue) {
        return mProps.getProperty(propName, defaultValue);
    }

    private void processSecurityData() {
        try {
            Object[] ciphers;
            CIMObjectPath settingDataOP = new CIMObjectPath(null, null, null, ProviderLibs.getInteropNamespace(), CCN_SETTINGSCLZ, null);
            CIMObjectPath theSettingData = null;
            CloseableAddableIterator iter = new CloseableAddableIterator();
            ProviderLibs.enumerateCIMOMInstances(settingDataOP, (CloseableAddableIterator<CIMInstance>)iter, wbemClient);
            if (iter.hasNext()) {
                CIMInstance inst = (CIMInstance)iter.next();
                theSettingData = inst.getObjectPath();
            }
            if (null != (ciphers = this.getCiphers())) {
                mLogger.log(Level.INFO, "Modifying ciphers to: {0}", Arrays.toString(ciphers));
                CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument(USERDEF_CIPHERS, CIMDataType.STRING_ARRAY_T, (Object)ciphers)};
                Object methRet = wbemClient.invokeMethod(theSettingData, CMN_METHODNAME, inArgs, null);
                if (0 == ((UnsignedInteger32)methRet).intValue()) {
                    mLogger.info("InvokeMethod to modify ciphers succeeded");
                } else {
                    mLogger.log(Level.SEVERE, "Modifying ciphers failed with code {0}", methRet);
                }
            } else {
                mLogger.log(Level.INFO, "Found {0}, no changes to ciphers ", "provider.properties");
            }
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "An exception occurred while processing security data", t);
        }
    }

    static {
        mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    }
}

