/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.ws.wbem.jserver.JServerProperties;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;

public final class ProviderStatusUtils {
    public static final String JSERVER_STATUS = "jserver.status";
    public static final char CLOSE_PAREN = ')';
    public static final String DETAIL_CODE = "(Detail Code ";

    public static ProviderStatus convertString2Status(String status) throws WBEMException {
        ProviderStatus ret;
        String tStatus;
        if (null == status) {
            throw new WBEMException("Parameter 'status' can not be null");
        }
        String rdyStr = ProviderStatus.Ready.toString();
        int idx = status.indexOf("(");
        String string = tStatus = -1 == idx ? status : status.substring(0, idx);
        if (ProviderStatus.Initializing.toString().equalsIgnoreCase(tStatus)) {
            ret = ProviderStatus.Initializing;
        } else if (rdyStr.equalsIgnoreCase(tStatus)) {
            ret = ProviderStatus.Ready;
        } else if (ProviderStatus.Stopped.toString().equalsIgnoreCase(tStatus)) {
            ret = ProviderStatus.Stopped;
        } else if (ProviderStatus.Suspended.toString().equalsIgnoreCase(tStatus)) {
            ret = ProviderStatus.Suspended;
        } else if (ProviderStatus.Warning.toString().equalsIgnoreCase(tStatus)) {
            ret = ProviderStatus.Warning;
        } else {
            throw new WBEMException("Passed in status(" + status + ") is not valid");
        }
        return ret;
    }

    public static synchronized String getCurrentStatus() throws WBEMException {
        String status;
        block16: {
            String statusFileName = JServerProperties.getPropertiesDirectory() + File.separator + JSERVER_STATUS;
            File statusFile = new File(statusFileName);
            if (statusFile.exists()) {
                try (BufferedReader fileRdr = new BufferedReader(new FileReader(statusFile));){
                    String line = fileRdr.readLine();
                    if (null != line) {
                        status = line.trim();
                        break block16;
                    }
                    throw new WBEMException(statusFileName + " exists but contains no data");
                }
                catch (IOException e) {
                    throw new WBEMException(statusFileName + " exists but can not be opened or read");
                }
            }
            throw new WBEMException(statusFileName + " does not exist");
        }
        return status;
    }

    public static ProviderStatus getCurrentStatusEnum() throws WBEMException {
        String status = ProviderStatusUtils.getCurrentStatus();
        return ProviderStatusUtils.convertString2Status(status);
    }

    public static synchronized boolean setProviderStatus(ProviderStatus newStatus, ProviderStatusDetailCode detailCode) {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        boolean status = true;
        logger.log(Level.INFO, "Attempting to change status to {0}({1})", new Object[]{newStatus, detailCode});
        try {
            if (ProviderStatus.Suspended == ProviderStatusUtils.getCurrentStatusEnum() && ProviderStatus.Ready != newStatus && ProviderStatus.Stopped != newStatus && ProviderStatus.Initializing != newStatus) {
                logger.log(Level.FINE, "Provider suspended, status can not be changed: {0} {1}", new Object[]{newStatus, null != detailCode ? detailCode : ""});
                status = false;
            }
        }
        catch (WBEMException e1) {
            if (ProviderStatus.Initializing != newStatus) {
                logger.log(Level.WARNING, "Unable to determine current status of provider", e1);
            }
            logger.log(Level.INFO, "Server initializing and status file doesn't exist. This is probably ok");
        }
        if (status) {
            String statusFileName = JServerProperties.getPropertiesDirectory() + File.separator + JSERVER_STATUS;
            StringBuilder sb = new StringBuilder(newStatus.toString());
            sb.append(DETAIL_CODE);
            sb.append(String.format("%02d", null == detailCode ? ProviderStatusDetailCode.NONE : Integer.valueOf(detailCode.getValue())));
            sb.append(')');
            logger.log(Level.FINE, "Updating {0} with satus: {1}", new Object[]{statusFileName, sb});
            File statusFile = new File(statusFileName);
            try (BufferedWriter fileWrtr = new BufferedWriter(new FileWriter(statusFile));){
                fileWrtr.write(sb.toString());
                logger.log(Level.FINE, "Done writing to {0}", statusFileName);
                status = true;
            }
            catch (Throwable e) {
                status = false;
                logger.log(Level.SEVERE, "Error creating/writing to " + statusFileName, e);
            }
        }
        return status;
    }

    public static enum ProviderStatusDetailCode {
        NONE(0),
        PORTINUSE(1),
        CACHEFAILED(2),
        MISSINGFILE(3),
        BADUSERPWD(4),
        TIMEOUT(5),
        JOBSRUNNING(6),
        UNEXPECTED(7),
        RMI_SERVER_UNAVAILABLE(8),
        CREDENTIALS(9);

        int value;

        private ProviderStatusDetailCode(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum ProviderStatus {
        Ready,
        Initializing,
        Stopped,
        Suspended,
        Warning;

    }
}

