/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.PGInfo;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ResourceRestriction;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RSGHostGroupIndex;
import sanproject.common.Robj_interface_RSGInfo;
import sanproject.common.Robj_interface_RSGgetRsg;
import sanproject.common.Robj_interface_RSGgetRsgs_IN;
import sanproject.common.Robj_interface_RSGgetRsgs_OUT;

public class ResourceGroupInfo
extends AbstractBaseCommonObject
implements Comparable<ResourceGroupInfo> {
    private static final Class<ResourceGroupInfo[]> clz = ResourceGroupInfo[].class;
    private static final long serialVersionUID = 1L;
    private final TreeSet<String> dns;
    private final TreeSet<String> pgs;
    private final TreeSet<String> hostGrps;
    private final TreeSet<String> ports;
    private int id;
    private String nickName;

    private static Map<String, List<ResourceGroupInfo>> addResourceInfoToMap(List<ResourceGroupInfo> infos) {
        Map<String, List<ResourceGroupInfo>> ret = Collections.emptyMap();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException {
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<ResourceGroupInfo> clazz = ResourceGroupInfo.class;
            synchronized (ResourceGroupInfo.class) {
                if (!cache.isCached(clz)) {
                    CommonClassAsList<ResourceGroupInfo> callback = new CommonClassAsList<ResourceGroupInfo>();
                    ResourceGroupInfo.getUnCachedResourceInfo(rmiMapping.getSerialNumber(), callback, null, null, null, null, false);
                    LinkedList<ResourceGroupInfo> infos = callback.getReturnValue();
                    callback = null;
                    cacheLogger.info("Created " + infos.size() + " ResourceGroups");
                    Map map = ResourceGroupInfo.addResourceInfoToMap(infos);
                    CacheLib.addDataToCache(map, infos, clz, rmiMapping.getSerialNumber());
                } else {
                    cacheLogger.warning("ResourceGroupInfo is already in the cache");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            cacheLogger.warning("ResourceGroupInfo is already in the cache");
        }
    }

    public static void compareCachedResourceGroup2Backend(List<ResourceGroupInfo> addedRSGs, List<ResourceGroupInfo> modifiedRSGs, List<ResourceGroupInfo> removedRSGs, String serialNumber, Map<SearchType, TreeSet<String>> addedElements, Map<SearchType, TreeSet<String>> removedElements) {
        cacheLogger.info("Entering ResourceGroupInfo.compareCachedResourceGroup2Backend");
        try {
            cacheLogger.fine("Getting cached ResourceGroupInfo");
            CommonClassAsList<ResourceGroupInfo> callback = new CommonClassAsList<ResourceGroupInfo>();
            ResourceGroupInfo.getResourceInfo(serialNumber, callback, null, null, null, null, false);
            LinkedList<ResourceGroupInfo> cachedList = callback.getReturnValue();
            callback = null;
            cacheLogger.fine("Getting back-end ResourceGroupInfo");
            callback = new CommonClassAsList();
            ResourceGroupInfo.getUnCachedResourceInfo(serialNumber, callback, null, null, null, null, false);
            LinkedList<ResourceGroupInfo> newList = callback.getReturnValue();
            callback = null;
            if (cacheLogger.isLoggable(Level.FINE)) {
                cacheLogger.fine("Found " + cachedList.size() + " cached and " + newList.size() + " back-end");
            }
            cacheLogger.fine("Sorting lists");
            Collections.sort(cachedList);
            Collections.sort(newList);
            cacheLogger.fine("Comparing RSG lists");
            ListIterator cachedIter = cachedList.listIterator();
            while (cachedIter.hasNext()) {
                ResourceGroupInfo cached = (ResourceGroupInfo)cachedIter.next();
                cachedIter.remove();
                int index = Collections.binarySearch(newList, cached);
                if (index < 0) {
                    removedRSGs.add(cached);
                    ResourceGroupInfo.processChanges(cached, new ResourceGroupInfo(cached.getSerialNumber(), cached.getId(), cached.getNickName()), addedElements, removedElements);
                    continue;
                }
                ResourceGroupInfo backend = (ResourceGroupInfo)newList.remove(index);
                if (cached.equals(backend)) continue;
                modifiedRSGs.add(new ResourceGroupInfo(cached));
                ResourceGroupInfo.processChanges(cached, backend, addedElements, removedElements);
            }
            for (int x = 0; x < newList.size(); ++x) {
                ResourceGroupInfo newRSG = (ResourceGroupInfo)newList.get(x);
                addedRSGs.add(newRSG);
                ResourceGroupInfo.processChanges(new ResourceGroupInfo(newRSG.getSerialNumber(), newRSG.getId(), newRSG.getNickName()), newRSG, addedElements, removedElements);
            }
            cacheLogger.log(Level.INFO, "ResourceGroupInfo: Modifying {0}, Removing {1}, Adding {2}", new Integer[]{modifiedRSGs.size(), removedRSGs.size(), addedRSGs.size()});
            if (cacheLogger.isLoggable(Level.FINE)) {
                cacheLogger.log(Level.FINE, "Modified elements:{0}Modified RSGs: {1}{0}Added RSGs {2}{0}Removed RSGs {3}{0}Modified RSG elements:{0}{4}", new Object[]{System.lineSeparator(), modifiedRSGs, addedRSGs, removedRSGs, addedElements});
            }
            CacheLib.removeDataFromCache(ResourceGroupInfo.addResourceInfoToMap(removedRSGs), (Serializable[])removedRSGs.toArray(new ResourceGroupInfo[removedRSGs.size()]), clz, (String)serialNumber);
            CacheLib.addDataToCache(ResourceGroupInfo.addResourceInfoToMap(addedRSGs), addedRSGs, clz, serialNumber);
        }
        catch (Throwable e) {
            cacheLogger.log(Level.SEVERE, "Exception occurred while inResourceGroupInfo.compareCachedResourceGroup2Backend: " + e.toString(), e);
        }
        cacheLogger.info("Exiting ResourceGroupInfo.compareCachedResourceGroup2Backend");
    }

    private static void determineWhatChanged(SearchType type, ResourceGroupInfo cached, ResourceGroupInfo backend, Set<String> added, Set<String> removed) {
        TreeSet<String> backendSet;
        TreeSet<String> cachedSet;
        switch (type) {
            case DN: {
                cachedSet = cached.dns;
                backendSet = backend.dns;
                break;
            }
            case PG: {
                cachedSet = cached.pgs;
                backendSet = backend.pgs;
                break;
            }
            case PHGI: {
                cachedSet = cached.hostGrps;
                backendSet = backend.hostGrps;
                break;
            }
            case PORT: {
                cachedSet = cached.ports;
                backendSet = backend.ports;
                break;
            }
            default: {
                cachedSet = null;
                backendSet = null;
            }
        }
        TreeSet<String> tmpRemoved = new TreeSet<String>();
        TreeSet<String> tmpAdded = new TreeSet<String>();
        if (null != cachedSet && null != backendSet) {
            tmpRemoved.addAll(cachedSet);
            tmpRemoved.removeAll(backendSet);
            tmpAdded.addAll(backendSet);
            tmpAdded.removeAll(cachedSet);
            if (!tmpRemoved.isEmpty() || !tmpAdded.isEmpty()) {
                cachedSet.clear();
                cachedSet.addAll(backendSet);
                try {
                    if (ResourceRestriction.isResourceGroupUsable(cached.getSerialNumber(), cached.getId())) {
                        removed.addAll(tmpRemoved);
                        added.addAll(tmpAdded);
                    }
                }
                catch (Throwable t) {
                    cacheLogger.log(Level.SEVERE, "Exception finding resource group " + cached.getId(), t);
                }
            }
        }
    }

    public static ResourceGroupInfo find(BaseDeviceNumber dn) throws WBEMException {
        ResourceGroupInfo ret = null;
        FindMethodCallbackHandler<ResourceGroupInfo> callback = new FindMethodCallbackHandler<ResourceGroupInfo>();
        ResourceGroupInfo.getResourceInfo(dn.getSerialNumber(), callback, dn, null, null, null, false);
        ret = callback.getReturnValue();
        return ret;
    }

    public static ResourceGroupInfo find(ChassisArrayGroup cag) throws WBEMException {
        ResourceGroupInfo ret = null;
        PGInfo pg = PGInfo.find(cag.getSerialNumber(), cag.getFb4(), cag.getPg());
        if (null != pg) {
            ret = ResourceGroupInfo.find(pg);
        }
        return ret;
    }

    public static ResourceGroupInfo find(FCPort port) throws WBEMException {
        ResourceGroupInfo ret = null;
        FindMethodCallbackHandler<ResourceGroupInfo> callback = new FindMethodCallbackHandler<ResourceGroupInfo>();
        ResourceGroupInfo.getResourceInfo(port.getSerialNumber(), callback, null, null, null, port, false);
        ret = callback.getReturnValue();
        return ret;
    }

    public static ResourceGroupInfo find(ISCSITargetPort.ISCSITarget target) throws WBEMException {
        ResourceGroupInfo ret = null;
        FindMethodCallbackHandler<ResourceGroupInfo> callback = new FindMethodCallbackHandler<ResourceGroupInfo>();
        ResourceGroupInfo.getResourceInfo(target.getSerialNumber(), callback, null, null, null, target, null, null, false);
        ret = callback.getReturnValue();
        return ret;
    }

    public static ResourceGroupInfo find(PGInfo pgInfo) throws WBEMException {
        if (null == pgInfo) {
            throw new WBEMException("PGInfo parameter can not be null");
        }
        ResourceGroupInfo ret = null;
        FindMethodCallbackHandler<ResourceGroupInfo> callback = new FindMethodCallbackHandler<ResourceGroupInfo>();
        ResourceGroupInfo.getResourceInfo(pgInfo.getSerialNumber(), callback, null, pgInfo, null, null, false);
        ret = callback.getReturnValue();
        return ret;
    }

    public static ResourceGroupInfo find(PortandHostGroupInfo phgi) throws WBEMException {
        ResourceGroupInfo ret = null;
        FindMethodCallbackHandler<ResourceGroupInfo> callback = new FindMethodCallbackHandler<ResourceGroupInfo>();
        ResourceGroupInfo.getResourceInfo(phgi.getSerialNumber(), callback, null, null, phgi, null, false);
        ret = callback.getReturnValue();
        return ret;
    }

    public static ResourceGroupInfo find(String serialNumber, Short portID) throws WBEMException {
        ResourceGroupInfo ret = null;
        FindMethodCallbackHandler<ResourceGroupInfo> callback = new FindMethodCallbackHandler<ResourceGroupInfo>();
        ResourceGroupInfo.getResourceInfo(serialNumber, callback, null, null, null, null, null, portID, false);
        ret = callback.getReturnValue();
        return ret;
    }

    private static void findSpecificResourceGroupInfo(ResourceGroupInfo[] rsgInfos, String key, IteratorCallback<ResourceGroupInfo> callback, SearchType searchType, boolean continueOnError) {
        providerLogger.log(Level.INFO, "Searching {0}  ResourceGroupInfo for a {1} with ID: {2}", new Object[]{rsgInfos.length, searchType, key});
        TaskProcessor task = new TaskProcessor("RSG Find", rsgInfos.length);
        String serialNum = null;
        for (ResourceGroupInfo rsg : rsgInfos) {
            if (null == serialNum) {
                serialNum = rsg.getSerialNumber();
            }
            if (task.shouldStop()) {
                callback.done();
                break;
            }
            WorkerThread worker = new WorkerThread(serialNum, task, callback, rsg, key, searchType, continueOnError);
            task.addTask(worker);
        }
    }

    private static String getDNString(Robj_interface_RJiLDEVIndex ldev) {
        long dn = BaseDeviceNumber.makeUniqueDN(ldev.getSLDKC(), ldev.getSCU(), ldev.getSLDEV());
        return Long.toString(dn);
    }

    private static String getDNStringStr(long dn) {
        return Long.toString(dn);
    }

    private static String getHostGrpStr(ISCSITargetPort.ISCSITarget target) {
        return String.format("%d:%d", target.getPortID(), target.getId());
    }

    private static String getHostGrpStr(PortandHostGroupInfo phgi) {
        return String.format("%d:%d", phgi.getPortID(), phgi.getHostgroupID());
    }

    private static String getHostGrpStr(Robj_interface_RSGHostGroupIndex hostGrp) {
        return String.format("%d:%d", hostGrp.getSPort(), hostGrp.getSHostGroupId());
    }

    private static String getPGString(PGInfo pgInfo) {
        return String.format("%d-%d", pgInfo.getFB4(), pgInfo.getPG());
    }

    private static String getPGString(Robj_interface_RJiPGIndex vdev) {
        return String.format("%d-%d", vdev.getIFB4(), vdev.getIPG());
    }

    private static String getPortIDStr(Robj_interface_RJiPortIndex rsgPort) {
        return Short.toString(rsgPort.getSPort());
    }

    public static void getResourceInfo(String deviceSerial, IteratorCallback<ResourceGroupInfo> callback, BaseDeviceNumber dn, PGInfo pgInfo, PortandHostGroupInfo phgi, FCPort port, boolean continueOnError) throws WBEMException {
        ResourceGroupInfo.getResourceInfo(deviceSerial, callback, dn, pgInfo, phgi, null, port, null, continueOnError);
    }

    public static void getResourceInfo(String deviceSerial, IteratorCallback<ResourceGroupInfo> callback, BaseDeviceNumber dn, PGInfo pgInfo, PortandHostGroupInfo phgi, ISCSITargetPort.ISCSITarget target, FCPort port, boolean continueOnError) throws WBEMException {
        ResourceGroupInfo.getResourceInfo(deviceSerial, callback, dn, pgInfo, phgi, target, port, null, continueOnError);
    }

    public static void getResourceInfo(String deviceSerial, IteratorCallback<ResourceGroupInfo> callback, BaseDeviceNumber dn, PGInfo pgInfo, PortandHostGroupInfo phgi, ISCSITargetPort.ISCSITarget target, FCPort port, Short portID, boolean continueOnError) throws WBEMException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(deviceSerial).getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] rsgInfos = (ResourceGroupInfo[])cache.getCachedObject(null, clz);
            if (rsgInfos != null && rsgInfos.length > 0) {
                String key = null;
                SearchType searchType = SearchType.NONE;
                if (null != dn) {
                    key = ResourceGroupInfo.getDNStringStr(dn.getDn());
                    searchType = SearchType.DN;
                } else if (pgInfo != null) {
                    key = ResourceGroupInfo.getPGString(pgInfo);
                    searchType = SearchType.PG;
                } else if (phgi != null) {
                    key = ResourceGroupInfo.getHostGrpStr(phgi);
                    searchType = SearchType.PHGI;
                } else if (target != null) {
                    key = ResourceGroupInfo.getHostGrpStr(target);
                    searchType = SearchType.PHGI;
                } else if (null != port) {
                    key = Short.toString(port.getPort());
                    searchType = SearchType.PORT;
                } else if (null != portID) {
                    key = Short.toString(portID);
                    searchType = SearchType.PORT;
                }
                if (key == null) {
                    callback.returnItems(rsgInfos);
                } else {
                    ResourceGroupInfo.findSpecificResourceGroupInfo((ResourceGroupInfo[])rsgInfos, key, callback, searchType, continueOnError);
                }
            } else {
                providerLogger.warning("No ResourceGroupInfo in cache.");
                callback.done();
            }
        } else {
            String msg = String.format("ResourceGroupInfo class is not cached on %s", deviceSerial);
            cacheLogger.log(Level.WARNING, msg, new Exception(msg));
            ResourceGroupInfo.getUnCachedResourceInfo(deviceSerial, callback, dn, pgInfo, phgi, port, continueOnError);
        }
    }

    private static void getUnCachedResourceInfo(String devSerial, IteratorCallback<ResourceGroupInfo> callback, BaseDeviceNumber dn, PGInfo pgInfo, PortandHostGroupInfo phgi, FCPort port, boolean continueOnError) {
        block5: {
            try {
                RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(devSerial).getRMIObject();
                Robj_interface_RSGgetRsgs_IN rsgIN = (Robj_interface_RSGgetRsgs_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RSGGETRSGS_IN);
                Robj_interface_RSGgetRsgs_OUT rsgOUT = (Robj_interface_RSGgetRsgs_OUT)rmiObj.getCmnData(rsgIN);
                ArrayList rsgs = rsgOUT.getRsgs();
                cacheLogger.info("Found " + rsgs.size() + " Robj_interface_RSGgetRsg");
                if (rsgs.size() > 0) {
                    TaskProcessor task = new TaskProcessor("RSG Process", rsgs.size());
                    for (Robj_interface_RSGgetRsg rsg : rsgs) {
                        if (task.shouldStop()) {
                            callback.done();
                            break block5;
                        }
                        WorkerThread worker = new WorkerThread(devSerial, task, callback, rsg, dn, pgInfo, phgi, port, continueOnError);
                        ProcessTask.addTask(worker);
                    }
                    break block5;
                }
                callback.done();
            }
            catch (Throwable e) {
                WBEMException we = new WBEMException(1, e.toString(), null, e);
                callback.exceptionOccurred(we);
                callback.done();
            }
        }
    }

    private static void processChanges(ResourceGroupInfo cached, ResourceGroupInfo backend, Map<SearchType, TreeSet<String>> addedElements, Map<SearchType, TreeSet<String>> removedElements) {
        for (SearchType type : SearchType.values()) {
            if (SearchType.NONE == type) continue;
            Set added = addedElements.get((Object)type);
            Set removed = removedElements.get((Object)type);
            ResourceGroupInfo.determineWhatChanged(type, cached, backend, added, removed);
        }
    }

    private static boolean processRsgInfo(String serialNum, IteratorCallback<ResourceGroupInfo> callback, Robj_interface_RSGgetRsg infoDetail, BaseDeviceNumber mDN, PGInfo pgInfo, PortandHostGroupInfo phgi, FCPort portID, boolean continueOnError) {
        boolean matched = false;
        boolean filter = false;
        ArrayList ldevs = infoDetail.getLdevs();
        ArrayList vdevs = infoDetail.getVdevs();
        ArrayList hostGrps = infoDetail.getHostGrps();
        ArrayList ports = infoDetail.getPorts();
        if (null != mDN) {
            filter = true;
            for (Robj_interface_RJiLDEVIndex ldev : ldevs) {
                if (ldev.getSLDKC() != mDN.getLdkc() || ldev.getSCU() != mDN.getCu() || ldev.getSLDEV() != mDN.getLdev()) continue;
                matched = true;
                break;
            }
        } else if (pgInfo != null) {
            filter = true;
            for (Robj_interface_RJiPGIndex vdev : vdevs) {
                if (pgInfo.getFB4() != vdev.getIFB4() || pgInfo.getPG() != vdev.getIPG()) continue;
                matched = true;
                break;
            }
        }
        if (phgi != null) {
            filter = true;
            for (Robj_interface_RSGHostGroupIndex hostGrp : hostGrps) {
                if (hostGrp.getSPort() != phgi.getPortID() || hostGrp.getSHostGroupId() != phgi.getHostgroupID()) continue;
                matched = true;
                break;
            }
        } else if (null != portID) {
            filter = true;
            for (Robj_interface_RJiPortIndex port : ports) {
                if (port.getSPort() != portID.getPort()) continue;
                matched = true;
                break;
            }
        } else {
            filter = false;
            matched = true;
        }
        if (matched) {
            ResourceGroupInfo t = new ResourceGroupInfo(serialNum, infoDetail.getRsg(), ldevs, vdevs, ports, hostGrps);
            callback.returnItem(t);
        }
        return !filter;
    }

    private ResourceGroupInfo(ResourceGroupInfo other) {
        this(other.getSerialNumber(), other.getId(), other.getNickName());
        this.copy(other);
    }

    private ResourceGroupInfo(String serialNumber, int id, String nickName) {
        super(serialNumber);
        this.id = id;
        this.nickName = nickName;
        this.dns = new TreeSet();
        this.pgs = new TreeSet();
        this.ports = new TreeSet();
        this.hostGrps = new TreeSet();
    }

    private ResourceGroupInfo(String serialNum, Robj_interface_RSGInfo rsgInfo, ArrayList<Robj_interface_RJiLDEVIndex> rsgLDEVs, ArrayList<Robj_interface_RJiPGIndex> rsgVDEVs, ArrayList<Robj_interface_RJiPortIndex> rsgPorts, ArrayList<Robj_interface_RSGHostGroupIndex> rsgHostGrps) {
        this(serialNum, rsgInfo.getRsgId(), rsgInfo.getNickname());
        for (Robj_interface_RJiLDEVIndex ldev : rsgLDEVs) {
            String dnStr = ResourceGroupInfo.getDNString(ldev);
            this.dns.add(dnStr);
        }
        for (Robj_interface_RJiPGIndex vdev : rsgVDEVs) {
            String pg = ResourceGroupInfo.getPGString(vdev);
            this.pgs.add(pg);
        }
        for (Robj_interface_RJiPortIndex rsgPort : rsgPorts) {
            String port = ResourceGroupInfo.getPortIDStr(rsgPort);
            this.ports.add(port);
        }
        for (Robj_interface_RSGHostGroupIndex hostGrp : rsgHostGrps) {
            String hostGrpStr = ResourceGroupInfo.getHostGrpStr(hostGrp);
            this.hostGrps.add(hostGrpStr);
        }
    }

    @Override
    public int compareTo(ResourceGroupInfo o) {
        Integer first = new Integer(this.id);
        Integer second = new Integer(o.getId());
        return first.compareTo(second);
    }

    private void copy(ResourceGroupInfo other) {
        this.id = other.getId();
        this.nickName = new String(other.getNickName());
        this.dns.clear();
        this.dns.addAll(other.dns);
        this.pgs.clear();
        this.pgs.addAll(other.pgs);
        this.ports.clear();
        this.ports.addAll(other.ports);
        this.hostGrps.clear();
        this.hostGrps.addAll(other.hostGrps);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceGroupInfo other = (ResourceGroupInfo)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.nickName == null ? other.nickName != null : !this.nickName.equals(other.nickName)) {
            return false;
        }
        if (!this.dns.equals(other.dns)) {
            return false;
        }
        if (!this.hostGrps.equals(other.hostGrps)) {
            return false;
        }
        if (!this.pgs.equals(other.pgs)) {
            return false;
        }
        return this.ports.equals(other.ports);
    }

    public int getId() {
        return this.id;
    }

    public String getNickName() {
        return this.nickName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dns == null ? 0 : this.dns.hashCode());
        result = 31 * result + (this.hostGrps == null ? 0 : this.hostGrps.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.nickName == null ? 0 : this.nickName.hashCode());
        result = 31 * result + (this.pgs == null ? 0 : this.pgs.hashCode());
        result = 31 * result + (this.ports == null ? 0 : this.ports.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceGroupInfo [id=");
        builder.append(this.id);
        builder.append(", nickName=");
        builder.append(this.nickName);
        builder.append("]");
        return builder.toString();
    }

    private static class WorkerThread
    implements Task {
        private Robj_interface_RSGgetRsg mInfoDetail;
        private BaseDeviceNumber mDN;
        private PGInfo mPGInfo;
        private PortandHostGroupInfo mPHGI;
        private FCPort mPort;
        private final TaskProcessor mTheTask;
        private final IteratorCallback<ResourceGroupInfo> mCallback;
        private final boolean mContinueOnError;
        private ResourceGroupInfo mRSG;
        private String mKey;
        private boolean mSearch;
        private SearchType mSearchType;
        private final String serialNum;

        private WorkerThread(String serialNum, TaskProcessor task, IteratorCallback<ResourceGroupInfo> callback, boolean continueOnError) {
            this.serialNum = serialNum;
            this.mTheTask = task;
            this.mCallback = callback;
            this.mContinueOnError = continueOnError;
            this.mInfoDetail = null;
            this.mDN = null;
            this.mPGInfo = null;
            this.mPHGI = null;
            this.mPort = null;
            this.mRSG = null;
            this.mKey = null;
            this.mSearch = false;
            this.mSearchType = SearchType.NONE;
        }

        public WorkerThread(String serialNum, TaskProcessor task, IteratorCallback<ResourceGroupInfo> callback, ResourceGroupInfo rsg, String key, SearchType searchType, boolean continueOnError) {
            this(serialNum, task, callback, continueOnError);
            this.mRSG = rsg;
            this.mKey = key;
            this.mSearch = true;
            this.mSearchType = searchType;
        }

        private WorkerThread(String serialNum, TaskProcessor theTask, IteratorCallback<ResourceGroupInfo> callback, Robj_interface_RSGgetRsg infoDetail, BaseDeviceNumber dn, PGInfo pgInfo, PortandHostGroupInfo phgi, FCPort port, boolean continueOnError) {
            this(serialNum, theTask, callback, continueOnError);
            this.mInfoDetail = infoDetail;
            this.mPort = port;
            this.mDN = dn;
            this.mPGInfo = pgInfo;
            this.mPHGI = phgi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                boolean ret;
                if (!this.mTheTask.shouldStop() && !(ret = !this.mSearch ? ResourceGroupInfo.processRsgInfo(this.serialNum, this.mCallback, this.mInfoDetail, this.mDN, this.mPGInfo, this.mPHGI, this.mPort, this.mContinueOnError) : this.searchForResourceGroupInfo())) {
                    this.mTheTask.setStop(true);
                }
            }
            catch (Exception e) {
                WBEMException we = new WBEMException(1, "Exception while processing items", null, (Throwable)e);
                this.mCallback.exceptionOccurred(we);
                this.mTheTask.setStop(true);
            }
            finally {
                int counter = this.mTheTask.taskDone();
                if (counter < 1) {
                    this.mCallback.done();
                }
            }
        }

        private boolean searchForResourceGroupInfo() {
            TreeSet set2Search;
            boolean ret = true;
            switch (this.mSearchType) {
                case DN: {
                    set2Search = this.mRSG.dns;
                    break;
                }
                case PG: {
                    set2Search = this.mRSG.pgs;
                    break;
                }
                case PHGI: {
                    set2Search = this.mRSG.hostGrps;
                    break;
                }
                case PORT: {
                    set2Search = this.mRSG.ports;
                    break;
                }
                default: {
                    set2Search = null;
                }
            }
            if (set2Search != null) {
                boolean match = set2Search.contains(this.mKey);
                if (match) {
                    this.mCallback.returnItem(this.mRSG);
                    ret = false;
                } else {
                    ret = true;
                }
            }
            return ret;
        }
    }

    public static enum SearchType {
        NONE,
        DN,
        PG,
        PHGI,
        PORT;

    }
}

