/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.HitachiCacheMangerService;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.Wait4ProcessTasks;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.DaemonThreadFactory;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJiHURget1PairSummaryInfo;
import sanproject.common.Robj_interface_RJiHURgetPairsInfo_IN;
import sanproject.common.Robj_interface_RJiHURgetPairsInfo_OUT;
import sanproject.common.Robj_interface_RJiInputHurPairParam;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail2;
import sanproject.common.Robj_interface_RJiLUPathIndex;
import sanproject.common.Robj_interface_RJiRMCPget1PairSummary;
import sanproject.common.Robj_interface_RJiRMCPget1PairSummaryEx;
import sanproject.common.Robj_interface_RJiRMCPgetHorcPairLU;
import sanproject.common.Robj_interface_RJiRMCPgetPair;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class RmcpPairInfo
extends AbstractBaseCommonObject
implements Comparable<RmcpPairInfo> {
    private static final int VOLUME_TYPE_BIT = 1;
    private static final long serialVersionUID = 1L;
    private static final ExecutorService executor = Executors.newFixedThreadPool(2, (ThreadFactory)new DaemonThreadFactory());
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private static boolean processing;
    private static Class<RmcpPairInfo[]> clz;
    private long dn;
    private int pairStatus = -1;
    private BitSet pairType = null;
    private String pairSN = "";
    private long targetDN = -1L;
    private int tracks = -1;
    private int pairRCUID = -1;
    private int pairSSID = -1;
    private int pairCtrlID = -1;
    private int async = -1;
    private String hostPairStatus = "";
    private int pairOptionBehavior = -1;
    private int luPairGroupNo = -1;
    private int luPairPortNo = -1;
    private int luPairLUN = -1;
    private String ndPairCopyTime = "";
    private int ndCopyProgress = -1;
    private String ndCreateTime = "";
    private String ndPairRenewTime = "";
    private int ndPriority = -1;
    private boolean trueCopy = true;
    private int ctgGroup;
    private int hurDiff = -1;
    private int hurPathType = -1;
    private int hurErrLvl = -1;
    private int hurExternal = -1;
    private int hurAgree = -1;
    private int hurDelta = -1;
    private int hurIntermix = -1;
    private int hurCFW = -1;
    private int hurMJournalGrp = -1;
    private int hurRJournalGrp = -1;
    private int hurMirrorID = -1;
    private int hurSeqChk = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException {
        String serialNum = rmiMapping.getSerialNumber();
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            mLogger.severe("RmcpPairInfo is already cached!");
            return;
        }
        try {
            RmcpPairInfo.setProcessing(true);
            ClosableAddableIteratorCB<RmcpPairInfo> callback = new ClosableAddableIteratorCB<RmcpPairInfo>();
            RmcpPairInfo.prepare4RmcpCall(callback, serialNum, null, PairCheckType.ALL);
            ArrayList<RmcpPairInfo> rmcps = new ArrayList<RmcpPairInfo>();
            CloseableAddableIterator<RmcpPairInfo> rmcpIter = callback.getWrappedCloseableAddableIter();
            while (rmcpIter.hasNext()) {
                RmcpPairInfo rmcp = (RmcpPairInfo)rmcpIter.next();
                rmcps.add(rmcp);
            }
            CacheLib.addDataToCache(Collections.emptyMap(), rmcps, clz, serialNum);
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Unexpected exception in Rmcp thread", t);
        }
        finally {
            RmcpPairInfo.setProcessing(false);
        }
    }

    private static void callGetHURPair(String serialNum, IteratorCallback<RmcpPairInfo> callerIter, Robj_interface_RJiLDEVInfoDetail2[] ldevs) throws RemoteException, GetRmiException, WBEMException, SANRmiException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
        long start = System.currentTimeMillis();
        cacheLogger.finer("Calling RMIObj.createObj for IN class");
        Robj_interface_RJiHURgetPairsInfo_IN in = (Robj_interface_RJiHURgetPairsInfo_IN)rmiObj.createObj(117769473);
        cacheLogger.finer("Calling RMIObj.createObj for parameter");
        Robj_interface_RJiInputHurPairParam param = (Robj_interface_RJiInputHurPairParam)rmiObj.createObj(100729010);
        param.setPP((short)1);
        param.setLDEVs((Robj_interface_RJiLDEVIndex[])ldevs);
        param.setFilterVolType((short)-1);
        param.setFilterStatus((short)511);
        in.setHurPairParamIn(param);
        cacheLogger.finer("Calling RMIObj.getCmnData for HUR Out object");
        Robj_interface_RJiHURgetPairsInfo_OUT result = (Robj_interface_RJiHURgetPairsInfo_OUT)rmiObj.getCmnData(in);
        ArrayList pairsInfo = result.getDataObject().getPairInfo();
        cacheLogger.log(Level.INFO, "Got {0} HUR Data", pairsInfo.size());
        if (pairsInfo.size() > 0) {
            for (int idx = 0; idx < pairsInfo.size(); ++idx) {
                Robj_interface_RJiHURget1PairSummaryInfo mPairSummary = (Robj_interface_RJiHURget1PairSummaryInfo)pairsInfo.get(idx);
                if (0 == mPairSummary.getPairStatus()) continue;
                callerIter.returnItem(new RmcpPairInfo(serialNum, mPairSummary));
            }
        }
        mLogger.log(Level.INFO, "callGetHurPair({0}) took {1} millis.", new Object[]{ldevs.length, System.currentTimeMillis() - start});
    }

    private static void callGetRmcpPair(String serialNum, IteratorCallback<RmcpPairInfo> callerIter, Robj_interface_RJiLDEVInfoDetail2[] indexesLDEV) throws RemoteException, GetRmiException, WBEMException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
        long start = System.currentTimeMillis();
        mLogger.log(Level.INFO, "entering callGetRmcpPair({0})", indexesLDEV.length);
        int MAX_ARRAY_SIZE = 4096;
        int numCalls = indexesLDEV.length / 4096;
        int remainder = indexesLDEV.length % 4096;
        int totalCalls = numCalls + (remainder > 0 ? 1 : 0);
        mLogger.log(Level.INFO, "Calling getRmcpPair: {0} times", totalCalls);
        int x = 0;
        int size = numCalls > 0 ? 4096 : remainder;
        Robj_interface_RJiLDEVIndex[] callParam = new Robj_interface_RJiLDEVIndex[size];
        int numElements2Copy = size;
        ArrayList<Wait4ProcessTasks> tasks = new ArrayList<Wait4ProcessTasks>(totalCalls);
        for (x = 0; x < totalCalls; ++x) {
            if (x != 0 && x == numCalls) {
                callParam = new Robj_interface_RJiLDEVIndex[remainder];
                numElements2Copy = remainder;
            }
            System.arraycopy(indexesLDEV, 4096 * x, callParam, 0, numElements2Copy);
            mLogger.info("Calling getRmcpPair with " + callParam.length + " items");
            Robj_interface_RJiRMCPgetPair rmcpPair = rmiObj.getRmcpPair(1, callParam);
            Robj_interface_RJiRMCPget1PairSummary[] pairSummaries = rmcpPair.get_PairSummary();
            mLogger.log(Level.FINEST, "get_PairSummary() returned: {0}", pairSummaries.length);
            Wait4ProcessTasks task = new Wait4ProcessTasks(pairSummaries.length);
            tasks.add(task);
            for (Robj_interface_RJiRMCPget1PairSummary pairSummary : pairSummaries) {
                TrueCopyWorkerThread worker = new TrueCopyWorkerThread(task, pairSummary, callerIter, serialNum);
                ProcessTask.addTask(worker);
            }
        }
        mLogger.log(Level.INFO, "{0} RMI calls made, waiting for tasks to complete.", tasks.size());
        for (Wait4ProcessTasks task : tasks) {
            task.processingDone();
        }
        mLogger.log(Level.INFO, "callGetRmcp({0}) took {1} millis.", new Object[]{indexesLDEV.length, System.currentTimeMillis() - start});
    }

    public static void checkCachedPairs(RMIObjectCache rmiObj, PairCheckType type, Robj_interface_RJiLDEVIndex[] lDEVIndexes2Get, List<RmcpPairInfo> added, List<RmcpPairInfo> modified, List<RmcpPairInfo> removed) throws WBEMException {
        if (type != PairCheckType.TC && type != PairCheckType.HUR) {
            throw new WBEMException("PairCheckType must be TC or HUR");
        }
        try {
            HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
            if (cache.isCached(clz)) {
                RmcpPairInfo cachedPairInfo;
                CommonClassAsList<RmcpPairInfo> callback = new CommonClassAsList<RmcpPairInfo>();
                RmcpPairInfo.get(rmiObj, callback, -1L);
                LinkedList<RmcpPairInfo> cachedList = callback.getReturnValue();
                Collections.sort(cachedList);
                callback = new CommonClassAsList();
                RmcpPairInfo.getUncached(rmiObj, callback, lDEVIndexes2Get, type);
                LinkedList<RmcpPairInfo> backEndList = callback.getReturnValue();
                callback = null;
                Collections.sort(backEndList);
                while (null != (cachedPairInfo = cachedList.poll())) {
                    if (type == PairCheckType.TC && cachedPairInfo.isHURPair() || type == PairCheckType.HUR && cachedPairInfo.isTrueCopyPair()) continue;
                    int idx = Collections.binarySearch(backEndList, cachedPairInfo);
                    if (idx > -1) {
                        RmcpPairInfo backEndPairInfo = backEndList.remove(idx);
                        if (backEndPairInfo.equals(cachedPairInfo)) continue;
                        modified.add(new RmcpPairInfo(cachedPairInfo));
                        cachedPairInfo.copy(backEndPairInfo);
                        continue;
                    }
                    if (null == lDEVIndexes2Get) continue;
                    removed.add(cachedPairInfo);
                }
                if (!backEndList.isEmpty()) {
                    cache.addCacheObject(clz, backEndList);
                    added.addAll(backEndList);
                }
                if (!removed.isEmpty()) {
                    CacheLib.removeDataFromCache(Collections.emptyMap(), (Serializable[])removed.toArray(new RmcpPairInfo[removed.size()]), clz, (String)rmiObj.getSMISMappingContainer().getSerialNumber());
                }
            } else {
                RmcpPairInfo.cache(rmiObj.getSMISMappingContainer());
                if (cache.isCached(clz)) {
                    CommonClassAsList<RmcpPairInfo> cached = new CommonClassAsList<RmcpPairInfo>();
                    RmcpPairInfo.get(rmiObj, cached, -1L);
                    added.addAll(cached.getReturnValue());
                }
            }
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception getting RmcpPairInfo on " + rmiObj.getSMISMappingContainer().getSerialNumber() + " - " + (Object)((Object)e), e);
        }
    }

    public static RmcpPairInfo find(RMIObjectCache rmiObj, long dnNum) throws WBEMException {
        FindMethodCallbackHandler<RmcpPairInfo> finder = new FindMethodCallbackHandler<RmcpPairInfo>();
        RmcpPairInfo.get(rmiObj, finder, dnNum);
        return finder.getReturnValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void get(RMIObjectCache rmiObj, IteratorCallback<RmcpPairInfo> callback, long dnNum) throws WBEMException {
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        try {
            if (!cache.isCached(clz)) {
                mLogger.log(Level.WARNING, "get: RMCPPairInfo is not cached for {0}, this is a serious performance issue", rmiObj.getSMISMappingContainer());
                RmcpPairInfo.getUncached(rmiObj, callback, dnNum);
                return;
            }
            Object[] rmcps = (RmcpPairInfo[])cache.getCachedObject(clz);
            mLogger.log(Level.INFO, "Found {0} RmcpPairInfo objects in cache", rmcps.length);
            if (dnNum > -1L) {
                Arrays.sort(rmcps);
                int index = Arrays.binarySearch(rmcps, new RmcpPairInfo(rmiObj.getSMISMappingContainer().getSerialNumber(), dnNum));
                if (index > -1) {
                    boolean done = false;
                    for (int idx = index; idx < rmcps.length && !done; ++idx) {
                        Object rmcp = rmcps[idx];
                        if (dnNum == ((RmcpPairInfo)rmcp).getDn()) {
                            callback.returnItem((RmcpPairInfo)rmcp);
                            continue;
                        }
                        done = true;
                    }
                } else {
                    mLogger.log(Level.FINER, "No RmcpPairInfo matched DN {0}, this is probably OK", dnNum);
                }
            } else {
                callback.returnItems((AbstractBaseCommonObject[])rmcps);
            }
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            WBEMException we = new WBEMException(1, t.toString(), null, t);
            callback.exceptionOccurred(we);
        }
        finally {
            callback.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAllMatches(RMIObjectCache rmiObj, IteratorCallback<RmcpPairInfo> callback, long dnNum) throws WBEMException {
        try {
            ClosableAddableIteratorCB<RmcpPairInfo> cb = new ClosableAddableIteratorCB<RmcpPairInfo>();
            RmcpPairInfo.get(rmiObj, cb, -1L);
            CloseableAddableIterator<RmcpPairInfo> rmcps = cb.getWrappedCloseableAddableIter();
            while (rmcps.hasNext()) {
                RmcpPairInfo rmcp = (RmcpPairInfo)rmcps.next();
                if (rmcp.getDn() != dnNum && rmcp.getTargetDN() != dnNum) continue;
                callback.returnItem(rmcp);
            }
        }
        catch (Throwable t) {
            while (null != t.getCause()) {
                t = t.getCause();
            }
            WBEMException we = new WBEMException(1, t.toString(), null, t);
            callback.exceptionOccurred(we);
        }
        finally {
            callback.done();
        }
    }

    private static Robj_interface_RJiLDEVInfoDetail2[] getInfoDetails(String serialNum, Robj_interface_RJiLDEVIndex[] ldevIdxArray) throws WBEMException, RemoteException, SANRmiException {
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
        Robj_interface_RJSetGettingParamLDEV paramLDEV = (Robj_interface_RJSetGettingParamLDEV)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.SetGettingLDEV);
        paramLDEV.setBAll(true);
        mLogger.finest("Getting details for: " + ldevIdxArray.length + " LDEVs");
        Robj_interface_RJiLDEVInfoDetail2[] infoDetails = rmiObj.getLDEVInfoDetail2(ldevIdxArray, paramLDEV);
        mLogger.finest("getLDEVInfoDetail2 returned: " + infoDetails.length);
        return infoDetails;
    }

    private static Robj_interface_RJiLDEVInfoDetail2[] getLDEVIndexes(String serialNum, Robj_interface_RJiLDEVIndex[] requestedLDEVs) throws RemoteException, SANRmiException, GetRmiException, WBEMException {
        Robj_interface_RJiLDEVIndex[] ldevIdxArray;
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
        if (requestedLDEVs == null) {
            ldevIdxArray = rmiObj.getLDEVIndex();
        } else {
            ldevIdxArray = requestedLDEVs;
            requestedLDEVs = null;
        }
        return RmcpPairInfo.getInfoDetails(serialNum, ldevIdxArray);
    }

    private static void getUncached(RMIObjectCache rmiObj, IteratorCallback<RmcpPairInfo> callback, long dnNum) throws WBEMException {
        Robj_interface_RJiLDEVIndex[] ldevs = null;
        if (-1L != dnNum) {
            ldevs = new Robj_interface_RJiLDEVIndex[1];
            short[] dkcCUldev = BaseDeviceNumber.getDevIdStringValues(Long.toBinaryString(dnNum));
            try {
                ldevs[0] = (Robj_interface_RJiLDEVIndex)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
            }
            catch (RemoteException | SANRmiException e) {
                Throwable t = e;
                if (null != t.getCause()) {
                    t = t.getCause();
                }
                WBEMException we = new WBEMException(1, t.toString(), null, t);
                callback.exceptionOccurred(we);
                throw we;
            }
            ldevs[0].setSLDKC(dkcCUldev[0]);
            ldevs[0].setSCU(dkcCUldev[1]);
            ldevs[0].setSLDEV(dkcCUldev[2]);
        }
        RmcpPairInfo.getUncached(rmiObj, callback, ldevs, PairCheckType.ALL);
    }

    private static void getUncached(RMIObjectCache rmiObj, IteratorCallback<RmcpPairInfo> callback, Robj_interface_RJiLDEVIndex[] ldevs, PairCheckType type) throws WBEMException {
        try {
            RmcpPairInfo.prepare4RmcpCall(callback, rmiObj.getSMISMappingContainer().getSerialNumber(), ldevs, type);
        }
        catch (WBEMException we) {
            callback.exceptionOccurred(we);
            throw we;
        }
        catch (Throwable t) {
            if (null != t.getCause()) {
                t = t.getCause();
            }
            WBEMException we = new WBEMException(1, t.toString(), null, t);
            callback.exceptionOccurred(we);
            throw we;
        }
        finally {
            callback.done();
        }
    }

    static synchronized boolean isProcessing() {
        return processing;
    }

    public static boolean isRemoteReplica(DeviceNumber pDNTargetVol) {
        CommonClassAsList<RmcpPairInfo> callback = new CommonClassAsList<RmcpPairInfo>();
        boolean remoteReplica = false;
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(pDNTargetVol.getSerialNumber()).getRMIObject();
            RmcpPairInfo.get(rmiObj, callback, pDNTargetVol.getDn());
            LinkedList<RmcpPairInfo> tmp = callback.getReturnValue();
            if (null != tmp && !tmp.isEmpty()) {
                remoteReplica = true;
            }
        }
        catch (WBEMException e) {
            remoteReplica = false;
            mLogger.log(Level.SEVERE, "Exception getting remote copy data for DN " + pDNTargetVol.getDNAsString(), e);
        }
        return remoteReplica;
    }

    private static boolean isValidDNForRcmp(Robj_interface_RJiLDEVInfoDetail2 infoDetail) throws RemoteException, SANRmiException {
        boolean ret = true;
        if (infoDetail.isBLUPathCmdDev() || infoDetail.isBSystemDisk() || infoDetail.isBPoolVol()) {
            mLogger.log(Level.FINEST, "skipping (dkc:cu:ldev): {0}:{1}:{2} - isBLUPathCmdDev() = {3} || isBSystemDisk() = {4} || isBPoolVol() = {5}", new Object[]{infoDetail.getSLDKC(), infoDetail.getSCU(), infoDetail.getSLDEV(), infoDetail.isBLUPathCmdDev(), infoDetail.isBSystemDisk(), infoDetail.isBPoolVol()});
            ret = false;
        } else if (infoDetail.isQSVvol() || infoDetail.isBJNLVolume() || infoDetail.isExternalMFVolume() || infoDetail.isBLockVolume()) {
            mLogger.log(Level.FINEST, "skipping (dkc:cu:ldev): {0}:{1}:2} - isQSVvol() = {3} || isBJNLVolume() = {4} || isExternalMFVolume() = {5} || isBLockVolume() = {6}", new Object[]{infoDetail.getSLDKC(), infoDetail.getSCU(), infoDetail.getSLDEV(), infoDetail.isQSVvol(), infoDetail.isBJNLVolume(), infoDetail.isExternalMFVolume(), infoDetail.isBLockVolume()});
            ret = false;
        } else if (infoDetail.getSLUSEElmCount() == 0) {
            mLogger.log(Level.FINEST, "skipping (dkc:cu:ldev): {0}:{1}:{3} - getSLUSEElmCount() = {4}", new Object[]{infoDetail.getSLDKC(), infoDetail.getSCU(), infoDetail.getSLDEV(), infoDetail.getSLUSEElmCount()});
            ret = false;
        } else if (infoDetail.getByVolumeType() == 2 || infoDetail.getByVolumeType() == 4) {
            mLogger.log(Level.FINEST, "skipping (dkc:cu:ldev): {0}:{1}:{2} - getByVolumeType() = {4}", new Object[]{infoDetail.getSLDKC(), infoDetail.getSCU(), infoDetail.getSLDEV(), infoDetail.getByVolumeType()});
            ret = false;
        } else if (infoDetail.isOpenVolume() && infoDetail.getILUPathNumber() == 0) {
            ret = false;
        }
        return ret;
    }

    private static void prepare4RmcpCall(IteratorCallback<RmcpPairInfo> callback, String serialNum, Robj_interface_RJiLDEVIndex[] lDEVIndexes2Get, PairCheckType type) throws RemoteException, GetRmiException, SANRmiException, WBEMException {
        Robj_interface_RJiLDEVInfoDetail2[] details = RmcpPairInfo.getLDEVIndexes(serialNum, lDEVIndexes2Get);
        mLogger.log(Level.FINEST, "Getting {0} LDEVs on {1} for RmcpPairInfo", new Object[]{details.length, serialNum});
        ArrayList<Robj_interface_RJiLDEVInfoDetail2> copiedIndexes = new ArrayList<Robj_interface_RJiLDEVInfoDetail2>(details.length);
        long startFirstLoop = System.currentTimeMillis();
        for (Robj_interface_RJiLDEVInfoDetail2 detail : details) {
            if (!RmcpPairInfo.isValidDNForRcmp(detail)) continue;
            copiedIndexes.add(detail);
        }
        long startSecondLoop = System.currentTimeMillis();
        mLogger.log(Level.FINEST, "Populating usable LDEVs took {0} millis", startSecondLoop - startFirstLoop);
        try {
            if (copiedIndexes.size() > 0) {
                Robj_interface_RJiLDEVInfoDetail2[] ldevs = copiedIndexes.toArray(new Robj_interface_RJiLDEVInfoDetail2[copiedIndexes.size()]);
                RMIApiCallThread tc = null;
                boolean tcDone = true;
                if (type == PairCheckType.ALL || type == PairCheckType.TC) {
                    tcDone = false;
                    tc = new RMIApiCallThread(serialNum, callback, ldevs, PairCheckType.TC);
                    executor.execute(tc);
                }
                RMIApiCallThread hur = null;
                boolean hurDone = true;
                if (type == PairCheckType.ALL || type == PairCheckType.HUR) {
                    hurDone = false;
                    hur = new RMIApiCallThread(serialNum, callback, ldevs, PairCheckType.HUR);
                    executor.execute(hur);
                }
                while (!(HitachiCacheMangerService.isShuttingDown() || tcDone && hurDone)) {
                    cacheLogger.info("TC & HUR threads not done, wait 5 seconds");
                    Thread.sleep(5000L);
                    if (null != tc && !tcDone) {
                        tcDone = tc.isDone();
                    }
                    if (null == hur || hurDone) continue;
                    hurDone = hur.isDone();
                }
            }
        }
        catch (InterruptedException e) {
            throw new WBEMException(1, "Wait interupted", null, (Throwable)e);
        }
        finally {
            callback.done();
        }
    }

    static synchronized void setProcessing(boolean processing) {
        RmcpPairInfo.processing = processing;
    }

    public RmcpPairInfo(RmcpPairInfo original) {
        this(original.getSerialNumber());
        this.copy(original);
    }

    private RmcpPairInfo(String serialNum) {
        super(serialNum);
    }

    private RmcpPairInfo(String serialNum, long dn) {
        this(serialNum);
        this.dn = dn;
    }

    private RmcpPairInfo(String serialNum, Robj_interface_RJiHURget1PairSummaryInfo pairSummary) throws WBEMException {
        this(serialNum);
        if (null != pairSummary) {
            this.trueCopy = false;
            Robj_interface_RJiLUPathIndex pvol = pairSummary.getPVolInfo();
            this.dn = BaseDeviceNumber.makeUniqueDN(pvol.getSLDKC(), pvol.getSCU(), pvol.getSLDEV());
            cacheLogger.log(Level.FINER, "P-Vol:\t {0}", this.dn);
            Robj_interface_RJiLUPathIndex svol = pairSummary.getSVolInfo();
            this.targetDN = BaseDeviceNumber.makeUniqueDN(svol.getSLDKC(), svol.getSCU(), svol.getSLDEV());
            cacheLogger.log(Level.FINER, "S-Vol:\t {0}", this.targetDN);
            this.ctgGroup = pairSummary.isCtgEnable() ? pairSummary.getCTGrp() : -1;
            this.hostPairStatus = pairSummary.getHostPairStatus();
            this.pairCtrlID = pairSummary.getModelID();
            this.pairType = new BitSet();
            if (1 == pairSummary.getPairKind()) {
                this.pairType.set(1);
            }
        } else {
            throw new WBEMException(1, "HUR pair summary was null");
        }
        this.pairSN = pairSummary.getPairSN();
        this.pairStatus = pairSummary.getPairStatus();
        this.luPairGroupNo = pairSummary.getPathID();
        this.ndPriority = pairSummary.getPriority();
        this.ndCopyProgress = pairSummary.getProgress();
        this.ndPairCopyTime = pairSummary.getCopyTime();
        this.hurErrLvl = pairSummary.getErrLv();
        this.hurExternal = pairSummary.getExternal();
        this.hurDiff = pairSummary.getDiff();
        this.hurSeqChk = pairSummary.getSEQCHK();
        this.hurAgree = pairSummary.getAgree();
        this.hurDelta = pairSummary.getDelta();
        this.hurIntermix = pairSummary.getIntermix();
        this.hurCFW = pairSummary.getCFW();
        this.hurMJournalGrp = pairSummary.getMjnlGrp();
        this.hurRJournalGrp = pairSummary.getRjnlGrp();
        this.hurMirrorID = pairSummary.getMirrorID();
        this.hurPathType = pairSummary.getPathType();
    }

    private RmcpPairInfo(String serialNum, Robj_interface_RJiRMCPget1PairSummary pairSummary) throws WBEMException {
        this(serialNum);
        if (null != pairSummary) {
            this.trueCopy = true;
            this.pairType = BitSet.valueOf(new long[]{pairSummary.getType()});
            if (!this.isSecondaryVol()) {
                this.dn = BaseDeviceNumber.makeUniqueDN(pairSummary.getSLDKC(), pairSummary.getSCU(), pairSummary.getSLDEV());
                this.targetDN = BaseDeviceNumber.makeUniqueDN(pairSummary.getPairLDKC(), pairSummary.getPairCUNo(), pairSummary.getPairLDEVNo());
            } else {
                this.targetDN = BaseDeviceNumber.makeUniqueDN(pairSummary.getSLDKC(), pairSummary.getSCU(), pairSummary.getSLDEV());
                this.dn = BaseDeviceNumber.makeUniqueDN(pairSummary.getPairLDKC(), pairSummary.getPairCUNo(), pairSummary.getPairLDEVNo());
            }
            this.pairStatus = pairSummary.getPairStatus();
            this.pairSN = pairSummary.getPairSN();
            this.tracks = pairSummary.getTracks();
            this.pairRCUID = pairSummary.getPairRCUID();
            this.pairSSID = pairSummary.getPairSSID();
            this.pairCtrlID = pairSummary.getPairControllerID();
            this.async = pairSummary.getAsync();
            this.ndPairCopyTime = pairSummary.getPairCopyTime();
            this.ndCopyProgress = pairSummary.getCopyProgress();
            this.ndCreateTime = pairSummary.getPairCreateTime();
            this.ndPairRenewTime = pairSummary.getPairRenewTime();
            this.ndPriority = pairSummary.getPriority();
            this.pairOptionBehavior = pairSummary.getPairOption().getBehavior();
            this.ctgGroup = (this.pairOptionBehavior & 0x2000) != 0 ? this.getAsync() & 0x3FF : -1;
            Robj_interface_RJiRMCPgetHorcPairLU tmp = pairSummary.getPairLU();
            this.luPairGroupNo = tmp.getGroupNo();
            this.luPairPortNo = tmp.getPortNo();
            this.luPairLUN = tmp.getLUN();
            this.hostPairStatus = pairSummary instanceof Robj_interface_RJiRMCPget1PairSummaryEx ? ((Robj_interface_RJiRMCPget1PairSummaryEx)pairSummary).getsHostPairStatus() : "";
        } else {
            throw new WBEMException(1, "RMCP pair summary was null");
        }
    }

    @Override
    public int compareTo(RmcpPairInfo other) {
        int ret;
        int n = this.dn < other.dn ? -1 : (ret = this.dn > other.dn ? 1 : 0);
        if (0 == ret && 0 == (ret = this.getPairSN().compareToIgnoreCase(other.getPairSN())) && -1L != other.getTargetDN()) {
            ret = this.targetDN < other.targetDN ? -1 : (this.targetDN > other.targetDN ? 1 : 0);
        }
        return ret;
    }

    private void copy(RmcpPairInfo original) {
        this.dn = original.getDn();
        this.trueCopy = original.isTrueCopyPair();
        this.pairStatus = original.getPairStatus();
        this.pairType = original.getPairType();
        this.pairSN = original.getPairSN();
        this.targetDN = original.getTargetDN();
        this.tracks = original.getTracks();
        this.pairRCUID = original.getPairRCUID();
        this.pairSSID = original.getPairSSID();
        this.pairCtrlID = original.getPairCtrlID();
        this.async = original.getAsync();
        this.ndPairCopyTime = original.getPairCopyTime();
        this.ndCopyProgress = original.getCopyProgress();
        this.ndCreateTime = original.getPairCreateTime();
        this.ndPairRenewTime = original.getPairRenewTime();
        this.ndPriority = original.getPriority();
        this.pairOptionBehavior = original.getPairOptionBehavior();
        this.luPairGroupNo = original.getPairGroupNo();
        this.luPairPortNo = original.getPairPortID();
        this.luPairLUN = original.getPairLUN();
        this.hostPairStatus = original.getHostPairStatus();
        this.hurAgree = original.getHurAgree();
        this.hurCFW = original.getHurCFW();
        this.hurDelta = original.getHurDelta();
        this.hurDiff = original.getHurDiff();
        this.hurErrLvl = original.getHurErrLvl();
        this.hurExternal = original.getHurExternal();
        this.hurIntermix = original.getHurIntermix();
        this.hurMirrorID = original.getHurMirrorID();
        this.hurMJournalGrp = original.getHurMJournalGrp();
        this.hurPathType = original.getHurPathType();
        this.hurRJournalGrp = original.getHurRJournalGrp();
        this.hurSeqChk = original.getHurSeqChk();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RmcpPairInfo other = (RmcpPairInfo)obj;
        if (this.async != other.async) {
            return false;
        }
        if (this.ctgGroup != other.ctgGroup) {
            return false;
        }
        if (this.dn != other.dn) {
            return false;
        }
        if (this.hostPairStatus == null ? other.hostPairStatus != null : !this.hostPairStatus.equals(other.hostPairStatus)) {
            return false;
        }
        if (this.hurAgree != other.hurAgree) {
            return false;
        }
        if (this.hurCFW != other.hurCFW) {
            return false;
        }
        if (this.hurDelta != other.hurDelta) {
            return false;
        }
        if (this.hurDiff != other.hurDiff) {
            return false;
        }
        if (this.hurErrLvl != other.hurErrLvl) {
            return false;
        }
        if (this.hurExternal != other.hurExternal) {
            return false;
        }
        if (this.hurIntermix != other.hurIntermix) {
            return false;
        }
        if (this.hurMJournalGrp != other.hurMJournalGrp) {
            return false;
        }
        if (this.hurMirrorID != other.hurMirrorID) {
            return false;
        }
        if (this.hurPathType != other.hurPathType) {
            return false;
        }
        if (this.hurRJournalGrp != other.hurRJournalGrp) {
            return false;
        }
        if (this.hurSeqChk != other.hurSeqChk) {
            return false;
        }
        if (this.luPairGroupNo != other.luPairGroupNo) {
            return false;
        }
        if (this.luPairLUN != other.luPairLUN) {
            return false;
        }
        if (this.luPairPortNo != other.luPairPortNo) {
            return false;
        }
        if (this.ndCopyProgress != other.ndCopyProgress) {
            return false;
        }
        if (this.ndCreateTime == null ? other.ndCreateTime != null : !this.ndCreateTime.equals(other.ndCreateTime)) {
            return false;
        }
        if (this.ndPairCopyTime == null ? other.ndPairCopyTime != null : !this.ndPairCopyTime.equals(other.ndPairCopyTime)) {
            return false;
        }
        if (this.ndPairRenewTime == null ? other.ndPairRenewTime != null : !this.ndPairRenewTime.equals(other.ndPairRenewTime)) {
            return false;
        }
        if (this.ndPriority != other.ndPriority) {
            return false;
        }
        if (this.pairCtrlID != other.pairCtrlID) {
            return false;
        }
        if (this.pairOptionBehavior != other.pairOptionBehavior) {
            return false;
        }
        if (this.pairRCUID != other.pairRCUID) {
            return false;
        }
        if (this.pairSN == null ? other.pairSN != null : !this.pairSN.equals(other.pairSN)) {
            return false;
        }
        if (this.pairSSID != other.pairSSID) {
            return false;
        }
        if (this.pairStatus != other.pairStatus) {
            return false;
        }
        if (this.pairType == null ? other.pairType != null : !this.pairType.equals(other.pairType)) {
            return false;
        }
        if (this.targetDN != other.targetDN) {
            return false;
        }
        if (this.tracks != other.tracks) {
            return false;
        }
        return this.trueCopy == other.trueCopy;
    }

    public int getAsync() {
        return this.async;
    }

    public int getConsistencyGroupID() {
        return this.ctgGroup;
    }

    public int getCopyProgress() {
        return this.ndCopyProgress;
    }

    public long getDn() {
        return this.dn;
    }

    public String getHostPairStatus() {
        return this.hostPairStatus;
    }

    public int getHurAgree() {
        return this.hurAgree;
    }

    public int getHurCFW() {
        return this.hurCFW;
    }

    public int getHurDelta() {
        return this.hurDelta;
    }

    public int getHurDiff() {
        return this.hurDiff;
    }

    public int getHurErrLvl() {
        return this.hurErrLvl;
    }

    public int getHurExternal() {
        return this.hurExternal;
    }

    public int getHurIntermix() {
        return this.hurIntermix;
    }

    public int getHurMirrorID() {
        return this.hurMirrorID;
    }

    public int getHurMJournalGrp() {
        return this.hurMJournalGrp;
    }

    public int getHurPathType() {
        return this.hurPathType;
    }

    public int getHurRJournalGrp() {
        return this.hurRJournalGrp;
    }

    public int getHurSeqChk() {
        return this.hurSeqChk;
    }

    public String getPairCopyTime() {
        return this.ndPairCopyTime;
    }

    public String getPairCreateTime() {
        return this.ndCreateTime;
    }

    public int getPairCtrlID() {
        return this.pairCtrlID;
    }

    public int getPairGroupNo() {
        return this.luPairGroupNo;
    }

    public int getPairLUN() {
        return this.luPairLUN;
    }

    public int getPairOptionBehavior() {
        return this.pairOptionBehavior;
    }

    public int getPairPortID() {
        return this.luPairPortNo;
    }

    public int getPairRCUID() {
        return this.pairRCUID;
    }

    public String getPairRenewTime() {
        return this.ndPairRenewTime;
    }

    public String getPairSN() {
        return this.pairSN;
    }

    public int getPairSSID() {
        return this.pairSSID;
    }

    public int getPairStatus() {
        return this.pairStatus;
    }

    public BitSet getPairType() {
        return this.pairType;
    }

    public int getPriority() {
        return this.ndPriority;
    }

    public long getTargetDN() {
        return this.targetDN;
    }

    public int getTracks() {
        return this.tracks;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.async;
        result = 31 * result + this.ctgGroup;
        result = 31 * result + (int)(this.dn ^ this.dn >>> 32);
        result = 31 * result + (this.hostPairStatus == null ? 0 : this.hostPairStatus.hashCode());
        result = 31 * result + this.hurAgree;
        result = 31 * result + this.hurCFW;
        result = 31 * result + this.hurDelta;
        result = 31 * result + this.hurDiff;
        result = 31 * result + this.hurErrLvl;
        result = 31 * result + this.hurExternal;
        result = 31 * result + this.hurIntermix;
        result = 31 * result + this.hurMJournalGrp;
        result = 31 * result + this.hurMirrorID;
        result = 31 * result + this.hurPathType;
        result = 31 * result + this.hurRJournalGrp;
        result = 31 * result + this.hurSeqChk;
        result = 31 * result + this.luPairGroupNo;
        result = 31 * result + this.luPairLUN;
        result = 31 * result + this.luPairPortNo;
        result = 31 * result + this.ndCopyProgress;
        result = 31 * result + (this.ndCreateTime == null ? 0 : this.ndCreateTime.hashCode());
        result = 31 * result + (this.ndPairCopyTime == null ? 0 : this.ndPairCopyTime.hashCode());
        result = 31 * result + (this.ndPairRenewTime == null ? 0 : this.ndPairRenewTime.hashCode());
        result = 31 * result + this.ndPriority;
        result = 31 * result + this.pairCtrlID;
        result = 31 * result + this.pairOptionBehavior;
        result = 31 * result + this.pairRCUID;
        result = 31 * result + (this.pairSN == null ? 0 : this.pairSN.hashCode());
        result = 31 * result + this.pairSSID;
        result = 31 * result + this.pairStatus;
        result = 31 * result + (this.pairType == null ? 0 : this.pairType.hashCode());
        result = 31 * result + (int)(this.targetDN ^ this.targetDN >>> 32);
        result = 31 * result + this.tracks;
        result = 31 * result + (this.trueCopy ? 1231 : 1237);
        return result;
    }

    public boolean isHURPair() {
        return !this.isTrueCopyPair();
    }

    public boolean isSecondaryVol() {
        return this.pairType.get(1);
    }

    public boolean isTrueCopyPair() {
        return this.trueCopy;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RmcpPairInfo (");
        builder.append(this.isTrueCopyPair() ? "True Copy" : "HUR");
        builder.append(") [dn=");
        builder.append(this.dn);
        builder.append(", pairSN=");
        builder.append(this.pairSN);
        builder.append(", targetDN=");
        builder.append(this.targetDN);
        builder.append(", hostPairStatus=");
        builder.append(this.hostPairStatus);
        builder.append("]");
        return builder.toString();
    }

    static {
        clz = RmcpPairInfo[].class;
    }

    private static class TrueCopyWorkerThread
    implements Task {
        private final Robj_interface_RJiRMCPget1PairSummary mPairSummary;
        private final Wait4ProcessTasks mTask;
        private final String mSerialNum;
        private final IteratorCallback<RmcpPairInfo> mIter;

        public TrueCopyWorkerThread(Wait4ProcessTasks task, Robj_interface_RJiRMCPget1PairSummary pInfo, IteratorCallback<RmcpPairInfo> callerIter, String serialNum) {
            this.mTask = task;
            this.mPairSummary = pInfo;
            this.mSerialNum = serialNum;
            this.mIter = callerIter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                if (!this.mTask.shouldStop() && 0 != this.mPairSummary.getPairStatus()) {
                    this.mIter.returnItem(new RmcpPairInfo(this.mSerialNum, this.mPairSummary));
                }
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "", we);
                this.mTask.setStop(true);
                this.mIter.exceptionOccurred(we);
            }
            finally {
                this.mTask.taskProcessed();
            }
        }
    }

    private static class RMIApiCallThread
    implements Runnable {
        private final String serialNum;
        private final IteratorCallback<RmcpPairInfo> callerIter;
        private final Robj_interface_RJiLDEVInfoDetail2[] ldevs;
        private boolean done;
        private final PairCheckType type;

        public RMIApiCallThread(String serialNum, IteratorCallback<RmcpPairInfo> callback, Robj_interface_RJiLDEVInfoDetail2[] ldevs, PairCheckType type) {
            this.serialNum = serialNum;
            this.callerIter = callback;
            this.ldevs = ldevs;
            this.type = type;
            this.done = false;
        }

        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                try {
                    Thread t = Thread.currentThread();
                    if (this.type == PairCheckType.TC) {
                        t.setName("RMCP Caller");
                        RmcpPairInfo.callGetRmcpPair(this.serialNum, this.callerIter, this.ldevs);
                        break block9;
                    }
                    if (this.type == PairCheckType.HUR) {
                        t.setName("HUR Caller");
                        RmcpPairInfo.callGetHURPair(this.serialNum, this.callerIter, this.ldevs);
                        break block9;
                    }
                    throw new WBEMException(1, "PairCheckType must be TC or HUR");
                }
                catch (WBEMException we) {
                    AbstractBaseCommonObject.cacheLogger.log(Level.SEVERE, "Exception calling RMCP API", we);
                    this.callerIter.exceptionOccurred(we);
                }
                catch (Throwable t) {
                    AbstractBaseCommonObject.cacheLogger.log(Level.SEVERE, "Error calling RMCP API", t);
                    this.callerIter.exceptionOccurred(new WBEMException(1, t.toString(), null, t));
                }
                finally {
                    this.done = true;
                    AbstractBaseCommonObject.cacheLogger.log(Level.INFO, "{0} thread exiting", Thread.currentThread().getName());
                }
            }
        }
    }

    public static enum PairCheckType {
        ALL,
        TC,
        HUR;

    }
}

