/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.FindMethodCallbackHandler;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.keyvalueapis.MRCFreadSnapshotRootLdevInfo;
import com.hitachi.smi.common.keyvalueapis.MRCFreadTiPairOfSecondaryVolumes;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.cim.CIMDateTimeAbsolute;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class SnapshotInfo2
extends AbstractBaseCommonObject
implements Comparable<SnapshotInfo2> {
    private static final long serialVersionUID = 48999381550898438L;
    private static final Class<SnapshotInfo2[]> clz = SnapshotInfo2[].class;
    private DeviceNumber primaryVolume;
    private DeviceNumber secondaryVolume;
    private int status;
    private int mirrorUnit;
    private int mCtgID;
    private short mPairRate;
    private int mWriteHist;
    private CIMDateTimeAbsolute mSnapshotDate;
    private long rootLDEV;
    private int snapshotGroup;
    private boolean cascade;
    private boolean clone;
    private int copyPace;
    private int synchronousRate;
    int pairNum;
    int suspendErrorPairNum;
    int tiPoolID;
    long tiPoolUsedCapacity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cache(RMIObjectMapping mapping) throws WBEMException, RemoteException, GetRmiException, SANRmiException {
        RMIObjectCache rmiObj = mapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (!cache.isCached(clz)) {
            Class<SnapshotInfo2> clazz = SnapshotInfo2.class;
            synchronized (SnapshotInfo2.class) {
                if (!cache.isCached(clz)) {
                    ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
                    SnapshotInfo2.getUncachedSnapshotInfo2(rmiObj, callback, null, null, false);
                    CloseableAddableIterator<SnapshotInfo2> cbIter = callback.getWrappedCloseableAddableIter();
                    ArrayList<SnapshotInfo2> sis = new ArrayList<SnapshotInfo2>();
                    ConcurrentHashMap siMap = new ConcurrentHashMap();
                    while (cbIter.hasNext()) {
                        SnapshotInfo2 si = (SnapshotInfo2)cbIter.next();
                        sis.add(si);
                    }
                    CacheLib.addDataToCache(siMap, sis, clz, mapping.getSerialNumber());
                } else {
                    Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                    logger.log(Level.WARNING, "PairData was cached in {0}", mapping.getSerialNumber());
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
            logger.log(Level.WARNING, "PairData is already in cache {0}", mapping.getSerialNumber());
        }
    }

    private static SnapshotInfo2 createSnapshotInfo2(String serialNumber, SanObject secondaryVolListObject, List<BaseDeviceNumber> dnList, Boolean isPVol, List<MRCFreadSnapshotRootLdevInfo.RootLDEVInfo> rootData) throws WBEMException {
        SanObject tiPair;
        if (null != dnList) {
            Collections.sort(dnList);
        }
        try {
            tiPair = secondaryVolListObject.getObj("TiPair");
        }
        catch (SanDataException e) {
            Throwable t = e;
            while (null != t.getCause()) {
                t = t.getCause();
            }
            WBEMException we = new WBEMException(1, "Exception getting pair data from key/Value API", null, t);
            throw we;
        }
        if (null == tiPair) {
            return null;
        }
        SnapshotInfo2 temp = new SnapshotInfo2(serialNumber, tiPair, rootData);
        if (null != dnList && !dnList.isEmpty()) {
            DeviceNumber pVol = temp.getPVol();
            DeviceNumber sVol = temp.getSVol();
            int idx = -1;
            try {
                if (null == isPVol || isPVol.booleanValue()) {
                    idx = Collections.binarySearch(dnList, new BaseDeviceNumber(RMIObjectMapping.getRMIObjectMapping(serialNumber).getSerialNumber(), pVol.getLdkc(), pVol.getLdev(), pVol.getCu(), 625));
                } else if (idx < 0 && null == isPVol || !isPVol.booleanValue()) {
                    idx = Collections.binarySearch(dnList, new BaseDeviceNumber(RMIObjectMapping.getRMIObjectMapping(serialNumber).getSerialNumber(), sVol.getLdkc(), sVol.getCu(), sVol.getLdev(), 625));
                }
            }
            catch (RemoteException | GetRmiException e) {
                throw new WBEMException(1, "Error creating a BaseDeviceNumber", null, e);
            }
            if (idx < 0) {
                temp = null;
            }
        }
        return temp;
    }

    public static boolean doAllPairsHaveStatus(RMIObjectCache rmiObj, List<DeviceNumber> dns2Check, int status2Check) throws WBEMException {
        boolean ret = true;
        ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
        SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, dns2Check, Boolean.FALSE);
        CloseableAddableIterator<SnapshotInfo2> ss2Iter = callback.getWrappedCloseableAddableIter();
        while (ret && ss2Iter.hasNext()) {
            SnapshotInfo2 ssi2 = (SnapshotInfo2)ss2Iter.next();
            if (ssi2.getPairStatus() == status2Check) continue;
            providerLogger.log(Level.FINE, "Volume {0} has status {1} want {2}, stopping", new Object[]{ssi2.getPVolDNString(), status2Check, ssi2.getPairStatus()});
            ret = false;
        }
        return ret;
    }

    public static SnapshotInfo2 find(DeviceNumber sVol) throws WBEMException {
        return SnapshotInfo2.find(sVol, false);
    }

    public static SnapshotInfo2 find(DeviceNumber vol, boolean isPVol) throws WBEMException {
        SnapshotInfo2 ret = null;
        if (vol != null) {
            try {
                RMIObjectMapping rmiMap = RMIObjectMapping.getRMIObjectMapping(vol.getSerialNumber());
                RMIObjectCache rmiObj = rmiMap.getRMIObject();
                FindMethodCallbackHandler<SnapshotInfo2> callback = new FindMethodCallbackHandler<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, vol.getDNAsString(), (Boolean)isPVol);
                ret = callback.getReturnValue();
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable e) {
                throw new WBEMException(1, e.toString(), null, e);
            }
        }
        return ret;
    }

    private static void getSnapshotInfo2(IteratorCallback<SnapshotInfo2> callback, List<? extends BaseDeviceNumber> dns, Boolean isPVol) throws WBEMException {
        Collection<RMIObjectMapping> mappings = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping mapObj : mappings) {
            if (null != mapObj) {
                SnapshotInfo2.getSnapshotInfo2(mapObj.getRMIObject(), callback, dns, isPVol);
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("One of the objects returned from getAllMappings is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getSnapshotInfo2(RMIObjectCache rmiObj, CommonClassAsList<SnapshotInfo2> callerCB, short poolID, boolean isPVol) throws WBEMException {
        ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
        SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, (List<? extends BaseDeviceNumber>)null, null);
        CloseableAddableIterator<SnapshotInfo2> allSSInfos = callback.getWrappedCloseableAddableIter();
        try {
            while (allSSInfos.hasNext()) {
                SnapshotInfo2 ssi = (SnapshotInfo2)allSSInfos.next();
                if (-1 == poolID || poolID != ssi.getTiPoolID()) continue;
                callerCB.returnItem(ssi);
            }
        }
        finally {
            callerCB.done();
        }
    }

    public static void getSnapshotInfo2(RMIObjectCache rmiObj, IteratorCallback<SnapshotInfo2> callback) throws WBEMException {
        SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, (List<? extends BaseDeviceNumber>)null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getSnapshotInfo2(RMIObjectCache rmiObj, IteratorCallback<SnapshotInfo2> callback, List<? extends BaseDeviceNumber> dns, Boolean isPVol) throws WBEMException {
        block18: {
            if (null == rmiObj) {
                SnapshotInfo2.getSnapshotInfo2(callback, dns, isPVol);
                return;
            }
            try {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
                HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
                if (cache.isCached(clz)) {
                    AbstractBaseCommonObject[] sis = (SnapshotInfo2[])cache.getCachedObject(clz);
                    if (sis != null && sis.length > 0) {
                        if (null != dns) {
                            Collections.sort(dns);
                            for (AbstractBaseCommonObject si2 : sis) {
                                if (null == dns || dns.isEmpty()) continue;
                                DeviceNumber pVol = ((SnapshotInfo2)si2).getPVol();
                                DeviceNumber sVol = ((SnapshotInfo2)si2).getSVol();
                                int idx = -1;
                                try {
                                    if (null == isPVol || isPVol.booleanValue()) {
                                        idx = Collections.binarySearch(dns, new BaseDeviceNumber(rmiObj.getSMISMappingContainer().getSerialNumber(), pVol.getLdkc(), pVol.getLdev(), pVol.getCu(), 625));
                                    } else if (idx < 0 && null == isPVol || !isPVol.booleanValue()) {
                                        idx = Collections.binarySearch(dns, new BaseDeviceNumber(rmiObj.getSMISMappingContainer().getSerialNumber(), sVol.getLdkc(), sVol.getLdev(), sVol.getCu(), 625));
                                    }
                                }
                                catch (RemoteException | GetRmiException e) {
                                    throw new WBEMException(1, "Error creating a BaseDeviceNumber", null, e);
                                }
                                if (idx < 0) continue;
                                callback.returnItem((SnapshotInfo2)si2);
                            }
                            break block18;
                        }
                        callback.returnItems(sis);
                        break block18;
                    }
                    logger.log(Level.FINER, "No {0} in {1} that match filters, isPVol: {2}, DN: {3} ", new Object[]{clz.getSimpleName(), rmiObj.getSMISMappingContainer().getSerialNumber(), isPVol, dns});
                    break block18;
                }
                LogRecord record = new LogRecord(Level.WARNING, "SnapshotInfo2 is not cached for {0}, this is a serious performance issue");
                record.setParameters(new Object[]{rmiObj.getSMISMappingContainer().getSerialNumber()});
                record.setThrown(new Exception(record.getMessage()));
                logger.log(record);
                SnapshotInfo2.getUncachedSnapshotInfo2(rmiObj, callback, dns, null, isPVol);
            }
            catch (WBEMException we) {
                callback.exceptionOccurred(we);
            }
            catch (Throwable t) {
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                WBEMException we = new WBEMException(1, t.toString(), null, t);
                callback.exceptionOccurred(we);
            }
            finally {
                callback.done();
            }
        }
    }

    public static void getSnapshotInfo2(RMIObjectCache rmiObj, IteratorCallback<SnapshotInfo2> callback, String dnIDStr, Boolean isPVols) throws WBEMException {
        if (null == rmiObj || null == dnIDStr) {
            throw new WBEMException("Must pass in both RMIObjectCache and Device Number ID");
        }
        DeviceNumber vVol = DeviceNumber.find(dnIDStr, rmiObj);
        if (null == vVol) {
            throw new WBEMException(6, "No DeviceNumber with ID: " + dnIDStr + " on " + rmiObj.getSMISMappingContainer().getSerialNumber());
        }
        ArrayList<DeviceNumber> dns = new ArrayList<DeviceNumber>(1);
        dns.add(vVol);
        SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, dns, isPVols);
    }

    private static void getUncachedSnapshotInfo2(RMIObjectCache rmiObj, IteratorCallback<SnapshotInfo2> callback, List<? extends BaseDeviceNumber> dnList, Robj_interface_RJiLDEVIndex[] ldevIndexArray, Boolean isPVol) throws WBEMException {
        try {
            MRCFreadTiPairOfSecondaryVolumes keyValTiPairData = new MRCFreadTiPairOfSecondaryVolumes(rmiObj, "127.0.0.1");
            MRCFreadSnapshotRootLdevInfo keyValRootData = new MRCFreadSnapshotRootLdevInfo(rmiObj, "127.0.0.1");
            ArrayList<BaseDeviceNumber> tempDNList = null;
            if (null != dnList) {
                keyValTiPairData.addDNs(dnList);
                tempDNList = new ArrayList<BaseDeviceNumber>(dnList);
            } else if (null != ldevIndexArray) {
                tempDNList = new ArrayList(ldevIndexArray.length);
                for (Robj_interface_RJiLDEVIndex ldevIndex : ldevIndexArray) {
                    tempDNList.add(new BaseDeviceNumber(rmiObj.getSMISMappingContainer().getSerialNumber(), ldevIndex.getSLDKC(), ldevIndex.getSLDEV(), ldevIndex.getSCU(), 625));
                }
            } else {
                Robj_interface_RJiLDEVIndex[] allLDEVs = rmiObj.getLDEVIndex();
                if (null == allLDEVs || allLDEVs.length == 0) {
                    cacheLogger.log(Level.INFO, "System has no LDEVs skipping SnapShotInfo2");
                    return;
                }
                keyValTiPairData.addLDEVs(allLDEVs);
                keyValRootData.addLDEVs(allLDEVs);
            }
            if (null != tempDNList && !tempDNList.isEmpty()) {
                keyValTiPairData.addDNs(tempDNList);
                keyValRootData.addDNs(tempDNList);
            }
            List<MRCFreadSnapshotRootLdevInfo.RootLDEVInfo> rootData = keyValRootData.getData();
            Collections.sort(rootData);
            String serialNumber = rmiObj.getSMISMappingContainer().getSerialNumber();
            SanList secondaryVolList = keyValTiPairData.invokeKVReadTiPairOfSecondaryVolumes();
            for (int x = 0; null != secondaryVolList && x < secondaryVolList.size(); ++x) {
                SanObject secondaryVolListObject = secondaryVolList.getObj(x);
                SanObject errorInf = secondaryVolListObject.getObj("ErrorInfo");
                int errorVal = errorInf.getInt("ErrorCode");
                if (0 == errorVal) {
                    SnapshotInfo2 val = SnapshotInfo2.createSnapshotInfo2(serialNumber, secondaryVolListObject, tempDNList, isPVol, rootData);
                    if (null == val) continue;
                    callback.returnItem(val);
                    continue;
                }
                int[] dkcVals = secondaryVolListObject.getIntArray("Id");
                throw new WBEMException(String.format("DN %d:%d:%d has error code %d, message ID %s", dkcVals[0], dkcVals[1], dkcVals[2], errorVal, Arrays.toString(errorInf.getIntArray("MessageId"))));
            }
        }
        catch (SanDataException | RemoteException | SANRmiException e) {
            Throwable t = e;
            while (null != t.getCause()) {
                t = t.getCause();
            }
            WBEMException we = new WBEMException(1, "Exception getting pair data from key/Value API", null, t);
            callback.exceptionOccurred(we);
            throw we;
        }
        catch (GetRmiException e) {
            WBEMException we = new WBEMException(1, "Exception getting BaseDeviceNumber", null, (Throwable)e);
            callback.exceptionOccurred(we);
            throw we;
        }
        finally {
            callback.done();
        }
    }

    public static boolean isVolumeUnpaired(DeviceNumber vol2Chk, Boolean isPVol) throws WBEMException {
        boolean ret;
        block6: {
            ret = false;
            if (null != vol2Chk) {
                SnapshotInfo2 snapInfo = null;
                try {
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(vol2Chk.getSerialNumber());
                    ArrayList<DeviceNumber> dns = new ArrayList<DeviceNumber>();
                    dns.add(vol2Chk);
                    ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
                    SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, dns, isPVol);
                    CloseableAddableIterator<SnapshotInfo2> listSnapshotInfo = callback.getWrappedCloseableAddableIter();
                    callback = null;
                    if (listSnapshotInfo.hasNext()) {
                        snapInfo = (SnapshotInfo2)listSnapshotInfo.next();
                    }
                    if (null == snapInfo || snapInfo.status == 0) {
                        ret = true;
                        break block6;
                    }
                    providerLogger.log(Level.FINE, "Volume, {0}, is a target of {1}", new Object[]{vol2Chk.getDn(), snapInfo.primaryVolume.getDn()});
                    ret = false;
                }
                catch (Throwable e) {
                    providerLogger.log(Level.SEVERE, "Unexpected error checking target volume " + e, e);
                    ret = false;
                }
            } else {
                providerLogger.log(Level.SEVERE, "Target volume is null");
                ret = false;
            }
        }
        return ret;
    }

    public static void modifyCache(Robj_interface_RJiLDEVIndex[] ldevIndexArray, Set<Short> changedCUs, List<SnapshotInfo2> added, List<SnapshotInfo2> modified, List<SnapshotInfo2> removed, String serialNum) throws WBEMException {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
        logger.log(Level.INFO, "SnapshotInfo2 processing {0} potentially modified LDEVs on {1}", new Object[]{ldevIndexArray.length, serialNum});
        RMIObjectMapping rmiMap = RMIObjectMapping.getRMIObjectMapping(serialNum);
        RMIObjectCache rmiObj = rmiMap.getRMIObject();
        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
        SnapshotInfo2.getSnapshotInfo2(rmiObj, callback);
        LinkedList<SnapshotInfo2> cached = callback.getReturnValue();
        callback = null;
        Collections.sort(cached);
        logger.log(Level.FINE, "Found {0} cached SnapshotInfo(s)", cached.size());
        ClosableAddableIteratorCB<SnapshotInfo2> backendCB = new ClosableAddableIteratorCB<SnapshotInfo2>();
        SnapshotInfo2.getUncachedSnapshotInfo2(rmiObj, backendCB, null, null, null);
        CloseableAddableIterator<SnapshotInfo2> uncachedIter = backendCB.getWrappedCloseableAddableIter();
        logger.log(Level.FINE, "Comparing cached and uncached SnapshotInfo2 objects");
        while (uncachedIter.hasNext()) {
            SnapshotInfo2 unCachedSI = (SnapshotInfo2)uncachedIter.next();
            int idx = Collections.binarySearch(cached, unCachedSI);
            if (idx >= 0) {
                SnapshotInfo2 cachedSI = cached.remove(idx);
                if (cachedSI.equals(unCachedSI)) continue;
                SnapshotInfo2 origSI = new SnapshotInfo2(cachedSI);
                modified.add(origSI);
                cachedSI.copySnapshotInfo2(unCachedSI);
                continue;
            }
            added.add(unCachedSI);
        }
        logger.log(Level.INFO, "Modified {0} SnapshotInfo2 in cache", modified.size());
        removed.addAll(cached);
        HashMap siMap = new HashMap();
        logger.log(Level.INFO, "Adding {0} SnapshotInfo2 in to cache", added.size());
        if (added.size() > 0) {
            siMap.clear();
            CacheLib.addDataToCache(siMap, added, clz, serialNum);
        }
        logger.log(Level.INFO, "Removing {0} SnapshotInfo2 from cache", removed.size());
        if (removed.size() > 0) {
            CacheLib.removeDataFromCache(siMap, (Serializable[])removed.toArray(new SnapshotInfo2[removed.size()]), clz, (String)serialNum);
        }
        logger.log(Level.INFO, "Done processing SnapshotInfo2 for {0}", serialNum);
    }

    private SnapshotInfo2(SnapshotInfo2 other) {
        super(other.getSerialNumber());
        this.copySnapshotInfo2(other);
    }

    private SnapshotInfo2(String serialNumber, SanObject tiPair, List<MRCFreadSnapshotRootLdevInfo.RootLDEVInfo> rootData) throws WBEMException {
        super(serialNumber);
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNumber).getRMIObject();
            if (null == tiPair) {
                throw new NullPointerException("CTOR called with null value in key value response");
            }
            SanObject pvObject = tiPair.getObj("PrimaryVolume").getObj("Ldev");
            int[] dkcfb4 = pvObject.getIntArray("Id");
            long dnVal = BaseDeviceNumber.makeUniqueDN((short)dkcfb4[0], (short)dkcfb4[1], (short)dkcfb4[2]);
            this.primaryVolume = DeviceNumber.find(Long.toString(dnVal), rmiObj);
            if (null == this.primaryVolume) {
                throw new WBEMException("Could not find primary Volume " + dnVal + " on " + serialNumber);
            }
            SanObject secondaryVolumeObj = tiPair.getObj("SecondaryVolume");
            int[] secondaryDkcCuFb = secondaryVolumeObj.getObj("Ldev").getIntArray("Id");
            dnVal = BaseDeviceNumber.makeUniqueDN((short)secondaryDkcCuFb[0], (short)secondaryDkcCuFb[1], (short)secondaryDkcCuFb[2]);
            this.secondaryVolume = DeviceNumber.find(Long.toString(dnVal), rmiObj);
            if (null == this.secondaryVolume) {
                throw new WBEMException("Failed to find secondary Volume " + dnVal + " on " + serialNumber);
            }
            this.mWriteHist = secondaryVolumeObj.getInt("WriteHistory");
            int[] rootLDEVInts = tiPair.getObj("RootLdev").getIntArray("Id");
            this.rootLDEV = BaseDeviceNumber.makeUniqueDN((short)rootLDEVInts[0], (short)rootLDEVInts[1], (short)rootLDEVInts[2]);
            this.mirrorUnit = tiPair.getInt("MirrorUnit");
            this.status = tiPair.getInt("Status");
            if (544 == this.getPairStatus()) {
                Calendar cal = Calendar.getInstance();
                int[] snapshotDateArr = tiPair.getIntArray("SnapshotDate");
                cal.set(snapshotDateArr[0], snapshotDateArr[1], snapshotDateArr[2], snapshotDateArr[3], snapshotDateArr[4], snapshotDateArr[5]);
                this.mSnapshotDate = new CIMDateTimeAbsolute(cal);
            } else {
                this.mSnapshotDate = null;
            }
            this.synchronousRate = tiPair.getInt("SynchronousRate");
            SanObject ctgObj = tiPair.getObj("Ctg");
            this.mCtgID = null != ctgObj ? ctgObj.getInt("Id") : -1;
            SanObject snapshotGroupObj = tiPair.getObj("SnapshotGroup");
            this.snapshotGroup = null != snapshotGroupObj ? snapshotGroupObj.getInt("Id") : -1;
            this.cascade = tiPair.getBoolean("Cascade");
            this.clone = tiPair.getBoolean("Clone");
            this.copyPace = tiPair.getInt("CopyPace");
            int idx = Collections.binarySearch(rootData, new MRCFreadSnapshotRootLdevInfo.RootLDEVInfo(this.rootLDEV));
            if (idx < 0) {
                String msg = String.format("Unable to find RootLDEVInfo for root volume %d", this.rootLDEV);
                throw new WBEMException(msg);
            }
            MRCFreadSnapshotRootLdevInfo.RootLDEVInfo rootDataVal = rootData.get(idx);
            this.pairNum = rootDataVal.getPairNum();
            this.suspendErrorPairNum = rootDataVal.getSuspendErrorPairNum();
            this.tiPoolID = rootDataVal.getTiPoolID();
            this.tiPoolUsedCapacity = rootDataVal.getTiPoolUsedCapacity();
        }
        catch (SanDataException sde) {
            throw new WBEMException(1, "Exception getting TiPair data for volume " + this.primaryVolume, null, (Throwable)sde);
        }
    }

    @Override
    public int compareTo(SnapshotInfo2 o) {
        int ret = 0;
        if (null != this.primaryVolume) {
            int n = this.primaryVolume.getDn() == o.primaryVolume.getDn() ? 0 : (ret = this.primaryVolume.getDn() < o.primaryVolume.getDn() ? -1 : 1);
        }
        if (0 == ret) {
            int n = this.secondaryVolume.getDn() == o.secondaryVolume.getDn() ? 0 : (ret = this.secondaryVolume.getDn() < o.secondaryVolume.getDn() ? -1 : 1);
        }
        if (0 == ret) {
            ret = this.mCtgID == o.mCtgID ? 0 : (this.mCtgID < o.mCtgID ? -1 : 1);
        }
        return ret;
    }

    private void copySnapshotInfo2(SnapshotInfo2 other) {
        this.cascade = other.isCascade();
        this.clone = other.isClone();
        this.copyPace = other.getCopyPace();
        this.mCtgID = other.getCtgID();
        this.mirrorUnit = other.getMirrorUnit();
        this.mSnapshotDate = other.getSnapshotDate();
        this.mWriteHist = other.getWriteHist();
        this.primaryVolume = other.getPVol();
        this.rootLDEV = other.getRootLDEV();
        this.secondaryVolume = other.getSVol();
        this.snapshotGroup = other.getSnapshotGroup();
        this.status = other.getPairStatus();
        this.synchronousRate = other.getSynchronousRate();
        this.pairNum = other.getPairNum();
        this.suspendErrorPairNum = other.getSuspendErrorPairNum();
        this.tiPoolID = other.getTiPoolID();
        this.tiPoolUsedCapacity = other.getTiPoolUsedCapacity();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotInfo2 other = (SnapshotInfo2)obj;
        if (this.cascade != other.cascade) {
            return false;
        }
        if (this.clone != other.clone) {
            return false;
        }
        if (this.copyPace != other.copyPace) {
            return false;
        }
        if (this.mCtgID != other.mCtgID) {
            return false;
        }
        if (this.mPairRate != other.mPairRate) {
            return false;
        }
        if (this.mSnapshotDate == null ? other.mSnapshotDate != null : !this.mSnapshotDate.equals((Object)other.mSnapshotDate)) {
            return false;
        }
        if (this.mWriteHist != other.mWriteHist) {
            return false;
        }
        if (this.mirrorUnit != other.mirrorUnit) {
            return false;
        }
        if (this.primaryVolume == null ? other.primaryVolume != null : !this.primaryVolume.equals(other.primaryVolume)) {
            return false;
        }
        if (this.rootLDEV != other.rootLDEV) {
            return false;
        }
        if (this.secondaryVolume == null ? other.secondaryVolume != null : !this.secondaryVolume.equals(other.secondaryVolume)) {
            return false;
        }
        if (this.snapshotGroup != other.snapshotGroup) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.synchronousRate == other.synchronousRate;
    }

    public int getCopyPace() {
        return this.copyPace;
    }

    public int getCtgID() {
        return this.mCtgID;
    }

    public int getMirrorUnit() {
        return this.mirrorUnit;
    }

    public int getPairNum() {
        return this.pairNum;
    }

    public short getPairRate() {
        return this.mPairRate;
    }

    public int getPairStatus() {
        return this.status;
    }

    public DeviceNumber getPVol() {
        return this.primaryVolume;
    }

    public String getPVolDNString() {
        String ret = null;
        if (null != this.primaryVolume) {
            return this.primaryVolume.getDNAsString();
        }
        return ret;
    }

    public long getRootLDEV() {
        return this.rootLDEV;
    }

    public CIMDateTimeAbsolute getSnapshotDate() {
        return this.mSnapshotDate;
    }

    public int getSnapshotGroup() {
        return this.snapshotGroup;
    }

    public int getSuspendErrorPairNum() {
        return this.suspendErrorPairNum;
    }

    public DeviceNumber getSVol() {
        return this.secondaryVolume;
    }

    public String getSVolDNString() {
        String ret = null;
        if (null != this.secondaryVolume) {
            return this.secondaryVolume.getDNAsString();
        }
        return ret;
    }

    public int getSynchronousRate() {
        return this.synchronousRate;
    }

    public int getTiPoolID() {
        return this.tiPoolID;
    }

    public long getTiPoolUsedCapacity() {
        return this.tiPoolUsedCapacity;
    }

    public int getWriteHist() {
        return this.mWriteHist;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.cascade ? 1231 : 1237);
        result = 31 * result + (this.clone ? 1231 : 1237);
        result = 31 * result + this.copyPace;
        result = 31 * result + this.mCtgID;
        result = 31 * result + this.mPairRate;
        result = 31 * result + (this.mSnapshotDate == null ? 0 : this.mSnapshotDate.hashCode());
        result = 31 * result + this.mWriteHist;
        result = 31 * result + this.mirrorUnit;
        result = 31 * result + (this.primaryVolume == null ? 0 : this.primaryVolume.hashCode());
        result = 31 * result + (int)(this.rootLDEV ^ this.rootLDEV >>> 32);
        result = 31 * result + (this.secondaryVolume == null ? 0 : this.secondaryVolume.hashCode());
        result = 31 * result + this.snapshotGroup;
        result = 31 * result + this.status;
        result = 31 * result + this.synchronousRate;
        return result;
    }

    public boolean isCascade() {
        return this.cascade;
    }

    public boolean isClone() {
        return this.clone;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SnapshotInfo2 [primaryVolume=");
        builder.append(null != this.primaryVolume ? this.primaryVolume.getDNAsString() : "null");
        builder.append(", secondaryVolume=");
        builder.append(null != this.secondaryVolume ? Long.valueOf(this.secondaryVolume.getDn()) : "null");
        builder.append(", rootLDEV=");
        builder.append(this.rootLDEV);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", mPairRate=");
        builder.append(this.mPairRate);
        builder.append(", cascade=");
        builder.append(this.cascade);
        builder.append(", clone=");
        builder.append(this.clone);
        builder.append(", copyPace=");
        builder.append(this.copyPace);
        builder.append(", mirrorUnit=");
        builder.append(this.mirrorUnit);
        builder.append(", mWriteHist=");
        builder.append(this.mWriteHist);
        builder.append(", mSnapshotDate=");
        builder.append(this.mSnapshotDate);
        builder.append(", synchronousRate=");
        builder.append(this.synchronousRate);
        builder.append(", snapshotGroup=");
        builder.append(this.snapshotGroup);
        builder.append(", mCtgID=");
        builder.append(this.mCtgID);
        builder.append("]");
        return builder.toString();
    }
}

