/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageVolumeCallbackHandler<E extends DeviceNumber>
extends IteratorCallbackIMPL<E> {
    private ChassisArrayGroup cag = null;
    private String expDeviceID = null;
    private String expInstID = null;
    private final BaseInstrumentation provider;
    private final BaseAssocInstrumentation assocProvider;
    private final VolumeTypeEnum volumeType;
    private final UnsignedInteger16 expUsage;

    public StorageVolumeCallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String expDeviceID, String expInstID, UnsignedInteger16 expUsage, ChassisArrayGroup cag, VolumeTypeEnum volumeType, BaseInstrumentation provider) {
        super(iter, isObjectPath, refInfo, op, propertyList);
        this.expDeviceID = expDeviceID;
        this.expInstID = expInstID;
        this.cag = cag;
        this.provider = provider;
        this.assocProvider = null;
        this.volumeType = volumeType;
        this.expUsage = expUsage;
    }

    public StorageVolumeCallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, VolumeTypeEnum volumeType, BaseAssocInstrumentation assocProvider) {
        super(iter, isObjectPath, refInfo, op, propertyList);
        this.expDeviceID = null;
        this.expInstID = null;
        this.cag = null;
        this.provider = null;
        this.volumeType = volumeType;
        this.expUsage = null;
        this.assocProvider = assocProvider;
    }

    private boolean returnAssocItem(DeviceNumber dn) {
        boolean ret = true;
        if (!this.mIter.isClosed()) {
            try {
                if (this.expUsage == null || this.expUsage.compareTo(dn.getUsageValue()) == 0) {
                    CIMObjectPath opRef1 = this.assocProvider.getReference1Instrumentation().generateObjectPath(this.mOP, dn);
                    CIMObjectPath opRef2 = this.assocProvider.getReference2Instrumentation().generateObjectPath(this.mOP, dn);
                    if (this.mIsObjectPath) {
                        this.mIter.add(this.assocProvider.generateObjectPath(this.mOP, opRef1, opRef2));
                    } else {
                        this.mIter.add(this.assocProvider.generateInstance(this.mOP, this.mPropertyList, opRef1, opRef2));
                    }
                }
            }
            catch (WBEMException we) {
                this.mIter.setException(we);
            }
            catch (Throwable thrown) {
                WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                this.mIter.setException(we);
                this.mIter.close();
            }
        }
        return true;
    }

    private boolean returnInstanceItem(DeviceNumber dn) {
        boolean ret;
        block9: {
            ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    if (this.expUsage != null && this.expUsage.compareTo(dn.getUsageValue()) != 0) break block9;
                    String deviceID = dn.getDNAsString();
                    if (null != this.expDeviceID && !this.expDeviceID.equals(deviceID)) {
                        return ret;
                    }
                    if (null != this.expInstID && (this.cag.getFb4() != dn.getFb4() || this.cag.getPg() != dn.getPg() || this.cag.getVdev() != dn.getVdev())) {
                        return ret;
                    }
                    if (null != this.mRefInfo) {
                        CIMObjectPath retOP = this.provider.generateObjectPath(this.mOP, dn);
                        this.mRefInfo.addReference(this.mIter, retOP);
                        break block9;
                    }
                    if (this.mIsObjectPath) {
                        CIMObjectPath retOP = this.provider.generateObjectPath(this.mOP, dn);
                        this.mIter.add(retOP);
                        break block9;
                    }
                    CIMInstance ci = this.provider.generateInstance(this.mOP, this.mPropertyList, dn);
                    this.mIter.add(ci.filterProperties(this.mPropertyList));
                }
                catch (WBEMException we) {
                    this.mIter.setException(we);
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            } else {
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public boolean returnItem(E item) {
        boolean ret = true;
        E dn = item;
        if (((DeviceNumber)dn).isQSVvol() && (VolumeTypeEnum.NON_AOUVOL_OR_NON_QSVVOL.equals((Object)this.volumeType) || VolumeTypeEnum.NON_QSVVOL.equals((Object)this.volumeType))) {
            return ret;
        }
        if (((DeviceNumber)dn).isAOUVol() && (VolumeTypeEnum.NON_AOUVOL_OR_NON_QSVVOL.equals((Object)this.volumeType) || VolumeTypeEnum.NON_AOUVOL.equals((Object)this.volumeType))) {
            return ret;
        }
        if (!((DeviceNumber)dn).isAOUVol() && !((DeviceNumber)dn).isQSVvol() && VolumeTypeEnum.AOUVOL_OR_QSVVOL.equals((Object)this.volumeType)) {
            return ret;
        }
        if (!((DeviceNumber)dn).isAOUVol() && VolumeTypeEnum.AOUVOL.equals((Object)this.volumeType)) {
            return ret;
        }
        if (!((DeviceNumber)dn).isQSVvol() && VolumeTypeEnum.QSVVOL.equals((Object)this.volumeType)) {
            return ret;
        }
        ret = this.assocProvider == null ? this.returnInstanceItem((DeviceNumber)dn) : this.returnAssocItem((DeviceNumber)dn);
        return ret;
    }
}

