/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.common;

import com.hitachi.smi.cache.CacheLib;
import com.hitachi.smi.cache.HitachiCacheInterface;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallback;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskProcessor;
import com.ws.wbem.CloseableAddableIterator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_HUVMVirtualDkc;
import sanproject.common.Robj_interface_HUVMVirtualLdev;
import sanproject.common.Robj_interface_HUVMgetVDKCs_IN;
import sanproject.common.Robj_interface_HUVMgetVDKCs_OUT;
import sanproject.common.Robj_interface_HUVMgetVirtualLDEVs_IN;
import sanproject.common.Robj_interface_HUVMgetVirtualLDEVs_OUT;
import sanproject.common.Robj_interface_HUVMvboxIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RSGIndex;
import sanproject.serverux.data.GetRmiException;
import sanproject.serverux.data.SANRmiException;

public class VirtualLDEV
extends AbstractBaseCommonObject
implements Comparable<VirtualLDEV> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
    private static final Class<VirtualLDEV[]> clz = VirtualLDEV[].class;
    private static final String clzName = VirtualLDEV[].class.getName();
    private static boolean comparing = false;
    private short realDKC;
    private short realCU;
    private short realLDEV;
    private BaseDeviceNumber virtLDEVInfo;
    private short huvmAttr;
    private boolean vCvs;
    private int vEmulation;
    private short vInfFlag;
    private byte vLuse;
    private int vSSID;
    private int vBoxID;
    private byte[] vModel;
    private String vProductName;
    private long vSerialNum;
    private ArrayList<Integer> rsgIndexes;

    private static void addVLDEV2Map(VirtualLDEV vLDEV, AbstractMap<String, List<VirtualLDEV>> vLDEVMap) {
        String dnKeyStr = clzName;
        CacheLib.addToMap(vLDEVMap, dnKeyStr, vLDEV);
        String realDKC = CacheLib.getDKCString(vLDEV.getRealDKC());
        String realCU = CacheLib.getCUString(vLDEV.getRealCU());
        String realLDEV = CacheLib.getLDEVIndexLDEVString(vLDEV.getRealLDEV());
        String dkcCULDevStr = "RealVirtualLDEV" + realDKC + realCU + realLDEV;
        CacheLib.addToMap(vLDEVMap, dkcCULDevStr, vLDEV);
        String tCUStr = "RealVirtualLDEV" + realCU;
        CacheLib.addToMap(vLDEVMap, tCUStr, vLDEV);
        String cuLDevStr = tCUStr + realLDEV;
        CacheLib.addToMap(vLDEVMap, cuLDevStr, vLDEV);
        BaseDeviceNumber virtData = vLDEV.getVirtLDEVInfo();
        String virtDKC = CacheLib.getDKCString(virtData.getLdkc());
        String virtCU = CacheLib.getCUString(virtData.getCu());
        String virtLDEV = CacheLib.getLDEVIndexLDEVString(virtData.getLdev());
        dkcCULDevStr = "VirtualLDEV" + virtData.getSerialNumber() + virtDKC + virtCU + virtLDEV;
        CacheLib.addToMap(vLDEVMap, dkcCULDevStr, vLDEV);
        tCUStr = "VirtualLDEV" + virtData.getSerialNumber() + virtCU;
        CacheLib.addToMap(vLDEVMap, tCUStr, vLDEV);
        cuLDevStr = tCUStr + virtLDEV;
        CacheLib.addToMap(vLDEVMap, cuLDevStr, vLDEV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cache(RMIObjectMapping rmiMapping) throws WBEMException, RemoteException, GetRmiException, SANRmiException {
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) return;
        Class<VirtualLDEV> clazz = VirtualLDEV.class;
        synchronized (VirtualLDEV.class) {
            if (!cache.isCached(clz)) {
                ConcurrentHashMap<String, List<VirtualLDEV>> vldevMap = new ConcurrentHashMap<String, List<VirtualLDEV>>();
                ArrayList<VirtualLDEV> vldevs = new ArrayList<VirtualLDEV>();
                ClosableAddableIteratorCB<VirtualLDEV> callback = new ClosableAddableIteratorCB<VirtualLDEV>();
                int all = -1;
                VirtualLDEV.getUncachedVLDEV(rmiObj, callback, (short)-1, (short)-1, (short)-1, false);
                CloseableAddableIterator<VirtualLDEV> cbIter = callback.getWrappedCloseableAddableIter();
                callback = null;
                while (cbIter.hasNext()) {
                    VirtualLDEV vLdev = (VirtualLDEV)cbIter.next();
                    vldevs.add(vLdev);
                    VirtualLDEV.addVLDEV2Map(vLdev, vldevMap);
                }
                CacheLib.addDataToCache(vldevMap, vldevs, clz, rmiMapping.getSerialNumber());
            } else {
                mLogger.log(Level.WARNING, "VirtualLDEV is already in the cache {0}", rmiMapping);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareCached2Backend(List<VirtualLDEV> added, List<VirtualLDEV> modified, List<VirtualLDEV> removed, String serialNum) {
        Class<VirtualLDEV> clazz = VirtualLDEV.class;
        synchronized (VirtualLDEV.class) {
            Object rmiObj;
            if (comparing) {
                mLogger.info("Skipping VirtualLDEV.compareCached2Backend");
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            comparing = true;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            mLogger.info("Entering VirtualLDEV.compareCached2Backend");
            try {
                VirtualLDEV cachedLdev;
                rmiObj = RMIObjectMapping.getRMIObjectMapping(serialNum).getRMIObject();
                mLogger.fine("Getting back-end VirtualLDEV");
                CommonClassAsList callback = new CommonClassAsList();
                Thread t = new Thread(new Runnable((RMIObjectCache)rmiObj, callback){
                    final /* synthetic */ RMIObjectCache val$rmiObj;
                    final /* synthetic */ CommonClassAsList val$callback;
                    {
                        this.val$rmiObj = rMIObjectCache;
                        this.val$callback = commonClassAsList;
                    }

                    @Override
                    public void run() {
                        try {
                            VirtualLDEV.getUncachedVLDEV(this.val$rmiObj, this.val$callback, (short)-1, (short)-1, (short)-1, false);
                        }
                        catch (Throwable t) {
                            WBEMException we = null;
                            if (t instanceof WBEMException) {
                                we = (WBEMException)t;
                            } else {
                                Throwable t1 = t.getCause();
                                while (null != t1 && null == we) {
                                    t = t1;
                                    if (t1 instanceof WBEMException) {
                                        we = (WBEMException)t1;
                                        continue;
                                    }
                                    if (null == t1.getCause()) continue;
                                    t1 = t1.getCause();
                                }
                            }
                            if (null == we) {
                                we = new WBEMException(1, "", null, t);
                            }
                            this.val$callback.exceptionOccurred(we);
                        }
                    }
                });
                t.setDaemon(true);
                t.setName("VirtualLDEV cache updater - getting backend data");
                t.start();
                mLogger.fine("Getting cached VirtualLDEV");
                CommonClassAsList<VirtualLDEV> cachedCallback = new CommonClassAsList<VirtualLDEV>();
                VirtualLDEV.getVLDEVs((RMIObjectCache)rmiObj, cachedCallback, (short)-1, (short)-1, (short)-1, false);
                LinkedList<VirtualLDEV> cachedList = cachedCallback.getReturnValue();
                cachedCallback = null;
                mLogger.fine("Sorting cached VirtualLDEV list");
                Collections.sort(cachedList);
                mLogger.fine("Waiting for backend to complete retrieving data");
                LinkedList backendList = callback.getReturnValue();
                mLogger.fine("Got backend data, sorting backend data");
                Collections.sort(backendList);
                mLogger.log(Level.FINE, "Found {0} cached and {1} back-end", new Object[]{cachedList.size(), backendList.size()});
                ArrayList<VirtualLDEV> changed = new ArrayList<VirtualLDEV>((int)((double)modified.size() * 1.5));
                mLogger.fine("comparing lists");
                while (null != (cachedLdev = cachedList.poll())) {
                    int compared = Collections.binarySearch(backendList, cachedLdev);
                    if (compared >= 0) {
                        VirtualLDEV backendLdev = (VirtualLDEV)backendList.remove(compared);
                        if (cachedLdev.equals(backendLdev)) continue;
                        modified.add(new VirtualLDEV(cachedLdev));
                        changed.add(backendLdev);
                        continue;
                    }
                    removed.add(cachedLdev);
                }
                mLogger.fine("Done comparing.");
                if (backendList.size() > 0) {
                    added.addAll(backendList);
                }
                if (cachedList.size() > 0) {
                    removed.addAll(backendList);
                }
                mLogger.log(Level.INFO, "Modifying {0} VirtualLDEV in cache", modified.size());
                if (modified.size() > 0) {
                    Class<VirtualLDEV[]> clazz2 = clz;
                    synchronized (clazz2) {
                        CacheLib.removeDataFromCache(VirtualLDEV.getMap(modified), (Serializable[])modified.toArray(new VirtualLDEV[modified.size()]), clz, (String)serialNum);
                        CacheLib.addDataToCache(VirtualLDEV.getMap(changed), changed, clz, serialNum);
                    }
                }
                mLogger.log(Level.INFO, "Removing {0} VirtualLDEV from cache", removed.size());
                CacheLib.removeDataFromCache(VirtualLDEV.getMap(removed), (Serializable[])removed.toArray(new VirtualLDEV[removed.size()]), clz, (String)serialNum);
                mLogger.log(Level.INFO, "Adding {0} VirtualLDEV to cache", added.size());
                CacheLib.addDataToCache(VirtualLDEV.getMap(added), added, clz, serialNum);
            }
            catch (Throwable e) {
                mLogger.log(Level.SEVERE, "Exception occurred while inVirtualLDEV.compareCachedResourceGroup2Backend: " + e.toString(), e);
            }
            finally {
                rmiObj = VirtualLDEV.class;
                synchronized (VirtualLDEV.class) {
                    comparing = false;
                    // ** MonitorExit[rmiObj] (shouldn't be in output)
                }
            }
            mLogger.info("Exiting VirtualLDEV.compareCachedResourceGroup2Backend");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VirtualLDEV find(RMIObjectCache rmiObj, short dkc, short cu, short ldev, int ldevSerial) throws WBEMException {
        VirtualLDEV ret = null;
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            VirtualLDEV[] vLDev;
            String key;
            StringBuilder blder;
            String dkcStr = CacheLib.getDKCString(dkc);
            String cuStr = CacheLib.getCUString(cu);
            String ldevStr = CacheLib.getLDEVIndexLDEVString(ldev);
            if (-1 == ldevSerial) {
                blder = new StringBuilder("RealVirtualLDEV");
                blder.append(dkcStr);
                blder.append(cuStr);
                blder.append(ldevStr);
                key = blder.toString();
            } else {
                blder = new StringBuilder("VirtualLDEV");
                blder.append(ldevSerial);
                blder.append(dkcStr);
                blder.append(cuStr);
                blder.append(ldevStr);
                key = blder.toString();
            }
            Class<VirtualLDEV[]> clazz = clz;
            synchronized (clazz) {
                vLDev = (VirtualLDEV[])cache.getCachedObject(key, clz);
            }
            if (vLDev != null && vLDev.length == 1) {
                ret = vLDev[0];
            } else if (vLDev != null && vLDev.length > 1) {
                LogRecord record = new LogRecord(Level.SEVERE, "{0} appears to point to more then one object on {1}");
                record.setThrown(new Exception("for stack trace purposes"));
                record.setParameters(new Object[]{key, rmiObj.getSMISMappingContainer()});
                mLogger.log(record);
                throw new WBEMException(1, "VirtualLDEV key " + key + " points to " + vLDev.length + " VirtualLDEVs on " + rmiObj.getSMISMappingContainer());
            }
        } else {
            throw new WBEMException("VirtualLDEV not cached, find will not work");
        }
        return ret;
    }

    public static VirtualLDEV find(RMIObjectCache rmiObj, String dnStr) throws WBEMException {
        short[] vals = BaseDeviceNumber.getDevIdStringValues(dnStr);
        return VirtualLDEV.find(rmiObj, vals[0], vals[1], vals[2], -1);
    }

    private static HashMap<String, List<VirtualLDEV>> getMap(List<VirtualLDEV> vldevs) {
        HashMap<String, List<VirtualLDEV>> map = new HashMap<String, List<VirtualLDEV>>();
        for (VirtualLDEV vldev : vldevs) {
            VirtualLDEV.addVLDEV2Map(vldev, map);
        }
        return map;
    }

    private static void getUncachedVLDEV(RMIObjectCache rmiObj, IteratorCallback<VirtualLDEV> callback, short dkc, short cu, short ldev, boolean realVals) throws WBEMException {
        block9: {
            String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.log(Level.INFO, "entered getUncachedVLDEV for {0}", serialNum);
            boolean atLeastOne = false;
            try {
                Robj_interface_HUVMgetVirtualLDEVs_IN in = (Robj_interface_HUVMgetVirtualLDEVs_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.VIRTUALLDEVS_IN);
                Robj_interface_HUVMgetVirtualLDEVs_OUT result = (Robj_interface_HUVMgetVirtualLDEVs_OUT)rmiObj.getCmnData(in);
                List vLDEVs = result.getVLdevs();
                if (vLDEVs.size() <= 0) break block9;
                List<Robj_interface_HUVMVirtualDkc> vDKC = VirtualLDEV.getVirtualDKC(rmiObj);
                Map<Integer, Robj_interface_HUVMVirtualDkc> sortedVDKC = VirtualLDEV.sortVirtualDKC(vDKC);
                TaskProcessor task = new TaskProcessor("VirtualLDEV:" + serialNum, vLDEVs.size());
                for (int idx = 0; idx < vLDEVs.size(); ++idx) {
                    Robj_interface_HUVMVirtualLdev vLDEV = (Robj_interface_HUVMVirtualLdev)vLDEVs.get(idx);
                    if (task.shouldStop()) {
                        callback.done();
                        break;
                    }
                    atLeastOne = true;
                    WorkerThread worker = new WorkerThread(callback, rmiObj, rmiObj.getSMISMappingContainer().getSerialNumber(), vLDEV, dkc, cu, ldev, realVals, sortedVDKC, task);
                    task.addTask(worker);
                }
            }
            catch (Throwable t) {
                if (t instanceof WBEMException) {
                    throw (WBEMException)t;
                }
                throw new WBEMException(1, "error getting uncached Vitual ldevs", null, t);
            }
            finally {
                if (!atLeastOne) {
                    callback.done();
                }
                logger.log(Level.INFO, "leaving getUncachedVLDEV for {0}", serialNum);
            }
        }
    }

    private static List<Robj_interface_HUVMVirtualDkc> getVirtualDKC(RMIObjectCache rmiObj) throws WBEMException, RemoteException, SANRmiException {
        Robj_interface_HUVMgetVDKCs_IN in = (Robj_interface_HUVMgetVDKCs_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.HUVMGETVDKCS_IN);
        Robj_interface_HUVMgetVDKCs_OUT out = (Robj_interface_HUVMgetVDKCs_OUT)rmiObj.getCmnData(in);
        List virtDKC = out.getVDkcs();
        return virtDKC;
    }

    private static void getVLDEVs(IteratorCallback<VirtualLDEV> callback, short dkc, short cu, short ldev, boolean realVals) throws WBEMException {
        Collection<RMIObjectMapping> maps = RMIObjectMapping.getAllRMIObjectMappings();
        for (RMIObjectMapping map : maps) {
            if (null != map) {
                VirtualLDEV.getVLDEVs(map.getRMIObject(), callback, dkc, cu, ldev, realVals);
                continue;
            }
            Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
            logger.severe("One of the mappings is null.");
        }
    }

    static void getVLDEVs(RMIObjectCache rmiObj, IteratorCallback<VirtualLDEV> callback) throws WBEMException {
        int all = -1;
        VirtualLDEV.getVLDEVs(rmiObj, callback, (short)-1, (short)-1, (short)-1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getVLDEVs(RMIObjectCache rmiObj, IteratorCallback<VirtualLDEV> callback, short dkc, short cu, short ldev, boolean realVals) throws WBEMException {
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        if (null == rmiObj) {
            VirtualLDEV.getVLDEVs(callback, dkc, cu, ldev, realVals);
            return;
        }
        HitachiCacheInterface cache = rmiObj.smisGetHitachiCacheIF();
        if (cache.isCached(clz)) {
            AbstractBaseCommonObject[] vldevs;
            Object cuStr;
            String key;
            if (-1 == dkc) {
                key = null;
            } else {
                String dkcStr = CacheLib.getDKCString(dkc);
                cuStr = CacheLib.getCUString(cu);
                String ldevStr = CacheLib.getLDEVIndexLDEVString(ldev);
                key = (realVals ? "RealVirtualLDEV" : "VirtualLDEV") + dkcStr + (String)cuStr + ldevStr;
            }
            cuStr = clz;
            synchronized (cuStr) {
                vldevs = (VirtualLDEV[])cache.getCachedObject(key, clz);
            }
            if (vldevs != null) {
                callback.returnItems(vldevs);
            } else {
                logger.warning("No VirtualLDEV info in cache matching filter: " + key);
                callback.done();
            }
        } else {
            LogRecord record = new LogRecord(Level.WARNING, "getDNs: VirtualLDEV is not cached for {0}, this is a serious performance issue");
            record.setParameters(new Object[]{rmiObj.getSMISMappingContainer()});
            record.setThrown(new Exception("This is for stack trace information"));
            logger.log(record);
            ClosableAddableIteratorCB<VirtualLDEV> allVLdevs = new ClosableAddableIteratorCB<VirtualLDEV>();
            VirtualLDEV.getUncachedVLDEV(rmiObj, allVLdevs, dkc, cu, ldev, realVals);
            CloseableAddableIterator<VirtualLDEV> vldevs = allVLdevs.getWrappedCloseableAddableIter();
            while (vldevs.hasNext()) {
                callback.returnItem((VirtualLDEV)((AbstractBaseCommonObject)vldevs.next()));
            }
        }
    }

    private static Map<Integer, Robj_interface_HUVMVirtualDkc> sortVirtualDKC(List<Robj_interface_HUVMVirtualDkc> vDKCs) {
        HashMap<Integer, Robj_interface_HUVMVirtualDkc> ret = new HashMap<Integer, Robj_interface_HUVMVirtualDkc>(vDKCs.size());
        for (Robj_interface_HUVMVirtualDkc vDKC : vDKCs) {
            int vboxID = vDKC.getRobjVboxIndex().getVboxId();
            Robj_interface_HUVMVirtualDkc prev = ret.put(vboxID, vDKC);
            if (null == prev) continue;
            mLogger.log(Level.SEVERE, "VirtualDKC with DBoxID of {0} already exists, replacing", new Object[]{vboxID});
        }
        return ret;
    }

    public VirtualLDEV(String serialNum, Robj_interface_HUVMVirtualLdev theVal, Map<Integer, Robj_interface_HUVMVirtualDkc> vDKC, DeviceNumber realDN) throws RemoteException, GetRmiException, WBEMException {
        super(serialNum);
        this.realDKC = theVal.getSLDKC();
        this.realCU = theVal.getSCU();
        this.realLDEV = theVal.getSLDEV();
        this.huvmAttr = theVal.getVAttrHuvm();
        this.vCvs = theVal.getVCvs();
        this.vEmulation = 0 != theVal.getVEmulation() ? theVal.getVEmulation() : 625;
        this.vInfFlag = theVal.getVInfflag();
        this.vLuse = theVal.getVLuse();
        this.vSSID = theVal.getVSsid();
        Robj_interface_RJiLDEVIndex virtLDEV = theVal.getRobjVirtualLdev();
        Robj_interface_HUVMvboxIndex vbox = theVal.getRobjVboxIndex();
        this.vBoxID = vbox.getVboxId();
        Robj_interface_HUVMVirtualDkc virtDKC = vDKC.get(this.vBoxID);
        this.vModel = virtDKC.getVModel();
        this.vProductName = virtDKC.getVProductName();
        this.vSerialNum = virtDKC.getVSerialNo();
        Robj_interface_RSGIndex[] rsgs = virtDKC.getRobjRsgList();
        this.rsgIndexes = new ArrayList(null != rsgs ? rsgs.length : 0);
        if (null != rsgs) {
            for (Robj_interface_RSGIndex rsg : rsgs) {
                this.rsgIndexes.add(rsg.getRsgId());
            }
        }
        String virtSerialStr = Long.toString(this.vSerialNum);
        this.virtLDEVInfo = new BaseDeviceNumber(virtSerialStr, virtLDEV.getSLDKC(), virtLDEV.getSLDEV(), virtLDEV.getSCU(), 625);
        if (!RMIObjectMapping.setVirtual2RealMapping(virtSerialStr, serialNum)) {
            throw new WBEMException(virtSerialStr + " can not be mapped to " + serialNum + " because it is already mappped to another device");
        }
    }

    public VirtualLDEV(VirtualLDEV theVal) throws WBEMException {
        super(theVal.getSerialNumber());
        this.copy(theVal);
    }

    @Override
    public int compareTo(VirtualLDEV other) {
        long otherVal;
        long thisVal = BaseDeviceNumber.makeUniqueDN(this.getRealDKC(), this.getRealCU(), this.getRealLDEV());
        return thisVal < (otherVal = BaseDeviceNumber.makeUniqueDN(other.getRealDKC(), other.getRealCU(), other.getRealLDEV())) ? -1 : (thisVal == otherVal ? 0 : 1);
    }

    private void copy(VirtualLDEV theVal) throws WBEMException {
        this.realDKC = theVal.getRealDKC();
        this.realCU = theVal.getRealCU();
        this.realLDEV = theVal.getRealLDEV();
        this.huvmAttr = theVal.getHuvmAttr();
        this.vCvs = theVal.isvCvs();
        this.vEmulation = theVal.getvEmulation();
        this.vInfFlag = theVal.getvInfFlag();
        this.vLuse = theVal.getvLuse();
        this.vSSID = theVal.getvSSID();
        this.vBoxID = theVal.getvBoxID();
        this.vModel = theVal.getvModel();
        this.vProductName = theVal.getvProductName();
        this.vSerialNum = theVal.getvSerialNum();
        Integer[] rsgs = theVal.getRsgIndexes();
        this.rsgIndexes = new ArrayList(null != rsgs ? rsgs.length : 0);
        if (null != rsgs) {
            for (Integer rsg : rsgs) {
                this.rsgIndexes.add(rsg);
            }
        }
        String virtSerialStr = Long.toString(this.vSerialNum);
        BaseDeviceNumber bdn = theVal.getVirtLDEVInfo();
        try {
            this.virtLDEVInfo = new BaseDeviceNumber(virtSerialStr, bdn.getLdkc(), bdn.getLdev(), bdn.getCu(), this.vEmulation);
        }
        catch (RemoteException | GetRmiException e) {
            throw new WBEMException(1, "Error getting BaseDeviceNumber", null, e);
        }
        if (!RMIObjectMapping.setVirtual2RealMapping(virtSerialStr, this.getSerialNumber())) {
            throw new WBEMException(virtSerialStr + " can not be mapped to " + this.getSerialNumber() + " because it is already mappped to another device");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualLDEV other = (VirtualLDEV)obj;
        if (this.huvmAttr != other.huvmAttr) {
            return false;
        }
        if (this.realCU != other.realCU) {
            return false;
        }
        if (this.realDKC != other.realDKC) {
            return false;
        }
        if (this.realLDEV != other.realLDEV) {
            return false;
        }
        if (this.rsgIndexes == null ? other.rsgIndexes != null : !this.rsgIndexes.equals(other.rsgIndexes)) {
            return false;
        }
        if (this.vBoxID != other.vBoxID) {
            return false;
        }
        if (this.vCvs != other.vCvs) {
            return false;
        }
        if (this.vEmulation != other.vEmulation) {
            return false;
        }
        if (this.vInfFlag != other.vInfFlag) {
            return false;
        }
        if (this.vLuse != other.vLuse) {
            return false;
        }
        if (!Arrays.equals(this.vModel, other.vModel)) {
            return false;
        }
        if (this.vProductName == null ? other.vProductName != null : !this.vProductName.equals(other.vProductName)) {
            return false;
        }
        if (this.vSSID != other.vSSID) {
            return false;
        }
        if (this.vSerialNum != other.vSerialNum) {
            return false;
        }
        return !(this.virtLDEVInfo == null ? other.virtLDEVInfo != null : !this.virtLDEVInfo.equals(other.virtLDEVInfo));
    }

    public short getHuvmAttr() {
        return this.huvmAttr;
    }

    public short getRealCU() {
        return this.realCU;
    }

    public short getRealDKC() {
        return this.realDKC;
    }

    public short getRealLDEV() {
        return this.realLDEV;
    }

    public Integer[] getRsgIndexes() {
        return this.rsgIndexes.toArray(new Integer[this.rsgIndexes.size()]);
    }

    public int getvBoxID() {
        return this.vBoxID;
    }

    public int getvEmulation() {
        return this.vEmulation;
    }

    public short getvInfFlag() {
        return this.vInfFlag;
    }

    public BaseDeviceNumber getVirtLDEVInfo() {
        return this.virtLDEVInfo;
    }

    public byte getvLuse() {
        return this.vLuse;
    }

    public byte[] getvModel() {
        return this.vModel;
    }

    public String getVModelName() {
        String ret;
        byte[] model = this.getvModel();
        int temp = (model[0] << 8) + (model[1] & 0xFF);
        switch (temp) {
            case 5120: {
                mLogger.log(Level.WARNING, "0x{0} is a generic HM800 model", Integer.toHexString(temp));
                ret = "HM800";
                break;
            }
            case 5137: {
                ret = "HM800 (S Model)";
                break;
            }
            case 5138: {
                ret = "HM800 (M Model)";
                break;
            }
            case 5139: {
                ret = "HM800 (H Model)";
                break;
            }
            case 4864: {
                ret = "HM700";
                break;
            }
            case 1024: {
                ret = "Raid800";
                break;
            }
            case 768: {
                ret = "Raid700";
                break;
            }
            case 512: 
            case 513: {
                ret = "Raid600";
                break;
            }
            case 256: 
            case 257: {
                ret = "Raid500";
                break;
            }
            case 8225: {
                ret = "DF850 XS";
                break;
            }
            case 8226: {
                ret = "DF850 S";
                break;
            }
            case 8227: {
                ret = "DF850 MH";
                break;
            }
            default: {
                mLogger.log(Level.SEVERE, "0x{0} is an unrecognized model", Integer.toHexString(temp));
                ret = "UNKNOWN";
            }
        }
        return ret;
    }

    public String getvProductName() {
        return this.vProductName;
    }

    public long getvSerialNum() {
        return this.vSerialNum;
    }

    public int getvSSID() {
        return this.vSSID;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.huvmAttr;
        result = 31 * result + this.realCU;
        result = 31 * result + this.realDKC;
        result = 31 * result + this.realLDEV;
        result = 31 * result + (this.rsgIndexes == null ? 0 : this.rsgIndexes.hashCode());
        result = 31 * result + this.vBoxID;
        result = 31 * result + (this.vCvs ? 1231 : 1237);
        result = 31 * result + this.vEmulation;
        result = 31 * result + this.vInfFlag;
        result = 31 * result + this.vLuse;
        result = 31 * result + Arrays.hashCode(this.vModel);
        result = 31 * result + (this.vProductName == null ? 0 : this.vProductName.hashCode());
        result = 31 * result + this.vSSID;
        result = 31 * result + (int)(this.vSerialNum ^ this.vSerialNum >>> 32);
        result = 31 * result + (this.virtLDEVInfo == null ? 0 : this.virtLDEVInfo.hashCode());
        return result;
    }

    public boolean isvCvs() {
        return this.vCvs;
    }

    @Override
    public String toString() {
        return "VirtualLDEV [realDKC=" + this.realDKC + ", realCU=" + this.realCU + ", realLDEV=" + this.realLDEV + ", virtLDEVInfo=" + this.virtLDEVInfo + ", huvmAttr=" + this.huvmAttr + ", vCvs=" + this.vCvs + ", vEmulation=" + this.vEmulation + ", vInfFlag=" + this.vInfFlag + ", vLuse=" + this.vLuse + ", vSSID=" + this.vSSID + ", vBoxID=" + this.vBoxID + ", vModel=" + Arrays.toString(this.vModel) + ", vProductName=" + this.vProductName + ", vSerialNum=" + this.vSerialNum + ", rsgIndexes=" + this.rsgIndexes + "]";
    }

    private static class WorkerThread
    implements Task {
        private final IteratorCallback<VirtualLDEV> callback;
        private final TaskProcessor theTask;
        private final String serialNum;
        private final Robj_interface_HUVMVirtualLdev theVal;
        private final short cu;
        private final short dkc;
        private final boolean realVals;
        private final short ldev;
        private final Map<Integer, Robj_interface_HUVMVirtualDkc> vDKC;
        private final RMIObjectCache rmiObject;

        public WorkerThread(IteratorCallback<VirtualLDEV> callback, RMIObjectCache rmiObj, String serialNum, Robj_interface_HUVMVirtualLdev val, short dkc, short cu, short ldev, boolean realVals, Map<Integer, Robj_interface_HUVMVirtualDkc> sortedVDKC, TaskProcessor pTheTask) {
            this.callback = callback;
            this.rmiObject = rmiObj;
            this.serialNum = serialNum;
            this.theVal = val;
            this.dkc = dkc;
            this.cu = cu;
            this.ldev = ldev;
            this.realVals = realVals;
            this.theTask = pTheTask;
            this.vDKC = sortedVDKC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            try {
                if (!this.theTask.shouldStop()) {
                    Robj_interface_RJiLDEVIndex virtDev = this.theVal.getRobjVirtualLdev();
                    Robj_interface_HUVMVirtualDkc virtSerial = this.vDKC.get(this.theVal.getRobjVboxIndex().getVboxId());
                    if (virtDev.getSLDEV() == this.theVal.getSLDEV() && virtDev.getSCU() == this.theVal.getSCU() && virtDev.getSLDKC() == this.theVal.getSLDKC() && virtSerial.getVSerialNo() == (long)Integer.parseInt(this.serialNum)) {
                        return;
                    }
                    long virtDN = BaseDeviceNumber.makeUniqueDN(this.theVal.getSLDKC(), this.theVal.getSCU(), this.theVal.getSLDEV());
                    DeviceNumber realDN = DeviceNumber.find(Long.toString(virtDN), false, this.rmiObject);
                    if (this.realVals) {
                        virtDev = (Robj_interface_RJiLDEVIndex)this.rmiObject.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.RJILDEVINDEX);
                        virtDev.setSLDKC(this.theVal.getSLDKC());
                        virtDev.setSCU(this.theVal.getSCU());
                        virtDev.setSLDEV(this.theVal.getSLDEV());
                    }
                    if (!(-1 != this.dkc && this.dkc != virtDev.getSLDKC() || -1 != this.cu && this.cu != virtDev.getSCU() || -1 != this.ldev && this.ldev != virtDev.getSLDEV())) {
                        VirtualLDEV retVal = new VirtualLDEV(this.serialNum, this.theVal, this.vDKC, realDN);
                        this.callback.returnItem(retVal);
                        if (-1 != this.dkc) {
                            this.theTask.setStop(true);
                        }
                    }
                }
            }
            catch (Exception e) {
                WBEMException we = e instanceof WBEMException ? (WBEMException)((Object)e) : new WBEMException(1, "Exception while processing items", null, (Throwable)e);
                this.callback.exceptionOccurred(we);
                this.theTask.setStop(true);
            }
            finally {
                int counter = this.theTask.taskDone();
                if (counter < 1) {
                    this.callback.done();
                }
            }
        }
    }
}

