/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class AssociatedStoragePoolPrimordialComponentDiskExtentInstrumentation
extends BaseAssocInstrumentation {
    protected AssociatedStoragePoolPrimordialComponentDiskExtentInstrumentation() {
        super("HITACHI_AssociatedStoragePoolPrimordialComponentDiskExtent", "HITACHI_StoragePoolPrimordial", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolPrimordialInstrumentation"), "HITACHI_DiskExtent", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskExtentInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_AssociatedStoragePoolPrimordialComponentDiskExtent".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        Hashtable<String, Object> expectedVals = this.getReference2SearchProperties(objectName);
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedVals, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        CIMInstance instStoragePoolPrimordial = this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject());
                        iter.add(instStoragePoolPrimordial.filterProperties(propertyList));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath sppOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath deOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), null);
                ReferenceInfo newRefInfo = new ReferenceInfo(sppOP, null, this.getReference1PropertyName(), this.getReference2PropertyName(), null, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(deviceIter, deOP, null, null, null, continueOnError, true, this.getReference2SearchProperties(sppOP), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath deOP;
            String sppPropName = this.getReference1PropertyName();
            CIMObjectPath sppOP = op.getKey(sppPropName) != null ? (CIMObjectPath)op.getKey(sppPropName).getValue() : null;
            String dePropName = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = deOP = op.getKey(dePropName) != null ? (CIMObjectPath)op.getKey(dePropName).getValue() : null;
            if (null != deOP && null != sppOP && this.getReference1Instrumentation().instanceExists(sppOP) && this.getReference2Instrumentation().instanceExists(deOP)) {
                String deSysName;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(deOP, "SystemName");
                CIMProperty sppInstIDProp = sppOP.getKey("InstanceID");
                String sppSysNameName = ProviderLibs.getAllButEndString((String)sppInstIDProp.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String sppPrimordial = ProviderLibs.getEndString((String)sppInstIDProp.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                CIMProperty deSysNameProp = deOP.getKey("SystemName");
                String string = deSysName = deSysNameProp != null ? (String)deSysNameProp.getValue() : null;
                if ("Primordial".equals(sppPrimordial) && null != sppSysNameName && null != deSysName && sppSysNameName.equals(deSysName) && sppSysNameName.equals(device.getStorageSystemName())) {
                    return this.generateInstance(op, propertyList, sppOP, deOP);
                }
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opRef2) {
        String sysName;
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        CIMProperty cpSysName = opRef2.getKey("SystemName");
        if (null != cpSysName && null != (sysName = (String)cpSysName.getValue())) {
            ret.put("SystemName", sysName);
        }
        return ret;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        String instID;
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        CIMProperty cpInstID = opRef1.getKey("InstanceID");
        if (null != cpInstID && null != (instID = (String)cpInstID.getValue())) {
            ret.put("SystemName", instID);
        }
        return ret;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_AssociatedStoragePoolPrimordialComponentDiskExtent".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath deOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                    CIMObjectPath opObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opObjectName, null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                    this.getReference2Instrumentation().enumerate(iter, deOP, new String[0], null, null, continueOnError, true, this.getReference2SearchProperties(objectName), newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMObjectPath sppOP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opObjectName = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, sppOP, opObjectName));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, sppOP, opObjectName));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

