/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;

public class AuthorizedSubjectInstrumentation
extends BaseAssocInstrumentation
implements CacheUpdateNotifier {
    protected AuthorizedSubjectInstrumentation() {
        super("HITACHI_AuthorizedSubject", "HITACHI_AuthorizedPrivilege", "Privilege", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.AuthorizedPrivilegeInstrumentation"), "HITACHI_StorageHardwareID", "PrivilegedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageHardwareIDInstrumentation"));
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            try {
                AbstractBaseCommonObject theObj = (AbstractBaseCommonObject)pObj;
                String serialNum = theObj.getSerialNumber();
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
                CIMObjectPath opNamespace = new CIMObjectPath(null, null, null, ProviderLibs.getImplementationNamespace(), "", null);
                IndicationHelper helper = new IndicationHelper(mHandle);
                if (theObj instanceof PortandHostGroupInfo) {
                    String[] hostORiscsiNames = ((PortandHostGroupInfo)theObj).getHostWWNs();
                    this.processIndication(device.getRMIObject(), theObj, new HashSet<String>(Arrays.asList(hostORiscsiNames)), opNamespace, helper, true);
                } else {
                    List<ISCSITargetPort.ISCSITarget> targets = ((ISCSITargetPort)theObj).getTargets();
                    HashSet<String> rNames = new HashSet<String>();
                    for (ISCSITargetPort.ISCSITarget target : targets) {
                        for (ISCSITargetPort.RemoteiSCSIName rName : target.getRemoteNames()) {
                            rNames.add(rName.getName());
                        }
                        this.processIndication(device.getRMIObject(), target, rNames, opNamespace, helper, true);
                    }
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_AuthorizedSubject added indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            try {
                AbstractBaseCommonObject theObj = (AbstractBaseCommonObject)pObj;
                String serialNum = theObj.getSerialNumber();
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
                CIMObjectPath opNamespace = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_AuthorizedSubject", null);
                IndicationHelper helper = new IndicationHelper(mHandle);
                if (theObj instanceof PortandHostGroupInfo) {
                    String[] hostORiscsiNames = ((PortandHostGroupInfo)theObj).getHostWWNs();
                    this.processIndication(device.getRMIObject(), theObj, new HashSet<String>(Arrays.asList(hostORiscsiNames)), opNamespace, helper, false);
                } else {
                    List<ISCSITargetPort.ISCSITarget> targets = ((ISCSITargetPort)theObj).getTargets();
                    HashSet<String> rNames = new HashSet<String>();
                    for (ISCSITargetPort.ISCSITarget target : targets) {
                        for (ISCSITargetPort.RemoteiSCSIName rName : target.getRemoteNames()) {
                            rNames.add(rName.getName());
                        }
                        this.processIndication(device.getRMIObject(), target, rNames, opNamespace, helper, false);
                    }
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_AuthorizedSubject deleted indication instance", t);
            }
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath opNamespace = new CIMObjectPath(null, null, null, ProviderLibs.getImplementationNamespace(), "", null);
                IndicationHelper helper = new IndicationHelper(mHandle);
                HashSet<String> prevWWNSet = new HashSet<String>();
                HashSet<String> newWWNSet = new HashSet<String>();
                AbstractBaseCommonObject theOldObj = (AbstractBaseCommonObject)pObj;
                String serialNum = theOldObj.getSerialNumber();
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
                if (theOldObj instanceof PortandHostGroupInfo) {
                    PortandHostGroupInfo phgiPrev = (PortandHostGroupInfo)theOldObj;
                    List<String> tmpList = Arrays.asList(phgiPrev.getHostWWNs());
                    prevWWNSet.addAll(tmpList);
                    PortandHostGroupInfo phgiNew = PortandHostGroupInfo.find(serialNum, phgiPrev.getSystemName(), String.valueOf(phgiPrev.getCtrlID()), String.valueOf(phgiPrev.getPortID()), String.valueOf(phgiPrev.getHostgroupID()), null, false, null);
                    if (phgiNew != null) {
                        String[] newHostWWNs = phgiNew.getHostWWNs();
                        newWWNSet.addAll(Arrays.asList(newHostWWNs));
                    }
                    HashSet<String> tmp = new HashSet<String>(newWWNSet);
                    tmp.removeAll(prevWWNSet);
                    if (!tmp.isEmpty()) {
                        this.processIndication(device.getRMIObject(), phgiNew, tmp, opNamespace, helper, true);
                    }
                    tmp.clear();
                    tmp.addAll(prevWWNSet);
                    tmp.removeAll(newWWNSet);
                    if (!tmp.isEmpty()) {
                        this.processIndication(device.getRMIObject(), phgiNew, tmp, opNamespace, helper, false);
                    }
                } else {
                    ISCSITargetPort oldPort = (ISCSITargetPort)theOldObj;
                    ISCSITargetPort newPort = ISCSITargetPort.find(device.getRMIObject(), oldPort.getPortId());
                    List<ISCSITargetPort.ISCSITarget> targets = oldPort.getTargets();
                    for (ISCSITargetPort.ISCSITarget target : targets) {
                        for (ISCSITargetPort.RemoteiSCSIName rName : target.getRemoteNames()) {
                            prevWWNSet.add(rName.getName());
                        }
                        ISCSITargetPort.ISCSITarget newTarget = newPort.getTarget(target.getId());
                        for (ISCSITargetPort.RemoteiSCSIName rName : newTarget.getRemoteNames()) {
                            newWWNSet.add(rName.getName());
                        }
                        HashSet<String> tmp = new HashSet<String>(newWWNSet);
                        tmp.removeAll(prevWWNSet);
                        if (!tmp.isEmpty()) {
                            this.processIndication(device.getRMIObject(), newTarget, tmp, opNamespace, helper, true);
                        }
                        tmp.clear();
                        tmp.addAll(prevWWNSet);
                        tmp.removeAll(newWWNSet);
                        if (tmp.isEmpty()) continue;
                        this.processIndication(device.getRMIObject(), newTarget, prevWWNSet, opNamespace, helper, false);
                    }
                }
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_AuthorizedSubject modified indication instance", t);
            }
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opStorageHardwareID) {
        String cvInstanceID;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        CIMProperty cpInstanceID = opStorageHardwareID.getKey("InstanceID");
        String string = cvInstanceID = null != cpInstanceID ? (String)cpInstanceID.getValue() : null;
        if (null != cvInstanceID) {
            hTable.put("ElementName", cvInstanceID);
            String hostWWN = ProviderLibs.getEndString(cvInstanceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            hTable.put("HostWWN", hostWWN);
        }
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opAuthorizedPrivilege) {
        String cvInstanceID;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        CIMProperty cpInstanceID = opAuthorizedPrivilege.getKey("InstanceID");
        String string = cvInstanceID = null != cpInstanceID ? (String)cpInstanceID.getValue() : null;
        if (null != cvInstanceID) {
            hTable.put("SystemName", cvInstanceID);
            String hostWWN = ProviderLibs.getEndString(cvInstanceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            hTable.put("HostWWN", hostWWN);
        }
        return hTable;
    }

    private void processIndication(RMIObjectCache rmiObj, AbstractBaseCommonObject commonObj, Set<String> set2Process, CIMObjectPath opNamespace, IndicationHelper helper, boolean isCreateInd) {
        for (String item2Process : set2Process) {
            try {
                CIMObjectPath opAuthorizedPrivilege = this.getReference1Instrumentation().generateObjectPath(opNamespace, commonObj, item2Process);
                CIMObjectPath opStorageHardwareID = this.getReference2Instrumentation().generateObjectPath(opNamespace, rmiObj, item2Process);
                CIMInstance instAuthorizedSubject = this.generateInstance(opNamespace, null, opAuthorizedPrivilege, opStorageHardwareID);
                CIMInstance indication = isCreateInd ? helper.createInstCreationInstance(instAuthorizedSubject) : helper.createInstDeletionInstance(instAuthorizedSubject);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable th) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate an HITACHI_AuthorizedSubject deleted indication instance", th);
            }
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_AuthorizedSubject".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_AuthorizedSubject".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(false);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORTHOSTGROUP, this, null);
        }
    }
}

