/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.LDEVStats;
import com.hitachi.smi.common.PortStats;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;

public class BlockStatisticalDataStorageSystemInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues);
            for (RMIObjectMapping device : devices) {
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                if (null != refInfo) {
                    refInfo.addReference(iter, ci.getObjectPath());
                    continue;
                }
                if (isObjectPath) {
                    iter.add(ci.getObjectPath());
                    continue;
                }
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        try {
            CIMObjectPath retOP = this.generateObjectPath(op, o);
            RMIObjectCache rmiObj = (RMIObjectCache)o[0];
            CIMProperty[] keys = retOP.getKeys();
            PortStats stats = PortStats.getAllPortStats(rmiObj.getSMISMappingContainer().getSerialNumber());
            CloseableAddableIterator ldevIter = new CloseableAddableIterator();
            LDEVStats.getAllStats(rmiObj, (CloseableAddableIterator<LDEVStats>)ldevIter);
            BigInteger readIOs = BigInteger.ZERO;
            BigInteger writeIOs = BigInteger.ZERO;
            BigInteger readHitIOs = BigInteger.ZERO;
            BigInteger writeHitIOs = BigInteger.ZERO;
            BigInteger kBytesRead = BigInteger.ZERO;
            BigInteger kBytesWritten = BigInteger.ZERO;
            while (ldevIter.hasNext()) {
                LDEVStats stat = (LDEVStats)ldevIter.next();
                mLogger.log(Level.FINE, "Adding LDEVStat to sum: {0}", stat);
                readIOs = readIOs.add(stat.getReadIOStatistic().bigIntegerValue());
                readHitIOs = readHitIOs.add(stat.getReadHitStatistic().bigIntegerValue());
                kBytesRead = kBytesRead.add(stat.getReadTransRateStatistic().bigIntegerValue());
                writeIOs = writeIOs.add(stat.getWriteIOStatistic().bigIntegerValue());
                writeHitIOs = writeHitIOs.add(stat.getWriteHitStatistic().bigIntegerValue());
                kBytesWritten = kBytesWritten.add(stat.getWriteTransRateStatistic().bigIntegerValue());
            }
            CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("SampleInterval", CIMDataType.DATETIME_T, (Object)new CIMDateTimeInterval("00000000000500.000000:000"), false), new CIMProperty("StatisticTime", CIMDataType.DATETIME_T, (Object)stats.getTargetTime(), false), new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("TotalIOs", CIMDataType.UINT64_T, (Object)stats.getIOs(), false), new CIMProperty("KBytesTransferred", CIMDataType.UINT64_T, (Object)stats.getTransRate(), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataStorageSystem", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataStorageSystem", false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataStorageSystem", false), new CIMProperty("ReadIOs", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(readIOs), false), new CIMProperty("ReadHitIOs", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(readHitIOs), false), new CIMProperty("KBytesRead", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(kBytesRead), false), new CIMProperty("WriteIOs", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(writeIOs), false), new CIMProperty("WriteHitIOs", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(writeHitIOs), false), new CIMProperty("KBytesWritten", CIMDataType.UINT64_T, (Object)new UnsignedInteger64(kBytesWritten), false)};
            return new CIMInstance(retOP, props).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "CIM_BlockStorageStatisticalData");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String name = null;
        try {
            name = rmiObj.getSMISMappingContainer().getStorageSystemName();
        }
        catch (Exception e) {
            throw new WBEMException(1, "Unable to get storage system name!", null, (Throwable)e);
        }
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)name, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_BlockStatisticalDataStorageSystem", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            String instIDVal;
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
            String name = device.getStorageSystemName();
            CIMProperty cpInstID = op.getKey("InstanceID");
            String string = instIDVal = null != cpInstID ? (String)cpInstID.getValue() : null;
            if (null == instIDVal || !instIDVal.equals(name)) {
                throw new WBEMException(6, op != null ? op.toString() : null);
            }
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

