/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class BlockStatisticsServiceInstrumentation
extends BaseInstrumentation {
    private static String bss = "HITACHI_BlockStatisticsService".substring("HITACHI_".length());

    private boolean checkKeyVal(CIMObjectPath op, String propName, String propVal) throws WBEMException {
        String val;
        CIMProperty cpProp = op.getKey(propName);
        String string = val = null != cpProp ? (String)cpProp.getValue() : null;
        if (null == val || !val.equals(propVal)) {
            throw new WBEMException(6, propName + " does not match " + propVal + ": " + (op != null ? op.toString() : null));
        }
        return true;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevicesFromObjectPath(op, "SystemName");
            for (RMIObjectMapping device : devices) {
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                if (null != refInfo) {
                    refInfo.addReference(iter, ci.getObjectPath());
                    continue;
                }
                if (isObjectPath) {
                    iter.add(ci.getObjectPath());
                    continue;
                }
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        try {
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("StartMode", CIMDataType.STRING_T, (Object)"Automatic", false), new CIMProperty("Started", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(2), false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)bss, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)bss, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)bss, false)};
            return new CIMInstance(retOP, props).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_BlockStatisticsService");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String name = null;
        try {
            name = rmiObj.getSMISMappingContainer().getStorageSystemName();
        }
        catch (Exception e) {
            throw new WBEMException(1, "Unable to get storage system name!", null, (Throwable)e);
        }
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticsService", true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)bss, true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)name, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_BlockStatisticsService", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
            String name = device.getStorageSystemName();
            this.checkKeyVal(op, "SystemName", name);
            this.checkKeyVal(op, "CreationClassName", "HITACHI_BlockStatisticsService");
            this.checkKeyVal(op, "Name", bss);
            this.checkKeyVal(op, "SystemCreationClassName", "HITACHI_StorageSystem");
            return this.generateInstance(op, propertyList, device.getRMIObject());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

