/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.DKCChassisInstrumentation;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class DKUChassisInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Tag", expectedValues, new String[]{"SystemName", "Tag"});
        try {
            String expTag;
            String expChassisID = null;
            String string = expTag = null != expectedValues ? (String)expectedValues.get("Tag") : null;
            if (null != expTag) {
                if (1 == devices.size()) {
                    expChassisID = ProviderLibs.getEndString(expTag, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                } else {
                    mLogger.log(Level.SEVERE, "Tag, {0}, results in Insf. managed devices - {1}", new Object[]{expTag, devices.size()});
                    iter.done();
                    return;
                }
            }
            for (RMIObjectMapping device : devices) {
                Iterator<String> iterDKUChassis = PDEVInfoEntry.getDKUChassisLocations(device.getSerialNumber());
                while (iterDKUChassis.hasNext()) {
                    String chassisID = iterDKUChassis.next();
                    if (null != expChassisID && !expChassisID.equals(chassisID)) continue;
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject(), chassisID));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, device.getRMIObject(), chassisID));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, device.getRMIObject(), chassisID));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String dkuID = (String)o[1];
        try {
            String model = rmiObj.getSMISMappingContainer().getModel();
            String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
            String tag = DKCChassisInstrumentation.createTag(dkuID, model, serialNum);
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], new CIMProperty("ChassisTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(18)}, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("Manufacturer", CIMDataType.STRING_T, (Object)"HITACHI", false), new CIMProperty("Model", CIMDataType.STRING_T, (Object)model, false), new CIMProperty("SerialNumber", CIMDataType.STRING_T, (Object)serialNum, false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)tag, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(2)}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)tag, false)};
            return new CIMInstance(retOP, retProps).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class, String.class}, o, "HITACHI_DKUChassis");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String dkuID = (String)o[1];
        String model = rmiObj.getSMISMappingContainer().getModel();
        String serialNum = rmiObj.getSMISMappingContainer().getSerialNumber();
        String tag = DKCChassisInstrumentation.createTag(dkuID, model, serialNum);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_DKUChassis", true), new CIMProperty("Tag", CIMDataType.STRING_T, (Object)tag, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DKUChassis", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Tag");
        try {
            String tagKeyValue;
            String ccName = null != op.getKey("CreationClassName") ? (String)op.getKey("CreationClassName").getValue() : null;
            String string = tagKeyValue = null != op.getKey("Tag") ? (String)op.getKey("Tag").getValue() : null;
            if (null == ccName || !ccName.equals("HITACHI_DKUChassis") || null == tagKeyValue) {
                throw new WBEMException(6, op.toString());
            }
            String[] vals = DKCChassisInstrumentation.decodeTag(tagKeyValue);
            String ssKeyValue = vals[0];
            String dkuID = vals[1];
            if (PDEVInfoEntry.dkuChassExists(device.getSerialNumber(), dkuID)) {
                String ssName = device.getStorageSystemName();
                if (null != ssKeyValue && ssKeyValue.equals(ssName)) {
                    return this.generateInstance(op, propertyList, device.getRMIObject(), dkuID);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

