/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class DiskProductInstrumentation
extends BaseInstrumentation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "Name", expectedValues, new String[]{"Name", "SystemName"});
        try {
            Integer iRDevNum;
            Integer iCDevNum;
            int expCDevNum = -1;
            int expRDevNum = -1;
            Integer n = iCDevNum = null != expectedValues ? (Integer)expectedValues.get("CDevNum") : null;
            if (null != iCDevNum) {
                expCDevNum = iCDevNum;
            }
            Integer n2 = iRDevNum = null != expectedValues ? (Integer)expectedValues.get("RDevNum") : null;
            if (null != iRDevNum) {
                expRDevNum = iRDevNum;
            }
            for (RMIObjectMapping device : devices) {
                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, expCDevNum, expRDevNum);
                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                for (PDEVInfoEntry pdev : pdevs) {
                    CIMObjectPath retOP;
                    if (null != refInfo) {
                        retOP = this.generateObjectPath(op, pdev);
                        refInfo.addReference(iter, retOP);
                        continue;
                    }
                    if (isObjectPath) {
                        retOP = this.generateObjectPath(op, pdev);
                        iter.add(retOP);
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, pdev));
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            Object callback = null;
            if (iter != null && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        if (null == o || o.length != 1) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_INSTANCE_ILLEGAL_ARGUMENT + " " + "HITACHI_DiskProduct");
        }
        PDEVInfoEntry infoEntry = (PDEVInfoEntry)o[0];
        try {
            CIMObjectPath retOP = this.generateObjectPath(op, infoEntry);
            CIMProperty[] keys = retOP.getKeys();
            String elementName = infoEntry.getDeviceID();
            CIMProperty[] retProps = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("Caption", CIMDataType.STRING_T, (Object)elementName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)elementName, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)elementName, false)};
            return new CIMInstance(retOP, retProps).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        if (null == o || o.length != 1) {
            throw new IllegalArgumentException(ProviderConstants.GENERATE_OBJECTPATH_ILLEGAL_ARGUMENT + " " + "HITACHI_DiskProduct");
        }
        PDEVInfoEntry infoEntry = (PDEVInfoEntry)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(infoEntry.getSerialNumber());
        String systemName = device.getStorageSystemName();
        String vendor = device.getVendor();
        String version = "0";
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("IdentifyingNumber", CIMDataType.STRING_T, (Object)infoEntry.getDeviceID(), true), new CIMProperty("Name", CIMDataType.STRING_T, (Object)systemName, true), new CIMProperty("Vendor", CIMDataType.STRING_T, (Object)vendor, true), new CIMProperty("Version", CIMDataType.STRING_T, (Object)"0", true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_DiskProduct", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "Name");
        try {
            String cvSystemName;
            CIMProperty cpID = op.getKey("IdentifyingNumber");
            String cvID = cpID != null ? (String)cpID.getValue() : null;
            CIMProperty cpVendor = op.getKey("Vendor");
            String cvVendor = cpVendor != null ? (String)cpVendor.getValue() : null;
            CIMProperty cpVersion = op.getKey("Version");
            String cvVersion = cpVersion != null ? (String)cpVersion.getValue() : null;
            CIMProperty cpSystemName = op.getKey("Name");
            String string = cvSystemName = cpSystemName != null ? (String)cpSystemName.getValue() : null;
            if (null != cpID && null != cvVendor && null != cvSystemName) {
                int[] deviceIDValues;
                String ssName = device.getStorageSystemName();
                String vendor = device.getVendor();
                String version = "0";
                if (cvSystemName.equals(ssName) && "0".equals(cvVersion) && cvVendor.equals(vendor) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(cvID))) {
                    PDEVInfoEntry infoEntry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1]);
                    return this.generateInstance(op, propertyList, infoEntry);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op != null ? op.toString() : null);
    }
}

