/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageCapabilitiesIMPL;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public final class ElementCapabilitiesStoragePoolInstrumentation
extends BaseAssocInstrumentation {
    protected ElementCapabilitiesStoragePoolInstrumentation() {
        super("HITACHI_ElementCapabilitiesStoragePool", "HITACHI_StoragePool", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolInstrumentation"), "HITACHI_StorageCapabilities", "Capabilities", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageCapabilitiesInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            if (isObjectPath) {
                CustomCloseableIterator<CIMObjectPath> ant = new CustomCloseableIterator<CIMObjectPath>();
                this.getReference1Instrumentation().enumerate(ant, new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference1ClassName(), null), null, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, null, null);
                this.getObjPath(ant, continueOnError, op, iter);
            } else {
                CustomCloseableIterator<CIMInstance> ant = new CustomCloseableIterator<CIMInstance>();
                this.getReference1Instrumentation().enumerate(ant, new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference1ClassName(), null), null, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, null, null);
                this.getInstance(ant, continueOnError, op, propertyList, iter);
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private void getInstance(CustomCloseableIterator<CIMInstance> ants, boolean continueOnError, CIMObjectPath op, String[] propertyList, CustomCloseableIterator<?> result) throws WBEMException {
        try {
            while (ants.hasNext()) {
                CIMInstance antInst = (CIMInstance)ants.next();
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(antInst.getObjectPath(), "InstanceID");
                String instID = (String)antInst.getProperty("InstanceID").getValue();
                String[] instIDParts = ProviderLibs.parseStorageCapabilitiesInstanceID(instID);
                String chassisArrayID = instIDParts[1];
                ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), false, chassisArrayID);
                StorageCapabilitiesIMPL storageCapabilitiesIMPL = new StorageCapabilitiesIMPL(cag, device.getStorageSystemName());
                CIMObjectPath opDep = this.getReference2Instrumentation().generateObjectPath(op, storageCapabilitiesIMPL);
                CIMInstance ret = this.generateInstance(op, propertyList, antInst.getObjectPath(), opDep);
                if (ret == null) continue;
                result.add(ret);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private void getObjPath(CustomCloseableIterator<CIMObjectPath> ants, boolean continueOnError, CIMObjectPath op, CustomCloseableIterator<?> result) throws Exception {
        while (ants.hasNext()) {
            CIMObjectPath antObj = (CIMObjectPath)ants.next();
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(antObj, "InstanceID");
            String instID = (String)antObj.getKey("InstanceID").getValue();
            String[] instIDParts = ProviderLibs.parseStorageCapabilitiesInstanceID(instID);
            String chassisArrayID = instIDParts[1];
            ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), false, chassisArrayID);
            StorageCapabilitiesIMPL storageCapabilitiesIMPL = new StorageCapabilitiesIMPL(cag, device.getStorageSystemName());
            CIMObjectPath depObj = this.getReference2Instrumentation().generateObjectPath(op, storageCapabilitiesIMPL);
            CIMObjectPath retOP = this.generateObjectPath(op, antObj, depObj);
            if (retOP == null) continue;
            result.add(retOP);
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String sysName = null != objectName && null != objectName.getKey("InstanceID") ? (String)objectName.getKey("InstanceID").getValue() : null;
        hTable.put("InstanceID", sysName);
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath objectName) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != objectName && null != objectName.getKey("InstanceID") ? (String)objectName.getKey("InstanceID").getValue() : null;
        hTable.put("InstanceID", name);
        return hTable;
    }
}

