/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class ElementDiskFirmwareInstrumentation
extends BaseAssocInstrumentation {
    protected ElementDiskFirmwareInstrumentation() {
        super("HITACHI_ElementDiskFirmware", "HITACHI_DiskFirmware", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskFirmwareInstrumentation"), "HITACHI_DiskDrive", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ElementDiskFirmware".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                int[] deviceIDVals = null;
                String sysName = null;
                boolean returnDiskFirmware = false;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    String instID;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    String string = instID = objectName.getKey("InstanceID") != null && objectName.getKey("InstanceID").getValue() != null ? (String)objectName.getKey("InstanceID").getValue() : null;
                    if (null != instID) {
                        String[] retSysName = new String[1];
                        deviceIDVals = PDEVInfoEntry.parseTag(instID, retSysName);
                        sysName = retSysName[0];
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    String deviceID = objectName.getKey("DeviceID") != null && objectName.getKey("DeviceID").getValue() != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                    deviceIDVals = PDEVInfoEntry.parseDeviceID(deviceID);
                    sysName = objectName.getKey("SystemName") != null && objectName.getKey("SystemName").getValue() != null ? (String)objectName.getKey("SystemName").getValue() : null;
                    returnDiskFirmware = true;
                }
                if (null != device && null != deviceIDVals && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), (int)deviceIDVals[0], (int)deviceIDVals[1])) != null) {
                    if (returnDiskFirmware) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, infoEntry));
                        }
                    } else if (isObjectPath) {
                        iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry));
                    } else {
                        iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, infoEntry));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackIMPL<PDEVInfoEntry> callback = new CallbackIMPL<PDEVInfoEntry>(deviceIter, isObjectPath, refInfo, op, propertyList);
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDiskDrive;
            String dfPropName = this.getReference1PropertyName();
            CIMObjectPath opDiskFirmware = op.getKey(dfPropName) != null ? (CIMObjectPath)op.getKey(dfPropName).getValue() : null;
            String ddPropName = this.getReference2PropertyName();
            CIMObjectPath cIMObjectPath = opDiskDrive = op.getKey(ddPropName) != null ? (CIMObjectPath)op.getKey(ddPropName).getValue() : null;
            if (null != opDiskFirmware && null != opDiskDrive && this.getReference1Instrumentation().instanceExists(opDiskFirmware) && this.getReference2Instrumentation().instanceExists(opDiskDrive)) {
                PDEVInfoEntry infoEntry;
                String instID;
                String ddDeviceID = opDiskDrive.getKey("DeviceID") != null && opDiskDrive.getKey("DeviceID").getValue() != null ? (String)opDiskDrive.getKey("DeviceID").getValue() : null;
                String ddSysName = opDiskDrive.getKey("SystemName") != null && opDiskDrive.getKey("SystemName").getValue() != null ? (String)opDiskDrive.getKey("SystemName").getValue() : null;
                int[] ddDeviceIDVals = PDEVInfoEntry.parseDeviceID(ddDeviceID);
                RMIObjectMapping device = null;
                int[] dfDeviceIDVals = null;
                String dfSysName = null;
                String string = instID = opDiskFirmware.getKey("InstanceID") != null && opDiskFirmware.getKey("InstanceID").getValue() != null ? (String)opDiskFirmware.getKey("InstanceID").getValue() : null;
                if (null != instID) {
                    String serial = ProviderLibs.getSerialFromString(instID);
                    device = RMIObjectMapping.getRMIObjectMapping(serial);
                    String[] sysName = new String[1];
                    dfDeviceIDVals = PDEVInfoEntry.parseTag(instID, sysName);
                    dfSysName = sysName[0];
                }
                if (null != device && null != dfSysName && null != ddSysName && dfSysName.equals(ddSysName) && dfSysName.equals(device.getStorageSystemName()) && null != dfDeviceIDVals && null != ddDeviceIDVals && dfDeviceIDVals[0] == ddDeviceIDVals[0] && dfDeviceIDVals[1] == ddDeviceIDVals[1] && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), dfDeviceIDVals[0], dfDeviceIDVals[1])) != null) {
                    opDiskFirmware = this.getReference1Instrumentation().generateObjectPath(op, infoEntry);
                    opDiskDrive = this.getReference2Instrumentation().generateObjectPath(op, infoEntry);
                    return this.generateInstance(op, propertyList, opDiskFirmware, opDiskDrive);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ElementDiskFirmware".equalsIgnoreCase(assocName.getObjectName())) {
                PDEVInfoEntry infoEntry;
                String serial;
                int[] deviceIDVals = null;
                String sysName = null;
                RMIObjectMapping device = null;
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    String instID;
                    String string = instID = objectName.getKey("InstanceID") != null && objectName.getKey("InstanceID").getValue() != null ? (String)objectName.getKey("InstanceID").getValue() : null;
                    if (null != instID) {
                        serial = ProviderLibs.getSerialFromString(instID);
                        device = RMIObjectMapping.getRMIObjectMapping(serial);
                        String[] retSysName = new String[1];
                        deviceIDVals = PDEVInfoEntry.parseTag(instID, retSysName);
                        sysName = retSysName[0];
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    String deviceID = objectName.getKey("DeviceID") != null && objectName.getKey("DeviceID").getValue() != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                    deviceIDVals = PDEVInfoEntry.parseDeviceID(deviceID);
                    sysName = objectName.getKey("SystemName") != null && objectName.getKey("SystemName").getValue() != null ? (String)objectName.getKey("SystemName").getValue() : null;
                    serial = ProviderLibs.getSerialFromString(sysName);
                    device = RMIObjectMapping.getRMIObjectMapping(serial);
                }
                if (null != device && null != deviceIDVals && null != sysName && sysName.equals(device.getStorageSystemName()) && (infoEntry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDVals[0], deviceIDVals[1])) != null) {
                    CIMObjectPath opDiskFirmware = this.getReference1Instrumentation().generateObjectPath(objectName, infoEntry);
                    CIMObjectPath opDiskDrive = this.getReference2Instrumentation().generateObjectPath(objectName, infoEntry);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opDiskFirmware, opDiskDrive));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opDiskFirmware, opDiskDrive));
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    public class CallbackIMPL<E extends PDEVInfoEntry>
    extends IteratorCallbackIMPL<E> {
        public CallbackIMPL(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block5: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E entry = item;
                        CIMObjectPath opDiskFirmware = ElementDiskFirmwareInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.mOP, entry);
                        CIMObjectPath opDiskDrive = ElementDiskFirmwareInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.mOP, entry);
                        if (this.mIsObjectPath) {
                            this.mIter.add(ElementDiskFirmwareInstrumentation.this.generateObjectPath(this.mOP, opDiskFirmware, opDiskDrive));
                            break block5;
                        }
                        this.mIter.add(ElementDiskFirmwareInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, opDiskFirmware, opDiskDrive));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                        ret = false;
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

