/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageVolumeCallbackHandler;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMDataType;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ElementProtectionSettingDataInstrumentation
extends BaseAssocInstrumentation {
    protected ElementProtectionSettingDataInstrumentation() {
        super("HITACHI_ElementProtectionSettingData", "HITACHI_StorageVolume", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"), "HITACHI_StorageProtectionSetting", "SettingData", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProtectionSettingInstrumentation"));
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                StorageVolumeCallbackHandler<DeviceNumber> callback = new StorageVolumeCallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList, VolumeTypeEnum.ALL, this);
                DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, null == propertyList || propertyList.length > 0, null);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        return new CIMProperty[]{new CIMProperty("IsDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("IsCurrent", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false)};
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opRef2) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String sysName = null != opRef2 && null != opRef2.getKey("InstanceID") ? (String)opRef2.getKey("InstanceID").getValue() : null;
        hTable.put("SystemName", ProviderLibs.getAllButEndString(sysName, ProviderConstants.ID_SEPERATOR_AS_CHAR));
        hTable.put("DeviceID", ProviderLibs.getEndString(sysName));
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opStorageVolume) {
        String[] props;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        for (String prop : props = new String[]{"SystemName", "DeviceID"}) {
            String val;
            String string = val = null != opStorageVolume && null != opStorageVolume.getKey(prop) ? (String)opStorageVolume.getKey(prop).getValue() : null;
            if (val == null) continue;
            hTable.put(prop, val);
        }
        return hTable;
    }
}

