/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class ElementViewCapabilitiesInstrumentation
extends BaseAssocInstrumentation {
    protected ElementViewCapabilitiesInstrumentation() {
        super("HITACHI_ElementViewCapabilities", "HITACHI_StorageSystem", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_ViewCapabilities", "Capabilities", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ViewCapabilitiesInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ElementViewCapabilities".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("ManagedElement")) && (null == resultRole || resultRole.equalsIgnoreCase("Capabilities"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        Hashtable<String, Object> expectedValues = this.createExpectedValues(device);
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, expectedValues, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Capabilities")) && (null == resultRole || resultRole.equalsIgnoreCase("ManagedElement")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private Hashtable<String, Object> createExpectedValues(RMIObjectMapping device) throws WBEMException {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("SystemName", device.getStorageSystemName());
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opViewCaps = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ViewCapabilities", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(opStorageSystem, null, "ManagedElement", "Capabilities", propertyList, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(deviceIter, opViewCaps, new String[0], null, null, continueOnError, true, this.createExpectedValues(device), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_ElementViewCapabilities".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageSystem") && (null == role || role.equalsIgnoreCase("ManagedElement")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath opViewCaps = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_ViewCapabilities", null);
                    CIMObjectPath opStorageSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opStorageSystem, null, "ManagedElement", "Capabilities", propertyList, isObjectPath, this);
                    this.getReference2Instrumentation().enumerate(iter, opViewCaps, new String[0], null, null, continueOnError, true, this.createExpectedValues(device), newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_ViewCapabilities") && (null == role || role.equalsIgnoreCase("Capabilities")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                    CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opViewCaps = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(opViewCaps, opStorageSystem, opViewCaps));
                    } else {
                        iter.add(this.generateInstance(opViewCaps, propertyList, opStorageSystem, opViewCaps));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

