/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.GeneratedStorageSettingsIMPL;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.GeneratedStorageSettingInstrumentation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class GeneratedStorageSettingOfPrimordialPoolInstrumentation
extends BaseInstrumentation {
    @Override
    public void deleteInstance(CIMObjectPath op) throws WBEMException {
        GeneratedStorageSettingsIMPL data = GeneratedStorageSettingInstrumentation.getGenSettings(op);
        if (data != null) {
            if (GeneratedStorageSettingsIMPL.removeGenSettings(data.getInstanceID()) == null) {
                throw new WBEMException(6, "Unable to locate a setting which matches: " + op);
            }
        } else {
            throw new WBEMException(6, "op: " + op);
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, "InstanceID");
            for (RMIObjectMapping device : devices) {
                Collection<GeneratedStorageSettingsIMPL> insts = GeneratedStorageSettingsIMPL.getGeneratedPrimordialStorageSettings(device.getSerialNumber());
                for (GeneratedStorageSettingsIMPL data : insts) {
                    if (iter.isClosed()) {
                        return;
                    }
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, data));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, data));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, data));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        GeneratedStorageSettingsIMPL setting = (GeneratedStorageSettingsIMPL)o[0];
        CIMProperty[] keys = retOP.getKeys();
        String cvElementName = RMIObjectMapping.getRMIObjectMapping(setting.getSerialNumber()).getStorageSystemName() + "." + setting.getSeqNumber();
        CIMProperty[] retProps = new CIMProperty[]{keys[0], new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)setting.isNoSinglePointOfFailure(), false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)setting.getDataRedunMax(), false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)setting.getDataRedunMin(), false), new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)setting.getDataRedun(), false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)setting.getPkgRedunMax(), false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)setting.getPkgRedunMin(), false), new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)setting.getPkgRedun(), false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, (Object)setting.getGenDeltaReservationMax(), false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, (Object)setting.getGenDeltaReservationMin(), false), new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, (Object)setting.getGenDeltaReservation(), false), new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)setting.getChangeableType(), false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, (Object)setting.getExtentStripLength(), false), new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, (Object)setting.getExtentStripLengthMax(), false), new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, (Object)setting.getExtentStripLengthMin(), false), new CIMProperty("ParityLayout", CIMDataType.UINT16_T, (Object)setting.getParityLayout(), false), new CIMProperty("UserDataStripeDepth", CIMDataType.UINT64_T, (Object)setting.getUserDataStrip(), false), new CIMProperty("UserDataStripeDepthMin", CIMDataType.UINT64_T, (Object)setting.getUserDataStrip(), false), new CIMProperty("UserDataStripeDepthMax", CIMDataType.UINT64_T, (Object)setting.getUserDataStrip(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)setting.getRaidLevel(), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)cvElementName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)cvElementName, false), new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false)};
        return new CIMInstance(retOP, retProps).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{GeneratedStorageSettingsIMPL.class}, o, "HITACHI_GeneratedStorageSettingOfPrimordialPool");
        GeneratedStorageSettingsIMPL setting = (GeneratedStorageSettingsIMPL)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)setting.getInstanceID(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_GeneratedStorageSettingOfPrimordialPool", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            GeneratedStorageSettingsIMPL data;
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != instID && (data = GeneratedStorageSettingsIMPL.lookUpSetting(instID)) != null) {
                return this.generateInstance(op, propertyList, data);
            }
            throw new WBEMException(6, op.toString());
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        GeneratedStorageSettingsIMPL settings = GeneratedStorageSettingInstrumentation.getGenSettings(ci.getObjectPath());
        if (settings == null) throw new WBEMException(6, "Instance does not exist: " + ci);
        GeneratedStorageSettingsIMPL newSettings = settings.clone();
        if (newSettings == null) {
            throw new WBEMException(1, "Unable to copy existing settings!");
        }
        if (propertyList != null) {
            for (String propName : propertyList) {
                if (propName.compareToIgnoreCase("InstanceID") == 0) {
                    throw new WBEMException(4, "Can not change InstanceID");
                }
                CIMProperty cIMProperty = ci.getProperty(propName);
                newSettings.setValue(cIMProperty);
            }
            return;
        } else {
            Object[] cpProperties;
            for (CIMProperty cIMProperty : cpProperties = ci.getProperties()) {
                if (cIMProperty != null) {
                    if (cIMProperty.getName().compareToIgnoreCase("InstanceID") != 0) {
                        newSettings.setValue(cIMProperty);
                        continue;
                    }
                    String cvInstID = (String)cIMProperty.getValue();
                    if (cvInstID.compareTo(settings.getInstanceID()) == 0) continue;
                    throw new WBEMException(4, "Passed in instance modifies InstanceID property, this is not valid");
                }
                mLogger.log(Level.INFO, "A property is null, ignoring {0}", Arrays.toString(cpProperties));
            }
            if (!newSettings.checkGeneratedSettings()) throw new WBEMException(4, "Invalid setting");
            newSettings.modifyOrCreateSetting();
        }
    }
}

