/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.GeneratedStorageSettingsIMPL;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.GeneratedStorageSettingInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class GeneratedThinProvisioningPoolSettingInstrumentation
extends BaseInstrumentation {
    @Override
    public void deleteInstance(CIMObjectPath op) throws WBEMException {
        GeneratedStorageSettingsIMPL data = GeneratedStorageSettingInstrumentation.getGenSettings(op);
        if (data != null) {
            if (GeneratedStorageSettingsIMPL.removeGenSettings(data.getInstanceID()) == null) {
                throw new WBEMException(6, "Unable to locate a setting which matches: " + op);
            }
        } else {
            throw new WBEMException(6, "op: " + op);
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Integer[] ids;
            String expInstID;
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"InstanceID", "SystemName"});
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices for " + op);
                }
                expInstID = (String)expectedValues.get("InstanceID");
                ids = expInstID == null ? null : ProviderLibs.getInstanceIDInts(expInstID);
            } else {
                ids = null;
                expInstID = null;
            }
            block3: for (RMIObjectMapping device : devices) {
                Iterable<GeneratedStorageSettingsIMPL> insts = GeneratedStorageSettingsIMPL.getGeneratedThinStorageSettings(device.getSerialNumber());
                for (GeneratedStorageSettingsIMPL data : insts) {
                    if (iter.isClosed()) {
                        return;
                    }
                    if (null != ids && ids[1].intValue() != data.getArrayGroup()) continue;
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, data));
                    } else if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, data));
                    } else {
                        iter.add(this.generateInstance(op, propertyList, data));
                    }
                    if (null == ids || ids[0].intValue() != data.getChassis() || ids[1].intValue() != data.getArrayGroup()) continue;
                    continue block3;
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        String cvSystemName;
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        GeneratedStorageSettingsIMPL setting = (GeneratedStorageSettingsIMPL)o[0];
        CIMProperty[] keys = retOP.getKeys();
        String value = cvSystemName = RMIObjectMapping.getRMIObjectMapping(setting.getSerialNumber()).getStorageSystemName() + "." + setting.getSeqNumber();
        CIMProperty[] retProps = new CIMProperty[]{keys[0], new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("CUImage", CIMDataType.STRING_T, (Object)setting.getGenCUImage(), false), new CIMProperty("SubsystemID", CIMDataType.STRING_T, (Object)setting.getGenSubsystemID(), false), new CIMProperty("EmulatedDevice", CIMDataType.STRING_T, (Object)setting.getGenEmulatedDevice(), false), new CIMProperty("ThinProvisionedPoolType", CIMDataType.UINT16_T, (Object)setting.getGenThinProvisionedPoolType(), false), new CIMProperty("ThinProvisionedInitialReserve", CIMDataType.UINT64_T, (Object)setting.getGenThinProvisionedInitialReserved(), false), new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)setting.isNoSinglePointOfFailure(), false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)setting.getDataRedunMax(), false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)setting.getDataRedunMin(), false), new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)setting.getDataRedun(), false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)setting.getPkgRedunMax(), false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)setting.getPkgRedunMin(), false), new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)setting.getPkgRedun(), false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, (Object)setting.getGenDeltaReservationMax(), false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, (Object)setting.getGenDeltaReservationMin(), false), new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, (Object)setting.getGenDeltaReservation(), false), new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)setting.getChangeableType(), false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, (Object)setting.getExtentStripLength(), false), new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, (Object)setting.getExtentStripLengthMax(), false), new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, (Object)setting.getExtentStripLengthMin(), false), new CIMProperty("ParityLayout", CIMDataType.UINT16_T, (Object)setting.getParityLayout(), false), new CIMProperty("UserDataStripeDepth", CIMDataType.UINT64_T, (Object)setting.getUserDataStrip(), false), new CIMProperty("UserDataStripeDepthMin", CIMDataType.UINT64_T, (Object)setting.getUserDataStrip(), false), new CIMProperty("UserDataStripeDepthMax", CIMDataType.UINT64_T, (Object)setting.getUserDataStrip(), false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)setting.getRaidLevel(), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)cvSystemName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)value, false)};
        return new CIMInstance(retOP, retProps).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{GeneratedStorageSettingsIMPL.class}, o, "CIM_StorageSetting");
        GeneratedStorageSettingsIMPL setting = (GeneratedStorageSettingsIMPL)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)setting.getInstanceID(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_GeneratedThinProvisioningPoolSetting", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            GeneratedStorageSettingsIMPL data = GeneratedStorageSettingInstrumentation.getGenSettings(op);
            if (data != null) {
                return this.generateInstance(op, propertyList, data);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void modifyInstance(CIMInstance ci, String[] propertyList) throws WBEMException {
        GeneratedStorageSettingsIMPL newSettings;
        GeneratedStorageSettingsIMPL settings = GeneratedStorageSettingInstrumentation.getGenSettings(ci.getObjectPath());
        if (settings != null) {
            newSettings = settings.clone();
            if (newSettings == null) {
                throw new WBEMException(1, "Unable to copy existing settings!");
            }
            if (propertyList != null) {
                for (String propName : propertyList) {
                    CIMProperty cpProperty = ci.getProperty(propName);
                    if (propName.compareToIgnoreCase("InstanceID") != 0) {
                        newSettings.setValue(cpProperty);
                        continue;
                    }
                    String cvInstID = (String)cpProperty.getValue();
                    if (cvInstID.compareTo(settings.getInstanceID()) == 0) continue;
                    throw new WBEMException(4, "Passed in instance modifies InstanceID property, this is not valid");
                }
            } else {
                CIMProperty[] cpProperties;
                for (CIMProperty cpProperty : cpProperties = ci.getProperties()) {
                    if (cpProperty == null) continue;
                    if (cpProperty.getName().compareToIgnoreCase("InstanceID") == 0 && !settings.getInstanceID().equals(cpProperty.getValue())) {
                        throw new WBEMException(4, String.format("InstanceID can not be changed, old: %s, new %s", settings.getInstanceID(), cpProperty.getValue()));
                    }
                    newSettings.setValue(cpProperty);
                }
            }
            if (!newSettings.checkGeneratedSettings()) {
                throw new WBEMException(4, "Invalid setting");
            }
        } else {
            throw new WBEMException(6, "Instance does not exist: " + ci);
        }
        newSettings.modifyOrCreateSetting();
    }
}

