/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ExternalChassisArrayGroup;
import com.hitachi.smi.common.PrimordialPoolIndicationThread;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.StoragePoolInstrumentation;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger64;
import javax.wbem.WBEMException;
import sanproject.serverux.data.SANRmiException;

public class ImportedStoragePoolPrimordialInstrumentation
extends StoragePoolInstrumentation {
    private static PrimordialPoolIndicationThread mIndThread = null;

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    protected Object extrinsic_getSupportedSizes(CIMObjectPath pOp, CIMArgument<?>[] pOutArgs) throws WBEMException {
        UnsignedInteger64[] emptyArray = new UnsignedInteger64[]{};
        pOutArgs[0] = new CIMArgument("Sizes", CIMDataType.UINT64_ARRAY_T, (Object)emptyArray);
        return ProviderConstants.UINT32_ZED;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws WBEMException {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        try {
            String SPCAG = "ImportedStoragePoolPrimordial";
            UnsignedInteger64 totalManagedSpace = this.getTotalManagedSpace(rmiObj.getSMISMappingContainer());
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("Name", CIMDataType.STRING_T, (Object)"ImportedStoragePoolPrimordial", false), new CIMProperty("ConsistsOf", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("Primordial", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("TotalManagedSpace", CIMDataType.UINT64_T, (Object)totalManagedSpace, false), new CIMProperty("RemainingManagedSpace", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false), new CIMProperty("PoolID", CIMDataType.STRING_T, (Object)"ImportedStoragePoolPrimordial.0", false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(ProviderConstants.OP_STATUS_INDEX.OK.getStatusValue())}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{ProviderConstants.getOpStatusDescription(ProviderConstants.OP_STATUS_INDEX.OK)}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(5), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"ImportedStoragePoolPrimordial", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"ImportedStoragePoolPrimordial", false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"ImportedStoragePoolPrimordial", false), new CIMProperty("ElementsShareSpace", CIMDataType.BOOLEAN_T, (Object)false, false), new CIMProperty("ReservedSpace", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false)};
            return new CIMInstance(retOP, props).filterProperties(propertyList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws WBEMException {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_ImportedStoragePoolPrimordial");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        StringBuffer keyValue = new StringBuffer(rmiObj.getSMISMappingContainer().getStorageSystemName());
        keyValue.append(".");
        keyValue.append("ImportedPrimordial");
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue.toString(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ImportedStoragePoolPrimordial", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            CIMProperty cpInstID = op.getKey("InstanceID");
            if (null != cpInstID) {
                String ssName = ProviderLibs.getAllButEndString((String)cpInstID.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String primordial = ProviderLibs.getEndString((String)cpInstID.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                if (null != ssName && ssName.equals(device.getStorageSystemName()) && "ImportedPrimordial".equals(primordial)) {
                    CIMInstance inst = this.generateInstance(op, propertyList, device.getRMIObject());
                    return inst;
                }
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public UnsignedInteger64 getTotalManagedSpace(RMIObjectMapping device) throws RemoteException, SANRmiException, WBEMException {
        long result = 0L;
        long blockSize = -1L;
        CommonClassAsList<ExternalChassisArrayGroup> callback = new CommonClassAsList<ExternalChassisArrayGroup>();
        ExternalChassisArrayGroup.getExternalChassisArrayGroup(device.getRMIObject(), callback, false);
        LinkedList<ExternalChassisArrayGroup> ecags = callback.getReturnValue();
        callback = null;
        ExternalChassisArrayGroup ecag = ecags.poll();
        while (ecag != null) {
            result += ecag.getNumberOfBlocks().longValue();
            if (-1L == blockSize) {
                blockSize = ecag.getBlockSize().longValue();
            }
            ecag = ecags.poll();
        }
        return new UnsignedInteger64(BigInteger.valueOf(result * (blockSize == -1L ? 512L : blockSize)));
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                // empty if block
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                // empty if block
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool".equalsIgnoreCase(query)) {
            if (startListening) {
                // empty if block
            }
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StoragePool AND SourceInstance.CIM_StoragePool::TotalManagedSpace <> PreviousInstance.CIM_StoragePool::TotalManagedSpace".equalsIgnoreCase(query)) {
            if (startListening) {
                this.startModifyCheck();
            } else {
                this.stopModifyCheck();
            }
        }
    }

    private synchronized void startModifyCheck() {
        if (mIndThread == null) {
            try {
                mIndThread = new PrimordialPoolIndicationThread(this, mHandle, "HITACHI_ImportedStoragePoolPrimordial");
                mIndThread.start();
                this.setListen4InstMod(true);
            }
            catch (Throwable we) {
                mLogger.log(Level.SEVERE, "Encountered exception(" + we + ") trying to setup modify instance for " + "HITACHI_ImportedStoragePoolPrimordial", we);
            }
        }
    }

    private synchronized void stopModifyCheck() {
        if (mIndThread != null) {
            mIndThread.stopThread();
            mIndThread = null;
        }
    }
}

