/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ImportingSCSIPCForFCPortInstrumentation
extends BaseAssocInstrumentation {
    protected ImportingSCSIPCForFCPortInstrumentation() {
        super("HITACHI_ImportingSCSIPCForFCPort", "HITACHI_ImportingSCSIProtocolController", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ImportingSCSIProtocolControllerInstrumentation"), "HITACHI_FCPort", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.FCPortInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ImportingSCSIPCForFCPort".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_ImportingSCSIProtocolController") && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                    CIMInstance instImportingSCSIProtocolController = null;
                    try {
                        instImportingSCSIProtocolController = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instImportingSCSIProtocolController) {
                        CIMObjectPath opFCPort = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_FCPort", null);
                        Hashtable<String, Object> expValues = new Hashtable<String, Object>();
                        expValues.put("SystemName", objectName.getKeyValue("SystemName"));
                        CustomCloseableIterator iterFCPort = new CustomCloseableIterator();
                        this.getReference2Instrumentation().enumerate(iterFCPort, opFCPort, null, null, null, false, false, expValues, null);
                        while (iterFCPort.hasNext()) {
                            CIMInstance instFCPort = (CIMInstance)iterFCPort.next();
                            if (!ProviderConstants.UINT16_THREE.equals(instFCPort.getPropertyValue("UsageRestriction"))) continue;
                            if (isObjectPath) {
                                iter.add(instFCPort.getObjectPath());
                                continue;
                            }
                            iter.add(instFCPort.filterProperties(propertyList));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_FCPort") && (null == role || role.equalsIgnoreCase("Dependent")) && (null == resultRole || resultRole.equalsIgnoreCase("Antecedent"))) {
                    CIMInstance instFCPort = null;
                    try {
                        instFCPort = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instFCPort && ProviderConstants.UINT16_THREE.equals(instFCPort.getPropertyValue("UsageRestriction"))) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                        } else {
                            CIMInstance instImportingSCSIProtocolController = this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject());
                            iter.add(instImportingSCSIProtocolController.filterProperties(propertyList));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opImportingSCSIProtocolController = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                Hashtable<String, Object> expValues = new Hashtable<String, Object>();
                expValues.put("SystemName", device.getStorageSystemName());
                CustomCloseableIterator iterFCPort = new CustomCloseableIterator();
                CIMObjectPath opFCPort = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_FCPort", null);
                String[] spPropList = new String[]{"UsageRestriction"};
                this.getReference2Instrumentation().enumerate(iterFCPort, opFCPort, spPropList, filterQueryLanguage, filterQuery, continueOnError, false, expValues, null);
                while (iterFCPort.hasNext()) {
                    CIMInstance instFCPort = (CIMInstance)iterFCPort.next();
                    CIMProperty cpConsistsOf = instFCPort.getProperty("UsageRestriction");
                    boolean isExternal = null != cpConsistsOf ? ProviderConstants.UINT16_THREE.equals(cpConsistsOf.getValue()) : false;
                    if (!isExternal || null == iter) continue;
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opImportingSCSIProtocolController, instFCPort.getObjectPath()));
                        continue;
                    }
                    iter.add(this.generateInstance(objectName, propertyList, opImportingSCSIProtocolController, instFCPort.getObjectPath()));
                }
                if (null == iter) continue;
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        return new CIMProperty[]{new CIMProperty("AccessPriority", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false)};
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block10: {
            try {
                CIMObjectPath opFCPort = opObjectName.getKey("Dependent") != null ? (CIMObjectPath)opObjectName.getKey("Dependent").getValue() : null;
                CIMInstance instFCPort = null;
                try {
                    instFCPort = this.getReference2Instrumentation().getInstance(opFCPort, null);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instFCPort) {
                    if (ProviderConstants.UINT16_THREE.equals(instFCPort.getPropertyValue("UsageRestriction"))) {
                        CIMObjectPath opImportingSCSIPC = opObjectName.getKey("Antecedent") != null ? (CIMObjectPath)opObjectName.getKey("Antecedent").getValue() : null;
                        CIMInstance instImportingSCSIPC = null;
                        try {
                            instImportingSCSIPC = this.getReference1Instrumentation().getInstance(opImportingSCSIPC, null);
                        }
                        catch (WBEMException we) {
                            // empty catch block
                        }
                        if (null != instImportingSCSIPC) {
                            return this.generateInstance(opObjectName, propertyList, instImportingSCSIPC.getObjectPath(), instFCPort.getObjectPath());
                        }
                        mLogger.finest("Unable to find ImportingSCSIPC instance: " + instImportingSCSIPC);
                        break block10;
                    }
                    mLogger.finest("Specified FCPort: " + opFCPort + " isn't a \"Back-End Only\" FCPort");
                    break block10;
                }
                mLogger.finest("Unable to find FCPort instance: " + opFCPort);
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_ImportingSCSIPCForFCPort".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_ImportingSCSIProtocolController") && (null == role || role.equalsIgnoreCase("Antecedent"))) {
                    CIMInstance instImportingSCSIProtocolController = null;
                    try {
                        instImportingSCSIProtocolController = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instImportingSCSIProtocolController) {
                        CIMObjectPath opFCPort = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_FCPort", null);
                        Hashtable<String, Object> expValues = new Hashtable<String, Object>();
                        expValues.put("SystemName", objectName.getKeyValue("SystemName"));
                        CustomCloseableIterator iterFCPort = new CustomCloseableIterator();
                        this.getReference2Instrumentation().enumerate(iterFCPort, opFCPort, null, null, null, false, false, expValues, null);
                        while (iterFCPort.hasNext()) {
                            CIMInstance instFCPort = (CIMInstance)iterFCPort.next();
                            if (!ProviderConstants.UINT16_THREE.equals(instFCPort.getPropertyValue("UsageRestriction"))) continue;
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, instImportingSCSIProtocolController.getObjectPath(), instFCPort.getObjectPath()));
                                continue;
                            }
                            iter.add(this.generateInstance(objectName, propertyList, instImportingSCSIProtocolController.getObjectPath(), instFCPort.getObjectPath()));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_FCPort") && (null == role || role.equalsIgnoreCase("Dependent"))) {
                    CIMInstance instFCPort = null;
                    try {
                        instFCPort = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instFCPort && ProviderConstants.UINT16_THREE.equals(instFCPort.getPropertyValue("UsageRestriction"))) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()), instFCPort.getObjectPath()));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()), instFCPort.getObjectPath()));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

