/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ExternalChassisArrayGroup;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class ImportingSCSIPCForImportedStorageExtentInstrumentation
extends BaseAssocInstrumentation {
    private static final String CPN_DEVICEACCESS = "DeviceAccess";

    protected ImportingSCSIPCForImportedStorageExtentInstrumentation() {
        super("HITACHI_ImportingSCSIPCForImportedStorageExtent", "HITACHI_ImportingSCSIProtocolController", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ImportingSCSIProtocolControllerInstrumentation"), "HITACHI_ImportedStorageExtent", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ImportedStorageExtentInstrumentation"));
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath objectName, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath opAssoc = this.generateObjectPath(objectName, o);
        String deviceNumber = this.getDeviceNumberString((CIMObjectPath)o[1]);
        CIMProperty key1 = opAssoc.getKey(this.getReference1PropertyName());
        CIMProperty key2 = opAssoc.getKey(this.getReference2PropertyName());
        CIMProperty[] props = new CIMProperty[]{key1, key2, new CIMProperty(CPN_DEVICEACCESS, CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("DeviceNumber", CIMDataType.STRING_T, (Object)deviceNumber, false)};
        return new CIMInstance(opAssoc, props).filterProperties(propertyList);
    }

    private String getDeviceNumberString(CIMObjectPath op) throws WBEMException {
        String ret = null;
        String devID = (String)op.getKey("DeviceID").getValue();
        StringTokenizer tok = new StringTokenizer(devID, ".");
        String fb4Str = tok.nextToken();
        String agStr = tok.nextToken();
        if (fb4Str != null && agStr != null) {
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
            try {
                ExternalChassisArrayGroup ecag = ExternalChassisArrayGroup.find(Integer.valueOf(fb4Str), Integer.valueOf(agStr), device.getRMIObject(), false);
                if (ecag != null) {
                    String[] dns;
                    StringBuilder t = new StringBuilder();
                    for (String dn : dns = ecag.getExternalDeviceNumber()) {
                        if (dn == null) continue;
                        Integer val = Integer.valueOf(dn);
                        t.append(String.format("%02X", val));
                    }
                    ret = t.toString();
                }
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "Exception trying to find ECAG, " + op, we);
            }
        } else {
            mLogger.severe("Unable to get DeviceNumber property as ObjectPath is invalid: " + op);
        }
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                Hashtable<String, Object> eValues = new Hashtable<String, Object>();
                eValues.put("SystemName", device.getStorageSystemName());
                CIMObjectPath opImportingSCSIProtocolController = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                CustomCloseableIterator iterImportedStorageExtent = new CustomCloseableIterator();
                CIMObjectPath opImportingSCSIProtocolEndpoint = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                this.getReference2Instrumentation().enumerate(iterImportedStorageExtent, opImportingSCSIProtocolEndpoint, null, filterQueryLanguage, filterQuery, continueOnError, false, eValues, null);
                while (iterImportedStorageExtent.hasNext()) {
                    CIMInstance instImportedStorageExtent = (CIMInstance)iterImportedStorageExtent.next();
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opImportingSCSIProtocolController, instImportedStorageExtent.getObjectPath()));
                        continue;
                    }
                    iter.add(this.generateInstance(objectName, propertyList, opImportingSCSIProtocolController, instImportedStorageExtent.getObjectPath()));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

