/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.StorageHardwareIDs;
import com.hitachi.smi.instrumentation.AuthorizedPrivilegeInstrumentation;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.SCSIPCForStorageVolumeInstrumentation;
import com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation;
import com.hitachi.smi.instrumentation.SCSIProtocolEndpointInstrumentation;
import com.hitachi.smi.paralleltasker.ProcessTask;
import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.Wait4ProcessTasks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class MaskingMappingViewInstrumentation
extends BaseAssocInstrumentation {
    private final BaseInstrumentation mReference3 = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolEndpointInstrumentation");
    private final String mReference3PropertyName = "ProtocolEndpoint";
    private final String mReference3ClassName = "HITACHI_SCSIProtocolEndpoint";

    protected MaskingMappingViewInstrumentation() {
        super("HITACHI_MaskingMappingView", "HITACHI_StorageHardwareID", "StorageHardwareID", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageHardwareIDInstrumentation"), "HITACHI_StorageVolume", "LogicalDevice", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    private boolean assocByHardwareID(CustomCloseableIterator<?> iter, CIMObjectPath opHardwareID, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        boolean ret = true;
        if (!(shouldTestInst && !this.getReference1Instrumentation().instanceExists(opHardwareID) || null != role && !role.equalsIgnoreCase(this.getReference1PropertyName()))) {
            String cvHardwareID = (String)opHardwareID.getKey("InstanceID").getValue();
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opHardwareID, "InstanceID");
            String hostWWN = ProviderLibs.getEndString(cvHardwareID);
            CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
            PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, null, null, null, null, hostWWN, true, null, continueOnError);
            LinkedList<PortandHostGroupInfo> phgis = callback.getReturnValue();
            callback = null;
            if (phgis.size() > 0) {
                PortandHostGroupInfo phgi;
                Wait4ProcessTasks task = new Wait4ProcessTasks(phgis.size());
                while ((phgi = phgis.poll()) != null) {
                    WorkerThread worker = new WorkerThread(iter, opHardwareID, propertyList, phgi, resultClass, resultRole, filterQueryLanguage, filterQuery, ExcludeFromAssocOp.StorageHardwareID, continueOnError, task, isObjectPath);
                    ProcessTask.addTask(worker);
                }
                ret = false;
            }
        }
        return ret;
    }

    private boolean assocByProtocolEndPoint(CustomCloseableIterator<?> iter, CIMObjectPath opSCSIPCEndPt, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        RMIObjectMapping device;
        boolean ret = true;
        String cvName = (String)opSCSIPCEndPt.getKey("Name").getValue();
        FCPort port = FCPort.find(cvName, FCPort.PortTypeRequested.OPEN, (device = ProviderLibs.getManagedDeviceFromObjectPath(opSCSIPCEndPt, "SystemName")).getRMIObject());
        if (port != null) {
            CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
            PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, null, null, String.valueOf(port.getPort()), null, null, true, null, continueOnError);
            LinkedList<PortandHostGroupInfo> phgis = callback.getReturnValue();
            callback = null;
            if (phgis.size() > 0) {
                PortandHostGroupInfo phgi;
                Wait4ProcessTasks task = new Wait4ProcessTasks(phgis.size());
                while ((phgi = phgis.poll()) != null) {
                    WorkerThread worker = new WorkerThread(iter, opSCSIPCEndPt, propertyList, phgi, resultClass, resultRole, filterQueryLanguage, filterQuery, ExcludeFromAssocOp.ProtocolEndPoint, continueOnError, task, isObjectPath);
                    ProcessTask.addTask(worker);
                }
                ret = false;
            }
        }
        return ret;
    }

    private boolean assocByStorageVolume(CustomCloseableIterator<?> iter, CIMObjectPath opStorageVol, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        RMIObjectMapping device;
        String cvDevID;
        DeviceNumber dn;
        boolean ret = true;
        if (!(shouldTestInst && !this.getReference2Instrumentation().instanceExists(opStorageVol) || null != role && !role.equalsIgnoreCase(this.getReference2PropertyName()) || (dn = DeviceNumber.find(cvDevID = (String)opStorageVol.getKey("DeviceID").getValue(), (device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageVol, "SystemName")).getRMIObject())) == null)) {
            CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
            LUPathObject.getLUPaths(device.getRMIObject(), callback, dn.getDn());
            LinkedList<LUPathObject> luPaths = callback.getReturnValue();
            callback = null;
            if (luPaths.size() > 0) {
                LUPathObject luPath;
                Wait4ProcessTasks task = new Wait4ProcessTasks(luPaths.size());
                while ((luPath = luPaths.poll()) != null) {
                    WorkerThread worker = new WorkerThread(iter, opStorageVol, resultClass, resultRole, propertyList, filterQueryLanguage, filterQuery, dn, luPath, ExcludeFromAssocOp.StorageVolume, task, isObjectPath);
                    ProcessTask.addTask(worker);
                }
                ret = false;
            }
        }
        return ret;
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_MaskingMappingView".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName())) {
                    needToCloseIter = this.assocByHardwareID(iter, objectName, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, shouldTestInst);
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName())) {
                    needToCloseIter = this.assocByStorageVolume(iter, objectName, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, shouldTestInst);
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_SCSIProtocolEndpoint")) {
                    needToCloseIter = this.assocByProtocolEndPoint(iter, objectName, resultClass, role, resultRole, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, shouldTestInst);
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    private void checkVarArgs(boolean isObjectPath, Object ... o) {
        int numObjs2Test;
        Class[] types = new Class[]{FCPort.class, DeviceNumber.class, String.class, PortandHostGroupInfo.class, LUPathObject.class};
        int n = numObjs2Test = isObjectPath ? 3 : types.length;
        if (o == null || o.length != numObjs2Test) {
            throw new IllegalArgumentException(isObjectPath ? ProviderConstants.GENERATE_OBJECTPATH_ILLEGAL_ARGUMENT : ProviderConstants.GENERATE_INSTANCE_ILLEGAL_ARGUMENT + ", expected " + numObjs2Test + " but got " + (o == null ? "null" : Integer.valueOf(o.length)) + " " + "HITACHI_MaskingMappingView");
        }
        for (int x = 0; x < numObjs2Test; ++x) {
            if (types[x].isInstance(o[x])) continue;
            throw new IllegalArgumentException("generateObjectPath param index: " + x + " was expected to be a '" + types[x].getSimpleName() + "' but was a '" + o[x].getClass().getSimpleName() + "'");
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CommonClassAsList<PortandHostGroupInfo> pghiCallback = new CommonClassAsList<PortandHostGroupInfo>();
                PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), pghiCallback, null, true, true);
                LinkedList<PortandHostGroupInfo> pghis = pghiCallback.getReturnValue();
                pghiCallback = null;
                if (pghis.size() > 0) {
                    PortandHostGroupInfo pghi;
                    Wait4ProcessTasks task = new Wait4ProcessTasks(pghis.size());
                    while ((pghi = pghis.poll()) != null) {
                        WorkerThread worker = new WorkerThread(deviceIter, objectName, propertyList, refInfo, pghi, task, isObjectPath);
                        ProcessTask.addTask(worker);
                    }
                    task.processingDone();
                    continue;
                }
                deviceIter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    private void generateAuthorizedPrivledgeProps(String wwn, PortandHostGroupInfo pghi, ArrayList<CIMProperty<?>> props) {
        String instID = AuthorizedPrivilegeInstrumentation.createInstanceID(pghi, wwn);
        props.add(new CIMProperty("APInstanceID", CIMDataType.STRING_T, (Object)instID, false));
        props.add(new CIMProperty("APElementName", CIMDataType.STRING_T, (Object)instID, false));
        props.add(new CIMProperty("APActivities", CIMDataType.UINT16_ARRAY_T, (Object)AuthorizedPrivilegeInstrumentation.CPV_ACTIVITIES, false));
        props.add(new CIMProperty("APPrivilegeGranted", CIMDataType.BOOLEAN_T, (Object)AuthorizedPrivilegeInstrumentation.CPV_PRIVILEGEGRANTED, false));
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath objectPath, String[] propertyList, Object ... o) throws Exception {
        CIMInstance ret = null;
        this.checkVarArgs(false, o);
        CIMObjectPath op = this.generateObjectPath(objectPath, o[0], o[1], o[2]);
        CIMProperty[] keys = op.getKeys();
        ArrayList props = new ArrayList(25);
        props.add(keys[0]);
        props.add(keys[1]);
        props.add(keys[2]);
        FCPort port = (FCPort)o[0];
        DeviceNumber dn = (DeviceNumber)o[1];
        String wwn = (String)o[2];
        PortandHostGroupInfo pghi = (PortandHostGroupInfo)o[3];
        LUPathObject luPath = (LUPathObject)o[4];
        this.generateStorageHardwareIDProps(wwn, props);
        props.add(new CIMProperty("LDDeviceID", CIMDataType.STRING_T, (Object)dn.getDNAsString(), true));
        this.generateSCSIProtocolEndPointProps(port, props);
        this.generateAuthorizedPrivledgeProps(wwn, pghi, props);
        this.generateSCSIPCProps(pghi, props);
        this.generateSCSIPCForStorageVolumeProps(luPath, props);
        CIMProperty[] retProps = props.toArray(new CIMProperty[props.size()]);
        ret = new CIMInstance(op, retProps).filterProperties(propertyList);
        return ret;
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath objectPath, Object ... o) throws Exception {
        CIMObjectPath ret = null;
        this.checkVarArgs(true, o);
        FCPort port = (FCPort)o[0];
        DeviceNumber dn = (DeviceNumber)o[1];
        String wwn = (String)o[2];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
        CIMObjectPath storageHardwareID = this.getReference1Instrumentation().generateObjectPath(objectPath, device.getRMIObject(), wwn);
        CIMObjectPath storageVolume = this.getReference2Instrumentation().generateObjectPath(objectPath, dn);
        CIMObjectPath scsiProtEndPt = this.mReference3.generateObjectPath(objectPath, port);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(this.getReference1PropertyName(), new CIMDataType(this.getReference1ClassName()), (Object)storageHardwareID, true), new CIMProperty(this.getReference2PropertyName(), new CIMDataType(this.getReference2ClassName()), (Object)storageVolume, true), new CIMProperty("ProtocolEndpoint", new CIMDataType("HITACHI_SCSIProtocolEndpoint"), (Object)scsiProtEndPt, true)};
        ret = new CIMObjectPath(objectPath.getScheme(), objectPath.getHost(), objectPath.getPort(), objectPath.getNamespace(), "HITACHI_MaskingMappingView", keys, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
        return ret;
    }

    private void generateSCSIPCForStorageVolumeProps(LUPathObject luPath, ArrayList<CIMProperty<?>> props) {
        props.add(new CIMProperty("PCFUDeviceAccess", CIMDataType.UINT16_T, (Object)SCSIPCForStorageVolumeInstrumentation.DEVICEACCESS, false));
        props.add(new CIMProperty("PCFUDeviceNumber", CIMDataType.STRING_T, (Object)luPath.getLunString(), false));
    }

    private void generateSCSIPCProps(PortandHostGroupInfo phgi, ArrayList<CIMProperty<?>> props) {
        String port = String.valueOf(phgi.getPortID());
        String hostgroup = String.valueOf(phgi.getHostgroupID());
        String ctrID = String.valueOf(phgi.getCtrlID());
        String deviceID = SCSIProtocolControllerInstrumentation.createDeviceID(port, hostgroup);
        String sysName = null;
        try {
            sysName = SCSIProtocolControllerInstrumentation.createSystemName(ctrID, phgi.getSerialNumber());
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Unable to get SPCSystemName value!", e);
            sysName = null;
        }
        props.add(new CIMProperty("SPCDeviceID", CIMDataType.STRING_T, (Object)deviceID, false));
        props.add(new CIMProperty("SPCSystemName", CIMDataType.STRING_T, (Object)sysName, false));
        props.add(new CIMProperty("SPCCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_SCSIProtocolController", false));
        props.add(new CIMProperty("SPCSystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", false));
    }

    private void generateSCSIProtocolEndPointProps(FCPort port, ArrayList<CIMProperty<?>> props) throws WBEMException {
        props.add(new CIMProperty("SPEPConnectionType", CIMDataType.UINT16_T, (Object)SCSIProtocolEndpointInstrumentation.CPV_CONNECTIONTYPE, false));
        props.add(new CIMProperty("SPEPRole", CIMDataType.UINT16_T, (Object)port.getPortRole(), false));
        props.add(new CIMProperty("SPEPCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_SCSIProtocolEndpoint", false));
        props.add(new CIMProperty("SPEPName", CIMDataType.STRING_T, (Object)port.getPortWWN(), false));
        props.add(new CIMProperty("SPEPSystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageProcessorSystem", false));
        try {
            props.add(new CIMProperty("SPEPSystemName", CIMDataType.STRING_T, (Object)SCSIProtocolEndpointInstrumentation.createSystemName(port), false));
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Unable to get SPEPSystemName value!", e);
        }
        props.add(new CIMProperty("SPEPProtocolIFType", CIMDataType.UINT16_T, (Object)SCSIProtocolEndpointInstrumentation.CPV_PROTOCOLIFTYPE, false));
        props.add(new CIMProperty("SPEPOtherTypeDescription", CIMDataType.STRING_T, (Object)"SCSI", false));
    }

    private void generateStorageHardwareIDProps(String wwn, ArrayList<CIMProperty<?>> props) {
        props.add(new CIMProperty("SHIDStorageID", CIMDataType.STRING_T, (Object)wwn, false));
        props.add(new CIMProperty("SHIDIDType", CIMDataType.UINT16_T, (Object)StorageHardwareIDs.CPV_IDTYPE, false));
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opReference1;
            CIMObjectPath cIMObjectPath = opReference1 = opObjectName.getKey(this.getReference1PropertyName()) != null ? (CIMObjectPath)opObjectName.getKey(this.getReference1PropertyName()).getValue() : null;
            if (this.getReference1Instrumentation().instanceExists(opReference1)) {
                CIMObjectPath opReference2;
                CIMObjectPath cIMObjectPath2 = opReference2 = opObjectName.getKey(this.getReference2PropertyName()) != null ? (CIMObjectPath)opObjectName.getKey(this.getReference2PropertyName()).getValue() : null;
                if (this.getReference2Instrumentation().instanceExists(opReference2)) {
                    CIMObjectPath opReference3;
                    CIMObjectPath cIMObjectPath3 = opReference3 = opObjectName.getKey("ProtocolEndpoint") != null ? (CIMObjectPath)opObjectName.getKey("ProtocolEndpoint").getValue() : null;
                    if (this.mReference3.instanceExists(opReference3)) {
                        return this.getInstance(opObjectName, propertyList, opReference1, opReference2, opReference3);
                    }
                    mLogger.finest("Unable to find instance: " + opReference3);
                } else {
                    mLogger.finest("Unable to find instance: " + opReference2);
                }
            } else {
                mLogger.finest("Unable to find instance: " + opReference1);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    private CIMInstance getInstance(CIMObjectPath op, String[] propertyList, CIMObjectPath opHardwareID, CIMObjectPath opStorVol, CIMObjectPath opSCSIPCEndPt) throws WBEMException, Exception {
        RMIObjectMapping device;
        String cvDevID = (String)opStorVol.getKey("DeviceID").getValue();
        DeviceNumber dn = DeviceNumber.find(cvDevID, (device = ProviderLibs.getManagedDeviceFromObjectPath(opStorVol, "SystemName")).getRMIObject());
        if (dn != null) {
            String cvName = (String)opSCSIPCEndPt.getKey("Name").getValue();
            FCPort port = FCPort.find(cvName, FCPort.PortTypeRequested.OPEN, device.getRMIObject());
            if (port != null) {
                String cvHardwareID = (String)opHardwareID.getKey("InstanceID").getValue();
                String hostWWN = ProviderLibs.getEndString(cvHardwareID);
                PortandHostGroupInfo phgi = PortandHostGroupInfo.find(device.getSerialNumber(), device.getStorageSystemName(), null, String.valueOf(port.getPort()), null, hostWWN, true, null);
                if (phgi != null) {
                    LUPathObject luPath;
                    CIMInstance ret = null;
                    CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
                    LUPathObject.getLUPaths(device.getRMIObject(), callback, (short)-1, phgi.getHostgroupID(), dn.getDn());
                    LinkedList<LUPathObject> luPaths = callback.getReturnValue();
                    callback = null;
                    while ((luPath = luPaths.poll()) != null && ret == null) {
                        if (luPath.getSHostGrp() != phgi.getHostgroupID()) continue;
                        ret = this.generateInstance(op, propertyList, port, dn, hostWWN, phgi, luPath);
                    }
                    if (ret != null) {
                        return ret;
                    }
                    throw new WBEMException(1, "Looked up LUPathObject with port: " + port.getPort() + " and HostGroup: " + phgi.getHostgroupID() + " and found " + luPaths.size() + ", there should only be 1");
                }
                throw new WBEMException(1, "Unable to find PortandHostGroupInfo for WWN: " + hostWWN);
            }
            throw new WBEMException(1, "Unable to find FCPort with name: " + cvName);
        }
        throw new WBEMException(1, "Unable to find DeviceNumber with DeviceID: " + cvDevID);
    }

    private void processByProtocolEndPt(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, boolean isObjectPath, FCPort port) throws Exception {
        CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
        PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, null, null, String.valueOf(port.getPort()), null, null, true, null, true);
        LinkedList<PortandHostGroupInfo> phgis = callback.getReturnValue();
        callback = null;
        if (phgis.size() > 0) {
            PortandHostGroupInfo phgi;
            Wait4ProcessTasks task = new Wait4ProcessTasks(phgis.size());
            while ((phgi = phgis.poll()) != null) {
                WorkerThread worker = new WorkerThread(iter, objectName, propertyList, phgi, port, task, isObjectPath);
                ProcessTask.addTask(worker);
            }
        } else {
            iter.done();
        }
    }

    private void processByStorageHardwareID(CustomCloseableIterator<?> iter, CIMObjectPath opStorHardID, String[] propertyList, boolean isObjectPath, String hostWWN) throws Exception {
        CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorHardID, "InstanceID");
        PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, device.getStorageSystemName(), null, null, null, hostWWN, true, null, true);
        LinkedList<PortandHostGroupInfo> phgis = callback.getReturnValue();
        callback = null;
        if (phgis.size() > 0) {
            PortandHostGroupInfo phgi;
            Wait4ProcessTasks task = new Wait4ProcessTasks(phgis.size());
            while ((phgi = phgis.poll()) != null) {
                WorkerThread worker = new WorkerThread(iter, opStorHardID, propertyList, phgi, hostWWN, task, isObjectPath);
                ProcessTask.addTask(worker);
            }
        } else {
            iter.done();
        }
    }

    private void processByStorageVolume(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, boolean isObjectPath, DeviceNumber dn) throws Exception {
        CommonClassAsList<LUPathObject> callback = new CommonClassAsList<LUPathObject>();
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
        LUPathObject.getLUPaths(device.getRMIObject(), callback, dn.getDn());
        LinkedList<LUPathObject> luPaths = callback.getReturnValue();
        callback = null;
        if (luPaths.size() > 0) {
            LUPathObject luPath;
            Wait4ProcessTasks task = new Wait4ProcessTasks(luPaths.size());
            while ((luPath = luPaths.poll()) != null) {
                WorkerThread worker = new WorkerThread(iter, objectName, propertyList, dn, luPath, null, task, isObjectPath);
                ProcessTask.addTask(worker);
            }
        } else {
            iter.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_MaskingMappingView".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        String cvHardwareID = (String)objectName.getKey("InstanceID").getValue();
                        String hostWWN = ProviderLibs.getEndString(cvHardwareID);
                        this.processByStorageHardwareID(iter, objectName, propertyList, isObjectPath, hostWWN);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference2Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        String cvDevID = (String)objectName.getKey("DeviceID").getValue();
                        DeviceNumber dn = DeviceNumber.find(cvDevID, device.getRMIObject());
                        if (dn == null) throw new WBEMException(1, "Unable to find DeviceNumber with DeviceID: " + cvDevID);
                        this.processByStorageVolume(iter, objectName, propertyList, isObjectPath, dn);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_SCSIProtocolEndpoint") && (null == role || role.equalsIgnoreCase("ProtocolEndpoint")) && this.mReference3.instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    String cvName = (String)objectName.getKey("Name").getValue();
                    FCPort port = FCPort.find(cvName, FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                    if (port == null) throw new WBEMException(1, "Unable to find FCPort with name: " + cvName);
                    this.processByProtocolEndPt(iter, objectName, propertyList, isObjectPath, port);
                    needToCloseIter = false;
                }
            }
            if (null == iter || !needToCloseIter) return;
            iter.done();
            return;
        }
        catch (WBEMException we) {
            if (null == iter) throw we;
            iter.setException(we);
            iter.close();
            throw we;
        }
        catch (Throwable th) {
            WBEMException we1 = new WBEMException(1, th.toString(), null, th);
            mLogger.log(Level.SEVERE, th.getLocalizedMessage(), th);
            if (null == iter) throw we1;
            iter.setException(we1);
            iter.close();
            throw we1;
        }
    }

    private class WorkerThread
    implements Task {
        private final Wait4ProcessTasks theTask;
        private final CustomCloseableIterator<?> theIter;
        private final CIMObjectPath op;
        private final boolean objectPath;
        private final String[] propertyList;
        private final ReferenceInfo refInfo;
        private PortandHostGroupInfo pghi;
        private DeviceNumber dn;
        private FCPort port;
        private LUPathObject luPath;
        private String hostWWN2Match;
        private String filterQueryLang;
        private String filterQuery;
        private String resultRole;
        private boolean continueOnError;
        private boolean isAssocOp;
        ExcludeFromAssocOp exclude;
        private String resultClass;
        private List<String> protocolEndpointHierarchy;
        private List<String> hardwareIDHierarchy;
        private List<String> volumeHierarchy;

        public WorkerThread(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, DeviceNumber dn, LUPathObject luPath, ExcludeFromAssocOp excluded, Wait4ProcessTasks task, boolean isObjectPath) {
            this(iter, objectName, propertyList, null, (PortandHostGroupInfo)null, task, isObjectPath);
            this.dn = dn;
            this.luPath = luPath;
            if (excluded != null) {
                this.exclude = excluded;
                this.isAssocOp = true;
            }
        }

        public WorkerThread(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, PortandHostGroupInfo phgi, FCPort port, Wait4ProcessTasks task, boolean isObjectPath) {
            this(iter, objectName, propertyList, null, phgi, task, isObjectPath);
            this.port = port;
        }

        public WorkerThread(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, PortandHostGroupInfo phgi, String hostWWN, Wait4ProcessTasks task, boolean isObjectPath) {
            this(iter, objectName, propertyList, null, phgi, task, isObjectPath);
            this.hostWWN2Match = hostWWN;
        }

        private WorkerThread(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, ReferenceInfo refInfo, PortandHostGroupInfo pghi, Wait4ProcessTasks task, boolean isObjectPath) {
            this.theIter = iter;
            this.objectPath = isObjectPath;
            this.op = objectName;
            this.propertyList = propertyList;
            this.refInfo = refInfo;
            this.pghi = pghi;
            this.theTask = task;
            this.dn = null;
            this.port = null;
            this.hostWWN2Match = null;
            this.filterQueryLang = null;
            this.filterQuery = null;
            this.resultRole = null;
            this.isAssocOp = false;
            this.exclude = null;
            this.setHierarchies();
        }

        public WorkerThread(CustomCloseableIterator<?> iter, CIMObjectPath opStorageVol, String resultClass, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, DeviceNumber dn, LUPathObject luPath, ExcludeFromAssocOp exclude, Wait4ProcessTasks task, boolean isObjectPath) {
            this(iter, opStorageVol, propertyList, dn, luPath, exclude, task, isObjectPath);
            this.filterQueryLang = filterQueryLanguage;
            this.filterQuery = filterQuery;
            this.resultRole = resultRole;
            this.resultClass = resultClass;
        }

        public WorkerThread(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, PortandHostGroupInfo pghi, String resultClass, String resultRole, String filterQueryLanguage, String filterQuery, ExcludeFromAssocOp excluded, boolean continueOnError, Wait4ProcessTasks task, boolean isObjectPath) {
            this(iter, objectName, propertyList, null, pghi, task, isObjectPath);
            this.resultClass = resultClass;
            this.resultRole = resultRole;
            this.filterQueryLang = filterQueryLanguage;
            this.filterQuery = filterQuery;
            this.continueOnError = continueOnError;
            this.isAssocOp = true;
            this.exclude = excluded;
        }

        private void doByDN() throws WBEMException, Exception {
            CommonClassAsList<PortandHostGroupInfo> callback = new CommonClassAsList<PortandHostGroupInfo>();
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.dn.getSerialNumber());
            PortandHostGroupInfo.getPortandHostGroupInfo(device.getRMIObject(), callback, device.getStorageSystemName(), null, String.valueOf(this.luPath.getSPort()), null, null, true, null, true);
            LinkedList<PortandHostGroupInfo> phgis = callback.getReturnValue();
            callback = null;
            while ((this.pghi = phgis.poll()) != null) {
                if (!this.isAssocOp) {
                    this.processLUPath(this.luPath);
                    continue;
                }
                this.processAssocLUPath(this.luPath);
            }
        }

        private void doByPGHI() throws Exception {
            CommonClassAsList<LUPathObject> luPathCallback = new CommonClassAsList<LUPathObject>();
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.pghi.getSerialNumber());
            LUPathObject.getLUPaths(device.getRMIObject(), luPathCallback, this.pghi.getPortID(), this.pghi.getHostgroupID());
            LinkedList<LUPathObject> luPaths = luPathCallback.getReturnValue();
            luPathCallback = null;
            if (luPaths != null) {
                this.processLUPaths(luPaths);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doTask() {
            if (!this.theTask.shouldStop() && !this.theIter.isDone()) {
                try {
                    if (this.pghi != null) {
                        this.doByPGHI();
                    } else if (this.dn != null) {
                        this.doByDN();
                    }
                }
                catch (Throwable t) {
                    WBEMException we = t.getClass().isInstance(WBEMException.class) ? (WBEMException)t : new WBEMException(1, "Exception while processing view: " + t, null, t);
                    this.theIter.setException(we);
                    this.theTask.setStop(true);
                }
                finally {
                    this.theTask.taskProcessed();
                    if (this.theTask.shouldStop()) {
                        this.theIter.done();
                    }
                }
            }
        }

        private boolean isResultClass(ExcludeFromAssocOp parentClz, String resultClass) {
            boolean ret = true;
            if (null != resultClass) {
                String rc = resultClass.toLowerCase();
                ret = false;
                switch (parentClz) {
                    case ProtocolEndPoint: {
                        ret = 0 <= Collections.binarySearch(this.protocolEndpointHierarchy, rc);
                        break;
                    }
                    case StorageHardwareID: {
                        ret = 0 <= Collections.binarySearch(this.hardwareIDHierarchy, rc);
                        break;
                    }
                    case StorageVolume: {
                        ret = 0 <= Collections.binarySearch(this.volumeHierarchy, rc);
                    }
                }
            }
            return ret;
        }

        private void processAssocLUPath(LUPathObject luPath) throws Exception {
            if (luPath.getSHostGrp() == this.pghi.getHostgroupID()) {
                if (this.exclude != ExcludeFromAssocOp.StorageHardwareID && this.isResultClass(ExcludeFromAssocOp.StorageHardwareID, this.resultClass) && (null == this.resultRole || this.resultRole.equalsIgnoreCase(MaskingMappingViewInstrumentation.this.getReference1PropertyName()))) {
                    String[] wwns;
                    for (String wwn : wwns = this.pghi.getHostWWNs()) {
                        if (this.theTask.shouldStop() || this.theIter.isDone()) break;
                        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(luPath.getSerialNumber());
                        if (this.objectPath) {
                            this.theIter.add(MaskingMappingViewInstrumentation.this.getReference1Instrumentation().generateObjectPath(this.op, device.getRMIObject(), wwn));
                            continue;
                        }
                        this.theIter.add(MaskingMappingViewInstrumentation.this.getReference1Instrumentation().generateInstance(this.op, this.propertyList, device.getRMIObject(), wwn));
                    }
                }
                if (this.exclude != ExcludeFromAssocOp.StorageVolume && this.isResultClass(ExcludeFromAssocOp.StorageVolume, this.resultClass) && (null == this.resultRole || this.resultRole.equalsIgnoreCase(MaskingMappingViewInstrumentation.this.getReference2PropertyName()))) {
                    DeviceNumber devNum = luPath.getDeviceNumber();
                    if (this.objectPath) {
                        this.theIter.add(MaskingMappingViewInstrumentation.this.getReference2Instrumentation().generateObjectPath(this.op, devNum));
                    } else {
                        this.theIter.add(MaskingMappingViewInstrumentation.this.getReference2Instrumentation().generateInstance(this.op, this.propertyList, devNum));
                    }
                }
                if (this.exclude != ExcludeFromAssocOp.ProtocolEndPoint && this.isResultClass(ExcludeFromAssocOp.ProtocolEndPoint, this.resultClass) && (null == this.resultRole || this.resultRole.equalsIgnoreCase("ProtocolEndpoint"))) {
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(luPath.getSerialNumber());
                    FCPort fcPort = FCPort.find(luPath.getSPort(), FCPort.PortTypeRequested.OPEN, device.getRMIObject());
                    if (this.objectPath) {
                        this.theIter.add(MaskingMappingViewInstrumentation.this.mReference3.generateObjectPath(this.op, fcPort));
                    } else {
                        this.theIter.add(MaskingMappingViewInstrumentation.this.mReference3.generateInstance(this.op, this.propertyList, fcPort));
                    }
                }
            }
        }

        private void processLUPath(LUPathObject luPath) throws Exception {
            if (luPath.getSHostGrp() == this.pghi.getHostgroupID()) {
                DeviceNumber devNum;
                DeviceNumber deviceNumber = devNum = this.dn == null ? luPath.getDeviceNumber() : this.dn;
                if (devNum != null) {
                    FCPort fcPort;
                    RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(this.pghi.getSerialNumber());
                    FCPort fCPort = fcPort = this.port == null ? FCPort.find(luPath.getSPort(), FCPort.PortTypeRequested.OPEN, device.getRMIObject()) : this.port;
                    if (fcPort != null) {
                        String[] wwns;
                        for (String wwn : wwns = this.pghi.getHostWWNs()) {
                            if (this.theTask.shouldStop() || this.theIter.isDone()) break;
                            if (this.hostWWN2Match != null && this.hostWWN2Match.compareTo(wwn) != 0) continue;
                            if (null != this.refInfo) {
                                this.refInfo.addReference(this.theIter, MaskingMappingViewInstrumentation.this.generateObjectPath(this.op, fcPort, devNum, wwn));
                                continue;
                            }
                            if (this.objectPath) {
                                this.theIter.add(MaskingMappingViewInstrumentation.this.generateObjectPath(this.op, fcPort, devNum, wwn));
                                continue;
                            }
                            this.theIter.add(MaskingMappingViewInstrumentation.this.generateInstance(this.op, this.propertyList, fcPort, devNum, wwn, this.pghi, luPath));
                        }
                    }
                }
            }
        }

        private void processLUPaths(LinkedList<LUPathObject> luPaths) throws Exception {
            LUPathObject luPath;
            while ((luPath = luPaths.poll()) != null) {
                if (!this.isAssocOp) {
                    this.processLUPath(luPath);
                    continue;
                }
                this.processAssocLUPath(luPath);
            }
        }

        private void setHierarchies() {
            this.protocolEndpointHierarchy = new ArrayList<String>(14);
            this.volumeHierarchy = new ArrayList<String>(20);
            this.hardwareIDHierarchy = new ArrayList<String>(8);
            String managedElement = "CIM_ManagedElement".toLowerCase();
            String managedSysElement = "CIM_ManagedSystemElement".toLowerCase();
            String logicalElement = "CIM_LogicalElement".toLowerCase();
            String enabledLogicalElement = "CIM_EnabledLogicalElement".toLowerCase();
            this.hardwareIDHierarchy.add("HITACHI_StorageHardwareID".toLowerCase());
            this.hardwareIDHierarchy.add("CIM_StorageHardwareID".toLowerCase());
            this.hardwareIDHierarchy.add("CIM_Identity".toLowerCase());
            this.hardwareIDHierarchy.add(managedElement);
            Collections.sort(this.hardwareIDHierarchy);
            this.volumeHierarchy.add("HITACHI_StorageVolume".toLowerCase());
            this.volumeHierarchy.add("SNIA_StorageVolume".toLowerCase());
            this.volumeHierarchy.add("CIM_StorageVolume".toLowerCase());
            this.volumeHierarchy.add("CIM_StorageExtent".toLowerCase());
            this.volumeHierarchy.add("CIM_LogicalDevice".toLowerCase());
            this.volumeHierarchy.add(enabledLogicalElement);
            this.volumeHierarchy.add(logicalElement);
            this.volumeHierarchy.add(managedSysElement);
            this.volumeHierarchy.add(managedElement);
            Collections.sort(this.volumeHierarchy);
            this.protocolEndpointHierarchy.add("HITACHI_SCSIProtocolEndpoint".toLowerCase());
            this.protocolEndpointHierarchy.add("CIM_SCSIProtocolEndpoint".toLowerCase());
            this.protocolEndpointHierarchy.add("CIM_ProtocolEndpoint".toLowerCase());
            this.protocolEndpointHierarchy.add("CIM_ServiceAccessPoint".toLowerCase());
            this.protocolEndpointHierarchy.add(enabledLogicalElement);
            this.protocolEndpointHierarchy.add(logicalElement);
            this.protocolEndpointHierarchy.add(managedSysElement);
            this.protocolEndpointHierarchy.add(managedElement);
            Collections.sort(this.protocolEndpointHierarchy);
        }
    }

    static enum ExcludeFromAssocOp {
        StorageHardwareID,
        StorageVolume,
        ProtocolEndPoint;

    }
}

