/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class MemberOfCollectionStorageProcessorSystemInstrumentation
extends BaseAssocInstrumentation {
    protected MemberOfCollectionStorageProcessorSystemInstrumentation() {
        super("HITACHI_MemberOfCollectionStorageProcessorSystem", "HITACHI_RedundancySet", "Collection", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.RedundancySetInstrumentation"), "HITACHI_StorageProcessorSystem", "Member", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageProcessorSystemInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_MemberOfCollectionStorageProcessorSystem".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Collection")) && (null == resultRole || resultRole.equalsIgnoreCase("Member"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        Hashtable<String, Object> ref2SearchProps = this.getReference2SearchProperties(objectName);
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, ref2SearchProps, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Member")) && (null == resultRole || resultRole.equalsIgnoreCase("Collection")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opRedundancySet = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageProcessorSystem", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(opRedundancySet, null, "Collection", "Member", propertyList, isObjectPath, this);
                Hashtable<String, Object> ref2SearchProps = this.getReference2SearchProperties(opRedundancySet);
                this.getReference2Instrumentation().enumerate(deviceIter, opStorageProcessorSystem, new String[0], null, null, continueOnError, true, ref2SearchProps, newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opRef2) {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        String sysName = null != opRef2 && null != opRef2.getKey("Name") ? (String)opRef2.getKey("Name").getValue() : null;
        ret.put("SystemName", sysName);
        return ret;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        String sysName = null != opRef1 && null != opRef1.getKey("InstanceID") ? (String)opRef1.getKey("InstanceID").getValue() : null;
        ret.put("ElementName", sysName);
        return ret;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_MemberOfCollectionStorageProcessorSystem".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_RedundancySet") && (null == role || role.equalsIgnoreCase("Collection")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_StorageProcessorSystem", null);
                    CIMObjectPath opRedundancySet = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opRedundancySet, null, "Collection", "Member", propertyList, isObjectPath, this);
                    Hashtable<String, Object> ref2SearchProps = this.getReference2SearchProperties(opRedundancySet);
                    this.getReference2Instrumentation().enumerate(iter, opStorageProcessorSystem, new String[0], null, null, continueOnError, true, ref2SearchProps, newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageProcessorSystem") && (null == role || role.equalsIgnoreCase("Member")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath opRedundancySet = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opStorageProcessorSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opRedundancySet, opStorageProcessorSystem));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opRedundancySet, opStorageProcessorSystem));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

